/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.dim.trait.CBT_Temperature;
import com.hbm.dim.trait.CBT_Water;
import com.hbm.dim.trait.CelestialBodyTrait;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityDysonReceiver;
import com.hbm.util.AstronomyUtil;
import com.hbm.util.BobMathUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.commons.lang3.NotImplementedException;

public class SolarSystem {
    public static CelestialBody kerbol;
    public static final double RENDER_SCALE = 180.0;
    public static final double SUN_RENDER_SCALE = 4.0;
    public static final float MAX_APPARENT_SIZE_SURFACE = 24.0f;
    public static final float MAX_APPARENT_SIZE_ORBIT = 160.0f;
    public static final double ORRERY_MAX_RADIUS = 20000.0;
    public static final double ORRERY_MIN_RADIUS = 2000.0;
    private static final int ECCENTRICITY_ITERATION_COUNT = 4;

    public static void init() {
        kerbol = new CelestialBody("kerbol").withMassRadius(1.757E28f, 261600.0f).withRotationalPeriod(432000).withTexture(new ResourceLocation("textures/environment/sun.png")).withShader(new ResourceLocation("hbm", "shaders/blackhole.frag"), 3.0f).withSatellites(new CelestialBody("moho", SpaceConfig.mohoDimension, Body.MOHO).withMassRadius(2.526E21f, 250.0f).withOrbitalParameters(5263138.0f, 0.2f, 15.0f, 7.0f, 70.0f).withRotationalPeriod(210000).withColor(0.4863f, 0.4f, 0.3456f).withBlockTextures("hbm:moho_stone", "", "", "").withAxialTilt(30.0f).withTraits(new CBT_Temperature(200.0f)), new CelestialBody("eve", SpaceConfig.eveDimension, Body.EVE).withMassRadius(1.224E23f, 700.0f).withOrbitalParameters(9832684.0f, 0.01f, 0.0f, 2.1f, 15.0f).withRotationalPeriod(80500).withColor(0.408f, 0.298f, 0.553f).withBlockTextures("hbm:eve_stone_2", "", "", "").withMinProcessingLevel(2).withTraits(new CBT_Atmosphere(Fluids.EVEAIR, 5.0), new CBT_Temperature(400.0f), new CBT_Water(Fluids.MERCURY)).withSatellites(new CelestialBody("gilly").withMassRadius(1.242E17f, 13.0f).withOrbitalParameters(31500.0f, 0.55f, 10.0f, 12.0f, 80.0f).withRotationalPeriod(28255).withTexture(new ResourceLocation("hbm", "textures/misc/space/planet.png"))), new CelestialBody("kerbin", 0, Body.KERBIN).withMassRadius(5.292E22f, 600.0f).withOrbitalParameters(1.359984E7f, 0.0f, 0.0f, 0.0f, 0.0f).withRotationalPeriod(21549).withColor(0.608f, 0.914f, 1.0f).withTraits(new CBT_Atmosphere(Fluids.EARTHAIR, 1.0), new CBT_Water()).withCityMask(new ResourceLocation("hbm", "textures/misc/space/kerbin_mask.png")).withBiomeMask(new ResourceLocation("hbm", "textures/misc/space/kerbin_biomes.png")).withSatellites(new CelestialBody("mun", SpaceConfig.moonDimension, Body.MUN).withMassRadius(9.76E20f, 200.0f).withOrbitalParameters(12000.0f, 0.054f, 0.0f, 5.15f, 17.0f).withRotationalPeriod(138984).withTidalLockingTo("kerbin").withBlockTextures("hbm:moon_rock", "", "", ""), new CelestialBody("minmus", SpaceConfig.minmusDimension, Body.MINMUS).withMassRadius(2.646E19f, 60.0f).withOrbitalParameters(47000.0f, 0.0f, 38.0f, 6.0f, 78.0f).withRotationalPeriod(40400).withBlockTextures("hbm:minmus_stone", "", "", "").withTraits(new CBT_Water(Fluids.MILK))), new CelestialBody("duna", SpaceConfig.dunaDimension, Body.DUNA).withMassRadius(4.515E21f, 320.0f).withOrbitalParameters(2.0726156E7f, 0.05f, 0.0f, 0.06f, 135.5f).withRotationalPeriod(65518).withTidalLockingTo("ike").withColor(0.6471f, 0.2824f, 0.1608f).withBlockTextures("hbm:duna_rock", "", "", "").withTraits(new CBT_Atmosphere(Fluids.DUNAAIR, 0.1)).withCityMask(new ResourceLocation("hbm", "textures/misc/space/duna_mask.png")).withSatellites(new CelestialBody("ike", SpaceConfig.ikeDimension, Body.IKE).withMassRadius(2.782E20f, 130.0f).withOrbitalParameters(3200.0f, 0.03f, 0.0f, 0.2f, 0.0f).withBlockTextures("hbm:ike_stone", "", "", "").withRotationalPeriod(65518).withTidalLockingTo("duna").withTraits(new CBT_Water(Fluids.BROMINE))), new CelestialBody("dres", SpaceConfig.dresDimension, Body.DRES).withMassRadius(3.219E20f, 138.0f).withOrbitalParameters(4.0839348E7f, 0.145f, 90.0f, 5.0f, 280.0f).withRotationalPeriod(34800).withBlockTextures("hbm:dresbase", "", "", "").withMinProcessingLevel(2), new CelestialBody("jool").withMassRadius(4.233E24f, 6000.0f).withOrbitalParameters(6.877356E7f, 0.05f, 0.0f, 1.304f, 52.0f).withRotationalPeriod(36000).withColor(0.4588f, 0.6784f, 0.3059f).withGas(Fluids.JOOLGAS).withSatellites(new CelestialBody("laythe", SpaceConfig.laytheDimension, Body.LAYTHE).withMassRadius(2.94E22f, 500.0f).withOrbitalParameters(27184.0f, 0.0288f, 0.0f, 0.348f, 0.0f).withRotationalPeriod(52981).withTidalLockingTo("jool").withMinProcessingLevel(3).withTraits(new CBT_Atmosphere(Fluids.EARTHAIR, 0.45).and(Fluids.XENON, 0.15), new CBT_Water()).withCityMask(new ResourceLocation("hbm", "textures/misc/space/laythe_mask.png")), new CelestialBody("vall").withMassRadius(3.109E21f, 300.0f).withOrbitalParameters(43152.0f, 0.111f, 342.9f, 7.48f, 128.0f).withRotationalPeriod(105962), new CelestialBody("tylo").withMassRadius(4.233E22f, 600.0f).withOrbitalParameters(68500.0f, 0.002f, 0.0f, 0.3f, 0.0f).withRotationalPeriod(211926), new CelestialBody("bop").withMassRadius(3.726E19f, 65.0f).withOrbitalParameters(128500.0f, 0.235f, 25.0f, 15.0f, 10.0f).withRotationalPeriod(544507), new CelestialBody("pol").withMassRadius(1.081E19f, 44.0f).withOrbitalParameters(179890.0f, 0.171f, 15.0f, 4.25f, 2.0f).withRotationalPeriod(901902)), new CelestialBody("sarnus").withMassRadius(1.223E24f, 5300.0f).withOrbitalParameters(1.2579852E8f, 0.0534f, 0.0f, 2.02f, 184.0f).withRotationalPeriod(28500).withColor(1.0f, 0.6862f, 0.5882f).withRings(10.0f, 3.0f, 0.6f, 0.4f, 0.3f).withGas(Fluids.SARNUSGAS).withSatellites(new CelestialBody("hale").withMassRadius(1.2166E16f, 6.0f).withOrbitalParameters(10488.0f, 0.0f, 0.0f, 1.0f, 55.0f).withRotationalPeriod(23555), new CelestialBody("ovok").withMassRadius(4.233E17f, 26.0f).withOrbitalParameters(12169.0f, 0.01f, 0.0f, 1.5f, 55.0f).withRotationalPeriod(29440), new CelestialBody("eeloo").withMassRadius(1.115E21f, 210.0f).withOrbitalParameters(19106.0f, 0.0034f, 0.0f, 2.3f, 55.0f).withRotationalPeriod(57915), new CelestialBody("slate").withMassRadius(2.965E22f, 540.0f).withOrbitalParameters(42593.0f, 0.04f, 0.0f, 2.3f, 55.0f).withRotationalPeriod(192771), new CelestialBody("tekto", SpaceConfig.tektoDimension, Body.TEKTO).withMassRadius(2.883E21f, 480.0f).withOrbitalParameters(67355.0f, 0.028f, 0.0f, 9.4f, 55.0f).withRotationalPeriod(57915).withAxialTilt(25.0f).withMinProcessingLevel(3).withTraits(new CBT_Atmosphere(Fluids.TEKTOAIR, 1.5), new CBT_Water(Fluids.CCL)).withBlockTextures("hbm:basalt", "", "", "")), new CelestialBody("neidon").withMassRadius(2.1228E23f, 2145.0f).withOrbitalParameters(4.093552E8f, 0.0534f, 0.0f, 2.02f, 184.0f).withRotationalPeriod(40250).withColor(1.0f, 0.6862f, 0.5882f).withSatellites(new CelestialBody("thatmo").withMassRadius(2.788E21f, 286.0f).withOrbitalParameters(32301.0f, 0.0534f, 0.0f, 4.02f, 284.0f).withRotationalPeriod(306443).withTraits(new CBT_Atmosphere(Fluids.NITROGEN, 0.005f), new CelestialBodyTrait.CBT_BATTLEFIELD()), new CelestialBody("nissee").withMassRadius(5.951E18f, 30.0f).withOrbitalParameters(487744.0f, 0.0534f, 0.0f, 45.02f, 84.0f).withRotationalPeriod(27924).withMinProcessingLevel(3)));
        SolarSystem.runTests();
    }

    public static List<OrreryMetric> calculatePositionsOrrery(World world, float partialTicks) {
        ArrayList<OrreryMetric> metrics = new ArrayList<OrreryMetric>();
        double ticks = ((double)world.func_82737_E() + (double)partialTicks) * (double)AstronomyUtil.TIME_MULTIPLIER;
        SolarSystem.calculatePositionsRecursiveOrrery(metrics, null, CelestialBody.getBody(world).getStar(), ticks, 0);
        return metrics;
    }

    public static List<AstroMetric> calculateMetricsFromBody(World world, float partialTicks, CelestialBody body, float solarAngle) {
        CelestialBody tidalLockedBody;
        ArrayList<AstroMetric> metrics = new ArrayList<AstroMetric>();
        double rotOffset = -120.0;
        CelestialBody celestialBody = tidalLockedBody = body.tidallyLockedTo != null ? CelestialBody.getBody(body.tidallyLockedTo) : null;
        if (tidalLockedBody != null && tidalLockedBody.getPlanet() != body) {
            tidalLockedBody = body;
            rotOffset += 180.0;
        }
        double ticks = ((double)world.func_82737_E() + (double)partialTicks) * (double)AstronomyUtil.TIME_MULTIPLIER;
        SolarSystem.calculatePositionsRecursive(metrics, null, body.getStar(), ticks, tidalLockedBody, (double)solarAngle * 360.0, rotOffset);
        SolarSystem.calculateMetricsFromBody(metrics, body);
        metrics.sort((a, b) -> (int)(b.distance - a.distance));
        return metrics;
    }

    public static List<AstroMetric> calculateMetricsFromSatellite(World world, float partialTicks, CelestialBody orbiting, double altitude) {
        ArrayList<AstroMetric> metrics = new ArrayList<AstroMetric>();
        double ticks = ((double)world.func_82737_E() + (double)partialTicks) * (double)AstronomyUtil.TIME_MULTIPLIER;
        SolarSystem.calculatePositionsRecursive(metrics, null, orbiting.getStar(), ticks);
        Vec3 position = SolarSystem.calculatePositionSatellite(orbiting, altitude, ticks);
        for (AstroMetric metric : metrics) {
            if (metric.body != orbiting) continue;
            position = position.func_72441_c(metric.position.field_72450_a, metric.position.field_72448_b, metric.position.field_72449_c);
            break;
        }
        SolarSystem.calculateMetricsFromPosition(metrics, position);
        metrics.sort((a, b) -> (int)(b.distance - a.distance));
        return metrics;
    }

    public static List<AstroMetric> calculateMetricsBetweenSatelliteOrbits(World world, float partialTicks, CelestialBody from, CelestialBody to, double fromAltitude, double toAltitude, double t) {
        ArrayList<AstroMetric> metrics = new ArrayList<AstroMetric>();
        double ticks = ((double)world.func_82737_E() + (double)partialTicks) * (double)AstronomyUtil.TIME_MULTIPLIER;
        SolarSystem.calculatePositionsRecursive(metrics, null, from.getStar(), ticks);
        Vec3 fromPos = SolarSystem.calculatePositionSatellite(from, fromAltitude, ticks);
        Vec3 toPos = SolarSystem.calculatePositionSatellite(to, toAltitude, ticks);
        for (AstroMetric metric : metrics) {
            if (metric.body == from) {
                fromPos = fromPos.func_72441_c(metric.position.field_72450_a, metric.position.field_72448_b, metric.position.field_72449_c);
            }
            if (metric.body != to) continue;
            toPos = toPos.func_72441_c(metric.position.field_72450_a, metric.position.field_72448_b, metric.position.field_72449_c);
        }
        Vec3 position = SolarSystem.lerp(fromPos, toPos, t);
        SolarSystem.calculateMetricsFromPosition(metrics, position);
        metrics.sort((a, b) -> (int)(b.distance - a.distance));
        return metrics;
    }

    public static double calculateDistanceBetweenTwoBodies(World world, CelestialBody from, CelestialBody to) {
        ArrayList<AstroMetric> metrics = new ArrayList<AstroMetric>();
        double ticks = (double)world.func_82737_E() * (double)AstronomyUtil.TIME_MULTIPLIER;
        SolarSystem.calculatePositionsRecursive(metrics, null, from.getStar(), ticks);
        Vec3 fromPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Vec3 toPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (AstroMetric metric : metrics) {
            if (metric.body == from) {
                fromPos = metric.position;
            }
            if (metric.body != to) continue;
            toPos = metric.position;
        }
        return fromPos.func_72438_d(toPos);
    }

    private static Vec3 lerp(Vec3 from, Vec3 to, double t) {
        double x = BobMathUtil.clampedLerp(from.field_72450_a, to.field_72450_a, t);
        double y = BobMathUtil.clampedLerp(from.field_72448_b, to.field_72448_b, t);
        double z = BobMathUtil.clampedLerp(from.field_72449_c, to.field_72449_c, t);
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    private static void calculatePositionsRecursive(List<AstroMetric> metrics, AstroMetric parentMetric, CelestialBody body, double ticks) {
        SolarSystem.calculatePositionsRecursive(metrics, parentMetric, body, ticks, null, 0.0, 0.0);
    }

    private static void calculatePositionsRecursive(List<AstroMetric> metrics, AstroMetric parentMetric, CelestialBody body, double ticks, CelestialBody lockBody, double solarAngle, double rotOffset) {
        Vec3 parentPosition = parentMetric != null ? parentMetric.position : Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (CelestialBody satellite : body.satellites) {
            Vec3 position = satellite == lockBody ? SolarSystem.calculatePositionFromAngle(satellite, solarAngle + SolarSystem.calculateSiderealAngle(satellite, ticks) - Math.toDegrees(satellite.argumentPeriapsis) - Math.toDegrees(satellite.ascendingNode) + rotOffset) : SolarSystem.calculatePositionFromTime(satellite, ticks);
            position = position.func_72441_c(parentPosition.field_72450_a, parentPosition.field_72448_b, parentPosition.field_72449_c);
            AstroMetric metric = new AstroMetric(satellite, position);
            metrics.add(metric);
            SolarSystem.calculatePositionsRecursive(metrics, metric, satellite, ticks, lockBody, solarAngle, rotOffset);
        }
    }

    private static void calculatePositionsRecursiveOrrery(List<OrreryMetric> metrics, OrreryMetric parentMetric, CelestialBody body, double ticks, int depth) {
        Vec3 parentPosition = parentMetric != null ? parentMetric.position : Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        double distance = Math.min((double)body.radiusKm, 20000.0) * 1.42;
        for (CelestialBody satellite : body.satellites) {
            double extraDistance = MathHelper.func_151237_a((double)satellite.radiusKm, (double)2000.0, (double)20000.0) * (double)((1.0f + satellite.eccentricity) * 2.0f) * 1.42;
            for (CelestialBody inner : satellite.satellites) {
                extraDistance += MathHelper.func_151237_a((double)inner.radiusKm, (double)2000.0, (double)20000.0) * (double)((1.0f + inner.eccentricity) * 2.0f) * 2.0;
            }
            Vec3 position = SolarSystem.calculatePositionFromTime(satellite, ticks, distance += extraDistance);
            position = position.func_72441_c(parentPosition.field_72450_a, parentPosition.field_72448_b, parentPosition.field_72449_c);
            OrreryMetric metric = new OrreryMetric(satellite, position);
            for (int i = 0; i < metric.orbitalPath.length; ++i) {
                metric.orbitalPath[i] = SolarSystem.calculatePositionFromAngle(satellite, (float)i / (float)metric.orbitalPath.length * 360.0f, distance).func_72441_c(parentPosition.field_72450_a, parentPosition.field_72448_b, parentPosition.field_72449_c);
            }
            metrics.add(metric);
            distance += extraDistance;
            SolarSystem.calculatePositionsRecursiveOrrery(metrics, metric, satellite, ticks, depth + 1);
        }
    }

    private static Vec3 calculatePositionFromTime(CelestialBody body, double ticks) {
        return SolarSystem.calculatePositionFromTime(body, ticks, body.semiMajorAxisKm);
    }

    private static Vec3 calculatePositionFromTime(CelestialBody body, double ticks, double semiMajorAxis) {
        double yearTicks = body.getOrbitalPeriod() * 24000.0;
        double meanAnomaly = Math.PI * 2 * (ticks / yearTicks);
        return SolarSystem.calculatePosition(body, meanAnomaly, semiMajorAxis);
    }

    private static Vec3 calculatePositionFromAngle(CelestialBody body, double angle) {
        return SolarSystem.calculatePosition(body, Math.toRadians(angle), body.semiMajorAxisKm);
    }

    private static Vec3 calculatePositionFromAngle(CelestialBody body, double angle, double semiMajorAxis) {
        return SolarSystem.calculatePosition(body, Math.toRadians(angle), semiMajorAxis);
    }

    private static Vec3 calculatePosition(CelestialBody body, double meanAnomaly, double semiMajorAxis) {
        double eccentricAnomaly = SolarSystem.calculateEccentricAnomaly(meanAnomaly, body.eccentricity);
        double x = semiMajorAxis * (Math.cos(eccentricAnomaly) - (double)body.eccentricity);
        double y = semiMajorAxis * (double)body.semiMinorAxisFactor * Math.sin(eccentricAnomaly);
        double z = 0.0;
        double px = x;
        x = Math.cos(body.argumentPeriapsis) * px - Math.sin(body.argumentPeriapsis) * y;
        y = Math.sin(body.argumentPeriapsis) * px + Math.cos(body.argumentPeriapsis) * y;
        z = Math.sin(body.inclination) * y;
        y = Math.cos(body.inclination) * y;
        px = x;
        x = Math.cos(body.ascendingNode) * px - Math.sin(body.ascendingNode) * y;
        y = Math.sin(body.ascendingNode) * px + Math.cos(body.ascendingNode) * y;
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    private static Vec3 calculatePositionSatellite(CelestialBody body, double altitude, double ticks) {
        double orbitalPeriod = Math.PI * 2 * Math.sqrt(altitude * altitude * altitude / (double)(6.6743014E-11f * body.massKg));
        double orbitTicks = (orbitalPeriod /= 21600.0) * 24000.0;
        double meanAnomaly = Math.PI * 2 * (ticks / orbitTicks);
        double x = altitude / 1000.0 * Math.cos(meanAnomaly);
        double y = altitude / 1000.0 * Math.sin(meanAnomaly);
        return Vec3.func_72443_a((double)x, (double)y, (double)0.0);
    }

    private static double calculateEccentricAnomaly(double meanAnomaly, float eccentricity) {
        double eccentricAnomaly = meanAnomaly;
        for (int i = 0; i < 4; ++i) {
            eccentricAnomaly = meanAnomaly + (double)eccentricity * Math.sin(eccentricAnomaly);
        }
        return eccentricAnomaly;
    }

    private static void calculateMetricsFromBody(List<AstroMetric> metrics, CelestialBody body) {
        AstroMetric from = null;
        for (AstroMetric metric : metrics) {
            if (metric.body != body) continue;
            from = metric;
            break;
        }
        for (AstroMetric to : metrics) {
            if (from == to) continue;
            SolarSystem.calculateMetric(to, from.position);
        }
    }

    private static void calculateMetricsFromPosition(List<AstroMetric> metrics, Vec3 position) {
        for (AstroMetric to : metrics) {
            SolarSystem.calculateMetric(to, position);
        }
    }

    private static void calculateMetric(AstroMetric metric, Vec3 position) {
        metric.distance = position.func_72438_d(metric.position);
        metric.apparentSize = SolarSystem.getApparentSize(Math.min(metric.body.radiusKm, 3000.0f), metric.distance);
        metric.angle = SolarSystem.getApparentAngleDegrees(position, metric.position);
        metric.inclination = SolarSystem.getApparentInclinationDegrees(position, metric.position);
        metric.phase = SolarSystem.getPhase(position, metric.position);
        metric.phaseObscure = SolarSystem.getPhaseObscure(position, metric.position);
    }

    private static double getApparentSize(double radius, double distance) {
        return 2.0 * (double)((float)Math.atan(2.0 * radius / (2.0 * distance))) * 180.0;
    }

    private static double getApparentAngleDegrees(Vec3 from, Vec3 to) {
        double angleToOrigin = Math.atan2(-from.field_72448_b, -from.field_72450_a);
        double angleToTarget = Math.atan2(to.field_72448_b - from.field_72448_b, to.field_72450_a - from.field_72450_a);
        return MathHelper.func_76138_g((double)Math.toDegrees(angleToOrigin - angleToTarget));
    }

    private static double getApparentInclinationDegrees(Vec3 from, Vec3 to) {
        double x = from.field_72450_a - to.field_72450_a;
        double y = from.field_72448_b - to.field_72448_b;
        double planeDistance = Math.sqrt(x * x + y * y);
        double offsetDistance = from.field_72449_c - to.field_72449_c;
        return MathHelper.func_76138_g((double)Math.toDegrees(Math.atan2(offsetDistance, planeDistance)));
    }

    private static double getPhase(Vec3 from, Vec3 to) {
        return SolarSystem.getApparentAngleDegrees(to, from) / 180.0;
    }

    private static double getPhaseObscure(Vec3 from, Vec3 to) {
        return Math.min(Math.abs(SolarSystem.getPhase(from, to)), 1.0 - Math.abs(SolarSystem.getApparentInclinationDegrees(from, to) / 180.0));
    }

    public static double calculateSunSize(CelestialBody from) {
        if (from.parent == null) {
            return 0.0;
        }
        if (from.parent.parent != null) {
            return SolarSystem.calculateSunSize(from.parent);
        }
        return SolarSystem.getApparentSize(from.parent.radiusKm, from.semiMajorAxisKm);
    }

    public static double calculateSingleAngle(List<AstroMetric> metrics, CelestialBody from, CelestialBody to) {
        AstroMetric metricFrom = null;
        AstroMetric metricTo = null;
        for (AstroMetric metric : metrics) {
            if (metric.body == from) {
                metricFrom = metric;
                continue;
            }
            if (metric.body != to) continue;
            metricTo = metric;
        }
        return SolarSystem.getApparentAngleDegrees(metricFrom.position, metricTo.position);
    }

    public static double calculateSingleAngle(World world, double partialTicks, List<AstroMetric> metrics, CelestialBody orbiting, double altitude) {
        double ticks = ((double)world.func_82737_E() + partialTicks) * (double)AstronomyUtil.TIME_MULTIPLIER;
        Vec3 from = SolarSystem.calculatePositionSatellite(orbiting, altitude, ticks);
        Vec3 to = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (AstroMetric metric : metrics) {
            if (metric.body != orbiting) continue;
            to = metric.position;
            from = from.func_72441_c(to.field_72450_a, to.field_72448_b, to.field_72449_c);
            break;
        }
        return SolarSystem.getApparentAngleDegrees(from, to);
    }

    public static double calculateSingleAngle(World world, CelestialBody from, CelestialBody to) {
        ArrayList<AstroMetric> metrics = new ArrayList<AstroMetric>();
        double ticks = (double)world.func_82737_E() * (double)AstronomyUtil.TIME_MULTIPLIER;
        SolarSystem.calculatePositionsRecursive(metrics, null, from.getStar(), ticks);
        AstroMetric metricFrom = null;
        AstroMetric metricTo = null;
        for (AstroMetric metric : metrics) {
            if (metric.body == from) {
                metricFrom = metric;
                continue;
            }
            if (metric.body != to) continue;
            metricTo = metric;
        }
        return SolarSystem.getApparentAngleDegrees(metricFrom.position, metricTo.position);
    }

    public static double calculateSiderealAngle(World world, float partialTicks, CelestialBody body) {
        double ticks = ((double)world.func_82737_E() + (double)partialTicks) * (double)AstronomyUtil.TIME_MULTIPLIER;
        return SolarSystem.calculateSiderealAngle(body, ticks);
    }

    public static double calculateSiderealAngle(CelestialBody body, double ticks) {
        body = body.getPlanet();
        Vec3 position = SolarSystem.calculatePositionFromTime(body, ticks);
        return Math.toDegrees(Math.atan2(position.field_72448_b, position.field_72450_a));
    }

    public static int getCostBetween(CelestialBody from, CelestialBody to, int mass, int thrust, int isp, boolean fromOrbit, boolean toOrbit) {
        double fromDrag = SolarSystem.getAtmosphericDrag(from.getTrait(CBT_Atmosphere.class));
        double toDrag = SolarSystem.getAtmosphericDrag(to.getTrait(CBT_Atmosphere.class));
        double launchDV = fromOrbit ? 0.0 : SolarSystem.getLiftoffDeltaV(from, mass, thrust, fromDrag);
        double travelDV = SolarSystem.getDeltaVBetween(from, to);
        double landerDV = toOrbit ? 0.0 : SolarSystem.getLandingDeltaV(to, mass, thrust, toDrag);
        double totalDV = launchDV + travelDV + landerDV;
        return SolarSystem.getFuelCost(totalDV, mass, isp);
    }

    public static int getFuelCost(double deltaV, int mass, int isp) {
        double g0 = 9.81;
        double exhaustVelocity = (double)isp * g0;
        double massFraction = 1.0 - Math.exp(-(deltaV / exhaustVelocity));
        double totalMass = (double)mass / (1.0 - massFraction);
        double propellantMass = totalMass - (double)mass;
        double propellantVolume = propellantMass / 2.0;
        return propellantVolume + 100.0 > 2.147483647E9 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)(propellantVolume * 0.01)) * 100;
    }

    private static double getAtmosphericDrag(CBT_Atmosphere atmosphere) {
        if (atmosphere == null) {
            return 0.0;
        }
        double pressure = atmosphere.getPressure();
        return Math.log(pressure + 1.0) / 10.0;
    }

    public static double getLiftoffDeltaV(CelestialBody body, float craftMassKg, float craftThrustN, double atmosphericDrag) {
        return SolarSystem.calculateSurfaceToOrbitDeltaV(body, craftMassKg, craftThrustN, atmosphericDrag, false);
    }

    public static double getLandingDeltaV(CelestialBody body, float craftMassKg, float craftThrustN, double atmosphericDrag) {
        return SolarSystem.calculateSurfaceToOrbitDeltaV(body, craftMassKg, craftThrustN, atmosphericDrag, atmosphericDrag > 0.006);
    }

    private static double calculateSurfaceToOrbitDeltaV(CelestialBody body, float craftMassKg, float craftThrustN, double atmosphericDrag, boolean lossesOnly) {
        float gravity = body.getSurfaceGravity();
        double orbitalDeltaV = Math.sqrt(6.6743014E-11f * body.massKg / (body.radiusKm * 1000.0f));
        double thrustToWeightRatio = craftThrustN / (craftMassKg * gravity);
        if (thrustToWeightRatio < 1.0) {
            return Double.MAX_VALUE;
        }
        double acceleration = (thrustToWeightRatio - 1.0) * (double)gravity;
        double timeToOrbit = orbitalDeltaV / acceleration;
        double gravityLosses = (double)gravity * timeToOrbit * 2.0;
        if (lossesOnly) {
            return gravityLosses * (1.0 - atmosphericDrag);
        }
        return orbitalDeltaV + gravityLosses * (1.0 + atmosphericDrag);
    }

    public static double getDeltaVBetween(CelestialBody start, CelestialBody end) {
        return SolarSystem.calculateHohmannTransfer(start, end);
    }

    private static double calculateHohmannTransfer(CelestialBody start, CelestialBody end) {
        if (start == end) {
            return 0.0;
        }
        if (start.parent == null || end.parent == null) {
            throw new NotImplementedException("Transfers to and from solar bodies not supported");
        }
        if (start.parent == end.parent) {
            double firstBurnCost = SolarSystem.calculateSingleHohmannTransfer(start.parent.massKg, start.semiMajorAxisKm, end.semiMajorAxisKm, start.massKg, start.radiusKm + 100.0f);
            double secondBurnCost = SolarSystem.calculateSingleHohmannTransfer(start.parent.massKg, end.semiMajorAxisKm, start.semiMajorAxisKm, end.massKg, end.radiusKm + 100.0f);
            return firstBurnCost + secondBurnCost;
        }
        if (start == end.parent) {
            double firstBurnCost = SolarSystem.calculateSingleHohmannTransfer(start.massKg, start.radiusKm + 100.0f, end.semiMajorAxisKm);
            double secondBurnCost = SolarSystem.calculateSingleHohmannTransfer(start.massKg, end.semiMajorAxisKm, start.radiusKm + 100.0f, end.massKg, end.radiusKm + 100.0f);
            return firstBurnCost + secondBurnCost;
        }
        if (start.parent == end) {
            double firstBurnCost = SolarSystem.calculateSingleHohmannTransfer(end.massKg, start.semiMajorAxisKm, end.radiusKm + 100.0f, start.massKg, start.radiusKm + 100.0f);
            double secondBurnCost = SolarSystem.calculateSingleHohmannTransfer(end.massKg, end.radiusKm + 100.0f, start.semiMajorAxisKm);
            return firstBurnCost + secondBurnCost;
        }
        CelestialBody commonParent = SolarSystem.getCommonParent(start, end);
        CelestialBody fromBody = start;
        CelestialBody toBody = end;
        float currentFromOrbitRadius = fromBody.semiMajorAxisKm;
        float currentToOrbitRadius = toBody.semiMajorAxisKm;
        double burnCost = 0.0;
        while (fromBody.parent != commonParent) {
            burnCost += SolarSystem.calculateSingleHohmannTransfer(fromBody.parent.massKg, fromBody.semiMajorAxisKm, fromBody.semiMajorAxisKm, fromBody.massKg, fromBody.semiMajorAxisKm);
            currentFromOrbitRadius = fromBody.semiMajorAxisKm;
            fromBody = fromBody.parent;
        }
        while (toBody.parent != commonParent) {
            burnCost += SolarSystem.calculateSingleHohmannTransfer(toBody.parent.massKg, toBody.semiMajorAxisKm, toBody.semiMajorAxisKm, toBody.massKg, toBody.semiMajorAxisKm);
            currentToOrbitRadius = toBody.semiMajorAxisKm;
            toBody = toBody.parent;
        }
        burnCost += SolarSystem.calculateSingleHohmannTransfer(commonParent.massKg, fromBody.semiMajorAxisKm, toBody.semiMajorAxisKm, fromBody.massKg, currentFromOrbitRadius);
        return burnCost += SolarSystem.calculateSingleHohmannTransfer(commonParent.massKg, toBody.semiMajorAxisKm, fromBody.semiMajorAxisKm, toBody.massKg, currentToOrbitRadius);
    }

    private static CelestialBody getCommonParent(CelestialBody start, CelestialBody end) {
        CelestialBody startParent = start.parent;
        while (startParent != null) {
            CelestialBody endParent = end.parent;
            while (endParent != null) {
                if (startParent == endParent) {
                    return startParent;
                }
                endParent = endParent.parent;
            }
            startParent = startParent.parent;
        }
        throw new InvalidParameterException("Bodies aren't in the same solar system");
    }

    private static double calculateSingleHohmannTransfer(float parentMassKg, float fromRadiusKm, float toRadiusKm) {
        double parentGravitationalParameter = parentMassKg * 6.6743014E-11f;
        double startOrbitalRadius = fromRadiusKm * 1000.0f;
        double endOrbitalRadius = toRadiusKm * 1000.0f;
        double transferSemiMajorAxis = (startOrbitalRadius + endOrbitalRadius) / 2.0;
        double currentOrbitalVelocity = Math.sqrt(parentGravitationalParameter / startOrbitalRadius);
        double requiredVelocity = Math.sqrt(parentGravitationalParameter * (2.0 / startOrbitalRadius - 1.0 / transferSemiMajorAxis));
        return Math.abs(requiredVelocity - currentOrbitalVelocity);
    }

    private static double calculateSingleHohmannTransfer(float parentMassKg, float fromRadiusKm, float toRadiusKm, float fromMassKg, float parkingOrbitRadiusKm) {
        double hyperbolicVelocity = SolarSystem.calculateSingleHohmannTransfer(parentMassKg, fromRadiusKm, toRadiusKm);
        double fromGravitationalParameter = fromMassKg * 6.6743014E-11f;
        double parkingOrbitRadius = parkingOrbitRadiusKm * 1000.0f;
        double parkingOrbitVelocity = Math.sqrt(fromGravitationalParameter / parkingOrbitRadius);
        double escapeVelocity = Math.sqrt(2.0 * fromGravitationalParameter / parkingOrbitRadius);
        double escapeHyperVelocity = Math.sqrt(hyperbolicVelocity * hyperbolicVelocity + escapeVelocity * escapeVelocity);
        return escapeHyperVelocity - parkingOrbitVelocity;
    }

    public static void runTests() {
        CelestialBody kerbin = CelestialBody.getBody("kerbin");
        CelestialBody eve = CelestialBody.getBody("eve");
        CelestialBody duna = CelestialBody.getBody("duna");
        CelestialBody mun = CelestialBody.getBody("mun");
        CelestialBody minmus = CelestialBody.getBody("minmus");
        CelestialBody ike = CelestialBody.getBody("ike");
        float deltaIVMass = 500000.0f;
        float RD180RocketThrust = 7887000.0f;
        MainRegistry.logger.info("Kerbin launch cost: " + SolarSystem.getLiftoffDeltaV(kerbin, deltaIVMass, RD180RocketThrust, 0.0));
        MainRegistry.logger.info("Eve launch cost: " + SolarSystem.getLiftoffDeltaV(eve, deltaIVMass, RD180RocketThrust, 0.0));
        MainRegistry.logger.info("Duna launch cost: " + SolarSystem.getLiftoffDeltaV(duna, deltaIVMass, RD180RocketThrust, 0.0));
        MainRegistry.logger.info("Mun launch cost: " + SolarSystem.getLiftoffDeltaV(mun, deltaIVMass, RD180RocketThrust, 0.0));
        MainRegistry.logger.info("Minmus launch cost: " + SolarSystem.getLiftoffDeltaV(minmus, deltaIVMass, RD180RocketThrust, 0.0));
        MainRegistry.logger.info("Ike launch cost: " + SolarSystem.getLiftoffDeltaV(ike, deltaIVMass, RD180RocketThrust, 0.0));
        MainRegistry.logger.info("Kerbin -> Eve cost: " + SolarSystem.getDeltaVBetween(kerbin, eve) + " - should be: " + 2450);
        MainRegistry.logger.info("Kerbin -> Duna cost: " + SolarSystem.getDeltaVBetween(kerbin, duna) + " - should be: " + 1690);
        MainRegistry.logger.info("Kerbin -> Ike cost: " + SolarSystem.getDeltaVBetween(kerbin, ike) + " - should be: " + 1540);
        MainRegistry.logger.info("Eve -> Duna cost: " + SolarSystem.getDeltaVBetween(eve, duna));
        MainRegistry.logger.info("Kerbin -> Mun cost: " + SolarSystem.getDeltaVBetween(kerbin, mun) + " - should be: " + 1170);
        MainRegistry.logger.info("Kerbin -> Minmus cost: " + SolarSystem.getDeltaVBetween(kerbin, minmus) + " - should be: " + 1090);
        MainRegistry.logger.info("Mun -> Kerbin cost: " + SolarSystem.getDeltaVBetween(mun, kerbin) + " - should be: " + 1170);
        MainRegistry.logger.info("Minmus -> Kerbin cost: " + SolarSystem.getDeltaVBetween(minmus, kerbin) + " - should be: " + 1090);
        MainRegistry.logger.info("Minmus -> Ike cost: " + SolarSystem.getDeltaVBetween(minmus, ike));
        MainRegistry.logger.info("Kerbin orbital period: " + kerbin.getOrbitalPeriod() + " - should be: " + 426);
        MainRegistry.logger.info("Eve orbital period: " + eve.getOrbitalPeriod() + " - should be: " + 261);
        MainRegistry.logger.info("Mun orbital period: " + mun.getOrbitalPeriod() + " - should be: " + 6);
        TileEntityDysonReceiver.runTests();
    }

    public static class OrreryMetric {
        public Vec3 position;
        public Vec3[] orbitalPath;
        public CelestialBody body;
        private static final int PATH_RESOLUTION = 32;

        public OrreryMetric(CelestialBody body, Vec3 position) {
            this.body = body;
            this.position = position;
            this.orbitalPath = new Vec3[32];
        }
    }

    public static class AstroMetric {
        public double distance;
        public double angle;
        public double inclination;
        public double apparentSize;
        public double phase;
        public double phaseObscure;
        protected Vec3 position;
        public CelestialBody body;

        public AstroMetric(CelestialBody body, Vec3 position) {
            this.body = body;
            this.position = position;
        }
    }

    public static enum Body {
        ORBIT(""),
        KERBIN("kerbin"),
        MUN("mun"),
        MINMUS("minmus"),
        DUNA("duna"),
        MOHO("moho"),
        DRES("dres"),
        EVE("eve"),
        IKE("ike"),
        LAYTHE("laythe"),
        TEKTO("tekto");

        public String name;
        private CelestialBody body;

        private Body(String name) {
            this.name = name;
        }

        public CelestialBody getBody() {
            if (this == ORBIT) {
                return null;
            }
            if (this.body == null) {
                this.body = CelestialBody.getBody(this.name);
            }
            return this.body;
        }

        public int getProcessingLevel(CelestialBody from) {
            if (this == ORBIT) {
                return 0;
            }
            return this.getBody().getProcessingLevel(from);
        }

        public String getStoneTexture() {
            if (this == ORBIT) {
                return null;
            }
            return this.getBody().stoneTexture;
        }

        public int getDimensionId() {
            if (this == ORBIT) {
                return SpaceConfig.orbitDimension;
            }
            return this.getBody().dimensionId;
        }
    }
}

