/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluidmk2;

import api.hbm.fluidmk2.IFluidReceiverMK2;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;

public interface IFluidStandardReceiverMK2
extends IFluidReceiverMK2 {
    public FluidTank[] getReceivingTanks();

    @Override
    default public long getDemand(FluidType type, int pressure) {
        long amount = 0L;
        for (FluidTank tank : this.getReceivingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            amount += (long)(tank.getMaxFill() - tank.getFill());
        }
        return amount;
    }

    @Override
    default public long transferFluid(FluidType type, int pressure, long amount) {
        int tanks = 0;
        for (FluidTank tank : this.getReceivingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            ++tanks;
        }
        if (tanks > 1) {
            int firstRound = (int)Math.floor((double)amount / (double)tanks);
            FluidTank[] fluidTankArray = this.getReceivingTanks();
            int n = fluidTankArray.length;
            for (int tank = 0; tank < n; ++tank) {
                FluidTank tank2 = fluidTankArray[tank];
                if (tank2.getTankType() != type || tank2.getPressure() != pressure) continue;
                int toAdd = Math.min(firstRound, tank2.getMaxFill() - tank2.getFill());
                tank2.setFill(tank2.getFill() + toAdd);
                amount -= (long)toAdd;
            }
        }
        if (amount > 0L) {
            for (FluidTank tank : this.getReceivingTanks()) {
                if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
                int toAdd = (int)Math.min(amount, (long)(tank.getMaxFill() - tank.getFill()));
                tank.setFill(tank.getFill() + toAdd);
                amount -= (long)toAdd;
            }
        }
        return amount;
    }

    @Override
    default public int[] getReceivingPressureRange(FluidType type) {
        int[] nArray;
        int lowest = 5;
        int highest = 0;
        for (FluidTank tank : this.getReceivingTanks()) {
            if (tank.getTankType() != type) continue;
            if (tank.getPressure() < lowest) {
                lowest = tank.getPressure();
            }
            if (tank.getPressure() <= highest) continue;
            highest = tank.getPressure();
        }
        if (lowest <= highest) {
            int[] nArray2 = new int[2];
            nArray2[0] = lowest;
            nArray = nArray2;
            nArray2[1] = highest;
        } else {
            nArray = DEFAULT_PRESSURE_RANGE;
        }
        return nArray;
    }

    @Override
    default public long getReceiverSpeed(FluidType type, int pressure) {
        return 1000000000L;
    }
}

