/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energymk2;

import api.hbm.energymk2.IEnergyConductorMK2;
import api.hbm.energymk2.IEnergyHandlerMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.energymk2.Nodespace;
import api.hbm.energymk2.PowerNetMK2;
import com.hbm.util.Compat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyProviderMK2
extends IEnergyHandlerMK2 {
    default public void usePower(long power) {
        this.setPower(this.getPower() - power);
    }

    default public long getProviderSpeed() {
        return this.getMaxPower();
    }

    default public void tryProvide(World world, int x, int y, int z, ForgeDirection dir) {
        IEnergyReceiverMK2 rec;
        Nodespace.PowerNode node;
        IEnergyConductorMK2 con;
        TileEntity te = Compat.getTileStandard(world, x, y, z);
        boolean red = false;
        if (te instanceof IEnergyConductorMK2 && (con = (IEnergyConductorMK2)te).canConnect(dir.getOpposite()) && (node = Nodespace.getNode(world, x, y, z)) != null && node.net != null) {
            ((PowerNetMK2)node.net).addProvider(this);
            red = true;
        }
        if (te instanceof IEnergyReceiverMK2 && te != this && (rec = (IEnergyReceiverMK2)te).canConnect(dir.getOpposite())) {
            long provides = Math.min(this.getPower(), this.getProviderSpeed());
            long receives = Math.min(rec.getMaxPower() - rec.getPower(), rec.getReceiverSpeed());
            long toTransfer = Math.min(provides, receives);
            toTransfer -= rec.transferPower(toTransfer);
            this.usePower(toTransfer);
        }
    }
}

