/*
 * Decompiled with CFR 0.152.
 */
package serenetweaks.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonASMHelper;
import serenetweaks.data.TimeStampsWorldSavedData;

public class SnowRecalculationHandler {
    private static ArrayList<Chunk> recalculationQueue = new ArrayList();

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        TickEvent.Type type = event.type;
        Side side = event.side;
        TickEvent.Phase phase = event.phase;
        World world = event.world;
        if (world.field_73011_w.field_76574_g != 0) {
            return;
        }
        if (type != TickEvent.Type.WORLD || side != Side.SERVER) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (recalculationQueue.size() == 0) {
            return;
        }
        int i = 0;
        int c = 0;
        while (recalculationQueue.size() > i && c < 20) {
            Chunk chunk = recalculationQueue.get(i);
            if (chunk.field_76636_d && chunk.field_76646_k) {
                boolean success = true;
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int j3 = 0; j3 < 16; ++j3) {
                        int posX = chunk.field_76635_g * 16 + k2;
                        int posZ = chunk.field_76647_h * 16 + j3;
                        int posY1 = chunk.func_76626_d(k2, j3);
                        int posY2 = posY1 - 1;
                        if (world.func_72834_c(posX, posY2, posZ, false)) {
                            boolean bl = success = success && world.func_147465_d(posX, posY2, posZ, Blocks.field_150432_aD, 0, 2);
                        }
                        if (world.canSnowAtBody(posX, posY1, posZ, true)) {
                            boolean bl = success = success && world.func_147465_d(posX, posY1, posZ, Blocks.field_150431_aC, 0, 2);
                        }
                        if (!this.shouldMelt(world, posX, posY1, posZ)) continue;
                        if (world.func_147439_a(posX, posY2, posZ) == Blocks.field_150432_aD) {
                            boolean bl = success = success && world.func_147465_d(posX, posY2, posZ, Blocks.field_150355_j, 0, 2);
                        }
                        if (world.func_147439_a(posX, posY1, posZ) != Blocks.field_150431_aC) continue;
                        success = success && world.func_147465_d(posX, posY1, posZ, Blocks.field_150350_a, 0, 2);
                    }
                }
                if (success) {
                    recalculationQueue.remove(i);
                    ++c;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onChunkLoaded(ChunkEvent.Load event) {
        int savedTime;
        if (!ModConfig.seasons.shouldRecalculateSnow) {
            return;
        }
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (world.field_73011_w.field_76574_g != 0) {
            return;
        }
        int currentTime = (int)(chunk.field_76637_e.func_72820_D() / 20L);
        if (currentTime - (savedTime = TimeStampsWorldSavedData.getChunkTimeStamp(chunk)) > ModConfig.seasons.timeToRecalculateSnow * 60) {
            recalculationQueue.add(chunk);
        }
    }

    @SubscribeEvent
    public void onChunkUnLoaded(ChunkEvent.Unload event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (world.field_73011_w.field_76574_g != 0) {
            return;
        }
        this.removeFromRecalculationQueue(chunk);
        int currentTime = (int)(chunk.field_76637_e.func_72820_D() / 20L);
        TimeStampsWorldSavedData.setChunkTimeStamp(chunk, currentTime);
    }

    private boolean shouldMelt(World world, int x, int y, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        Season.SubSeason subSeason = SeasonHelper.getSeasonState(world).getSubSeason();
        float f = SeasonASMHelper.getFloatTemperature(subSeason, biome, x, y, z);
        return f >= 0.15f;
    }

    private boolean removeFromRecalculationQueue(Chunk chunk) {
        for (int i = 0; i < recalculationQueue.size(); ++i) {
            Chunk queueChunk = recalculationQueue.get(i);
            if (chunk.field_76635_g != queueChunk.field_76635_g || chunk.field_76647_h != queueChunk.field_76647_h) continue;
            recalculationQueue.remove(i);
            --i;
            return true;
        }
        return false;
    }
}

