/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.mixins;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockVine;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import sereneseasons.config.BiomeConfig;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColourUtil;

@Mixin(value={Block.class})
public abstract class BlockMixin {
    public int colorMultiplierOld(IBlockAccess blockAccess, int x, int y, int z) {
        return 0xFFFFFF;
    }

    int handleFoliage(IBlockAccess blockAccess, int x, int y, int z) {
        BiomeGenBase biome = blockAccess.func_72807_a(x, z);
        if (BiomeConfig.enablesSeasonalEffects(biome)) {
            SeasonTime calendar = SeasonHandler.getClientSeasonTime();
            Enum colorProvider = BiomeConfig.usesTropicalSeasons(biome) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            return SeasonColourUtil.applySeasonalFoliageColouring(colorProvider, biome, this.colorMultiplierOld(blockAccess, x, y, z));
        }
        return this.colorMultiplierOld(blockAccess, x, y, z);
    }

    int handleGrass(IBlockAccess blockAccess, int x, int y, int z) {
        return this.colorMultiplierOld(blockAccess, x, y, z);
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        Block block = (Block)this;
        if (block instanceof BlockGrass) {
            return this.handleGrass(blockAccess, x, y, z);
        }
        if (block instanceof BlockBush) {
            return this.handleGrass(blockAccess, x, y, z);
        }
        if (block instanceof BlockVine) {
            return this.handleFoliage(blockAccess, x, y, z);
        }
        if (block instanceof BlockLeaves) {
            if (block instanceof BlockOldLeaf && blockAccess.func_72805_g(x, y, z) % 4 == 1) {
                return this.colorMultiplierOld(blockAccess, x, y, z);
            }
            return this.handleFoliage(blockAccess, x, y, z);
        }
        return this.colorMultiplierOld(blockAccess, x, y, z);
    }
}

