/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.mixins;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import sereneseasons.asm.IBiomeMixin;
import sereneseasons.config.BiomeConfig;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonASMHelper;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColourUtil;

@Mixin(value={BiomeGenBase.class})
public abstract class BiomeMixin
implements IBiomeMixin {
    @Shadow
    public boolean field_76765_S;
    @Shadow
    protected static NoiseGeneratorPerlin field_150605_ac;
    @Shadow
    public float field_76750_F;

    @Shadow
    public abstract boolean func_150559_j();

    @Shadow
    @SideOnly(value=Side.CLIENT)
    public abstract float func_76727_i();

    @Shadow(remap=false)
    public abstract int getModdedBiomeGrassColor(int var1);

    @Override
    public boolean canSpawnLightningBoltOld() {
        return this.func_150559_j() ? false : this.field_76765_S;
    }

    @Override
    public boolean getEnableSnowOld() {
        return this.func_150559_j();
    }

    @Override
    public float getFloatTemperatureOld(int x, int y, int z) {
        if (y > 64) {
            float f = (float)field_150605_ac.func_151601_a((double)x * 1.0 / 8.0, (double)z * 1.0 / 8.0) * 4.0f;
            return this.field_76750_F - (f + (float)y - 64.0f) * 0.05f / 30.0f;
        }
        return this.field_76750_F;
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public boolean func_76738_d() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return this.canSpawnLightningBoltOld();
        }
        return SeasonASMHelper.shouldAddRainParticles((World)world, (BiomeGenBase)this);
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public boolean func_76746_c() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return this.getEnableSnowOld();
        }
        return SeasonASMHelper.shouldRenderRainSnow((World)world, (BiomeGenBase)this);
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public float func_150564_a(int x, int y, int z) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return this.getFloatTemperatureOld(x, y, z);
        }
        return SeasonASMHelper.getFloatTemperature((World)Minecraft.func_71410_x().field_71441_e, (BiomeGenBase)this, x, y, z);
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public int func_150558_b(int p_150558_1_, int p_150558_2_, int p_150558_3_) {
        double d0 = MathHelper.func_76131_a((float)this.func_150564_a(p_150558_1_, p_150558_2_, p_150558_3_), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        int old = this.getModdedBiomeGrassColor(ColorizerGrass.func_77480_a((double)d0, (double)d1));
        BiomeGenBase biome = (BiomeGenBase)this;
        if (BiomeConfig.enablesSeasonalEffects(biome)) {
            SeasonTime calendar = SeasonHandler.getClientSeasonTime();
            Enum colorProvider = BiomeConfig.usesTropicalSeasons(biome) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            return SeasonColourUtil.applySeasonalGrassColouring(colorProvider, biome, old);
        }
        return old;
    }
}

