/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonTime;

public class ItemSeasonClock
extends Item {
    private IIcon[] icons = new IIcon[64];
    private double field_185089_b;
    private double field_185088_a;
    private long ticks;

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < 64; ++i) {
            String num = String.valueOf(i);
            if (num.length() < 2) {
                num = "0" + num;
            }
            this.icons[i] = iconRegister.func_94245_a("sereneseasons:season_clock_" + num);
        }
        this.field_77791_bV = iconRegister.func_94245_a("sereneseasons:season_clock_00");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient worldClient = mc.field_71441_e;
        EntityClientPlayerMP entityClientPlayerMP = mc.field_71439_g;
        if (worldClient != null && entityClientPlayerMP != null && stack != null) {
            float frame = this.apply(stack, (World)worldClient, (EntityLivingBase)entityClientPlayerMP);
            int index = Math.round(frame * 64.0f);
            if (index >= 64) {
                index = 0;
            }
            return this.icons[index];
        }
        return this.field_77791_bV;
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static float positiveModulo(float numerator, float denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    @SideOnly(value=Side.CLIENT)
    public float apply(ItemStack stack, World world, EntityLivingBase entity) {
        double d0;
        EntityLivingBase holder;
        Object object = holder = entity != null ? entity : stack.func_82836_z();
        if (world == null && holder != null) {
            world = holder.field_70170_p;
        }
        if (world == null) {
            return 0.0f;
        }
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g)) {
            int seasonCycleTicks = SeasonHelper.getSeasonState(world).getSeasonCycleTicks();
            d0 = (float)seasonCycleTicks / (float)SeasonTime.ZERO.getCycleDuration();
        } else {
            d0 = Math.random();
        }
        d0 = this.actualFrame(world, d0);
        return ItemSeasonClock.positiveModulo((float)d0, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private double actualFrame(World world, double frame) {
        if (world.func_82737_E() != this.ticks) {
            this.ticks = (int)world.func_82737_E();
            double newFrame = frame - this.field_185088_a;
            if (newFrame < -0.5) {
                newFrame += 1.0;
            }
            this.field_185089_b += newFrame * 0.1;
            this.field_185089_b *= 0.9;
            this.field_185088_a += this.field_185089_b;
        }
        return this.field_185088_a;
    }
}

