/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.asm.IBiomeMixin;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.SeasonsConfig;

public class ModFertility {
    private static HashSet<String> springPlants = new HashSet();
    private static HashSet<String> summerPlants = new HashSet();
    private static HashSet<String> autumnPlants = new HashSet();
    private static HashSet<String> winterPlants = new HashSet();
    private static HashSet<String> allListedPlants = new HashSet();
    private static HashMap<String, Integer> seedSeasons = new HashMap();

    public static void init() {
        ModFertility.initSeasonCrops(FertilityConfig.seasonal_fertility.spring_crops, springPlants, 1);
        ModFertility.initSeasonCrops(FertilityConfig.seasonal_fertility.summer_crops, summerPlants, 2);
        ModFertility.initSeasonCrops(FertilityConfig.seasonal_fertility.autumn_crops, autumnPlants, 4);
        ModFertility.initSeasonCrops(FertilityConfig.seasonal_fertility.winter_crops, winterPlants, 8);
    }

    public static boolean isCropFertile(String cropName, World world, int x, int y, int z) {
        Season season = SeasonHelper.getSeasonState(world).getSeason();
        BiomeGenBase biome = world.func_72807_a(x, z);
        IBiomeMixin biomeMixin = (IBiomeMixin)biome;
        if (BiomeConfig.disablesCrops(biome)) {
            return false;
        }
        if (!(FertilityConfig.general_category.seasonal_crops && BiomeConfig.enablesSeasonalEffects(biome) && SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g))) {
            return true;
        }
        if (BiomeConfig.usesTropicalSeasons(biome)) {
            return summerPlants.contains(cropName) || !allListedPlants.contains(cropName);
        }
        if (biomeMixin.getFloatTemperatureOld(x, y, z) < 0.15f) {
            return winterPlants.contains(cropName);
        }
        if (season == Season.SPRING && springPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.SUMMER && summerPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.AUTUMN && autumnPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.WINTER && winterPlants.contains(cropName)) {
            return true;
        }
        if (!allListedPlants.contains(cropName)) {
            if (season == Season.WINTER) {
                return FertilityConfig.general_category.ignore_unlisted_crops;
            }
            return true;
        }
        return false;
    }

    private static void initSeasonCrops(String[] seeds, HashSet<String> cropSet, int bitmask) {
        for (String seed : seeds) {
            int seasons;
            String plantName;
            ResourceLocation loc = new ResourceLocation(seed);
            Item item = GameRegistry.findItem((String)loc.func_110624_b(), (String)loc.func_110623_a());
            if (item instanceof IPlantable) {
                Block plantBlock = ((IPlantable)item).getPlant(null, 0, 0, 0);
                plantName = GameRegistry.findUniqueIdentifierFor((Block)plantBlock).toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(seed)) {
                    seasons = seedSeasons.get(seed);
                    seedSeasons.put(seed, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(seed, bitmask);
                continue;
            }
            Block block = GameRegistry.findBlock((String)loc.func_110624_b(), (String)loc.func_110623_a());
            if (block == null || block == Blocks.field_150350_a) continue;
            plantName = GameRegistry.findUniqueIdentifierFor((Block)block).toString();
            cropSet.add(plantName);
            if (bitmask == 0) continue;
            allListedPlants.add(plantName);
            if (seedSeasons.containsKey(seed)) {
                seasons = seedSeasons.get(seed);
                seedSeasons.put(seed, seasons | bitmask);
                continue;
            }
            seedSeasons.put(seed, bitmask);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupTooltips(ItemTooltipEvent event) {
        if (FertilityConfig.general_category.crop_tooltips && FertilityConfig.general_category.seasonal_crops) {
            String name;
            try {
                name = GameRegistry.findUniqueIdentifierFor((Item)event.itemStack.func_77973_b()).toString();
            }
            catch (Exception ex) {
                return;
            }
            if (seedSeasons.containsKey(name)) {
                int mask = seedSeasons.get(name);
                String fertileSeasons = StatCollector.func_74838_a((String)"desc.sereneseasons.fertile_seasons");
                event.toolTip.add(fertileSeasons);
                if ((mask & 1) != 0 && (mask & 2) != 0 && (mask & 4) != 0 && (mask & 8) != 0) {
                    event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)"desc.sereneseasons.year_round"));
                } else {
                    if ((mask & 1) != 0) {
                        event.toolTip.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"desc.sereneseasons.spring"));
                    }
                    if ((mask & 2) != 0) {
                        event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"desc.sereneseasons.summer"));
                    }
                    if ((mask & 4) != 0) {
                        event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"desc.sereneseasons.autumn"));
                    }
                    if ((mask & 8) != 0) {
                        event.toolTip.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"desc.sereneseasons.winter"));
                    }
                }
            }
        }
    }
}

