/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sereneseasons.api.ISSBlock;
import sereneseasons.api.SSBlocks;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.item.ItemSSBlock;
import sereneseasons.season.SeasonTime;
import sereneseasons.tileentity.TileEntitySeasonSensor;

public class BlockSeasonSensor
extends BlockContainer
implements ISSBlock {
    private final DetectorType type;
    IIcon iconSide;
    IIcon iconTop;

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemSSBlock.class;
    }

    public BlockSeasonSensor(DetectorType type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(0.2f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.375f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        switch (this.type) {
            case SPRING: {
                this.iconTop = ir.func_94245_a("sereneseasons:season_sensor_spring_top");
                break;
            }
            case SUMMER: {
                this.iconTop = ir.func_94245_a("sereneseasons:season_sensor_summer_top");
                break;
            }
            case AUTUMN: {
                this.iconTop = ir.func_94245_a("sereneseasons:season_sensor_autumn_top");
                break;
            }
            case WINTER: {
                this.iconTop = ir.func_94245_a("sereneseasons:season_sensor_winter_top");
            }
        }
        this.iconSide = ir.func_94245_a("sereneseasons:season_sensor_side");
    }

    public IIcon func_149691_a(int i, int m) {
        if (i == 1) {
            return this.iconTop;
        }
        return this.iconSide;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return blockAccess.func_72805_g(x, y, z);
    }

    public void updatePower(World world, int x, int y, int z) {
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g)) {
            int meta = world.func_72805_g(x, y, z);
            int power = 0;
            int startTicks = this.type.ordinal() * SeasonTime.ZERO.getSeasonDuration();
            int endTicks = (this.type.ordinal() + 1) * SeasonTime.ZERO.getSeasonDuration();
            int currentTicks = SeasonHelper.getSeasonState(world).getSeasonCycleTicks();
            if (currentTicks >= startTicks && currentTicks <= endTicks) {
                float delta = (float)(currentTicks - startTicks) / (float)SeasonTime.ZERO.getSeasonDuration();
                power = (int)Math.min(delta * 15.0f + 1.0f, 15.0f);
            }
            if (meta != power) {
                world.func_72921_c(x, y, z, power, 3);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Block nextBlock = SSBlocks.season_sensors[(this.type.ordinal() + 1) % DetectorType.values().length];
        world.func_147449_b(x, y, z, nextBlock);
        ((BlockSeasonSensor)nextBlock).updatePower(world, x, y, z);
        return true;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)SSBlocks.season_sensors[0]);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySeasonSensor();
    }

    public static enum DetectorType {
        SPRING,
        SUMMER,
        AUTUMN,
        WINTER;


        public String getName() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.getName();
        }
    }
}

