/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network.data;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.IReadOnlyCollection;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelNormal;
import appeng.parts.p2p.PartP2PTunnelStatic;
import appeng.util.Platform;
import com.projecturanus.betterp2p.BetterP2P;
import com.projecturanus.betterp2p.network.data.P2PInfo;
import com.projecturanus.betterp2p.network.data.P2PInfoKt;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.network.data.P2PLocationKt;
import com.projecturanus.betterp2p.util.p2p.P2PUtilKt;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0013J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J,\u0010\u001f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0014\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0012J\"\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/projecturanus/betterp2p/network/data/GridServerCache;", "", "grid", "Lappeng/api/networking/IGrid;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "type", "", "<init>", "(Lappeng/api/networking/IGrid;Lnet/minecraft/entity/player/EntityPlayer;I)V", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayer;", "getType", "()I", "setType", "(I)V", "listP2P", "", "Lcom/projecturanus/betterp2p/network/data/P2PLocation;", "Lappeng/parts/p2p/PartP2PTunnel;", "dirtyP2P", "", "rebuildList", "", "retrieveP2PList", "", "Lcom/projecturanus/betterp2p/network/data/P2PInfo;", "markDirty", "key", "p2p", "getP2PUpdates", "linkP2P", "Lkotlin/Pair;", "inputIndex", "outputIndex", "unlinkP2P", "p2pIndex", "changeP2PType", "tunnel", "newType", "Lcom/projecturanus/betterp2p/util/p2p/TunnelInfo;", "changeAllP2Ps", "", "betterp2p"})
@SourceDebugExtension(value={"SMAP\nGridServerCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridServerCache.kt\ncom/projecturanus/betterp2p/network/data/GridServerCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1863#2:282\n1863#2,2:283\n1864#2:285\n1611#2,9:286\n1863#2:295\n1864#2:297\n1620#2:298\n1611#2,9:299\n1863#2:308\n1864#2:310\n1620#2:311\n1#3:296\n1#3:309\n*S KotlinDebug\n*F\n+ 1 GridServerCache.kt\ncom/projecturanus/betterp2p/network/data/GridServerCache\n*L\n50#1:282\n54#1:283,2\n50#1:285\n74#1:286,9\n74#1:295\n74#1:297\n74#1:298\n99#1:299,9\n99#1:308\n99#1:310\n99#1:311\n74#1:296\n99#1:309\n*E\n"})
public final class GridServerCache {
    @NotNull
    private final IGrid grid;
    @NotNull
    private final EntityPlayer player;
    private int type;
    @NotNull
    private final Map<P2PLocation, PartP2PTunnel<?>> listP2P;
    @NotNull
    private final Set<P2PLocation> dirtyP2P;

    public GridServerCache(@NotNull IGrid grid, @NotNull EntityPlayer player, int type) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.grid = grid;
        this.player = player;
        this.type = type;
        this.listP2P = new LinkedHashMap();
        this.dirtyP2P = new LinkedHashSet();
        this.rebuildList(this.type);
    }

    @NotNull
    public final EntityPlayer getPlayer() {
        return this.player;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rebuildList(int type) {
        Map<P2PLocation, PartP2PTunnel<?>> map = this.listP2P;
        synchronized (map) {
            boolean bl = false;
            this.listP2P.clear();
            this.dirtyP2P.clear();
            IReadOnlyCollection iReadOnlyCollection = this.grid.getMachinesClasses();
            Intrinsics.checkNotNullExpressionValue((Object)iReadOnlyCollection, (String)"getMachinesClasses(...)");
            Iterable $this$forEach$iv = (Iterable)iReadOnlyCollection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                if (!PartP2PTunnel.class.isAssignableFrom(it)) continue;
                if (type != -1) {
                    TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromIndex(type);
                    if (!Intrinsics.areEqual(tunnelInfo != null ? tunnelInfo.getClazz() : null, (Object)it)) continue;
                }
                IMachineSet iMachineSet = this.grid.getMachines(it);
                Intrinsics.checkNotNullExpressionValue((Object)iMachineSet, (String)"getMachines(...)");
                Iterable $this$forEach$iv2 = (Iterable)iMachineSet;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IGridNode gridNode = (IGridNode)element$iv2;
                    boolean bl3 = false;
                    IGridHost iGridHost = gridNode.getMachine();
                    Intrinsics.checkNotNull((Object)iGridHost, (String)"null cannot be cast to non-null type appeng.parts.p2p.PartP2PTunnel<*>");
                    PartP2PTunnel p2p = (PartP2PTunnel)iGridHost;
                    this.listP2P.put(P2PLocationKt.toLoc(p2p), p2p);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<P2PInfo> retrieveP2PList() {
        void $this$mapNotNullTo$iv$iv;
        if (this.grid instanceof ISecurityGrid && !((ISecurityGrid)this.grid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return CollectionsKt.emptyList();
        }
        this.rebuildList(this.type);
        Iterable $this$mapNotNull$iv = this.listP2P.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            P2PInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PartP2PTunnel it = (PartP2PTunnel)element$iv$iv;
            boolean bl2 = false;
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(it.getClass());
            int index = tunnelInfo != null ? tunnelInfo.getIndex() : -1;
            if ((this.type == -1 || index == this.type ? P2PInfoKt.toInfo(it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markDirty(@NotNull P2PLocation key, @NotNull PartP2PTunnel<?> p2p) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(p2p, (String)"p2p");
        Map<P2PLocation, PartP2PTunnel<?>> map = this.listP2P;
        synchronized (map) {
            boolean bl = false;
            if (this.type == -1 || P2PUtilKt.getTypeIndex(p2p) == this.type) {
                this.listP2P.put(key, p2p);
                this.dirtyP2P.add(key);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<P2PInfo> getP2PUpdates() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.dirtyP2P;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            P2PInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            P2PLocation it = (P2PLocation)element$iv$iv;
            boolean bl2 = false;
            PartP2PTunnel<?> partP2PTunnel = this.listP2P.get(it);
            if ((partP2PTunnel != null ? P2PInfoKt.toInfo(partP2PTunnel) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List result = (List)destination$iv$iv;
        this.dirtyP2P.clear();
        return result;
    }

    @Nullable
    public final Pair<PartP2PTunnel<?>, PartP2PTunnel<?>> linkP2P(@NotNull P2PLocation inputIndex, @NotNull P2PLocation outputIndex) {
        Intrinsics.checkNotNullParameter((Object)inputIndex, (String)"inputIndex");
        Intrinsics.checkNotNullParameter((Object)outputIndex, (String)"outputIndex");
        PartP2PTunnel<?> partP2PTunnel = this.listP2P.get(inputIndex);
        if (partP2PTunnel == null) {
            return null;
        }
        PartP2PTunnel<?> input = partP2PTunnel;
        PartP2PTunnel<?> partP2PTunnel2 = this.listP2P.get(outputIndex);
        if (partP2PTunnel2 == null) {
            return null;
        }
        PartP2PTunnel<?> output = partP2PTunnel2;
        if (this.grid instanceof ISecurityGrid && !((ISecurityGrid)this.grid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return null;
        }
        if (!Intrinsics.areEqual(input.getClass(), output.getClass())) {
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(input.getClass());
            Intrinsics.checkNotNull((Object)tunnelInfo);
            PartP2PTunnel<?> partP2PTunnel3 = this.changeP2PType(output, tunnelInfo);
            if (partP2PTunnel3 == null) {
                return null;
            }
            output = partP2PTunnel3;
        }
        if (Intrinsics.areEqual(input, output)) {
            return null;
        }
        NBTTagCompound memoryCardData = null;
        PartP2PTunnel inputResult = input.convertToInput(this.player, null);
        if (inputResult == null) {
            throw new IllegalStateException("Cannot bind");
        }
        memoryCardData = inputResult.getMemoryCardData();
        this.markDirty(inputIndex, inputResult);
        ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)memoryCardData);
        long freq = memoryCardData.func_74763_f("freq");
        PartP2PTunnel outputResult = output.convertToOutput(this.player, newType, freq);
        if (outputResult == null) {
            throw new IllegalStateException("Cannot bind");
        }
        this.markDirty(outputIndex, outputResult);
        return TuplesKt.to((Object)inputResult, (Object)outputResult);
    }

    @Nullable
    public final PartP2PTunnel<?> unlinkP2P(@NotNull P2PLocation p2pIndex) {
        Intrinsics.checkNotNullParameter((Object)p2pIndex, (String)"p2pIndex");
        PartP2PTunnel<?> partP2PTunnel = this.listP2P.get(p2pIndex);
        if (partP2PTunnel == null) {
            return null;
        }
        PartP2PTunnel<?> tunnel = partP2PTunnel;
        PartP2PTunnel newTunnel = tunnel.unbind(this.player);
        if (!Intrinsics.areEqual((Object)newTunnel, tunnel)) {
            Intrinsics.checkNotNull((Object)newTunnel);
            this.markDirty(p2pIndex, newTunnel);
        }
        return newTunnel;
    }

    private final PartP2PTunnel<?> changeP2PType(PartP2PTunnel<?> tunnel, TunnelInfo newType) {
        if (Intrinsics.areEqual((Object)BetterP2P.INSTANCE.getProxy().getP2PFromClass(tunnel.getClass()), (Object)newType)) {
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.same_type", new Object[0]));
            return null;
        }
        boolean converted = false;
        if (PartP2PTunnelStatic.class.isAssignableFrom(newType.getClazz())) {
            Intrinsics.checkNotNullExpressionValue((Object)this.player.field_71071_by.field_70462_a, (String)"mainInventory");
            Object[] objectArray = this.player.field_71071_by.field_70462_a;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack stack;
                int i2 = i;
                ItemStack itemStack = stack = objectArray[i];
                boolean bl = itemStack != null ? itemStack.func_77969_a(newType.getStack()) : false;
                if (!bl) continue;
                this.player.field_71071_by.func_70298_a(i2, 1);
                converted = true;
                break;
            }
            if (!converted) {
                objectArray = new Object[]{1, newType.getStack().func_82833_r()};
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.missing_items", objectArray));
                return null;
            }
        }
        if (tunnel instanceof PartP2PTunnelStatic) {
            List attunables = BetterP2P.INSTANCE.getProxy().getP2PTypeList().stream().filter(arg_0 -> GridServerCache.changeP2PType$lambda$7(GridServerCache::changeP2PType$lambda$6, arg_0)).sorted((arg_0, arg_1) -> GridServerCache.changeP2PType$lambda$9((arg_0, arg_1) -> GridServerCache.changeP2PType$lambda$8(newType, arg_0, arg_1), arg_0, arg_1)).collect(Collectors.toList());
            block3: for (TunnelInfo attunable : attunables) {
                Intrinsics.checkNotNullExpressionValue((Object)this.player.field_71071_by.field_70462_a, (String)"mainInventory");
                ItemStack[] i2 = this.player.field_71071_by.field_70462_a;
                int n = i2.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack stack;
                    int i3 = i;
                    ItemStack itemStack = stack = i2[i];
                    boolean bl = itemStack != null ? itemStack.func_77969_a(attunable.getStack()) : false;
                    if (!bl) continue;
                    this.player.field_71071_by.func_70298_a(i3, 1);
                    converted = true;
                    break block3;
                }
            }
            if (!converted) {
                Object[] objectArray = new Object[]{1, newType.getStack().func_82833_r()};
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.missing_items", objectArray));
                return null;
            }
        }
        if (converted) {
            ItemStack drop = ItemStack.func_77944_b((ItemStack)tunnel.getItemStack());
            drop.field_77994_a = 1;
            ItemStack[] attunable = new ItemStack[]{drop};
            List drops = CollectionsKt.mutableListOf((Object[])attunable);
            tunnel.getDrops(drops, false);
            for (ItemStack j : drops) {
                this.player.field_71071_by.func_70441_a(j);
            }
            Platform.spawnDrops((World)this.player.field_70170_p, (int)((int)this.player.field_70165_t), (int)((int)this.player.field_70163_u), (int)((int)this.player.field_70161_v), (List)drops);
        }
        IPartHost host = tunnel.getHost();
        host.removePart(tunnel.getSide(), false);
        ForgeDirection dir = host.addPart(newType.getStack(), tunnel.getSide(), this.player);
        IPart newPart = host.getPart(dir);
        if (newPart instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newPart, tunnel.isOutput());
            try {
                P2PCache p2PCache = ((PartP2PTunnel)newPart).getProxy().getP2P();
                Intrinsics.checkNotNullExpressionValue((Object)p2PCache, (String)"getP2P(...)");
                P2PCache p2p = p2PCache;
                p2p.updateFreq((PartP2PTunnel)newPart, tunnel.getFrequency());
                return (PartP2PTunnel)newPart;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public final boolean changeAllP2Ps(@NotNull P2PLocation p2p, @NotNull TunnelInfo newType) {
        Intrinsics.checkNotNullParameter((Object)p2p, (String)"p2p");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        if (this.grid instanceof ISecurityGrid && !((ISecurityGrid)this.grid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return false;
        }
        PartP2PTunnel partP2PTunnel = this.listP2P.get(p2p);
        if (partP2PTunnel == null) {
            return false;
        }
        PartP2PTunnel tunnel = partP2PTunnel;
        try {
            if (tunnel.isOutput() && tunnel.getInput() != null) {
                tunnel = tunnel.getInput();
            }
            TunnelCollection tunnelCollection = tunnel.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)tunnelCollection, (String)"getOutputs(...)");
            List outputs = CollectionsKt.toMutableList((Iterable)((Iterable)tunnelCollection));
            if (PartP2PTunnelStatic.class.isAssignableFrom(newType.getClazz())) {
                int amt = outputs.size() + 1;
                int hasItems = 0;
                Object[] objectArray = ArrayIteratorKt.iterator((Object[])this.player.field_71071_by.field_70462_a);
                while (objectArray.hasNext()) {
                    ItemStack stack;
                    ItemStack itemStack = stack = (ItemStack)objectArray.next();
                    boolean bl = itemStack != null ? itemStack.func_77969_a(newType.getStack()) : false;
                    if (!bl || (hasItems += stack.field_77994_a) < amt) continue;
                }
                if (hasItems < amt) {
                    objectArray = new Object[]{amt, newType.getStack().func_82833_r()};
                    this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.advanced_memory_card.error.missing_items", objectArray));
                    return false;
                }
            }
            this.changeP2PType(tunnel, newType);
            for (PartP2PTunnel o : outputs) {
                Intrinsics.checkNotNull((Object)o);
                this.changeP2PType(o, newType);
            }
            return true;
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    private static final boolean changeP2PType$lambda$6(TunnelInfo e) {
        return PartP2PTunnelNormal.class.isAssignableFrom(e.getClazz());
    }

    private static final boolean changeP2PType$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int changeP2PType$lambda$8(TunnelInfo $newType, TunnelInfo o1, TunnelInfo o2) {
        return o1.equals($newType) ? -1 : (o2.equals($newType) ? 1 : 0);
    }

    private static final int changeP2PType$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

