/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import net.minecraft.inventory.Slot;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.ReflectionCache;

public class Reflection {
    public static ReflectionCache forestry;
    public static ReflectionCache codechickencore;
    public static ReflectionCache NEI;

    public static boolean reflectForestry() {
        forestry = new ReflectionCache();
        Class<?> guiForestryClass = Reflection.getClass("forestry.core.gui.GuiForestry");
        if (guiForestryClass != null) {
            forestry.storeClass("GuiForestry", guiForestryClass);
            Reflection.forestry.available = true;
            Field inventorySlotsField = Reflection.getField(guiForestryClass, "inventorySlots");
            if (inventorySlotsField != null) {
                forestry.storeField("inventorySlots", inventorySlotsField);
                Method getSlotAtPositionMethod = Reflection.getMethod(guiForestryClass, "getSlotAtPosition", Integer.TYPE, Integer.TYPE);
                if (getSlotAtPositionMethod != null) {
                    forestry.storeMethod("getSlotAtPosition", getSlotAtPositionMethod);
                    Method handleMouseClickMethod = Reflection.getMethod(guiForestryClass, "handleMouseClick", Slot.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    if (handleMouseClickMethod != null) {
                        forestry.storeMethod("handleMouseClick", handleMouseClickMethod);
                        Reflection.forestry.compatible = true;
                    }
                }
            }
        }
        return Reflection.forestry.compatible;
    }

    public static boolean reflectCodeChickenCore() {
        codechickencore = new ReflectionCache();
        Class<?> guiContainerWidgetClass = Reflection.getClass("codechicken.core.inventory.GuiContainerWidget");
        if (guiContainerWidgetClass != null) {
            codechickencore.storeClass("GuiContainerWidget", guiContainerWidgetClass);
            Reflection.codechickencore.available = true;
            Reflection.codechickencore.compatible = true;
        }
        return Reflection.codechickencore.compatible;
    }

    public static boolean reflectNEI() {
        NEI = new ReflectionCache();
        Class<?> guiRecipeClass = Reflection.getClass("codechicken.nei.recipe.GuiRecipe");
        if (guiRecipeClass != null) {
            NEI.storeClass("GuiRecipe", guiRecipeClass);
            Reflection.NEI.available = true;
            Class<?> guiEnchantmentModifierClass = Reflection.getClass("codechicken.nei.GuiEnchantmentModifier");
            if (guiEnchantmentModifierClass != null) {
                NEI.storeClass("GuiEnchantmentModifier", guiEnchantmentModifierClass);
                Reflection.NEI.compatible = true;
            }
        }
        return Reflection.NEI.compatible;
    }

    public static boolean is(Object object, String name) {
        return object.getClass().getSimpleName() == name;
    }

    public static boolean doesClassExist(String name) {
        Class<?> clazz = Reflection.getClass(name);
        return clazz != null;
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            Field field = null;
            try {
                field = clazz.getField(name);
            }
            catch (Exception e) {
                field = null;
            }
            if (field == null) {
                field = clazz.getDeclaredField(name);
            }
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            if (!Objects.equals(name, "ofProfiler") && !Objects.equals(name, "inventorySlots")) {
                Constants.LOGGER.error("Could not retrieve field \"" + name + "\" from class \"" + clazz.getName() + "\"", (Throwable)e);
            }
            return null;
        }
    }

    public static Field getFinalField(Class<?> clazz, String name) {
        try {
            Field field = null;
            try {
                field = clazz.getField(name);
            }
            catch (Exception e) {
                field = null;
            }
            if (field == null) {
                field = clazz.getDeclaredField(name);
            }
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.set(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            Constants.LOGGER.error("Could not retrieve field \"" + name + "\" from class \"" + clazz.getName() + "\"", (Throwable)e);
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            Method method = null;
            try {
                method = clazz.getMethod(name, args);
            }
            catch (Exception e) {
                method = null;
            }
            if (method == null) {
                method = args != null & args.length != 0 ? clazz.getDeclaredMethod(name, args) : clazz.getDeclaredMethod(name, new Class[0]);
            }
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            Constants.LOGGER.error("Could not retrieve method \"" + name + "\" from class \"" + clazz.getName() + "\"", (Throwable)e);
            return null;
        }
    }

    public static String methodToString(Method method) {
        return Modifier.toString(method.getModifiers()) + " " + (method.getReturnType() != null ? method.getReturnType().getName() : "void") + " " + method.getName();
    }
}

