/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.api.base;

import java.awt.Color;
import tehnut.resourceful.crops.api.base.Chance;
import tehnut.resourceful.crops.api.base.ChanceBuilder;
import tehnut.resourceful.crops.api.base.Compat;
import tehnut.resourceful.crops.api.base.CompatBuilder;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.base.SeedReq;
import tehnut.resourceful.crops.api.base.SeedReqBuilder;

public class SeedBuilder {
    private String name;
    private int tier;
    private int amount;
    private String input;
    private String output;
    private String secondOutput = null;
    private String thirdOutput = null;
    private Color color;
    private SeedReq seedReq = new SeedReqBuilder().build();
    private Chance chance = new ChanceBuilder().build();
    private boolean compatSeed = false;
    private Compat compat = new CompatBuilder().build();

    public SeedBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SeedBuilder setTier(int tier) {
        this.tier = tier > 4 ? 4 : (tier < 1 ? 1 : tier);
        return this;
    }

    public SeedBuilder setAmount(int amount) {
        this.amount = amount > 64 ? 64 : amount;
        return this;
    }

    public SeedBuilder setInput(String input) {
        this.input = input;
        return this;
    }

    public SeedBuilder setOutput(String output) {
        this.output = output;
        return this;
    }

    public SeedBuilder setSecondOutput(String secondOutput) {
        this.secondOutput = secondOutput;
        return this;
    }

    public SeedBuilder setThirdOutput(String thirdOutput) {
        this.thirdOutput = thirdOutput;
        return this;
    }

    public SeedBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public SeedBuilder setSeedReq(SeedReq seedReq) {
        this.seedReq = seedReq;
        return this;
    }

    public SeedBuilder setChance(Chance chance) {
        this.chance = chance;
        return this;
    }

    public SeedBuilder setCompatSeed(boolean compatSeed) {
        this.compatSeed = compatSeed;
        return this;
    }

    public SeedBuilder setCompat(Compat compat) {
        this.compat = compat;
        return this;
    }

    public Seed build() {
        return new Seed(this.name, this.tier, this.amount, this.input, this.output, this.secondOutput, this.thirdOutput, this.color, this.seedReq, this.chance, this.compatSeed, this.compat);
    }
}

