/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import com.InfinityRaider.AgriCraft.utility.Vector;
import net.minecraft.util.Vec3;

public class TransformationMatrix {
    private static final int SIZE = 4;
    private double[][] matrix = new double[4][4];

    public TransformationMatrix() {
        for (int i = 0; i < 4; ++i) {
            this.matrix[i][i] = 1.0;
        }
    }

    public TransformationMatrix(double angle, double x, double y, double z) {
        this.setRotation(angle, x, y, z);
        this.matrix[3][3] = 1.0;
    }

    public TransformationMatrix(double x, double y, double z) {
        this.setTranslation(x, y, z);
        for (int i = 0; i < 4; ++i) {
            this.matrix[i][i] = 1.0;
        }
    }

    public TransformationMatrix(Vec3 translation) {
        this(translation.field_72450_a, translation.field_72448_b, translation.field_72449_c);
    }

    public TransformationMatrix(Vector translation) {
        this(translation.getX(), translation.getY(), translation.getZ());
    }

    public TransformationMatrix(double angle, double x, double y, double z, Vector translation) {
        this.setRotation(angle, x, y, z);
        this.setTranslation(translation);
        this.matrix[3][3] = 1.0;
    }

    public TransformationMatrix(double[][] data) {
        this();
        int m = 3 >= data.length ? data.length : 3;
        for (int i = 0; i < m; ++i) {
            int n = 4 >= data[i].length ? data[i].length : 4;
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = data[i][j];
            }
        }
    }

    public void setRotation(double angle, double x, double y, double z) {
        Vector axis = new Vector(x, y, z).normalize();
        angle = Math.toRadians(angle);
        x = axis.getX();
        y = axis.getY();
        z = axis.getZ();
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        this.matrix[0][0] = x * x * (1.0 - cos) + cos;
        this.matrix[0][1] = y * x * (1.0 - cos) - z * sin;
        this.matrix[0][2] = z * x * (1.0 - cos) + y * sin;
        this.matrix[1][0] = x * y * (1.0 - cos) + z * sin;
        this.matrix[1][1] = y * y * (1.0 - cos) + cos;
        this.matrix[1][2] = y * z * (1.0 - cos) - x * sin;
        this.matrix[2][0] = x * z * (1.0 - cos) - y * sin;
        this.matrix[2][1] = y * z * (1.0 - cos) + x * sin;
        this.matrix[2][2] = z * z * (1.0 - cos) + cos;
    }

    public void setTranslation(Vector v) {
        this.setTranslation(v.getX(), v.getY(), v.getZ());
    }

    public void setTranslation(double x, double y, double z) {
        this.matrix[0][3] = x;
        this.matrix[1][3] = y;
        this.matrix[2][3] = z;
    }

    public double[] getTranslation() {
        return new double[]{this.matrix[0][3], this.matrix[1][3], this.matrix[2][3]};
    }

    public TransformationMatrix scale(double x, double y, double z) {
        TransformationMatrix m = new TransformationMatrix();
        m.matrix[0][0] = x;
        m.matrix[1][1] = y;
        m.matrix[2][2] = z;
        this.multiplyRightWith(m);
        return this;
    }

    public TransformationMatrix multiplyLeftWith(TransformationMatrix m) {
        double[][] newValues = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double value = 0.0;
                for (int k = 0; k < 4; ++k) {
                    value += m.matrix[i][k] * this.matrix[k][j];
                }
                newValues[i][j] = value;
            }
        }
        this.matrix = newValues;
        return this;
    }

    public TransformationMatrix multiplyRightWith(TransformationMatrix m) {
        double[][] newValues = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double value = 0.0;
                for (int k = 0; k < 4; ++k) {
                    value += this.matrix[i][k] * m.matrix[k][j];
                }
                newValues[i][j] = value;
            }
        }
        this.matrix = newValues;
        return this;
    }

    public double[] transform(double x, double y, double z) {
        double[] coords = new double[]{x, y, z, 1.0};
        double[] result = new double[3];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                result[i] = result[i] + this.matrix[i][j] * coords[j];
            }
        }
        return result;
    }
}

