/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.peripheral;

import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.tileentity.TileEntitySeedAnalyzer;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.IMethod;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodAnalyze;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodException;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetBaseBlock;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetBaseBlockType;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetBrightness;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetBrightnessRange;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetCurrentSoil;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetGrowthStage;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetNeededSoil;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetPlant;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetSpecimen;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodGetStats;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodHasJournal;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodHasPlant;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodHasWeeds;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodIsAnalyzed;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodIsCrossCrop;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodIsFertile;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodIsMature;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodNeedsBaseBlock;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.peripheral.IPeripheral"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.SimpleComponent"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.ManagedPeripheral")})
public class TileEntityPeripheral
extends TileEntitySeedAnalyzer
implements IPeripheral,
SimpleComponent,
ManagedPeripheral {
    private static IMethod[] methods;
    private boolean mayAnalyze = false;
    @SideOnly(value=Side.CLIENT)
    private int updateCheck;
    @SideOnly(value=Side.CLIENT)
    private HashMap<ForgeDirection, Integer> timers;
    @SideOnly(value=Side.CLIENT)
    private HashMap<ForgeDirection, Boolean> activeSides;
    public static final ForgeDirection[] VALID_DIRECTIONS;
    public static final int MAX = 60;

    public TileEntityPeripheral() {
        this.initMethods();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("ac_Flag", this.mayAnalyze);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.mayAnalyze = tag.func_74764_b("ac_Flag") && tag.func_74767_n("ac_Flag");
    }

    private void initMethods() {
        if (methods == null) {
            methods = TileEntityPeripheral.methodList();
        }
    }

    public IMethod[] getMethods() {
        this.initMethods();
        return methods;
    }

    @Override
    public void func_145845_h() {
        if (this.mayAnalyze) {
            if (this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
                super.func_145845_h();
            } else {
                this.reset();
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.updateCheck == 0) {
                this.checkSides();
            }
            for (ForgeDirection dir : VALID_DIRECTIONS) {
                int timer = this.timers.get(dir);
                timer = (timer += this.isSideActive(dir) ? 1 : -1) < 0 ? 0 : timer;
                timer = timer > 60 ? 60 : timer;
                this.timers.put(dir, timer);
            }
            this.updateCheck = (this.updateCheck + 1) % 1200;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimer(ForgeDirection dir) {
        if (this.updateCheck == 0 || this.timers == null) {
            this.checkSides();
        }
        return this.timers.get(dir);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isSideActive(ForgeDirection dir) {
        return this.activeSides.containsKey(dir) && this.activeSides.get(dir) != false;
    }

    @SideOnly(value=Side.CLIENT)
    public void checkSides() {
        for (ForgeDirection dir : VALID_DIRECTIONS) {
            this.checkSide(dir);
        }
        this.updateCheck = 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void checkSide(ForgeDirection dir) {
        if (this.timers == null) {
            this.timers = new HashMap();
        }
        if (!this.timers.containsKey(dir)) {
            this.timers.put(dir, 0);
        }
        if (this.activeSides == null) {
            this.activeSides = new HashMap();
        }
        this.activeSides.put(dir, this.isCrop(dir));
    }

    private boolean isCrop(ForgeDirection dir) {
        return this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof BlockCrop;
    }

    public void startAnalyzing() {
        if (!this.mayAnalyze && this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
            this.mayAnalyze = true;
            this.markForUpdate();
        }
    }

    @Override
    public void analyze() {
        super.analyze();
        this.reset();
    }

    private void reset() {
        if (this.mayAnalyze) {
            this.mayAnalyze = false;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    public String getName() {
        return "agricraft_peripheral";
    }

    public String[] getAllMethodNames() {
        String[] names = new String[methods.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = methods[i].getName();
        }
        return names;
    }

    public Object[] invokeMethod(IMethod method, Object ... arguments) throws MethodException {
        return method.call(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getJournal(), arguments);
    }

    private static IMethod[] methodList() {
        return new IMethod[]{new MethodAnalyze(), new MethodGetBaseBlock(), new MethodGetBaseBlockType(), new MethodGetBrightness(), new MethodGetBrightnessRange(), new MethodGetCurrentSoil(), new MethodGetGrowthStage(), new MethodGetNeededSoil(), new MethodGetPlant(), new MethodGetSpecimen(), new MethodGetStats(), new MethodHasJournal(), new MethodHasPlant(), new MethodHasWeeds(), new MethodIsAnalyzed(), new MethodIsCrossCrop(), new MethodIsFertile(), new MethodIsMature(), new MethodNeedsBaseBlock()};
    }

    @Override
    public String getType() {
        return this.getName();
    }

    @Override
    public String[] getMethodNames() {
        return this.getAllMethodNames();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        IMethod calledMethod = methods[method];
        try {
            return this.invokeMethod(calledMethod, arguments);
        }
        catch (MethodException e) {
            throw new LuaException(e.getDescription());
        }
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other instanceof TileEntityPeripheral;
    }

    @Override
    public String getComponentName() {
        return this.getName();
    }

    @Override
    public String[] methods() {
        return this.getAllMethodNames();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        IMethod calledMethod = null;
        for (IMethod iMethod : methods) {
            if (!iMethod.getName().equals(method)) continue;
            calledMethod = iMethod;
            break;
        }
        if (calledMethod == null) {
            return null;
        }
        try {
            return this.invokeMethod(calledMethod, args.toArray());
        }
        catch (MethodException e) {
            throw new Exception(e.getDescription());
        }
    }

    static {
        VALID_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    }
}

