/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.irrigation;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.network.MessageSyncFluidLevel;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.IIrrigationComponent;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityChannel;
import com.InfinityRaider.AgriCraft.utility.multiblock.IMultiBlockComponent;
import com.InfinityRaider.AgriCraft.utility.multiblock.MultiBlockManager;
import com.InfinityRaider.AgriCraft.utility.multiblock.MultiBlockPartData;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTank
extends TileEntityCustomWood
implements IFluidHandler,
IIrrigationComponent,
IMultiBlockComponent<MultiBlockManager, MultiBlockPartData>,
IDebuggable {
    public static final int SYNC_DELTA = 500;
    public static final int DISCRETE_MAX = 16;
    public static final int SINGLE_CAPACITY = 8000;
    private int fluidLevel = 0;
    private int lastFluidLevel = 0;
    private int lastDiscreteFluidLevel = 0;
    private MultiBlockPartData multiBlockData;
    private TileEntityTank mainComponent;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.fluidLevel > 0) {
            tag.func_74768_a("level", this.fluidLevel);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fluidLevel = tag.func_74764_b("level") ? tag.func_74762_e("level") : 0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            BiomeGenBase biome;
            if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_72896_J() && !this.hasNeighbour(ForgeDirection.UP) && (biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e)) != BiomeGenBase.field_76769_d && biome != BiomeGenBase.field_76786_s) {
                this.setFluidLevel(this.getFluidLevel() + 1);
            }
            if (ConfigurationHandler.fillFromFlowingWater && (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150358_i)) {
                this.setFluidLevel(this.getFluidLevel() + 5);
            }
        }
    }

    @Override
    public void syncFluidLevel() {
        if (this.needsSync()) {
            MessageSyncFluidLevel msg = new MessageSyncFluidLevel(this.fluidLevel, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
            NetworkWrapperAgriCraft.wrapper.sendToAllAround((IMessage)msg, point);
        }
    }

    private boolean needsSync() {
        int newDiscreteLvl = this.getDiscreteFluidLevel();
        if (newDiscreteLvl != this.lastDiscreteFluidLevel) {
            this.lastDiscreteFluidLevel = newDiscreteLvl;
            this.lastFluidLevel = this.fluidLevel;
            return true;
        }
        if (500 <= Math.abs(this.lastFluidLevel - this.fluidLevel)) {
            this.lastDiscreteFluidLevel = newDiscreteLvl;
            this.lastFluidLevel = this.fluidLevel;
            return true;
        }
        return false;
    }

    public boolean isConnectedToChannel(ForgeDirection direction) {
        TileEntity tile;
        if (this.field_145850_b != null && direction != ForgeDirection.UNKNOWN && direction.offsetY == 0 && (tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)) instanceof TileEntityChannel) {
            return ((TileEntityChannel)tile).isSameMaterial(this);
        }
        return false;
    }

    public FluidStack getContents() {
        return new FluidStack(FluidRegistry.WATER, this.getFluidLevel());
    }

    @Override
    public int getFluidLevel() {
        if (this.getMainComponent() == this) {
            return this.fluidLevel;
        }
        TileEntityTank mainComponent = this.getMainComponent();
        return mainComponent != null ? mainComponent.getFluidLevel() : 0;
    }

    public int getYPosition() {
        return this.getMultiBlockData().posY();
    }

    public int getDiscreteFluidLevel() {
        return this.getDiscreteFluidLevel(this.getFluidLevel());
    }

    public int getDiscreteFluidLevel(int lvl) {
        MultiBlockPartData data = this.getMultiBlockData();
        float discreteFactor = 16.0f / (8000.0f * (float)data.sizeX() * (float)data.sizeZ());
        int discreteFluidLevel = Math.round(discreteFactor * (float)lvl);
        if (discreteFluidLevel < 2 && lvl > 0) {
            discreteFluidLevel = 2;
        }
        return discreteFluidLevel;
    }

    @Override
    public float getFluidHeight() {
        return this.getDiscreteFluidLevel();
    }

    @Override
    public float getFluidHeight(int lvl) {
        return this.getDiscreteFluidLevel(lvl);
    }

    @Override
    public int pushFluid(int amount) {
        if (!this.field_145850_b.field_72995_K && this.canAccept() && amount >= 0) {
            int room = this.getCapacity() - this.getFluidLevel();
            if (room >= amount) {
                this.setFluidLevel(this.getFluidLevel() + amount);
                amount = 0;
            } else if (room > 0) {
                this.setFluidLevel(this.getCapacity());
                amount -= room;
            }
        }
        return amount;
    }

    @Override
    public int pullFluid(int amount) {
        if (!this.field_145850_b.field_72995_K && this.canProvide() && amount >= 0) {
            if (amount <= this.getFluidLevel()) {
                this.setFluidLevel(this.getFluidLevel() - amount);
            } else {
                amount = this.getFluidLevel();
                this.setFluidLevel(0);
            }
        }
        return amount;
    }

    @Override
    public void setFluidLevel(int lvl) {
        if (lvl != this.getFluidLevel()) {
            TileEntityTank tank = this.getMainComponent();
            if (tank == null) {
                tank = this;
            }
            tank.fluidLevel = lvl = lvl > tank.getCapacity() ? tank.getCapacity() : lvl;
            if (!tank.field_145850_b.field_72995_K) {
                tank.syncFluidLevel();
            }
        }
    }

    @Override
    public boolean canConnectTo(IIrrigationComponent component) {
        return false;
    }

    @Override
    public int getCapacity() {
        return 8000 * this.getMultiBlockData().size();
    }

    @Override
    public boolean canAccept() {
        return this.getFluidLevel() < this.getCapacity();
    }

    @Override
    public boolean canProvide() {
        return this.getFluidLevel() > 0;
    }

    public boolean isEmpty() {
        return this.getFluidLevel() == 0;
    }

    public int fill(ForgeDirection from, int amount, boolean doFill) {
        return this.fill(from, new FluidStack(FluidRegistry.WATER, amount), doFill);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int filled = Math.min(resource.amount, this.getCapacity() - this.getFluidLevel());
        if (doFill && !this.field_145850_b.field_72995_K) {
            this.setFluidLevel(this.getFluidLevel() + filled);
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        int drained = Math.min(resource.amount, this.getFluidLevel());
        if (doDrain && !this.field_145850_b.field_72995_K) {
            this.setFluidLevel(this.getFluidLevel() - drained);
        }
        return new FluidStack(FluidRegistry.WATER, drained);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(from, new FluidStack(FluidRegistry.WATER, maxDrain), doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.canAccept();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.canProvide();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[]{new FluidTankInfo(this.getContents(), this.getCapacity())};
        return info;
    }

    @Override
    public TileEntityTank getMainComponent() {
        if (this.field_145850_b.field_72995_K) {
            MultiBlockPartData data = this.getMultiBlockData();
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - data.posX(), this.field_145848_d - data.posY(), this.field_145849_e - data.posZ());
            return te instanceof TileEntityTank ? (TileEntityTank)te : this;
        }
        if (this.mainComponent == null) {
            MultiBlockPartData data = this.getMultiBlockData();
            this.mainComponent = (TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c - data.posX(), this.field_145848_d - data.posY(), this.field_145849_e - data.posZ());
        }
        return this.mainComponent;
    }

    @Override
    public MultiBlockManager getMultiBlockManager() {
        return MultiBlockManager.getInstance();
    }

    @Override
    public void setMultiBlockPartData(MultiBlockPartData data) {
        this.multiBlockData = data;
        this.mainComponent = null;
        this.markForUpdate();
    }

    @Override
    public MultiBlockPartData getMultiBlockData() {
        if (this.multiBlockData == null) {
            this.multiBlockData = new MultiBlockPartData(0, 0, 0, 1, 1, 1);
        }
        return this.multiBlockData;
    }

    @Override
    public boolean hasNeighbour(ForgeDirection dir) {
        MultiBlockPartData data = this.getMultiBlockData();
        int x = data.posX() + dir.offsetX;
        int y = data.posY() + dir.offsetY;
        int z = data.posZ() + dir.offsetZ;
        return x >= 0 && x < data.sizeX() && y >= 0 && y < data.sizeY() && z >= 0 && z < data.sizeZ();
    }

    @Override
    public boolean isValidComponent(IMultiBlockComponent component) {
        return component instanceof TileEntityTank && this.isSameMaterial((TileEntityTank)component);
    }

    @Override
    public void preMultiBlockCreation(int sizeX, int sizeY, int sizeZ) {
        int lvl = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_147438_o(x + this.field_145851_c, y + this.field_145848_d, z + this.field_145849_e);
                    if (tank == null) continue;
                    lvl += tank.fluidLevel;
                    tank.fluidLevel = 0;
                }
            }
        }
        this.fluidLevel = lvl;
    }

    @Override
    public void postMultiBlockCreation() {
        this.mainComponent = null;
    }

    @Override
    public void preMultiBlockBreak() {
        MultiBlockPartData data = this.getMultiBlockData();
        int[] fluidLevelByLayer = new int[data.sizeY()];
        int area = data.sizeX() * data.sizeZ();
        int fluidContentByLayer = area * 8000;
        for (int layer = 0; this.fluidLevel > 0 && layer < fluidLevelByLayer.length; ++layer) {
            fluidLevelByLayer[layer] = this.fluidLevel >= fluidContentByLayer ? fluidContentByLayer / area : this.fluidLevel / area;
            this.fluidLevel = this.fluidLevel >= fluidContentByLayer ? this.fluidLevel - fluidContentByLayer : 0;
        }
        for (int x = 0; x < data.sizeX(); ++x) {
            for (int y = 0; y < fluidLevelByLayer.length; ++y) {
                for (int z = 0; z < data.sizeZ(); ++z) {
                    TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_147438_o(x + this.field_145851_c, y + this.field_145848_d, z + this.field_145849_e);
                    if (tank == null) continue;
                    tank.fluidLevel = fluidLevelByLayer[y];
                }
            }
        }
    }

    @Override
    public void postMultiBlockBreak() {
        this.mainComponent = null;
        this.syncFluidLevel();
    }

    @Override
    public void addDebugInfo(List<String> list) {
        super.addDebugInfo(list);
        MultiBlockPartData data = this.getMultiBlockData();
        TileEntityTank root = this.getMainComponent();
        list.add("TANK:");
        list.add("coordinates: (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ")");
        list.add("root coords: (" + root.field_145851_c + ", " + root.field_145848_d + ", " + root.field_145849_e + ")");
        list.add("Tank: (single capacity: 8000)");
        list.add("  - FluidLevel: " + this.getFluidLevel() + "/" + this.getCapacity());
        list.add("  - Water level is on layer " + (int)Math.floor(((float)this.getFluidLevel() - 0.1f) / (float)(this.getCapacity() * data.sizeX() * data.sizeZ())) + ".");
        list.add("  - Water height is " + this.getFluidHeight());
        StringBuilder neighbours = new StringBuilder();
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN || !this.hasNeighbour(dir)) continue;
            neighbours.append(dir.name()).append(", ");
        }
        list.add("  - Neighbours: " + neighbours.toString());
        list.add("  - MultiBlock data: " + ((Object)data).toString());
        list.add("  - MultiBlock Size: " + data.sizeX() + "x" + data.sizeY() + "x" + data.sizeZ());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWailaInformation(List information) {
        super.addWailaInformation(information);
        information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.waterLevel") + ": " + this.getFluidLevel() + "/" + this.getCapacity());
    }
}

