/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.api.v3.IMutationHandler;
import com.InfinityRaider.AgriCraft.api.v3.IMutationLogic;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationLogicAgriCraft;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MutationHandler
implements IMutationHandler {
    private static final MutationHandler INSTANCE = new MutationHandler();
    private List<IMutation> mutations;
    private boolean isSyncing = false;
    private IMutationLogic mutationLogic = MutationLogicAgriCraft.getInstance();

    public static MutationHandler getInstance() {
        return INSTANCE;
    }

    private MutationHandler() {
    }

    public void init() {
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readMutationData());
        this.mutations = new ArrayList<IMutation>();
        LogHelper.info("Registered Mutations:");
        for (String line : data) {
            Mutation mutation = this.readMutation(line);
            if (mutation == null || this.mutations.contains(mutation)) continue;
            this.mutations.add(mutation);
            LogHelper.info(" - " + mutation.getFormula());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void syncFromServer(IMutation mutation, boolean finished) {
        if (!this.isSyncing) {
            LogHelper.info("Receiving mutations from server");
            this.mutations = new ArrayList<IMutation>();
            this.isSyncing = true;
        }
        this.mutations.add(mutation);
        if (finished) {
            this.isSyncing = false;
            LogHelper.info("Successfully received mutations from server");
        }
    }

    private Mutation readMutation(String input) {
        Mutation mutation = null;
        String[] data = IOHelper.getData(input);
        if (data.length == 0) {
            LogHelper.info("Error when reading mutation: invalid number of arguments. (line: " + input + ")");
            return null;
        }
        String mutationData = data[0];
        int indexEquals = mutationData.indexOf(61);
        int indexPlus = mutationData.indexOf(43);
        if (indexEquals <= 0 || indexPlus <= indexEquals) {
            LogHelper.info("Error when reading mutation: mutation is not defined correctly. (line: " + input + ")");
            return null;
        }
        ItemStack resultStack = IOHelper.getStack(mutationData.substring(0, indexEquals), false);
        ItemStack parentStack1 = IOHelper.getStack(mutationData.substring(indexEquals + 1, indexPlus), false);
        ItemStack parentStack2 = IOHelper.getStack(mutationData.substring(indexPlus + 1), false);
        if (!CropPlantHandler.isValidSeed(resultStack)) {
            LogHelper.info("Error when reading mutation: resulting stack is not correct. (line: " + input + ")");
            return null;
        }
        if (!CropPlantHandler.isValidSeed(parentStack1)) {
            LogHelper.info("Error when reading mutation: first parent stack is not correct. (line: " + input + ")");
            return null;
        }
        if (!CropPlantHandler.isValidSeed(parentStack2)) {
            LogHelper.info("Error when reading mutation: second parent stack is not correct. (line: " + input + ")");
            return null;
        }
        try {
            mutation = new Mutation(resultStack, parentStack1, parentStack2);
        }
        catch (Exception e) {
            LogHelper.debug("Caught exception when trying to add mutation: " + resultStack.func_77977_a() + "=" + parentStack1.func_77977_a() + "+" + parentStack2.func_77977_a() + ", this seed is not registered");
        }
        return mutation;
    }

    @Override
    public IMutation[] getCrossOvers(List<? extends ICrop> crops) {
        ICrop[] parents = this.filterParents(crops);
        ArrayList<IMutation> list = new ArrayList<IMutation>();
        switch (parents.length) {
            case 2: {
                list.addAll(this.getMutationsFromParent(parents[0], parents[1]));
                break;
            }
            case 3: {
                list.addAll(this.getMutationsFromParent(parents[0], parents[1]));
                list.addAll(this.getMutationsFromParent(parents[0], parents[2]));
                list.addAll(this.getMutationsFromParent(parents[1], parents[2]));
                break;
            }
            case 4: {
                list.addAll(this.getMutationsFromParent(parents[0], parents[1]));
                list.addAll(this.getMutationsFromParent(parents[0], parents[2]));
                list.addAll(this.getMutationsFromParent(parents[0], parents[3]));
                list.addAll(this.getMutationsFromParent(parents[1], parents[2]));
                list.addAll(this.getMutationsFromParent(parents[1], parents[3]));
                list.addAll(this.getMutationsFromParent(parents[2], parents[3]));
            }
        }
        return this.cleanMutationArray(list.toArray(new IMutation[list.size()]));
    }

    private ICrop[] filterParents(List<? extends ICrop> input) {
        ArrayList<ICrop> list = new ArrayList<ICrop>();
        for (ICrop iCrop : input) {
            if (iCrop == null || !iCrop.isMature()) continue;
            list.add(iCrop);
        }
        return list.toArray(new ICrop[list.size()]);
    }

    private ArrayList<IMutation> getMutationsFromParent(ICrop parent1, ICrop parent2) {
        Item seed1 = parent1.getSeedStack().func_77973_b();
        Item seed2 = parent2.getSeedStack().func_77973_b();
        int meta1 = parent1.getSeedStack().func_77960_j();
        int meta2 = parent2.getSeedStack().func_77960_j();
        ArrayList<IMutation> list = new ArrayList<IMutation>();
        for (IMutation mutation : this.mutations) {
            ItemStack parent1Stack = mutation.getParents()[0];
            ItemStack parent2Stack = mutation.getParents()[1];
            if (seed1 == parent1Stack.func_77973_b() && seed2 == parent2Stack.func_77973_b() && meta1 == parent1Stack.func_77960_j() && meta2 == parent2Stack.func_77960_j()) {
                list.add(mutation);
            }
            if (seed1 != parent2Stack.func_77973_b() || seed2 != parent1Stack.func_77973_b() || meta1 != parent2Stack.func_77960_j() || meta2 != parent1Stack.func_77960_j()) continue;
            list.add(mutation);
        }
        return list;
    }

    private IMutation[] cleanMutationArray(IMutation[] input) {
        ArrayList<IMutation> list = new ArrayList<IMutation>();
        for (IMutation mutation : input) {
            if (mutation.getResult() == null) continue;
            list.add(mutation);
        }
        return list.toArray(new IMutation[list.size()]);
    }

    @Override
    public IMutation[] getMutations() {
        return this.mutations.toArray(new IMutation[this.mutations.size()]);
    }

    @Override
    public IMutation[] getMutationsFromParent(ItemStack stack) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (IMutation mutation : this.mutations) {
            ItemStack parent1Stack = mutation.getParents()[0];
            ItemStack parent2Stack = mutation.getParents()[1];
            if (parent1Stack.func_77973_b() == stack.func_77973_b() && parent1Stack.func_77960_j() == stack.func_77960_j()) {
                list.add(new Mutation(mutation));
            }
            if (parent2Stack.func_77973_b() != stack.func_77973_b() || parent2Stack.func_77960_j() != stack.func_77960_j() || parent2Stack.func_77973_b() == parent1Stack.func_77973_b() && parent2Stack.func_77960_j() == parent1Stack.func_77960_j()) continue;
            list.add(new Mutation(mutation));
        }
        return list.toArray(new IMutation[list.size()]);
    }

    public IMutation[] getMutationsFromChild(Item seed, int meta) {
        return this.getMutationsFromChild(new ItemStack(seed, 1, meta));
    }

    @Override
    public IMutation[] getMutationsFromChild(ItemStack stack) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        if (CropPlantHandler.isValidSeed(stack)) {
            for (IMutation mutation : this.mutations) {
                if (mutation.getResult().func_77973_b() != stack.func_77973_b() || mutation.getResult().func_77960_j() != stack.func_77960_j()) continue;
                list.add(new Mutation(mutation));
            }
        }
        return list.toArray(new IMutation[list.size()]);
    }

    @Override
    public List<IMutation> removeMutationsByResult(ItemStack result) {
        ArrayList<IMutation> removedMutations = new ArrayList<IMutation>();
        Iterator<IMutation> iter = this.mutations.iterator();
        while (iter.hasNext()) {
            IMutation mutation = iter.next();
            if (!mutation.getResult().func_77969_a(result)) continue;
            iter.remove();
            removedMutations.add(mutation);
        }
        return removedMutations;
    }

    @Override
    public void add(IMutation mutation) {
        this.mutations.add(mutation);
    }

    @Override
    public void remove(IMutation mutation) {
        this.mutations.remove(mutation);
    }

    @Override
    public void addAll(Collection<? extends IMutation> mutationsToAdd) {
        this.mutations.addAll(mutationsToAdd);
    }

    @Override
    public Mutation createNewMutation(ItemStack result, ItemStack parent1, ItemStack parent2) {
        return new Mutation(result, parent1, parent2);
    }

    @Override
    public Mutation createNewMutation(ItemStack result, ItemStack parent1, ItemStack parent2, double chance) {
        return new Mutation(result, parent1, parent2, chance);
    }

    @Override
    public void setMutationLogic(IMutationLogic logic) {
        this.mutationLogic = logic;
    }

    @Override
    public IMutationLogic getMutationLogic() {
        return this.mutationLogic;
    }
}

