/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.growthrequirement;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.ISoilContainer;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class GrowthRequirement
implements IGrowthRequirement {
    public static final int NEARBY_DEFAULT_RANGE = 4;
    private int maxBrightness = 16;
    private int minBrightness = 8;
    private BlockWithMeta soil = null;
    private BlockWithMeta requiredBlock = null;
    private boolean oreDict = false;
    private RequirementType requiredType = RequirementType.NONE;

    GrowthRequirement() {
    }

    public List<BlockWithMeta> getSoilBlocks() {
        if (this.requiresSpecificSoil()) {
            ArrayList<BlockWithMeta> list = new ArrayList<BlockWithMeta>();
            list.add(this.soil);
            return list;
        }
        return GrowthRequirementHandler.defaultSoils;
    }

    public List<BlockWithMeta> getBelowBlocks() {
        ArrayList<BlockWithMeta> list = new ArrayList<BlockWithMeta>();
        if (this.requiredType == RequirementType.BELOW) {
            list.add(this.requiredBlock);
        }
        return list;
    }

    public List<BlockWithMeta> getNearBlocks() {
        ArrayList<BlockWithMeta> list = new ArrayList<BlockWithMeta>();
        if (this.requiredType == RequirementType.NEARBY) {
            list.add(this.requiredBlock);
        }
        return list;
    }

    @Override
    public boolean canGrow(World world, int x, int y, int z) {
        return this.isValidSoil(world, x, y - 1, z) && this.isBrightnessGood(world, x, y, z) && this.isBaseBlockPresent(world, x, y, z);
    }

    @Override
    public boolean isBaseBlockPresent(World world, int x, int y, int z) {
        if (this.requiresBaseBlock()) {
            switch (this.requiredType) {
                case BELOW: {
                    return this.isBaseBlockBelow(world, x, y, z);
                }
                case NEARBY: {
                    return this.isBaseBlockNear(world, x, y, z);
                }
            }
        }
        return true;
    }

    private boolean isBaseBlockBelow(World world, int x, int y, int z) {
        if (this.requiresBaseBlock() && this.requiredType == RequirementType.BELOW) {
            return this.isBlockAdequate(world, x, y - 2, z);
        }
        return true;
    }

    private boolean isBaseBlockNear(World world, int x, int y, int z) {
        if (this.requiresBaseBlock() && this.requiredType == RequirementType.NEARBY) {
            int range = 4;
            for (int xPos = x - range; xPos <= x + range; ++xPos) {
                for (int yPos = y - range; yPos <= y + range; ++yPos) {
                    for (int zPos = z - range; zPos <= z + range; ++zPos) {
                        if (!this.isBlockAdequate(world, xPos, yPos, zPos)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean isBlockAdequate(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = block.func_149643_k(world, x, y, z);
        if (this.oreDict) {
            return OreDictHelper.isSameOre(block, meta, this.requiredBlock.getBlock(), this.requiredBlock.getMeta());
        }
        return block == this.requiredBlock.getBlock() && meta == this.requiredBlock.getMeta();
    }

    public boolean isBrightnessGood(World world, int x, int y, int z) {
        int lvl = world.func_72972_b(EnumSkyBlock.Block, x, y + 1, z);
        boolean day = world.func_72935_r();
        if (day) {
            int light_sky = world.func_72972_b(EnumSkyBlock.Sky, x, y + 1, z);
            lvl = Math.max(light_sky, lvl);
        }
        return lvl < this.maxBrightness && lvl >= this.minBrightness;
    }

    @Override
    public boolean isValidSoil(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        BlockWithMeta soil = new BlockWithMeta(block, meta);
        if (block instanceof ISoilContainer) {
            soil = new BlockWithMeta(((ISoilContainer)block).getSoil(world, x, y, z), ((ISoilContainer)block).getSoilMeta(world, x, y, z));
        }
        return this.isValidSoil(soil);
    }

    @Override
    public boolean isValidSoil(BlockWithMeta soil) {
        if (this.requiresSpecificSoil()) {
            return this.soil.equals(soil);
        }
        return GrowthRequirementHandler.defaultSoils.contains(soil);
    }

    public boolean requiresSpecificSoil() {
        return this.soil != null;
    }

    public boolean requiresBaseBlock() {
        return this.requiredType != RequirementType.NONE;
    }

    @Override
    public ItemStack requiredBlockAsItemStack() {
        return new ItemStack(this.requiredBlock.getBlock(), 1, this.requiredBlock.getMeta());
    }

    @Override
    public RequirementType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public BlockWithMeta getSoil() {
        return this.soil;
    }

    @Override
    public void setSoil(BlockWithMeta soil) {
        this.soil = soil;
        GrowthRequirementHandler.addSoil(soil);
    }

    @Override
    public int[] getBrightnessRange() {
        return new int[]{this.minBrightness, this.maxBrightness};
    }

    @Override
    public void setBrightnessRange(int min, int max) {
        this.minBrightness = min;
        this.maxBrightness = max;
    }

    @Override
    public void setRequiredBlock(BlockWithMeta requiredBlock, RequirementType requirementType, boolean oreDict) {
        this.requiredBlock = requiredBlock;
        this.requiredType = requirementType;
        this.oreDict = oreDict;
    }

    @Override
    public BlockWithMeta getRequiredBlock() {
        return this.requiredBlock;
    }

    @Override
    public boolean isOreDict() {
        return this.oreDict;
    }
}

