/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import appeng.container.AEBaseContainer;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.me.storage.NullInventory;
import appeng.tile.networking.TileCableBus;
import appeng.tile.networking.TileWireless;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import baubles.api.BaublesApi;
import codechicken.nei.recipe.StackInfo;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.inventory.IAEFluidTank;
import com.glodblock.github.inventory.item.IFluidPortableCell;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;

public final class Util {
    public static boolean isBaublesLoaded = Loader.isModLoaded((String)"Baubles");

    public static int drainItemPower(AEBaseContainer c, InventoryPlayer ip, int slot, int ticks, double pm, IFluidPortableCell wt) {
        if (slot != -1) {
            ItemStack currentItem = Util.getWirelessTerminal(ip.field_70458_d, slot);
            if (wt != null) {
                if (currentItem != wt.getItemStack()) {
                    if (currentItem != null) {
                        if (Platform.isSameItem((ItemStack)wt.getItemStack(), (ItemStack)currentItem)) {
                            if (GuiHelper.decodeInvType(slot).getLeft() == GuiHelper.InvType.PLAYER_INV) {
                                ip.func_70299_a(slot, wt.getItemStack());
                            } else {
                                BaublesApi.getBaubles((EntityPlayer)ip.field_70458_d).func_70299_a(((Integer)GuiHelper.decodeInvType(slot).getRight()).intValue(), wt.getItemStack());
                            }
                        } else {
                            c.setValidContainer(false);
                        }
                    } else {
                        c.setValidContainer(false);
                    }
                }
            } else {
                c.setValidContainer(false);
            }
        } else {
            c.setValidContainer(false);
        }
        if (++ticks > 10 && wt != null) {
            if (!DimensionalCoordSide.hasEnergyCard(wt.getItemStack())) {
                wt.extractAEPower(pm * (double)ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
            ticks = 0;
        }
        return ticks;
    }

    public static boolean rangeCheck(ItemStack is, EntityPlayer player, IGridNode grid) {
        if (grid.getGrid() == null) {
            return false;
        }
        return Util.rangeCheck(is, player, grid.getGrid());
    }

    public static boolean rangeCheck(ItemStack is, EntityPlayer player, IGrid grid) {
        boolean canConnect = false;
        if (Util.hasInfinityBoosterCard(is)) {
            canConnect = true;
        } else {
            for (IGridNode node : grid.getMachines(TileWireless.class)) {
                IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node.getMachine();
                if (!accessPoint.isActive() || accessPoint.getLocation().getDimension() != player.field_71093_bK) continue;
                WorldCoord distance = accessPoint.getLocation().subtract((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
                if (!((double)squaredDistance <= accessPoint.getRange() * accessPoint.getRange())) continue;
                canConnect = true;
                break;
            }
        }
        return canConnect;
    }

    public static boolean isRestock(ItemStack is) {
        if (is.func_77973_b() instanceof ItemBaseWirelessTerminal) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            return data.func_74764_b(ItemBaseWirelessTerminal.restockItems) && data.func_74767_n(ItemBaseWirelessTerminal.restockItems);
        }
        return false;
    }

    public static boolean hasInfinityBoosterCard(ItemStack is) {
        if (is.func_77973_b() instanceof ItemBaseWirelessTerminal) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            return data.func_74764_b(ItemBaseWirelessTerminal.infinityBoosterCard) && data.func_74767_n(ItemBaseWirelessTerminal.infinityBoosterCard);
        }
        return false;
    }

    public static IGridNode getWirelessGrid(ItemStack is) {
        if (is.func_77973_b() instanceof ToolWirelessTerminal) {
            String key = ((ToolWirelessTerminal)is.func_77973_b()).getEncryptionKey(is);
            IGridHost securityTerminal = (IGridHost)AEApi.instance().registries().locatable().getLocatableBy(Long.parseLong(key));
            if (securityTerminal == null) {
                return null;
            }
            return securityTerminal.getGridNode(ForgeDirection.UNKNOWN);
        }
        return null;
    }

    public static IMEInventoryHandler<?> getWirelessInv(ItemStack is, EntityPlayer player, StorageChannel channel) {
        if (Platform.isServer()) {
            IStorageGrid gridCache;
            IGrid grid;
            IGridNode gridNode = Util.getWirelessGrid(is);
            if (gridNode != null && (grid = gridNode.getGrid()) != null && Util.rangeCheck(is, player, grid) && (gridCache = (IStorageGrid)grid.getCache(IStorageGrid.class)) != null) {
                if (channel == StorageChannel.FLUIDS) {
                    return gridCache.getFluidInventory();
                }
                return gridCache.getItemInventory();
            }
            return null;
        }
        return new NullInventory();
    }

    public static ItemStack getWirelessTerminal(EntityPlayer player, int x) {
        ImmutablePair<GuiHelper.InvType, Integer> result = GuiHelper.decodeInvType(x);
        if (result.getLeft() == GuiHelper.InvType.PLAYER_INV) {
            return player.field_71071_by.func_70301_a(((Integer)result.getRight()).intValue());
        }
        return BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(((Integer)result.getRight()).intValue());
    }

    public static ImmutablePair<Integer, ItemStack> getUltraWirelessTerm(EntityPlayer player) {
        IInventory handler;
        int invSize = player.field_71071_by.func_70302_i_();
        if (invSize <= 0) {
            return null;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (is == null || !(is.func_77973_b() instanceof ItemWirelessUltraTerminal)) continue;
            return new ImmutablePair((Object)i, (Object)is);
        }
        if (isBaublesLoaded && (handler = BaublesApi.getBaubles((EntityPlayer)player)) != null) {
            invSize = handler.func_70302_i_();
            for (int i = 0; i < invSize; ++i) {
                ItemStack is = handler.func_70301_a(i);
                if (is == null || !(is.func_77973_b() instanceof ItemWirelessUltraTerminal)) continue;
                return new ImmutablePair((Object)GuiHelper.encodeType(i, GuiHelper.InvType.PLAYER_BAUBLES), (Object)is);
            }
        }
        return null;
    }

    public static int findItemInPlayerInvSlot(EntityPlayer player, ItemStack itemStack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i] != itemStack) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGrid grid) {
        return grid == null || Util.hasPermission(player, permission, (ISecurityGrid)grid.getCache(ISecurityGrid.class));
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGridHost host) {
        return Util.hasPermission(player, permission, host, ForgeDirection.UNKNOWN);
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGridHost host, ForgeDirection side) {
        return host == null || Util.hasPermission(player, permission, host.getGridNode(side));
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IGridNode host) {
        return host == null || Util.hasPermission(player, permission, host.getGrid());
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, IPart part) {
        return part == null || Util.hasPermission(player, permission, part.getGridNode());
    }

    public static boolean hasPermission(EntityPlayer player, SecurityPermissions permission, ISecurityGrid securityGrid) {
        return player == null || permission == null || securityGrid == null || securityGrid.hasPermission(player, permission);
    }

    public static ItemStack copyStackWithSize(ItemStack itemStack, int size) {
        if (size == 0 || itemStack == null) {
            return null;
        }
        ItemStack copy = itemStack.func_77946_l();
        copy.field_77994_a = size;
        return copy;
    }

    public static AEFluidStack getAEFluidFromItem(ItemStack stack) {
        FluidStack fluid;
        if (stack != null && (fluid = Util.getFluidFromItem(stack)) != null) {
            return AEFluidStack.create((Object)fluid.copy());
        }
        return null;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        FluidStack fluid = null;
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        } else if (FluidContainerRegistry.isContainer((ItemStack)stack)) {
            fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        } else if (stack.func_77973_b() instanceof ItemFluidPacket) {
            fluid = ItemFluidPacket.getFluidStack(stack);
        } else if (stack.func_77973_b() instanceof ItemFluidDrop) {
            fluid = ItemFluidDrop.getFluidStack(Util.copyStackWithSize(stack, 1));
        }
        if (fluid == null) {
            fluid = StackInfo.getFluid((ItemStack)Util.copyStackWithSize(stack, 1));
        }
        if (fluid != null) {
            FluidStack fluid0 = fluid.copy();
            fluid0.amount *= stack.field_77994_a;
            return fluid0;
        }
        return null;
    }

    public static boolean isFluidPacket(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemFluidPacket;
    }

    public static String getFluidModID(Fluid fluid) {
        String name = FluidRegistry.getDefaultFluidName((Fluid)fluid);
        try {
            return name.split(":")[0];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static ModContainer getFluidMod(Fluid fluid) {
        return GameData.findModOwner((String)FluidRegistry.getDefaultFluidName((Fluid)fluid));
    }

    public static int getFluidID(Fluid fluid) {
        return GameData.getBlockRegistry().getId((Object)fluid.getBlock());
    }

    public static String getFluidModName(Fluid fluid) {
        try {
            ModContainer mod = Util.getFluidMod(fluid);
            return mod == null ? "Minecraft" : mod.getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void writeItemStackToNBT(ItemStack itemStack, NBTTagCompound tag) {
        itemStack.func_77955_b(tag);
        tag.func_74768_a("Count", itemStack.field_77994_a);
    }

    public static ItemStack loadItemStackFromNBT(NBTTagCompound tag) {
        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (itemStack == null) {
            return null;
        }
        itemStack.field_77994_a = tag.func_74762_e("Count");
        return itemStack;
    }

    public static IAEFluidStack loadFluidStackFromNBT(NBTTagCompound i) {
        FluidStack t = FluidRegistry.getFluidStack((String)i.func_74779_i("FluidName"), (int)1);
        if (t == null) {
            return null;
        }
        AEFluidStack fluid = AEFluidStack.create((Object)t);
        fluid.setStackSize(i.func_74763_f("Cnt"));
        fluid.setCountRequestable(i.func_74763_f("Req"));
        fluid.setCraftable(i.func_74767_n("Craft"));
        return fluid;
    }

    public static void mirrorFluidToPacket(IInventory packet, IAEFluidTank fluidTank) {
        for (int i = 0; i < fluidTank.getSlots(); ++i) {
            IAEFluidStack fluid = fluidTank.getFluidInSlot(i);
            if (fluid == null) {
                packet.func_70299_a(i, null);
                continue;
            }
            packet.func_70299_a(i, ItemFluidPacket.newDisplayStack(fluid.getFluidStack()));
        }
    }

    public static FluidStack getFluidFromVirtual(ItemStack virtual) {
        if (virtual == null) {
            return null;
        }
        if (virtual.func_77973_b() instanceof ItemFluidPacket) {
            return ItemFluidPacket.getFluidStack(virtual);
        }
        if (virtual.func_77973_b() instanceof ItemFluidDrop) {
            return ItemFluidDrop.getFluidStack(virtual);
        }
        return null;
    }

    public static IPart getPart(Object te, ForgeDirection face) {
        if (te instanceof TileCableBus) {
            return ((TileCableBus)te).getPart(face);
        }
        return null;
    }

    public static void writeFluidMapToBuf(Map<Integer, IAEFluidStack> list, ByteBuf buf) throws IOException {
        buf.writeInt(list.size());
        for (Map.Entry<Integer, IAEFluidStack> fs : list.entrySet()) {
            buf.writeInt(fs.getKey().intValue());
            if (fs.getValue() == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            fs.getValue().writeToPacket(buf);
        }
    }

    public static void readFluidMapFromBuf(Map<Integer, IAEFluidStack> list, ByteBuf buf) throws IOException {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int id = buf.readInt();
            boolean isNull = buf.readBoolean();
            if (!isNull) {
                list.put(id, null);
                continue;
            }
            IAEFluidStack fluid = AEFluidStack.loadFluidStackFromPacket((ByteBuf)buf);
            list.put(id, fluid);
        }
    }

    public static void writeAEStackMapToBuf(Map<Integer, IAEStack<?>> list, ByteBuf buf) throws IOException {
        buf.writeInt(list.size());
        for (Map.Entry<Integer, IAEStack<?>> as : list.entrySet()) {
            buf.writeInt(as.getKey().intValue());
            if (as.getValue() == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            as.getValue().writeToPacket(buf);
        }
    }

    public static void readAEStackMapFromBuf(Map<Integer, IAEStack<?>> list, ByteBuf buf) throws IOException {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int id = buf.readInt();
            boolean isNull = buf.readBoolean();
            if (!isNull) {
                list.put(id, null);
                continue;
            }
            Object as = id > 99 ? AEItemStack.loadItemStackFromPacket((ByteBuf)buf) : AEFluidStack.loadFluidStackFromPacket((ByteBuf)buf);
            list.put(id, (IAEStack<?>)as);
        }
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }

    public static class GuiHelper {
        private static final int value = 0x40000000;

        public static int encodeType(int y, GuiType type) {
            if (Math.abs(y) > 0x10000000) {
                throw new IllegalArgumentException("out of range");
            }
            return 0x40000000 | type.ordinal() << 29 | y;
        }

        public static int encodeType(int x, InvType type) {
            if (Math.abs(x) > 0x10000000) {
                throw new IllegalArgumentException("out of range");
            }
            return 0x40000000 | type.ordinal() << 29 | x;
        }

        public static ImmutablePair<GuiType, Integer> decodeType(int y) {
            if (Math.abs(y) > 0x10000000) {
                return new ImmutablePair((Object)GuiType.values()[y >> 29 & 1], (Object)(y - (0x60000000 & y)));
            }
            return new ImmutablePair((Object)GuiType.TILE, (Object)y);
        }

        public static ImmutablePair<InvType, Integer> decodeInvType(int x) {
            if (Math.abs(x) > 0x10000000) {
                return new ImmutablePair((Object)InvType.values()[x >> 29 & 1], (Object)(x - (0x60000000 & x)));
            }
            return new ImmutablePair((Object)InvType.PLAYER_INV, (Object)x);
        }

        public static enum GuiType {
            TILE,
            ITEM;

        }

        public static enum InvType {
            PLAYER_INV,
            PLAYER_BAUBLES;

        }
    }

    public static class DimensionalCoordSide
    extends DimensionalCoord {
        private ForgeDirection side = ForgeDirection.UNKNOWN;
        private final String name;

        public DimensionalCoordSide(int _x, int _y, int _z, int _dim, ForgeDirection side, String name) {
            super(_x, _y, _z, _dim);
            this.side = side;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ForgeDirection getSide() {
            return this.side;
        }

        public void writeToNBT(NBTTagCompound data) {
            data.func_74768_a("side", this.side.ordinal());
            data.func_74778_a("name", this.name);
            super.writeToNBT(data);
        }

        public static DimensionalCoordSide readFromNBT(NBTTagCompound data) {
            return new DimensionalCoordSide(data.func_74762_e("x"), data.func_74762_e("y"), data.func_74762_e("z"), data.func_74762_e("dim"), ForgeDirection.getOrientation((int)data.func_74762_e("side")), data.func_74779_i("name"));
        }

        public static boolean hasEnergyCard(ItemStack is) {
            if (is.func_77973_b() instanceof ItemBaseWirelessTerminal) {
                NBTTagCompound data = Platform.openNbtData((ItemStack)is);
                return data.func_74764_b(ItemBaseWirelessTerminal.infinityEnergyCard) && data.func_74767_n(ItemBaseWirelessTerminal.infinityEnergyCard);
            }
            return false;
        }
    }

    public static class FluidUtil {
        private static final ItemStack glassBottle = new ItemStack(Items.field_151069_bo, 1);
        public static final ItemStack water_bucket = new ItemStack(Items.field_151131_as, 1);

        public static ItemStack getPotion(FluidStack fs) {
            if (fs == null) {
                return null;
            }
            MutablePair<Integer, ItemStack> fillStack = FluidUtil.fillStack(glassBottle, fs);
            if (fillStack != null && fillStack.getRight() != null && ((ItemStack)fillStack.getRight()).func_77973_b() instanceof ItemPotion) {
                return (ItemStack)fillStack.right;
            }
            return null;
        }

        public static IAEFluidStack createAEFluidStack(Fluid fluid) {
            return FluidUtil.createAEFluidStack(new FluidStack(fluid, 1000));
        }

        public static IAEFluidStack createAEFluidStack(Fluid fluid, long amount) {
            return FluidUtil.createAEFluidStack(fluid.getID(), amount);
        }

        public static IAEFluidStack createAEFluidStack(FluidStack fluid) {
            return AEApi.instance().storage().createFluidStack(fluid);
        }

        public static IAEFluidStack createAEFluidStack(int fluidId, long amount) {
            return (IAEFluidStack)FluidUtil.createAEFluidStack(new FluidStack(FluidRegistry.getFluid((int)fluidId), 1)).setStackSize(amount);
        }

        public static boolean isEmpty(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            Item item = itemStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
                return content == null || content.amount <= 0;
            }
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
        }

        public static boolean isFilled(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            Item item = itemStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
                return content != null && content.amount > 0;
            }
            return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
        }

        public static boolean isFluidContainer(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            Item item = itemStack.func_77973_b();
            return item instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)itemStack);
        }

        public static FluidStack getFluidFromContainer(ItemStack itemStack) {
            if (itemStack == null) {
                return null;
            }
            ItemStack container = itemStack.func_77946_l();
            Item item = container.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)item).getFluid(container);
            }
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        }

        public static int getCapacity(ItemStack itemStack, Fluid fluid) {
            if (itemStack == null) {
                return 0;
            }
            Item item = itemStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                IFluidContainerItem fluidContainerItem = (IFluidContainerItem)item;
                int capacity = fluidContainerItem.getCapacity(itemStack);
                FluidStack existing = fluidContainerItem.getFluid(itemStack);
                if (existing != null) {
                    if (!existing.getFluid().equals(fluid)) {
                        return 0;
                    }
                    capacity -= existing.amount;
                }
                return capacity;
            }
            if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
                return FluidContainerRegistry.getContainerCapacity((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)itemStack);
            }
            return 0;
        }

        public static ItemStack clearFluid(ItemStack itemStack) {
            if (itemStack == null) {
                return null;
            }
            Item item = itemStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                ((IFluidContainerItem)item).drain(itemStack, ((IFluidContainerItem)item).getFluid((ItemStack)itemStack).amount, true);
                return itemStack;
            }
            if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
                return FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack);
            }
            return null;
        }

        public static ItemStack setFluidContainerAmount(ItemStack itemStack, int amount) {
            FluidStack fs = FluidUtil.getFluidFromContainer(itemStack);
            if (fs == null) {
                return null;
            }
            fs.amount = amount;
            ItemStack is = itemStack.func_77946_l();
            is.field_77994_a = 1;
            ItemStack emptyContainer = FluidUtil.clearFluid(is);
            if (emptyContainer == null) {
                return null;
            }
            MutablePair<Integer, ItemStack> result = FluidUtil.fillStack(emptyContainer, fs);
            if (result != null) {
                ((ItemStack)result.right).field_77994_a = itemStack.field_77994_a;
                return (ItemStack)result.right;
            }
            return null;
        }

        public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, FluidStack fluid) {
            if (itemStack == null) {
                return null;
            }
            Item item = itemStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                FluidStack drained = ((IFluidContainerItem)item).drain(itemStack, fluid.amount, true);
                int amountDrained = drained != null && drained.getFluid() == fluid.getFluid() ? drained.amount : 0;
                return new MutablePair((Object)amountDrained, (Object)itemStack);
            }
            if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
                FluidStack content = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                int amountDrained = content != null && content.getFluid() == fluid.getFluid() ? content.amount : 0;
                return new MutablePair((Object)amountDrained, (Object)FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack));
            }
            return null;
        }

        public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack, FluidStack fluid) {
            if (itemStack == null || itemStack.field_77994_a != 1) {
                return null;
            }
            Item item = itemStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                int filled = ((IFluidContainerItem)item).fill(itemStack, fluid, true);
                return new MutablePair((Object)filled, (Object)itemStack);
            }
            if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)itemStack);
                FluidStack filled = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
                return new MutablePair((Object)(filled != null ? filled.amount : 0), (Object)filledContainer);
            }
            return null;
        }
    }
}

