/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.PatternHelper;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class FluidPatternDetails
implements ICraftingPatternDetails,
Comparable<FluidPatternDetails> {
    private final ItemStack patternStack;
    private IAEItemStack patternStackAe;
    private IAEItemStack[] inputs = null;
    private IAEItemStack[] inputsCond = null;
    private IAEItemStack[] outputs = null;
    private IAEItemStack[] outputsCond = null;
    private IAEStack<?>[] aeInputs = null;
    private IAEStack<?>[] aeInputsCond = null;
    private IAEStack<?>[] aeOutputs = null;
    private IAEStack<?>[] aeOutputsCond = null;
    private int priority = 0;
    private int combine = 0;
    private int beSubstitute = 0;

    public FluidPatternDetails(ItemStack stack) {
        this.patternStack = stack;
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("author")) {
            ItemStack forComparison = this.patternStack.func_77946_l();
            forComparison.field_77990_d.func_82580_o("author");
            this.patternStackAe = (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)forComparison));
        } else {
            this.patternStackAe = (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)stack));
        }
    }

    public boolean canBeSubstitute() {
        return this.beSubstitute != 0;
    }

    public void setCanBeSubstitute(int beSubstitute) {
        this.beSubstitute = beSubstitute;
    }

    public ItemStack getPattern() {
        return this.patternStack;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setCombine(int combine) {
        this.combine = combine;
    }

    public int getCombine() {
        return this.combine;
    }

    public boolean isCraftable() {
        return false;
    }

    public boolean canSubstitute() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return FluidPatternDetails.checkInitialized(this.inputs);
    }

    public IAEStack<?>[] getAEInputs() {
        return FluidPatternDetails.checkInitialized(this.aeInputs);
    }

    public IAEItemStack[] getCondensedInputs() {
        return FluidPatternDetails.checkInitialized(this.inputsCond);
    }

    public IAEStack<?>[] getCondensedAEInputs() {
        return FluidPatternDetails.checkInitialized(this.aeInputsCond);
    }

    public boolean setInputs(IAEStack<?>[] inputs) {
        IAEStack<?>[] condensed = FluidPatternDetails.condenseAEStacks(inputs);
        if (condensed.length == 0) {
            return false;
        }
        this.aeInputs = inputs;
        this.aeInputsCond = condensed;
        IAEItemStack[] legacy = new IAEItemStack[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            legacy[i] = inputs[i].isItem() ? (IAEItemStack)inputs[i] : Platform.stackConvert(inputs[i]);
        }
        this.inputs = legacy;
        this.inputsCond = FluidPatternDetails.condenseStacks(legacy);
        return true;
    }

    public IAEItemStack[] getOutputs() {
        return FluidPatternDetails.checkInitialized(this.outputs);
    }

    public IAEStack<?>[] getAEOutputs() {
        return FluidPatternDetails.checkInitialized(this.aeOutputs);
    }

    public IAEItemStack[] getCondensedOutputs() {
        return FluidPatternDetails.checkInitialized(this.outputsCond);
    }

    public IAEStack<?>[] getCondensedAEOutputs() {
        return FluidPatternDetails.checkInitialized(this.aeOutputsCond);
    }

    public boolean setOutputs(IAEStack<?>[] outputs) {
        IAEStack<?>[] condensed = FluidPatternDetails.condenseAEStacks(outputs);
        if (condensed.length == 0) {
            return false;
        }
        this.aeOutputs = (IAEStack[])Arrays.stream(outputs).filter(Objects::nonNull).toArray(IAEStack[]::new);
        this.aeOutputsCond = condensed;
        IAEItemStack[] legacy = new IAEItemStack[outputs.length];
        for (int i = 0; i < outputs.length; ++i) {
            if (outputs[i] == null) continue;
            legacy[i] = outputs[i].isItem() ? (IAEItemStack)outputs[i] : Platform.stackConvert(outputs[i]);
        }
        this.outputs = legacy;
        this.outputsCond = FluidPatternDetails.condenseStacks(legacy);
        return true;
    }

    private static IAEItemStack[] condenseStacks(IAEItemStack[] stacks) {
        return PatternHelper.convertToCondensedList((IAEItemStack[])stacks);
    }

    private static IAEStack<?>[] condenseAEStacks(IAEStack<?>[] stacks) {
        return PatternHelper.convertToCondensedAEList(stacks);
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        throw new IllegalStateException("Not a crafting recipe!");
    }

    public boolean isValidItemForSlot(int slotIndex, IAEStack<?> stack, World world) {
        throw new IllegalStateException("Not a crafting recipe!");
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        throw new IllegalStateException("Not a crafting recipe!");
    }

    private static <T> T checkInitialized(@Nullable T value) {
        if (value == null) {
            throw new IllegalStateException("Pattern is not initialized!");
        }
        return value;
    }

    public int hashCode() {
        return this.patternStackAe.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FluidPatternDetails && this.patternStackAe.equals(((FluidPatternDetails)obj).patternStackAe);
    }

    @Override
    public int compareTo(FluidPatternDetails o) {
        return Integer.compare(o.priority, this.priority);
    }

    public ItemStack writeToStack() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Inputs", (NBTBase)FluidPatternDetails.writeStackArray((IAEStack[])FluidPatternDetails.checkInitialized(this.inputs)));
        tag.func_74782_a("Outputs", (NBTBase)FluidPatternDetails.writeStackArray((IAEStack[])FluidPatternDetails.checkInitialized(this.outputs)));
        tag.func_74782_a("in", (NBTBase)FluidPatternDetails.writeStackArray((IAEStack[])FluidPatternDetails.checkInitialized(this.inputs)));
        tag.func_74782_a("out", (NBTBase)FluidPatternDetails.writeStackArray((IAEStack[])FluidPatternDetails.checkInitialized(this.outputs)));
        tag.func_74768_a("combine", this.getCombine());
        tag.func_74757_a("beSubstitute", this.canBeSubstitute());
        this.patternStack.func_77982_d(tag);
        this.patternStackAe = (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)this.patternStack));
        return this.patternStack;
    }

    public static NBTTagList writeStackArray(IAEStack<?>[] stacks) {
        NBTTagList listTag = new NBTTagList();
        for (IAEStack<?> stack : stacks) {
            NBTTagCompound stackTag = new NBTTagCompound();
            Platform.writeStackNBT(stack, (NBTTagCompound)stackTag);
            listTag.func_74742_a((NBTBase)stackTag);
        }
        return listTag;
    }

    public boolean readFromStack() {
        if (!this.patternStack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = Objects.requireNonNull(this.patternStack.func_77978_p());
        this.setCanBeSubstitute(tag.func_74767_n("beSubstitute") ? 1 : 0);
        this.setCombine(tag.func_74762_e("combine"));
        return this.setInputs(FluidPatternDetails.readStackArray(tag.func_150295_c("in", 10))) && this.setOutputs(FluidPatternDetails.readStackArray(tag.func_150295_c("out", 10)));
    }

    public static IAEStack<?>[] readStackArray(NBTTagList listTag) {
        IAEStack[] stacks = new IAEStack[listTag.func_74745_c()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = Platform.readStackNBT((NBTTagCompound)listTag.func_150305_b(i), (boolean)true);
        }
        return stacks;
    }
}

