/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.parts.automation.PartLevelEmitter;
import com.glodblock.github.common.parts.PartFluidLevelEmitter;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketLevelTerminalCommands
implements IMessage {
    private Action action;
    private int x;
    private int y;
    private int z;
    private int dim;
    private ForgeDirection side;
    private int originalGui = -1;

    public CPacketLevelTerminalCommands() {
    }

    public CPacketLevelTerminalCommands(Action action, int x, int y, int z, int dim, ForgeDirection side) {
        this.action = action;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        this.side = side;
    }

    public CPacketLevelTerminalCommands setOriginalGui(int originalGui) {
        this.originalGui = originalGui;
        return this;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        switch (this.action) {
            case EDIT: {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
                this.dim = buf.readInt();
                this.side = ForgeDirection.getOrientation((int)buf.readInt());
                break;
            }
            case BACK: {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
                this.dim = buf.readInt();
                this.side = ForgeDirection.getOrientation((int)buf.readInt());
                this.originalGui = buf.readInt();
                break;
            }
            case ENABLE: {
                break;
            }
            case DISABLE: {
                break;
            }
            case ENABLE_ALL: {
                break;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        switch (this.action) {
            case EDIT: {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
                buf.writeInt(this.dim);
                buf.writeInt(this.side.ordinal());
                break;
            }
            case BACK: {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
                buf.writeInt(this.dim);
                buf.writeInt(this.side.ordinal());
                buf.writeInt(this.originalGui);
                break;
            }
            case ENABLE: {
                break;
            }
            case DISABLE: {
                break;
            }
            case ENABLE_ALL: {
                break;
            }
        }
    }

    public static enum Action {
        EDIT,
        BACK,
        ENABLE,
        DISABLE,
        ENABLE_ALL,
        DISABLE_ALL;

    }

    public static class Handler
    implements IMessageHandler<CPacketLevelTerminalCommands, IMessage> {
        public IMessage onMessage(CPacketLevelTerminalCommands message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            switch (message.action) {
                case EDIT: {
                    TileEntity tile = DimensionManager.getWorld((int)message.dim).func_147438_o(message.x, message.y, message.z);
                    if (tile instanceof IPartHost) {
                        IPartHost host = (IPartHost)tile;
                        IPart part = host.getPart(message.side);
                        if (part instanceof PartLevelEmitter) {
                            InventoryHandler.openGui((EntityPlayer)player, tile.func_145831_w(), new BlockPos(tile), message.side, GuiType.LEVEL_EMITTER_PROXY);
                            break;
                        }
                        if (!(part instanceof PartFluidLevelEmitter)) break;
                        InventoryHandler.openGui((EntityPlayer)player, tile.func_145831_w(), new BlockPos(tile), message.side, GuiType.FLUID_LEVEL_EMITTER);
                        break;
                    }
                    InventoryHandler.openGui((EntityPlayer)player, tile.func_145831_w(), new BlockPos(tile), message.side, GuiType.LEVEL_MAINTAINER);
                    break;
                }
                case BACK: {
                    GuiType originalGui = GuiType.getByOrdinal(message.originalGui);
                    if (originalGui == null) {
                        return null;
                    }
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(message.x, message.y, message.z, (World)DimensionManager.getWorld((int)message.dim)), message.side, originalGui);
                    break;
                }
            }
            return null;
        }
    }
}

