/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.entity.EntityFloatingItem;
import appeng.util.Platform;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;

public class WirelessMagnet {
    public static String modeKey = "MagnetMode";
    public static String filterKey = "MagnetFilter";
    public static String filterConfigKey = "MagnetConfig";

    private static <T> List<T> getEntitiesInRange(Class<T> entityType, World world, int x, int y, int z, int distance) {
        return world.func_72872_a(entityType, AxisAlignedBB.func_72330_a((double)(x - distance), (double)(y - distance), (double)(z - distance), (double)(x + distance), (double)(y + distance), (double)(z + distance)));
    }

    public static boolean isConfigured(ItemStack wirelessTerm) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)wirelessTerm);
        return data.func_74764_b(modeKey);
    }

    public static void doMagnet(ItemStack wirelessTerm, EntityPlayer player) {
        if (player.field_70173_aa % 5 != 0 || player.func_70093_af() || !WirelessMagnet.isConfigured(wirelessTerm)) {
            return;
        }
        World world = player.field_70170_p;
        List<EntityItem> items = WirelessMagnet.getEntitiesInRange(EntityItem.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, Config.magnetRange);
        boolean skipPlayerCheck = world.field_73010_i.size() < 2;
        boolean playSound = false;
        double playerEyesPos = player.field_70163_u + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        for (EntityItem itemToGet : items) {
            EntityPlayer closestPlayer;
            if (itemToGet.func_92059_d() == null || itemToGet instanceof EntityFloatingItem || !skipPlayerCheck && ((closestPlayer = world.func_72890_a((Entity)itemToGet, (double)Config.magnetRange)) == null || closestPlayer != player)) continue;
            if (itemToGet.field_145804_b > 0) {
                itemToGet.field_145804_b = 0;
            }
            playSound = true;
            itemToGet.field_70159_w = 0.0;
            itemToGet.field_70181_x = 0.0;
            itemToGet.field_70179_y = 0.0;
            itemToGet.func_70107_b(player.field_70165_t - 0.2 + world.field_73012_v.nextDouble() * 0.4, playerEyesPos - 0.62, player.field_70161_v - 0.2 + world.field_73012_v.nextDouble() * 0.4);
        }
        if (playSound) {
            world.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
        if (!world.field_72995_K) {
            List<EntityXPOrb> xpOrbs = WirelessMagnet.getEntitiesInRange(EntityXPOrb.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, Config.magnetRange);
            for (EntityXPOrb xpToGet : xpOrbs) {
                EntityPlayer closestPlayer;
                if (xpToGet.field_70532_c != 0 || !xpToGet.func_70089_S() || !skipPlayerCheck && ((closestPlayer = world.func_72890_a((Entity)xpToGet, (double)Config.magnetRange)) == null || closestPlayer != player) || MinecraftForge.EVENT_BUS.post((Event)new PlayerPickupXpEvent(player, xpToGet))) continue;
                world.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
                player.func_71001_a((Entity)xpToGet, 1);
                player.func_71023_q(xpToGet.field_70530_e);
                xpToGet.func_70106_y();
            }
        }
    }

    public static Mode getMode(ItemStack is) {
        if (is != null && is.func_77973_b() instanceof ItemWirelessUltraTerminal) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            if (data.func_74764_b(modeKey)) {
                return Mode.getModes()[data.func_74762_e(modeKey)];
            }
            WirelessMagnet.setMode(is, Mode.Off);
        }
        return Mode.Off;
    }

    public static void setMode(ItemStack is, Mode mode) {
        if (is != null && is.func_77973_b() instanceof ItemWirelessUltraTerminal) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            data.func_74768_a(modeKey, mode.ordinal());
        }
    }

    public static enum Mode {
        Off,
        Inv,
        ME;

        private static final Mode[] MODES;

        public static Mode[] getModes() {
            return MODES;
        }

        static {
            MODES = Mode.values();
        }
    }

    public static enum ListMode {
        WhiteList,
        BlackList;

    }
}

