/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts.base;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FCPart
extends AEBasePart
implements IPowerChannelState,
ITerminalHost,
IConfigManagerHost,
IViewCellStorage,
IAEAppEngInventory {
    protected static final int POWERED_FLAG = 4;
    protected static final int CHANNEL_FLAG = 16;
    private static final int BOOTING_FLAG = 8;
    private byte spin = 0;
    private int clientFlags = 0;
    private float opacity = -1.0f;
    private final IConfigManager cm = new ConfigManager((IConfigManagerHost)this);
    private final AppEngInternalInventory viewCell = new AppEngInternalInventory((IAEAppEngInventory)this, 5);

    public FCPart(ItemStack is) {
        this(is, false);
    }

    protected FCPart(ItemStack is, boolean requireChannel) {
        super(is);
        if (requireChannel) {
            this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.getProxy().setIdlePowerUsage(0.5);
        } else {
            this.getProxy().setIdlePowerUsage(0.0625);
        }
        this.cm.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.cm.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        if (!this.isLightSource()) {
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public final void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    public void onNeighborChanged() {
        this.opacity = -1.0f;
        this.getHost().markForUpdate();
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.viewCell) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("opacity")) {
            this.opacity = data.func_74760_g("opacity");
        }
        this.spin = data.func_74771_c("spin");
        this.cm.readFromNBT(data);
        this.viewCell.readFromNBT(data, "viewCell");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("opacity", this.opacity);
        data.func_74774_a("spin", this.getSpin());
        this.cm.writeToNBT(data);
        this.viewCell.writeToNBT(data, "viewCell");
    }

    public abstract GuiType getGui();

    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.clientFlags = this.getSpin() & 3;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.clientFlags = this.getClientFlags() | 4;
            }
            if (this.getProxy().getPath().isNetworkBooting()) {
                this.clientFlags = this.getClientFlags() | 8;
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.clientFlags = this.getClientFlags() | 0x10;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        int oldFlags = this.getClientFlags();
        this.clientFlags = data.readByte();
        this.spin = (byte)(this.getClientFlags() & 3);
        return this.getClientFlags() != oldFlags;
    }

    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    public boolean onPartActivate0(EntityPlayer player, Vec3 pos) {
        TileEntity te = this.getTile();
        if (!player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e)) {
            if (Platform.isServer()) {
                if (this.getSpin() > 3) {
                    this.spin = 0;
                }
                switch (this.getSpin()) {
                    case 0: {
                        this.spin = 1;
                        break;
                    }
                    case 1: {
                        this.spin = (byte)3;
                        break;
                    }
                    case 2: {
                        this.spin = 0;
                        break;
                    }
                    case 3: {
                        this.spin = (byte)2;
                    }
                }
                this.getHost().markForUpdate();
                this.saveChanges();
            }
            return true;
        }
        return super.onPartActivate(player, pos);
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        TileEntity te = this.getTile();
        BlockPos tePos = new BlockPos(te);
        if (Platform.isWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (int)tePos.getX(), (int)tePos.getY(), (int)tePos.getZ())) {
            return super.onPartActivate(player, pos);
        }
        if (Platform.isServer()) {
            if (Util.hasPermission(player, SecurityPermissions.INJECT, (IGridHost)this) || Util.hasPermission(player, SecurityPermissions.EXTRACT, (IGridHost)this)) {
                InventoryHandler.openGui(player, te.func_145831_w(), tePos, Objects.requireNonNull(this.getSide()), this.getGui());
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("You don't have permission to view."));
            }
        }
        return true;
    }

    public final void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        byte rotation = (byte)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
        if (side == ForgeDirection.UP) {
            this.spin = rotation;
        } else if (side == ForgeDirection.DOWN) {
            this.spin = rotation;
        }
    }

    private int blockLight(int emit) {
        if (this.opacity < 0.0f) {
            TileEntity te = this.getTile();
            this.opacity = 255 - te.func_145831_w().getBlockLightOpacity(te.field_145851_c + this.getSide().offsetX, te.field_145848_d + this.getSide().offsetY, te.field_145849_e + this.getSide().offsetZ);
        }
        return (int)((float)emit * (this.opacity / 255.0f));
    }

    public final boolean isPowered() {
        try {
            if (Platform.isServer()) {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            return (this.getClientFlags() & 4) == 4;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        try {
            return this.getProxy().getStorage().getItemInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        try {
            return this.getProxy().getStorage().getFluidInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public IInventory getViewCellStorage() {
        return this.viewCell;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.getHost().markForSave();
    }

    public final boolean isActive() {
        if (!this.isLightSource()) {
            return (this.getClientFlags() & 0x14) == 20;
        }
        return this.isPowered();
    }

    public final int getClientFlags() {
        return this.clientFlags;
    }

    public final byte getSpin() {
        return this.spin;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        rh.setTexture(sideTexture, sideTexture, backTexture, FCPartsTexture.PartTerminalBroad.getIcon(), sideTexture, sideTexture);
        rh.renderInventoryBox(renderer);
        rh.setInvColor(this.getColor().whiteVariant);
        rh.renderInventoryFace(this.getFrontBright().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setInvColor(this.getColor().mediumVariant);
        rh.renderInventoryFace(this.getFrontDark().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setInvColor(this.getColor().blackVariant);
        rh.renderInventoryFace(this.getFrontColored().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        int l;
        boolean hasPower;
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        rh.setTexture(sideTexture, sideTexture, backTexture, FCPartsTexture.PartTerminalBroad.getIcon(), sideTexture, sideTexture);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        Tessellator tess = Tessellator.field_78398_a;
        if (this.getLightLevel() > 0) {
            int l2 = 13;
            tess.func_78380_c(0xD000D0);
        }
        byte by = this.getSpin();
        renderer.field_147873_r = by;
        renderer.field_147867_u = by;
        renderer.field_147871_s = by;
        renderer.field_147869_t = by;
        renderer.field_147875_q = by;
        renderer.field_147865_v = by;
        tess.func_78378_d(this.getColor().whiteVariant);
        rh.renderFace(x, y, z, this.getFrontBright().getIcon(), ForgeDirection.SOUTH, renderer);
        tess.func_78378_d(this.getColor().mediumVariant);
        rh.renderFace(x, y, z, this.getFrontDark().getIcon(), ForgeDirection.SOUTH, renderer);
        tess.func_78378_d(this.getColor().blackVariant);
        rh.renderFace(x, y, z, this.getFrontColored().getIcon(), ForgeDirection.SOUTH, renderer);
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        IIcon sideStatusTexture = CableBusTextures.PartMonitorSidesStatus.getIcon();
        rh.setTexture(sideStatusTexture, sideStatusTexture, backTexture, this.getItemStack().func_77954_c(), sideStatusTexture, sideStatusTexture);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        boolean hasChan = (this.getClientFlags() & 0x14) == 20;
        boolean bl = hasPower = (this.getClientFlags() & 4) == 4;
        if (hasChan) {
            l = 14;
            tess.func_78380_c(0xE000E0);
            tess.func_78378_d(this.getColor().blackVariant);
        } else if (hasPower) {
            l = 9;
            tess.func_78380_c(0x900090);
            tess.func_78378_d(this.getColor().whiteVariant);
        } else {
            tess.func_78380_c(0);
            tess.func_78378_d(0);
        }
        IIcon sideStatusLightTexture = CableBusTextures.PartMonitorSidesStatusLights.getIcon();
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.EAST, renderer);
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.WEST, renderer);
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.UP, renderer);
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.DOWN, renderer);
    }

    public abstract FCPartsTexture getFrontBright();

    public abstract FCPartsTexture getFrontColored();

    public abstract FCPartsTexture getFrontDark();

    public abstract boolean isLightSource();
}

