/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.contents.CellUpgrades;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.Platform;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.inventory.FluidCellConfig;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IItemInventory;
import com.glodblock.github.inventory.item.PortableFluidCellInventory;
import com.glodblock.github.loader.IRegister;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.RenderUtil;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPortableFluidCell
extends AEBasePoweredItem
implements IStorageFluidCell,
IItemInventory,
IRegister<ItemPortableFluidCell> {
    public ItemPortableFluidCell() {
        super(Config.portableCellBattery, Optional.absent());
        this.func_77655_b("portable_fluid_cell");
        this.func_111206_d(FluidCraft.resource("portable_fluid_cell").toString());
        this.setFeature(EnumSet.of(AEFeature.PortableCell, AEFeature.StorageCells, AEFeature.PoweredTools));
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        InventoryHandler.openGui(player, w, new BlockPos(player.field_71071_by.field_70461_c, 0, 0), ForgeDirection.UNKNOWN, GuiType.PORTABLE_FLUID_CELL);
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        IFluidCellInventoryHandler handler;
        IFluidCellInventory cellInventory;
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof IFluidCellInventoryHandler && (cellInventory = (handler = (IFluidCellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(EnumChatFormatting.WHITE + NumberFormat.getInstance().format(cellInventory.getUsedBytes()) + EnumChatFormatting.GRAY + " " + GuiText.Of.getLocal() + " " + EnumChatFormatting.DARK_GREEN + cellInventory.getTotalBytes() + " " + EnumChatFormatting.GRAY + GuiText.BytesUsed.getLocal());
            lines.add(EnumChatFormatting.WHITE + NumberFormat.getInstance().format(cellInventory.getStoredFluidTypes()) + EnumChatFormatting.GRAY + " " + GuiText.Of.getLocal() + " " + EnumChatFormatting.DARK_GREEN + cellInventory.getTotalFluidTypes() + " " + EnumChatFormatting.GRAY + GuiText.Types.getLocal());
        }
        if (GuiScreen.func_146272_n()) {
            lines.addAll(RenderUtil.listFormattedStringToWidth(StatCollector.func_74837_a((String)"ae2fc.tooltip.cell_portable", (Object[])new Object[0])));
        } else {
            lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.shift_for_more"));
        }
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        return 256L;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 5;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return 0.5;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 0);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new FluidCellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public ItemPortableFluidCell register() {
        GameRegistry.registerItem((Item)this, (String)"portable_fluid_cell", (String)"ae2fc");
        this.func_77637_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    @Override
    public Object getInventory(ItemStack stack, World world, int x, int y, int z, EntityPlayer player) {
        return new PortableFluidCellInventory(stack, x);
    }

    public ItemStack stack() {
        return new ItemStack((Item)this, 1);
    }
}

