/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.render;

import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ItemDropRender
implements IItemRenderer {
    private final Map<String, Integer> colourCache = new HashMap<String, Integer>();

    public ItemDropRender() {
        MinecraftForgeClient.registerItemRenderer((Item)ItemAndBlockHolder.DROP, (IItemRenderer)this);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        IIcon shape = ItemAndBlockHolder.DROP.shape;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        if (type.equals((Object)IItemRenderer.ItemRenderType.ENTITY)) {
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.6, (double)0.0);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        GL11.glBlendFunc((int)770, (int)771);
        FluidStack fluid = ItemFluidDrop.getFluidStack(item);
        if (fluid != null) {
            int RGB = this.getColour(fluid);
            GL11.glColor3f((float)((float)(RGB >> 16 & 0xFF) / 255.0f), (float)((float)(RGB >> 8 & 0xFF) / 255.0f), (float)((float)(RGB & 0xFF) / 255.0f));
        }
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            RenderUtil.renderItemIcon(shape, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)shape.func_94212_f(), (float)shape.func_94206_g(), (float)shape.func_94209_e(), (float)shape.func_94210_h(), (int)shape.func_94211_a(), (int)shape.func_94216_b(), (float)0.0625f);
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
    }

    public int getColour(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        int colour = fluid.getColor(fluidStack);
        return colour != 0xFFFFFF ? colour : this.getColour(fluid);
    }

    public int getColour(Fluid fluid) {
        Integer cached = this.colourCache.get(fluid.getName());
        if (cached != null) {
            return cached;
        }
        int colour = fluid.getColor();
        if (colour == 0xFFFFFF) {
            TextureAtlasSprite sprite;
            try {
                sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStillIcon().func_94215_i());
            }
            catch (NullPointerException e) {
                this.colourCache.put(fluid.getName(), colour);
                return colour;
            }
            if (sprite != null && sprite.func_110970_k() > 0) {
                int[][] image = sprite.func_147965_a(0);
                int r = 0;
                int g = 0;
                int b = 0;
                int count = 0;
                int[][] nArray = image;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] row;
                    for (int pixel : row = nArray[i]) {
                        if ((pixel >> 24 & 0xFF) <= 127) continue;
                        r += pixel >> 16 & 0xFF;
                        g += pixel >> 8 & 0xFF;
                        b += pixel & 0xFF;
                        ++count;
                    }
                }
                if (count > 0) {
                    colour = r / count << 16 | g / count << 8 | b / count;
                }
            }
        }
        this.colourCache.put(fluid.getName(), colour);
        return colour;
    }
}

