/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.InventoryAction;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.tile.TileFluidPatternEncoder;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.AeStackInventory;
import com.glodblock.github.inventory.IPatternConsumer;
import com.glodblock.github.inventory.slot.SlotFluidConvertingFake;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerFluidPatternEncoder
extends AEBaseContainer
implements IPatternConsumer {
    private final TileFluidPatternEncoder tile;

    public ContainerFluidPatternEncoder(InventoryPlayer ipl, TileFluidPatternEncoder tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        AeItemStackHandler crafting = new AeItemStackHandler(tile.getCraftingSlots());
        AeItemStackHandler output = new AeItemStackHandler(tile.getOutputSlots());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotFluidConvertingFake(crafting, y * 3 + x, 23 + x * 18, 17 + y * 18));
            }
            this.func_75146_a((Slot)new SlotFluidConvertingFake(output, y, 113, 17 + y * 18));
        }
        this.func_75146_a((Slot)new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, tile.getInventory(), 0, 138, 20, ipl));
        this.func_75146_a((Slot)new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, tile.getInventory(), 1, 138, 50, ipl));
        this.bindPlayerInventory(ipl, 0, 84);
    }

    public TileFluidPatternEncoder getTile() {
        return this.tile;
    }

    private static boolean isNotPattern(ItemStack stack) {
        return stack == null || !AEApi.instance().definitions().materials().blankPattern().isSameAs(stack) && !(stack.func_77973_b() instanceof ItemFluidEncodedPattern);
    }

    public boolean canEncodePattern() {
        block3: {
            if (ContainerFluidPatternEncoder.isNotPattern(this.tile.getInventory().func_70301_a(0)) && ContainerFluidPatternEncoder.isNotPattern(this.tile.getInventory().func_70301_a(1))) {
                return false;
            }
            for (IAEItemStack stack : this.tile.getCraftingSlots()) {
                if (stack == null || stack.getStackSize() <= 0L) continue;
                break block3;
            }
            return false;
        }
        for (IAEItemStack stack : this.tile.getOutputSlots()) {
            if (stack == null || stack.getStackSize() <= 0L) continue;
            return true;
        }
        return false;
    }

    public void encodePattern() {
        if (this.canEncodePattern()) {
            if (this.tile.getInventory().func_70301_a(1) == null) {
                this.tile.getInventory().func_70298_a(0, 1);
            }
            ItemStack patternStack = new ItemStack((Item)ItemAndBlockHolder.PATTERN);
            FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
            pattern.setInputs((IAEStack<?>[])ContainerFluidPatternEncoder.collectAeInventory(this.tile.getCraftingSlots()));
            pattern.setOutputs((IAEStack<?>[])ContainerFluidPatternEncoder.collectAeInventory(this.tile.getOutputSlots()));
            this.tile.getInventory().func_70299_a(1, pattern.writeToStack());
        }
    }

    private static IAEItemStack[] collectAeInventory(AeStackInventory<IAEItemStack> inv) {
        ArrayList<IAEItemStack> acc = new ArrayList<IAEItemStack>();
        for (IAEItemStack stack : inv) {
            IAEItemStack dropStack;
            if (stack == null) continue;
            if (stack.getItem() instanceof ItemFluidPacket && (dropStack = ItemFluidDrop.newAeStack(ItemFluidPacket.getFluidStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            acc.add(stack);
        }
        return acc.toArray(new IAEItemStack[0]);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        block11: {
            block10: {
                Slot slot = this.func_75139_a(slotId);
                if (!(slot instanceof SlotFluidConvertingFake)) break block10;
                ItemStack stack = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (stack == null) {
                            slot.func_75215_d(null);
                            break;
                        }
                        ((SlotFluidConvertingFake)slot).putConvertedStack(stack.func_77946_l());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (stack == null) break;
                        ((SlotFluidConvertingFake)slot).putConvertedStack(Objects.requireNonNull(Util.copyStackWithSize(stack, 1)));
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        ItemStack inSlot = slot.func_75211_c();
                        if (inSlot != null) {
                            if (stack == null) {
                                slot.func_75215_d(Util.copyStackWithSize(inSlot, Math.max(1, inSlot.field_77994_a - 1)));
                                break;
                            }
                            if (stack.func_77969_a(inSlot)) {
                                slot.func_75215_d(Util.copyStackWithSize(inSlot, Math.min(inSlot.func_77976_d(), inSlot.field_77994_a + 1)));
                                break;
                            }
                            ((SlotFluidConvertingFake)slot).putConvertedStack(Objects.requireNonNull(Util.copyStackWithSize(stack, 1)));
                            break;
                        }
                        if (stack != null) {
                            ((SlotFluidConvertingFake)slot).putConvertedStack(Objects.requireNonNull(Util.copyStackWithSize(stack, 1)));
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            super.doAction(player, action, slotId, id);
        }
    }

    @Override
    public void acceptPattern(IAEItemStack[] inputs, IAEItemStack[] outputs) {
        ContainerFluidPatternEncoder.copyStacks(inputs, this.tile.getCraftingSlots());
        ContainerFluidPatternEncoder.copyStacks(outputs, this.tile.getOutputSlots());
    }

    private static void copyStacks(IAEItemStack[] src, AeStackInventory<IAEItemStack> dest) {
        int bound = Math.min(src.length, dest.getSlotCount());
        for (int i = 0; i < bound; ++i) {
            dest.setStack(i, src[i]);
        }
    }
}

