/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotFake;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIDragClick;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cofh.core.render.CoFHFontRenderer;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.api.registries.LevelState;
import com.glodblock.github.client.gui.FCGuiLineField;
import com.glodblock.github.client.gui.FCGuiTextField;
import com.glodblock.github.client.gui.GuiFCImgButton;
import com.glodblock.github.client.gui.container.ContainerLevelMaintainer;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.common.parts.PartLevelTerminal;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.gui.MouseRegionManager;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessLevelTerminalInventory;
import com.glodblock.github.inventory.slot.SlotFluidConvertingFake;
import com.glodblock.github.inventory.slot.SlotSingleItem;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.network.CPacketLevelMaintainer;
import com.glodblock.github.network.CPacketLevelTerminalCommands;
import com.glodblock.github.util.FCGuiColors;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.Optional;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Optional.Interface(modid="NotEnoughItems", iface="codechicken.nei.api.INEIGuiHandler")
public class GuiLevelMaintainer
extends AEBaseGui
implements INEIGuiHandler {
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/level_maintainer.png");
    private final ContainerLevelMaintainer cont;
    private final Component[] component = new Component[5];
    private final MouseRegionManager mouseRegions = new MouseRegionManager((GuiContainer)this);
    private Widget focusedWidget;
    private final CoFHFontRenderer render;
    protected ItemStack icon = null;
    protected GuiType originalGui;
    protected Util.DimensionalCoordSide originalBlockPos;
    protected GuiTabButton originalGuiBtn;

    public GuiLevelMaintainer(InventoryPlayer ipl, TileLevelMaintainer tile) {
        super((Container)new ContainerLevelMaintainer(ipl, tile));
        this.cont = (ContainerLevelMaintainer)this.field_147002_h;
        this.field_146999_f = 195;
        this.field_147000_g = 214;
        this.render = new CoFHFontRenderer(Minecraft.func_71410_x().field_71474_y, TEX_BG, Minecraft.func_71410_x().func_110434_K(), true);
        Container container = ipl.field_70458_d.field_71070_bA;
        if (container instanceof AEBaseContainer) {
            IWirelessTerminal terminal;
            AEBaseContainer container2 = (AEBaseContainer)container;
            Object target = container2.getTarget();
            if (target instanceof PartLevelTerminal) {
                PartLevelTerminal terminal2 = (PartLevelTerminal)target;
                this.icon = ItemAndBlockHolder.LEVEL_TERMINAL.stack();
                this.originalGui = GuiType.LEVEL_TERMINAL;
                DimensionalCoord blockPos = new DimensionalCoord(terminal2.getTile());
                this.originalBlockPos = new Util.DimensionalCoordSide(blockPos.x, blockPos.y, blockPos.z, blockPos.getDimension(), terminal2.getSide(), "");
            } else if (target instanceof IWirelessTerminal && (terminal = (IWirelessTerminal)target).isUniversal(target)) {
                this.icon = ItemAndBlockHolder.WIRELESS_ULTRA_TERM.stack();
                this.originalGui = ItemWirelessUltraTerminal.readMode(terminal.getItemStack());
                this.originalBlockPos = new Util.DimensionalCoordSide(terminal.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0, ipl.field_70458_d.field_70170_p.field_73011_w.field_76574_g, ForgeDirection.UNKNOWN, "");
            } else if (target instanceof WirelessLevelTerminalInventory) {
                WirelessLevelTerminalInventory terminal3 = (WirelessLevelTerminalInventory)target;
                this.icon = ItemAndBlockHolder.WIRELESS_LEVEL_TERM.stack();
                this.originalGui = GuiType.WIRELESS_LEVEL_TERMINAL;
                this.originalBlockPos = new Util.DimensionalCoordSide(terminal3.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0, ipl.field_70458_d.field_70170_p.field_73011_w.field_76574_g, ForgeDirection.UNKNOWN, "");
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 5; ++i) {
            this.component[i] = new Component(new Widget(new FCGuiTextField(this.field_146289_q, this.field_147003_i + 46, this.field_147009_r + 19 + 19 * i, 52, 14), "ae2fc.tooltip.level_maintainer.request_size", i, CPacketLevelMaintainer.Action.Quantity), new Widget(new FCGuiTextField(this.field_146289_q, this.field_147003_i + 100, this.field_147009_r + 19 + 19 * i, 52, 14), "ae2fc.tooltip.level_maintainer.batch_size", i, CPacketLevelMaintainer.Action.Batch), new GuiFCImgButton(this.field_147003_i + 105 + 47, this.field_147009_r + 17 + 19 * i, "SUBMIT", "SUBMIT", false), new GuiFCImgButton(this.field_147003_i + 9, this.field_147009_r + 20 + 19 * i, "ENABLE", "ENABLE", false), new GuiFCImgButton(this.field_147003_i + 9, this.field_147009_r + 20 + 19 * i, "DISABLE", "DISABLE", false), new FCGuiLineField(this.field_146289_q, this.field_147003_i + 47, this.field_147009_r + 33 + 19 * i, 125), this.field_146292_n, this.cont);
        }
        if (this.icon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 151, this.field_147009_r - 4, this.icon, this.icon.func_82833_r(), field_146296_j);
            this.originalGuiBtn.setHideEdge(13);
            this.field_146292_n.add(this.originalGuiBtn);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        super.func_73863_a(mouseX, mouseY, btn);
        for (Component com : this.component) {
            com.getQty().textField.handleTooltip(mouseX, mouseY, this);
            com.getBatch().textField.handleTooltip(mouseX, mouseY, this);
            com.getLine().handleTooltip(mouseX, mouseY, this);
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, 176, this.field_147000_g);
        for (int i = 0; i < 5; ++i) {
            this.component[i].draw();
        }
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(NameConst.i18n("ae2fc.gui.level_maintainer")), 8, 6, 0x404040);
        this.mouseRegions.render(mouseX, mouseY);
    }

    public void func_146977_a(Slot s) {
        if (this.drawSlot0(s)) {
            super.func_146977_a(s);
        }
    }

    public boolean drawSlot0(Slot slot) {
        if (slot instanceof SlotFake) {
            IAEItemStack stack = ((SlotFluidConvertingFake)slot).getAeStack();
            super.func_146977_a((Slot)new SlotSingleItem(slot));
            if (stack == null) {
                return true;
            }
            IAEItemStack fake = stack.copy();
            Widget qty = this.component[slot.getSlotIndex()].getQty();
            qty.validate();
            fake.setStackSize(qty.getAmount() != null ? qty.getAmount() : 0L);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
            aeRenderItem.setAeStack(fake);
            aeRenderItem.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), fake.getItemStack(), slot.field_75223_e, slot.field_75221_f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
            return false;
        }
        return true;
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (btn == 0) {
            if (this.focusedWidget != null) {
                this.focusedWidget.textField.func_146195_b(false);
            }
            for (Component com : this.component) {
                Widget textField = com.isMouseIn(xCoord, yCoord);
                if (textField == null) continue;
                textField.textField.func_146195_b(true);
                this.focusedWidget = textField;
                super.func_73864_a(xCoord, yCoord, btn);
                return;
            }
            this.focusedWidget = null;
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) {
        if (this.focusedWidget == null) {
            super.func_73869_a(character, key);
            return;
        }
        if (!this.func_146983_a(key)) {
            if (character != ' ' || !this.focusedWidget.textField.func_146179_b().isEmpty()) {
                this.focusedWidget.textField.func_146201_a(character, key);
            }
            super.func_73869_a(character, key);
            this.focusedWidget.validate();
            if (key == 28 || key == 156) {
                this.component[this.focusedWidget.componentIndex].submit();
                this.focusedWidget.textField.func_146195_b(false);
                this.focusedWidget = null;
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.originalGuiBtn) {
            this.switchGui();
        } else {
            super.func_146284_a(btn);
            for (Component com : this.component) {
                if (com.sendToServer(btn)) break;
            }
        }
    }

    public void switchGui() {
        CPacketLevelTerminalCommands message = new CPacketLevelTerminalCommands(CPacketLevelTerminalCommands.Action.BACK, this.originalBlockPos.x, this.originalBlockPos.y, this.originalBlockPos.z, this.originalBlockPos.getDimension(), this.originalBlockPos.getSide());
        if (this.originalGui != null) {
            message.setOriginalGui(this.originalGui.ordinal());
        }
        FluidCraft.proxy.netHandler.sendToServer(message);
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    protected void func_146984_a(Slot slot, int slotIdx, int ctrlDown, int mouseButton) {
        if (slot instanceof SlotFluidConvertingFake && this.cont.getPlayerInv().func_70445_o() == null) {
            slot.func_75215_d(null);
            this.component[slot.getSlotIndex()].reset();
        }
        super.func_146984_a(slot, slotIdx, ctrlDown, mouseButton);
    }

    public boolean handleDragNDrop(GuiContainer gui, int mouseX, int mouseY, ItemStack draggedStack, int button) {
        if (draggedStack == null) {
            return false;
        }
        draggedStack.field_77994_a = 0;
        Slot slotAtPosition = this.func_146975_c(mouseX, mouseY);
        if (slotAtPosition == null) {
            return false;
        }
        for (int i = 0; i < this.cont.getRequestSlots().length; ++i) {
            SlotFluidConvertingFake slot = this.cont.getRequestSlots()[i];
            if (!slotAtPosition.equals(slot)) continue;
            slot.func_75215_d(draggedStack);
            this.component[i].reset();
            NetworkHandler.instance.sendToServer((AppEngPacket)new PacketNEIDragClick(draggedStack, slot.getSlotIndex()));
            return true;
        }
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return false;
    }

    public void updateComponent(int index, long quantity, long batchSize, boolean isEnabled, LevelState state) {
        if (index < 0 || index >= 5) {
            return;
        }
        this.component[index].setEnable(isEnabled);
        this.component[index].setState(state);
        this.component[index].getQty().textField.func_146180_a(String.valueOf(quantity));
        this.component[index].getBatch().textField.func_146180_a(String.valueOf(batchSize));
        this.component[index].getQty().validate();
        this.component[index].getBatch().validate();
    }

    public void updateComponent(int index, LevelState state) {
        if (index < 0 || index >= 5) {
            return;
        }
        this.component[index].setState(state);
    }

    private class Component {
        public boolean isEnable = false;
        private final Widget qty;
        private final Widget batch;
        private final GuiFCImgButton disable;
        private final GuiFCImgButton enable;
        private final GuiFCImgButton submit;
        private final FCGuiLineField line;
        private LevelState state;
        private final ContainerLevelMaintainer container;

        public Component(Widget qtyInput, Widget batchInput, GuiFCImgButton submitBtn, GuiFCImgButton enableBtn, GuiFCImgButton disableBtn, FCGuiLineField line, List<GuiButton> buttonList, ContainerLevelMaintainer container) {
            this.qty = qtyInput;
            this.batch = batchInput;
            this.enable = enableBtn;
            this.disable = disableBtn;
            this.submit = submitBtn;
            this.line = line;
            this.state = LevelState.None;
            this.container = container;
            buttonList.add(this.submit);
            buttonList.add(this.enable);
            buttonList.add(this.disable);
        }

        public int getIndex() {
            return this.qty.componentIndex;
        }

        public void setEnable(boolean enable) {
            this.isEnable = enable;
        }

        private void send(Widget widget) {
            if (((Slot)((GuiLevelMaintainer)GuiLevelMaintainer.this).cont.field_75151_b.get(widget.componentIndex)).func_75216_d() && widget.getAmount() != null) {
                FluidCraft.proxy.netHandler.sendToServer(new CPacketLevelMaintainer(widget.action, widget.componentIndex, widget.getAmount()));
            }
        }

        public void submit() {
            this.sendToServer(this.submit);
        }

        protected boolean sendToServer(GuiButton btn) {
            boolean didSomething = false;
            if (this.submit == btn) {
                Widget qty = this.getQty();
                Widget batch = this.getBatch();
                qty.validate();
                batch.validate();
                if (qty.getAmount() != null) {
                    this.send(qty);
                    qty.textField.func_146180_a(String.valueOf(qty.getAmount()));
                }
                if (batch.getAmount() != null) {
                    this.send(batch);
                    batch.textField.func_146180_a(String.valueOf(batch.getAmount()));
                }
                didSomething = true;
            } else if (this.enable == btn) {
                this.setEnable(false);
                FluidCraft.proxy.netHandler.sendToServer(new CPacketLevelMaintainer(CPacketLevelMaintainer.Action.Enable, this.getIndex()));
                didSomething = true;
            } else if (this.disable == btn && this.container.func_75138_a().get(this.getIndex()) != null) {
                this.setEnable(true);
                FluidCraft.proxy.netHandler.sendToServer(new CPacketLevelMaintainer(CPacketLevelMaintainer.Action.Disable, this.getIndex()));
                didSomething = true;
            }
            return didSomething;
        }

        public Widget isMouseIn(int xCoord, int yCoord) {
            if (this.qty.textField.isMouseIn(xCoord, yCoord)) {
                return this.getQty();
            }
            if (this.batch.textField.isMouseIn(xCoord, yCoord)) {
                return this.getBatch();
            }
            return null;
        }

        public Widget getQty() {
            return this.qty;
        }

        public Widget getBatch() {
            return this.batch;
        }

        public FCGuiLineField getLine() {
            return this.line;
        }

        public void draw() {
            this.qty.draw();
            this.batch.draw();
            ArrayList<String> message = new ArrayList<String>();
            message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.title") + "\n");
            switch (this.state) {
                case Idle: {
                    this.line.setColor(FCGuiColors.StateIdle.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.idle"));
                    break;
                }
                case Craft: {
                    this.line.setColor(FCGuiColors.StateCraft.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.link"));
                    break;
                }
                case Export: {
                    this.line.setColor(FCGuiColors.StateExport.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.export"));
                    break;
                }
                case Error: {
                    this.line.setColor(FCGuiColors.StateError.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.error"));
                    break;
                }
                case NotFound: {
                    this.line.setColor(FCGuiColors.StateError.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.not_found"));
                    break;
                }
                case CantCraft: {
                    this.line.setColor(FCGuiColors.StateError.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.cant_craft"));
                    break;
                }
                default: {
                    this.line.setColor(FCGuiColors.StateNone.getColor());
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + " " + NameConst.i18n("ae2fc.tooltip.level_maintainer.none"));
                }
            }
            message.add("");
            if (GuiScreen.func_146272_n()) {
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.idle"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.idle_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.link"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.link_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.export"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.export_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.error"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.error_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.not_found"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.not_found_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.cant_craft"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.cant_craft_desc"));
            } else {
                message.add(NameConst.i18n("ae2fc.tooltip.shift_for_more"));
            }
            this.line.setMessage(GuiLevelMaintainer.this.render.func_78280_d(String.join((CharSequence)"\n", message), (int)Math.floor((double)GuiLevelMaintainer.this.field_146999_f * 0.8)));
            this.line.func_146194_f();
            if (this.isEnable) {
                this.enable.field_146125_m = true;
                this.disable.field_146125_m = false;
            } else {
                this.enable.field_146125_m = false;
                this.disable.field_146125_m = true;
            }
        }

        public void setState(LevelState state) {
            this.state = state;
        }

        public void reset() {
            this.qty.textField.func_146180_a("0");
            this.batch.textField.func_146180_a("0");
            this.qty.validate();
            this.batch.validate();
            this.setEnable(false);
            this.setState(LevelState.None);
        }
    }

    private class Widget {
        public final int componentIndex;
        public final CPacketLevelMaintainer.Action action;
        public final FCGuiTextField textField;
        private final String tooltip;
        private Long amount;

        public Widget(FCGuiTextField textField, String tooltip, int componentIndex, CPacketLevelMaintainer.Action action) {
            this.textField = textField;
            this.textField.func_146185_a(false);
            this.textField.func_146180_a("0");
            this.textField.func_146203_f(16);
            this.componentIndex = componentIndex;
            this.action = action;
            this.tooltip = tooltip;
        }

        public void draw() {
            String current;
            String string = current = this.amount != null ? StatCollector.func_74838_a((String)"ae2fc.tooltip.level_maintainer.current") + " " + NumberFormat.getNumberInstance().format(this.amount) + "\n" : "";
            if (GuiScreen.func_146272_n()) {
                this.setTooltip(GuiLevelMaintainer.this.render.func_78280_d(StatCollector.func_74838_a((String)this.tooltip) + "\n" + current + "\n" + StatCollector.func_74838_a((String)(this.tooltip + ".hint")), GuiLevelMaintainer.this.field_146999_f / 2));
            } else {
                this.setTooltip(GuiLevelMaintainer.this.render.func_78280_d(NameConst.i18n(this.tooltip, "\n", false) + "\n" + current + NameConst.i18n("ae2fc.tooltip.shift_for_more"), (int)Math.floor((double)GuiLevelMaintainer.this.field_146999_f * 0.8)));
            }
            this.textField.func_146194_f();
        }

        public void setTooltip(String message) {
            this.textField.setMessage(message);
        }

        public void validate() {
            double result = Calculator.conversion((String)this.textField.func_146179_b());
            if (Double.isNaN(result) || result < 0.0) {
                this.amount = null;
                this.textField.func_146193_g(0xFF0000);
            } else {
                this.amount = (long)ArithHelper.round((double)result, (int)0);
                this.textField.func_146193_g(0xFFFFFF);
            }
        }

        @Nullable
        public Long getAmount() {
            return this.amount;
        }
    }
}

