/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.implementations.GuiUpgradeable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.core.AEConfig;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.ContainerFluidLevelEmitter;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.common.parts.PartFluidLevelEmitter;
import com.glodblock.github.common.parts.PartLevelTerminal;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessLevelTerminalInventory;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.network.CPacketLevelTerminalCommands;
import com.glodblock.github.network.CPacketValueConfig;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.Util;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiFluidLevelEmitter
extends GuiUpgradeable {
    private MEGuiTextField amountTextField;
    protected GuiType originalGui;
    protected Util.DimensionalCoordSide originalBlockPos;
    protected ItemStack originalGuiIcon;
    protected GuiTabButton originalGuiBtn;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton minus1;
    private GuiButton minus10;
    private GuiButton minus100;
    private GuiButton minus1000;
    private GuiButton setButton;
    private boolean isMul = false;

    public GuiFluidLevelEmitter(InventoryPlayer inventoryPlayer, PartFluidLevelEmitter te) {
        super((ContainerUpgradeable)new ContainerFluidLevelEmitter(inventoryPlayer, te));
        Container container = inventoryPlayer.field_70458_d.field_71070_bA;
        if (container instanceof AEBaseContainer) {
            IWirelessTerminal terminal;
            AEBaseContainer container2 = (AEBaseContainer)container;
            Object target = container2.getTarget();
            if (target instanceof PartLevelTerminal) {
                PartLevelTerminal terminal2 = (PartLevelTerminal)target;
                this.originalGuiIcon = ItemAndBlockHolder.LEVEL_TERMINAL.stack();
                this.originalGui = GuiType.LEVEL_TERMINAL;
                DimensionalCoord blockPos = new DimensionalCoord(terminal2.getTile());
                this.originalBlockPos = new Util.DimensionalCoordSide(blockPos.x, blockPos.y, blockPos.z, blockPos.getDimension(), terminal2.getSide(), "");
            } else if (target instanceof IWirelessTerminal && (terminal = (IWirelessTerminal)target).isUniversal(target)) {
                this.originalGuiIcon = ItemAndBlockHolder.WIRELESS_ULTRA_TERM.stack();
                this.originalGui = ItemWirelessUltraTerminal.readMode(terminal.getItemStack());
                this.originalBlockPos = new Util.DimensionalCoordSide(terminal.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0, inventoryPlayer.field_70458_d.field_70170_p.field_73011_w.field_76574_g, ForgeDirection.UNKNOWN, "");
            } else if (target instanceof WirelessLevelTerminalInventory) {
                WirelessLevelTerminalInventory terminal3 = (WirelessLevelTerminalInventory)target;
                this.originalGuiIcon = ItemAndBlockHolder.WIRELESS_LEVEL_TERM.stack();
                this.originalGui = GuiType.WIRELESS_LEVEL_TERMINAL;
                this.originalBlockPos = new Util.DimensionalCoordSide(terminal3.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0, inventoryPlayer.field_70458_d.field_70170_p.field_73011_w.field_76574_g, ForgeDirection.UNKNOWN, "");
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.amountTextField = new MEGuiTextField(90, 12);
        this.amountTextField.x = this.field_147003_i + 39;
        this.amountTextField.y = this.field_147009_r + 44;
        this.amountTextField.setFocused(true);
        ((ContainerFluidLevelEmitter)this.field_147002_h).setTextField(this.amountTextField);
        this.validateText();
        if (this.originalGuiIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 151, this.field_147009_r - 4, this.originalGuiIcon, this.originalGuiIcon.func_82833_r(), field_146296_j);
            this.originalGuiBtn.setHideEdge(13);
            this.field_146292_n.add(this.originalGuiBtn);
        }
    }

    protected void addButtons() {
        this.redstoneMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, (Enum)Settings.REDSTONE_EMITTER, (Enum)RedstoneMode.LOW_SIGNAL);
        int a = AEConfig.instance.levelByStackAmounts(0);
        int b = AEConfig.instance.levelByStackAmounts(1);
        int c = AEConfig.instance.levelByStackAmounts(2);
        int d = AEConfig.instance.levelByStackAmounts(3);
        this.plus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 17, 22, 20, "+" + a);
        this.field_146292_n.add(this.plus1);
        this.plus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 17, 28, 20, "+" + b);
        this.field_146292_n.add(this.plus10);
        this.plus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 17, 32, 20, "+" + c);
        this.field_146292_n.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 17, 38, 20, "+" + d);
        this.field_146292_n.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 63, 22, 20, "-" + a);
        this.field_146292_n.add(this.minus1);
        this.minus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 63, 28, 20, "-" + b);
        this.field_146292_n.add(this.minus10);
        this.minus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 63, 32, 20, "-" + c);
        this.field_146292_n.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 63, 38, 20, "-" + d);
        this.field_146292_n.add(this.minus1000);
        this.setButton = new GuiButton(0, this.field_147003_i + 134, this.field_147009_r + 40, 28, 20, GuiText.Set.getLocal());
        this.field_146292_n.add(this.setButton);
        this.field_146292_n.add(this.redstoneMode);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(NameConst.i18n("ae2fc.gui.part_fluid_level_emitter")), 8, 6, GuiColors.UpgradableTitle.getColor());
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, GuiColors.UpgradableInventory.getColor());
        this.redstoneMode.set((Enum)this.cvb.getRedStoneMode());
        if (GuiFluidLevelEmitter.func_146272_n() && !this.isMul) {
            for (GuiButton btn : this.field_146292_n) {
                if (!(btn instanceof GuiButton)) continue;
                btn.field_146126_j = btn.field_146126_j + "000";
            }
            this.isMul = true;
        } else if (!GuiFluidLevelEmitter.func_146272_n() && this.isMul) {
            for (GuiButton btn : this.field_146292_n) {
                if (!(btn instanceof GuiButton)) continue;
                btn.field_146126_j = btn.field_146126_j.substring(0, btn.field_146126_j.lastIndexOf("000"));
            }
            this.isMul = false;
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.amountTextField.drawTextBox();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.getBackground());
    }

    protected void handleButtonVisibility() {
    }

    protected String getBackground() {
        return "guis/lvlemitter.png";
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.originalGuiBtn) {
            CPacketLevelTerminalCommands message = new CPacketLevelTerminalCommands(CPacketLevelTerminalCommands.Action.BACK, this.originalBlockPos.x, this.originalBlockPos.y, this.originalBlockPos.z, this.originalBlockPos.getDimension(), this.originalBlockPos.getSide());
            message.setOriginalGui(this.originalGui.ordinal());
            FluidCraft.proxy.netHandler.sendToServer(message);
        } else if (btn == this.setButton && this.setButton.field_146124_l) {
            long amount = this.getAmountLong();
            this.amountTextField.setText(Long.toString(amount));
            FluidCraft.proxy.netHandler.sendToServer(new CPacketValueConfig(amount, 0));
        } else {
            boolean isMinus;
            boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
            boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
            if (isPlus || isMinus) {
                long result = this.addOrderAmount(this.getQty(btn));
                this.amountTextField.setText(Long.toString(result));
            } else {
                super.func_146284_a(btn);
            }
        }
    }

    private long addOrderAmount(int i) {
        long resultL = this.getAmountLong();
        if (resultL == 1L && i > 1) {
            resultL = 0L;
        }
        if ((resultL += (long)i) < 1L) {
            resultL = 1L;
        }
        return resultL;
    }

    private long getAmountLong() {
        String out = this.amountTextField.getText();
        double resultD = Calculator.conversion((String)out);
        if (resultD <= 0.0 || Double.isNaN(resultD)) {
            return 0L;
        }
        return (long)ArithHelper.round((double)resultD, (int)0);
    }

    private void validateText() {
        String text = this.amountTextField.getText();
        double resultD = Calculator.conversion((String)text);
        this.setButton.field_146124_l = !Double.isNaN(resultD);
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.amountTextField.mouseClicked(xCoord, yCoord, btn);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.setButton);
            } else {
                boolean typedTextbox = this.amountTextField.textboxKeyTyped(character, key);
                if (typedTextbox) {
                    this.validateText();
                } else {
                    super.func_73869_a(character, key);
                }
            }
        }
    }

    protected boolean drawUpgrades() {
        return false;
    }

    public void update(Integer key, IAEFluidStack value) {
        ((ContainerFluidLevelEmitter)this.cvb).getBus().setFluidInSlot(key, value);
    }
}

