/*
 * Decompiled with CFR 0.152.
 */
package enviromine.utils;

import enviromine.blocks.water.BlockEnviroMineWater;
import enviromine.core.EM_Settings;
import enviromine.handlers.ObjectHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.Fluid;

public class WaterUtils {
    public static WATER_TYPES heatUp(WATER_TYPES waterType) {
        boolean isDirty = waterType.isDirty;
        boolean isSalty = waterType.isSalty;
        int heatIndex = waterType.heatIndex;
        if (heatIndex >= 0) {
            isDirty = false;
            isSalty = false;
        }
        heatIndex = heatIndex < 2 ? ++heatIndex : 2;
        return WATER_TYPES.fromTraits(waterType, heatIndex, waterType.isRadioactive, isDirty, isSalty);
    }

    public static WATER_TYPES heatUp(WATER_TYPES waterType, int iterations) {
        boolean isDirty = waterType.isDirty;
        boolean isSalty = waterType.isSalty;
        int heatIndex = waterType.heatIndex;
        if (heatIndex >= 0) {
            isDirty = false;
            isSalty = false;
        }
        heatIndex = heatIndex + iterations < 2 ? (heatIndex += iterations) : 2;
        if (heatIndex == 2) {
            isDirty = false;
            isSalty = false;
        }
        return WATER_TYPES.fromTraits(waterType, heatIndex, waterType.isRadioactive, isDirty, isSalty);
    }

    public static WATER_TYPES coolDown(WATER_TYPES waterType) {
        boolean isDirty = waterType.isDirty;
        boolean isSalty = waterType.isSalty;
        int heatIndex = waterType.heatIndex;
        if (heatIndex < 0) {
            isDirty = false;
            isSalty = false;
        }
        heatIndex = heatIndex > -2 ? --heatIndex : -2;
        return WATER_TYPES.fromTraits(waterType, heatIndex, waterType.isRadioactive, isDirty, isSalty);
    }

    public static WATER_TYPES coolDown(WATER_TYPES waterType, int iterations) {
        boolean isDirty = waterType.isDirty;
        boolean isSalty = waterType.isSalty;
        int heatIndex = waterType.heatIndex;
        if (heatIndex < 0) {
            isDirty = false;
            isSalty = false;
        }
        heatIndex = heatIndex - iterations > -2 ? (heatIndex -= iterations) : -2;
        if (heatIndex == -2) {
            isDirty = false;
            isSalty = false;
        }
        return WATER_TYPES.fromTraits(waterType, heatIndex, waterType.isRadioactive, isDirty, isSalty);
    }

    public static WATER_TYPES saltDown(WATER_TYPES waterType) {
        return WATER_TYPES.fromTraits(waterType, waterType.heatIndex, waterType.isRadioactive, waterType.isDirty, true);
    }

    public static WATER_TYPES forceSaltDown(WATER_TYPES waterType) {
        int heatIndex = waterType.heatIndex == 2 ? 1 : (waterType.heatIndex == -2 ? -1 : waterType.heatIndex);
        return WATER_TYPES.fromTraits(waterType, heatIndex, false, false, true);
    }

    public static WATER_TYPES pollute(WATER_TYPES waterType) {
        return WATER_TYPES.fromTraits(waterType, waterType.heatIndex, waterType.isRadioactive, true, waterType.isSalty);
    }

    public static WATER_TYPES forcePollute(WATER_TYPES waterType) {
        int heatIndex = waterType.heatIndex == 2 ? 1 : (waterType.heatIndex == -2 ? -1 : waterType.heatIndex);
        return WATER_TYPES.fromTraits(waterType, heatIndex, false, true, false);
    }

    public static WATER_TYPES radiate(WATER_TYPES waterType) {
        return WATER_TYPES.fromTraits(waterType, waterType.heatIndex, true, false, false);
    }

    public static WATER_TYPES getTypeFromFluid(Fluid fluid) {
        switch (fluid.getName()) {
            case "radioactive_frosty_water": {
                return WATER_TYPES.RADIOACTIVE_FROSTY;
            }
            case "frosty_water": {
                return WATER_TYPES.FROSTY;
            }
            case "radioactive_cold_water": {
                return WATER_TYPES.RADIOACTIVE_COLD;
            }
            case "dirty_cold_water": {
                return WATER_TYPES.DIRTY_COLD;
            }
            case "salty_cold_water": {
                return WATER_TYPES.SALTY_COLD;
            }
            case "clean_cold_water": {
                return WATER_TYPES.CLEAN_COLD;
            }
            case "radioactive_water": {
                return WATER_TYPES.RADIOACTIVE;
            }
            case "dirty_water": {
                return WATER_TYPES.DIRTY;
            }
            case "salty_water": {
                return WATER_TYPES.SALTY;
            }
            case "radioactive_warm_water": {
                return WATER_TYPES.RADIOACTIVE_WARM;
            }
            case "dirty_warm_water": {
                return WATER_TYPES.DIRTY_WARM;
            }
            case "salty_warm_water": {
                return WATER_TYPES.SALTY_WARM;
            }
            case "clean_warm_water": {
                return WATER_TYPES.CLEAN_WARM;
            }
            case "radioactive_hot_water": {
                return WATER_TYPES.RADIOACTIVE_HOT;
            }
            case "hot_water": {
                return WATER_TYPES.HOT;
            }
        }
        return WATER_TYPES.CLEAN;
    }

    public static Block getBlockFromType(WATER_TYPES type) {
        Block block;
        switch (type) {
            case RADIOACTIVE_FROSTY: {
                block = ObjectHandler.block_radioactive_frosty_Water;
                break;
            }
            case FROSTY: {
                block = ObjectHandler.block_frosty_Water;
                break;
            }
            case RADIOACTIVE_COLD: {
                block = ObjectHandler.block_radioactive_cold_Water;
                break;
            }
            case DIRTY_COLD: {
                block = ObjectHandler.block_dirty_cold_Water;
                break;
            }
            case SALTY_COLD: {
                block = ObjectHandler.block_salty_cold_Water;
                break;
            }
            case CLEAN_COLD: {
                block = ObjectHandler.block_clean_cold_Water;
                break;
            }
            case RADIOACTIVE: {
                block = ObjectHandler.block_radioactive_Water;
                break;
            }
            case DIRTY: {
                block = ObjectHandler.block_dirty_Water;
                break;
            }
            case SALTY: {
                block = ObjectHandler.block_salty_Water;
                break;
            }
            case RADIOACTIVE_WARM: {
                block = ObjectHandler.block_radioactive_warm_Water;
                break;
            }
            case DIRTY_WARM: {
                block = ObjectHandler.block_dirty_warm_Water;
                break;
            }
            case SALTY_WARM: {
                block = ObjectHandler.block_salty_warm_Water;
                break;
            }
            case CLEAN_WARM: {
                block = ObjectHandler.block_clean_warm_Water;
                break;
            }
            case RADIOACTIVE_HOT: {
                block = ObjectHandler.block_radioactive_hot_Water;
                break;
            }
            case HOT: {
                block = ObjectHandler.block_hot_Water;
                break;
            }
            default: {
                block = Blocks.field_150355_j;
            }
        }
        return block;
    }

    public static WATER_TYPES getTypeFromString(String type) {
        WATER_TYPES wATER_TYPES;
        switch (type) {
            case "RADIOACTIVE_FROSTY": {
                wATER_TYPES = WATER_TYPES.RADIOACTIVE_FROSTY;
                break;
            }
            case "FROSTY": {
                wATER_TYPES = WATER_TYPES.FROSTY;
                break;
            }
            case "RADIOACTIVE_COLD": {
                wATER_TYPES = WATER_TYPES.RADIOACTIVE_COLD;
                break;
            }
            case "DIRTY_COLD": {
                wATER_TYPES = WATER_TYPES.DIRTY_COLD;
                break;
            }
            case "SALTY_COLD": {
                wATER_TYPES = WATER_TYPES.SALTY_COLD;
                break;
            }
            case "CLEAN_COLD": {
                wATER_TYPES = WATER_TYPES.CLEAN_COLD;
                break;
            }
            case "RADIOACTIVE": {
                wATER_TYPES = WATER_TYPES.RADIOACTIVE;
                break;
            }
            case "DIRTY": {
                wATER_TYPES = WATER_TYPES.DIRTY;
                break;
            }
            case "SALTY": {
                wATER_TYPES = WATER_TYPES.SALTY;
                break;
            }
            case "RADIOACTIVE_WARM": {
                wATER_TYPES = WATER_TYPES.RADIOACTIVE_WARM;
                break;
            }
            case "DIRTY_WARM": {
                wATER_TYPES = WATER_TYPES.DIRTY_WARM;
                break;
            }
            case "SALTY_WARM": {
                wATER_TYPES = WATER_TYPES.SALTY_WARM;
                break;
            }
            case "CLEAN_WARM": {
                wATER_TYPES = WATER_TYPES.CLEAN_WARM;
                break;
            }
            case "RADIOACTIVE_HOT": {
                wATER_TYPES = WATER_TYPES.RADIOACTIVE_HOT;
                break;
            }
            case "HOT": {
                wATER_TYPES = WATER_TYPES.HOT;
                break;
            }
            default: {
                wATER_TYPES = WATER_TYPES.CLEAN;
            }
        }
        return wATER_TYPES;
    }

    public static String getStringFromType(WATER_TYPES type) {
        String string;
        switch (type) {
            case RADIOACTIVE_FROSTY: {
                string = "RADIOACTIVE_FROSTY";
                break;
            }
            case FROSTY: {
                string = "FROSTY";
                break;
            }
            case RADIOACTIVE_COLD: {
                string = "RADIOACTIVE_COLD";
                break;
            }
            case DIRTY_COLD: {
                string = "DIRTY_COLD";
                break;
            }
            case SALTY_COLD: {
                string = "SALTY_COLD";
                break;
            }
            case CLEAN_COLD: {
                string = "CLEAN_COLD";
                break;
            }
            case RADIOACTIVE: {
                string = "RADIOACTIVE";
                break;
            }
            case DIRTY: {
                string = "DIRTY";
                break;
            }
            case SALTY: {
                string = "SALTY";
                break;
            }
            case RADIOACTIVE_WARM: {
                string = "RADIOACTIVE_WARM";
                break;
            }
            case DIRTY_WARM: {
                string = "DIRTY_WARM";
                break;
            }
            case SALTY_WARM: {
                string = "SALTY_WARM";
                break;
            }
            case CLEAN_WARM: {
                string = "CLEAN_WARM";
                break;
            }
            case RADIOACTIVE_HOT: {
                string = "RADIOACTIVE_HOT";
                break;
            }
            case HOT: {
                string = "HOT";
                break;
            }
            default: {
                string = "CLEAN";
            }
        }
        return string;
    }

    public static String getStringFromTypeNTMFluid(WATER_TYPES type) {
        String string;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RADIOACTIVE_FROSTY: {
                string = "RADIOACTIVE_FROSTY_WATER";
                break;
            }
            case FROSTY: {
                string = "FROSTY_WATER";
                break;
            }
            case RADIOACTIVE_COLD: {
                string = "RADIOACTIVE_COLD_WATER";
                break;
            }
            case DIRTY_COLD: {
                string = "DIRTY_COLD_WATER";
                break;
            }
            case SALTY_COLD: {
                string = "SALTY_COLD_WATER";
                break;
            }
            case CLEAN_COLD: {
                string = "CLEAN_COLD_WATER";
                break;
            }
            case RADIOACTIVE: {
                string = "RADIOACTIVE_WATER";
                break;
            }
            case DIRTY: {
                string = "DIRTY_WATER";
                break;
            }
            case SALTY: {
                string = "SALTY_WATER";
                break;
            }
            case CLEAN: {
                string = "CLEAN_WATER";
                break;
            }
            case RADIOACTIVE_WARM: {
                string = "RADIOACTIVE_WARM_WATER";
                break;
            }
            case DIRTY_WARM: {
                string = "DIRTY_WARM_WATER";
                break;
            }
            case SALTY_WARM: {
                string = "SALTY_WARM_WATER";
                break;
            }
            case CLEAN_WARM: {
                string = "CLEAN_WARM_WATER";
                break;
            }
            case RADIOACTIVE_HOT: {
                string = "RADIOACTIVE_HOT_WATER";
                break;
            }
            case HOT: {
                string = "HOT_WATER";
            }
        }
        return string;
    }

    public static boolean isWater(Block block, boolean radIncluded) {
        if (block instanceof BlockEnviroMineWater) {
            BlockEnviroMineWater enviroMineWater = (BlockEnviroMineWater)block;
            return radIncluded || !WaterUtils.getTypeFromFluid((Fluid)enviroMineWater.getFluid()).isRadioactive;
        }
        return block == Blocks.field_150355_j || block == Blocks.field_150358_i;
    }

    public static enum WATER_TYPES {
        RADIOACTIVE_FROSTY(-2, true, false, false, EM_Settings.RADIOACTIVE_FROSTY_Hydration, EM_Settings.RADIOACTIVE_FROSTY_TemperatureInfluence, EM_Settings.RADIOACTIVE_FROSTY_TempInfluenceCap),
        FROSTY(-2, false, false, false, EM_Settings.FROSTY_Hydration, EM_Settings.FROSTY_TemperatureInfluence, EM_Settings.FROSTY_TempInfluenceCap),
        RADIOACTIVE_COLD(-1, true, false, false, EM_Settings.RADIOACTIVE_COLD_Hydration, EM_Settings.RADIOACTIVE_COLD_TemperatureInfluence, EM_Settings.RADIOACTIVE_COLD_TempInfluenceCap),
        DIRTY_COLD(-1, false, true, false, EM_Settings.DIRTY_COLD_Hydration, EM_Settings.DIRTY_COLD_TemperatureInfluence, EM_Settings.DIRTY_COLD_TempInfluenceCap),
        SALTY_COLD(-1, false, false, true, EM_Settings.SALTY_COLD_Hydration, EM_Settings.SALTY_COLD_TemperatureInfluence, EM_Settings.SALTY_COLD_TempInfluenceCap),
        CLEAN_COLD(-1, false, false, false, EM_Settings.CLEAN_COLD_Hydration, EM_Settings.CLEAN_COLD_TemperatureInfluence, EM_Settings.CLEAN_COLD_TempInfluenceCap),
        RADIOACTIVE(0, true, false, false, EM_Settings.RADIOACTIVE_Hydration, EM_Settings.RADIOACTIVE_TemperatureInfluence, EM_Settings.RADIOACTIVE_TempInfluenceCap),
        DIRTY(0, false, true, false, EM_Settings.DIRTY_Hydration, EM_Settings.DIRTY_TemperatureInfluence, EM_Settings.DIRTY_TempInfluenceCap),
        SALTY(0, false, false, true, EM_Settings.SALTY_Hydration, EM_Settings.SALTY_TemperatureInfluence, EM_Settings.SALTY_TempInfluenceCap),
        CLEAN(0, false, false, false, EM_Settings.CLEAN_Hydration, EM_Settings.CLEAN_TemperatureInfluence, EM_Settings.CLEAN_TempInfluenceCap),
        RADIOACTIVE_WARM(1, true, false, false, EM_Settings.RADIOACTIVE_WARM_Hydration, EM_Settings.RADIOACTIVE_WARM_TemperatureInfluence, EM_Settings.RADIOACTIVE_WARM_TempInfluenceCap),
        DIRTY_WARM(1, false, true, false, EM_Settings.DIRTY_WARM_Hydration, EM_Settings.DIRTY_WARM_TemperatureInfluence, EM_Settings.DIRTY_WARM_TempInfluenceCap),
        SALTY_WARM(1, false, false, true, EM_Settings.SALTY_WARM_Hydration, EM_Settings.SALTY_WARM_TemperatureInfluence, EM_Settings.SALTY_WARM_TempInfluenceCap),
        CLEAN_WARM(1, false, false, false, EM_Settings.CLEAN_WARM_Hydration, EM_Settings.CLEAN_WARM_TemperatureInfluence, EM_Settings.CLEAN_WARM_TempInfluenceCap),
        RADIOACTIVE_HOT(2, true, false, false, EM_Settings.RADIOACTIVE_HOT_Hydration, EM_Settings.RADIOACTIVE_HOT_TemperatureInfluence, EM_Settings.RADIOACTIVE_HOT_TempInfluenceCap),
        HOT(2, false, false, false, EM_Settings.HOT_Hydration, EM_Settings.HOT_TemperatureInfluence, EM_Settings.HOT_TempInfluenceCap);

        public final int heatIndex;
        public final boolean isRadioactive;
        public final boolean isDirty;
        public final boolean isSalty;
        public final float hydration;
        public final float temperatureInfluence;
        public final float temperatureInfluenceCap;

        private WATER_TYPES(int heatIndex, boolean isRadioactive, boolean isDirty, boolean isSalty, float hydration, float temperatureInfluence, float temperatureInfluenceCap) {
            this.heatIndex = heatIndex;
            this.isRadioactive = isRadioactive;
            this.isDirty = isDirty;
            this.isSalty = isSalty;
            this.hydration = hydration;
            this.temperatureInfluence = temperatureInfluence;
            this.temperatureInfluenceCap = temperatureInfluenceCap;
        }

        public static WATER_TYPES fromTraits(WATER_TYPES waterTypeInitial, int heatIndex, boolean isRadioactive, boolean isDirty, boolean isSalty) {
            for (WATER_TYPES type : WATER_TYPES.values()) {
                if (type.heatIndex != heatIndex || type.isRadioactive != isRadioactive || type.isDirty != isDirty || type.isSalty != isSalty) continue;
                return type;
            }
            return waterTypeInitial;
        }
    }
}

