/*
 * Decompiled with CFR 0.152.
 */
package enviromine.utils;

import enviromine.trackers.properties.ArmorProperties;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class ArmorTempUtils {
    public static boolean getTempResistance(EntityLivingBase entityLiving) {
        return ArmorTempUtils.checkArmorProperty(entityLiving, true);
    }

    public static boolean getTempSealing(EntityLivingBase entityLiving) {
        return ArmorTempUtils.checkArmorProperty(entityLiving, false);
    }

    public static boolean checkArmorPropertyItemStack(ItemStack stack, boolean Resistance) {
        ArmorProperties props = ArmorTempUtils.getArmorProperties(stack);
        if (props != null) {
            if (Resistance) {
                return props.isTemperatureResistance;
            }
            return props.isTemperatureSealed;
        }
        return false;
    }

    private static boolean checkArmorProperty(EntityLivingBase entityLiving, boolean Resistance) {
        ArmorProperties helmetprops = ArmorTempUtils.getArmorProperties(entityLiving, 4);
        ArmorProperties plateprops = ArmorTempUtils.getArmorProperties(entityLiving, 3);
        ArmorProperties legsprops = ArmorTempUtils.getArmorProperties(entityLiving, 2);
        ArmorProperties bootsprops = ArmorTempUtils.getArmorProperties(entityLiving, 1);
        if (helmetprops != null && plateprops != null && legsprops != null && bootsprops != null) {
            if (Resistance) {
                return helmetprops.isTemperatureResistance && plateprops.isTemperatureResistance && legsprops.isTemperatureResistance && bootsprops.isTemperatureResistance;
            }
            return helmetprops.isTemperatureSealed && plateprops.isTemperatureSealed && legsprops.isTemperatureSealed && bootsprops.isTemperatureSealed;
        }
        return false;
    }

    private static ArmorProperties getArmorProperties(EntityLivingBase entityLiving, int slot) {
        ItemStack armor = entityLiving.func_71124_b(slot);
        if (armor != null && ArmorProperties.base.hasProperty(armor)) {
            return ArmorProperties.base.getProperty(armor);
        }
        return null;
    }

    private static ArmorProperties getArmorProperties(ItemStack stack) {
        if (stack != null && ArmorProperties.base.hasProperty(stack)) {
            return ArmorProperties.base.getProperty(stack);
        }
        return null;
    }
}

