/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.items.EnviroItemWaterBottle;
import enviromine.trackers.properties.compat.ItemProperties_NTM;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import enviromine.utils.misc.CompatSafe;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

@CompatSafe
public class ItemProperties
implements SerialisableProperty,
PropertyBase {
    public static final ItemProperties base = new ItemProperties();
    static String[] IPName = new String[14];
    public String name;
    public int meta;
    public boolean enableTemp;
    public float ambTemp;
    public float ambAir;
    public float ambSanity;
    public float effTemp;
    public float effAir;
    public float effSanity;
    public float effHydration;
    public float effTempCap;
    public int camelFill;
    public String fillReturnItem;
    public int fillReturnMeta;
    public String loadedFrom;

    public ItemProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public ItemProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public ItemProperties(String name, int meta, boolean enableTemp, float ambTemp, float ambAir, float ambSanity, float effTemp, float effAir, float effSanity, float effHydration, float effTempCap, int camelFill, String fillReturnItem, int fillReturnMeta, String fileName) {
        this.name = name;
        this.meta = meta;
        this.enableTemp = enableTemp;
        this.ambTemp = ambTemp;
        this.ambAir = ambAir;
        this.ambSanity = ambSanity;
        if (EM_Settings.enableItemPropsDivideByTwo) {
            this.effTemp = effTemp / 2.0f;
            this.effAir = effAir / 2.0f;
            this.effSanity = effSanity / 2.0f;
            this.effHydration = effHydration / 2.0f;
        } else {
            this.effTemp = effTemp;
            this.effAir = effAir;
            this.effSanity = effSanity;
            this.effHydration = effHydration;
        }
        this.effTempCap = effTempCap;
        this.camelFill = camelFill;
        this.fillReturnItem = fillReturnItem;
        this.fillReturnMeta = fillReturnMeta;
        this.loadedFrom = fileName;
    }

    public boolean hasProperty(ItemStack stack) {
        return EM_Settings.itemProperties.containsKey("" + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + "," + stack.func_77960_j()) || EM_Settings.itemProperties.containsKey("" + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
    }

    public ItemProperties getProperty(ItemStack stack) {
        ItemProperties itemProps = EM_Settings.itemProperties.containsKey("" + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + "," + stack.func_77960_j()) ? EM_Settings.itemProperties.get("" + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + "," + stack.func_77960_j()) : EM_Settings.itemProperties.get("" + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        return itemProps;
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("name", this.name);
        tags.func_74757_a("enableTemp", this.enableTemp);
        tags.func_74776_a("ambTemp", this.ambTemp);
        tags.func_74776_a("ambAir", this.ambAir);
        tags.func_74776_a("ambSanity", this.ambSanity);
        tags.func_74776_a("effTemp", this.effTemp);
        tags.func_74776_a("effAir", this.effAir);
        tags.func_74776_a("effHydration", this.effHydration);
        tags.func_74776_a("effTempCap", this.effTempCap);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.name = tags.func_74779_i("name");
        this.enableTemp = tags.func_74767_n("enableTemp");
        this.ambTemp = tags.func_74760_g("ambTemp");
        this.ambAir = tags.func_74760_g("ambAir");
        this.ambSanity = tags.func_74760_g("ambSanity");
        this.effTemp = tags.func_74760_g("effTemp");
        this.effAir = tags.func_74760_g("effAir");
        this.effHydration = tags.func_74760_g("effHydration");
        this.effTempCap = tags.func_74760_g("effTempCap");
    }

    @Override
    public String categoryName() {
        return "items";
    }

    @Override
    public String categoryDescription() {
        return "Custom effects for items";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        String name = config.get(category, IPName[0], "").getString();
        int meta = config.get(category, IPName[1], 0).getInt(0);
        boolean enableTemp = config.get(category, IPName[2], false).getBoolean(false);
        float ambTemp = (float)config.get(category, IPName[3], 0.0).getDouble(0.0);
        float ambAir = (float)config.get(category, IPName[4], 0.0).getDouble(0.0);
        float ambSanity = (float)config.get(category, IPName[5], 0.0).getDouble(0.0);
        float effTemp = (float)config.get(category, IPName[6], 0.0).getDouble(0.0);
        float effAir = (float)config.get(category, IPName[7], 0.0).getDouble(0.0);
        float effSanity = (float)config.get(category, IPName[8], 0.0).getDouble(0.0);
        float effHydration = (float)config.get(category, IPName[9], 0.0).getDouble(0.0);
        float effTempCap = (float)config.get(category, IPName[10], 36.6).getDouble(36.6);
        int camelFill = config.get(category, IPName[11], 0).getInt(0);
        String camelReturnItem = config.get(category, IPName[12], "").getString();
        int camelReturnMeta = config.get(category, IPName[13], 0).getInt(0);
        String filename = config.getConfigFile().getName();
        ItemProperties entry = new ItemProperties(name, meta, enableTemp, ambTemp, ambAir, ambSanity, effTemp, effAir, effSanity, effHydration, effTempCap, camelFill, camelReturnItem, camelReturnMeta, filename);
        if (meta < 0) {
            if (EM_Settings.itemProperties.containsKey("" + name) && !EM_ConfigHandler.loadedConfigs.contains(filename) && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Items - " + name.toUpperCase() + " was already added from " + EM_Settings.itemProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
            }
            EM_Settings.itemProperties.put("" + name, entry);
        } else {
            if (EM_Settings.itemProperties.containsKey("" + name + "," + meta) && !EM_ConfigHandler.loadedConfigs.contains(filename) && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Items - " + name.toUpperCase() + " - Meta:" + meta + " was already added from " + EM_Settings.itemProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
            }
            EM_Settings.itemProperties.put("" + name + "," + meta, entry);
        }
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, IPName[0], this.name).getString();
        config.get(category, IPName[1], this.meta).getInt(this.meta);
        config.get(category, IPName[2], this.enableTemp).getBoolean(this.enableTemp);
        config.get(category, IPName[3], (double)this.ambTemp).getDouble((double)this.ambTemp);
        config.get(category, IPName[4], (double)this.ambAir).getDouble((double)this.ambAir);
        config.get(category, IPName[5], (double)this.ambSanity).getDouble((double)this.ambSanity);
        config.get(category, IPName[6], (double)this.effTemp).getDouble((double)this.effTemp);
        config.get(category, IPName[7], (double)this.effAir).getDouble((double)this.effAir);
        config.get(category, IPName[8], (double)this.effSanity).getDouble((double)this.effSanity);
        config.get(category, IPName[9], (double)this.effHydration).getDouble((double)this.effHydration);
        config.get(category, IPName[10], (double)this.effTempCap).getDouble((double)this.effTempCap);
        config.get(category, IPName[11], this.camelFill).getInt(this.camelFill);
        config.get(category, IPName[12], this.fillReturnItem).getString();
        config.get(category, IPName[13], this.fillReturnMeta).getInt(this.fillReturnMeta);
    }

    @Override
    public void GenDefaults() {
        for (Item item : Item.field_150901_e) {
            String[] regName;
            Block block = Blocks.field_150350_a;
            if (item == null) continue;
            if (item instanceof ItemBlock) {
                block = ((ItemBlock)item).field_150939_a;
            }
            if ((regName = Item.field_150901_e.func_148750_c((Object)item).split(":")).length <= 0) {
                if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) continue;
                EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + item.func_77658_a());
                continue;
            }
            File itemFile = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(regName[0]) + ".cfg");
            if (!itemFile.exists()) {
                try {
                    itemFile.createNewFile();
                }
                catch (Exception e) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) continue;
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for " + item.func_77658_a(), (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(itemFile, true);
            String category = this.categoryName() + "." + EnviroUtils.replaceULN(item.func_77658_a() + "_" + regName[1]);
            config.load();
            if (EnviroMine.isHbmLoaded) {
                try {
                    ItemProperties_NTM.registerItemsNTM(config, category, IPName, item);
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            if (item == Items.field_151069_bo) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], false).getBoolean(false);
                config.get(category, IPName[3], 36.6).getDouble(36.6);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], -25).getInt(-25);
                config.get(category, IPName[12], "minecraft:potion").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (item == Items.field_151068_bn || item instanceof EnviroItemWaterBottle) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                EnviroItemWaterBottle enviroItemWaterBottle;
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], false).getBoolean(false);
                config.get(category, IPName[3], 0.0).getDouble(0.0);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                String string = IPName[6];
                if (item instanceof EnviroItemWaterBottle) {
                    enviroItemWaterBottle = (EnviroItemWaterBottle)item;
                    d6 = enviroItemWaterBottle.getWaterType().temperatureInfluence;
                } else {
                    d6 = -0.1f;
                }
                Property property = config.get(category, string, d6);
                if (item instanceof EnviroItemWaterBottle) {
                    enviroItemWaterBottle = (EnviroItemWaterBottle)item;
                    d5 = enviroItemWaterBottle.getWaterType().temperatureInfluence;
                } else {
                    d5 = -0.1f;
                }
                property.getDouble(d5);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                String string2 = IPName[9];
                if (item instanceof EnviroItemWaterBottle) {
                    enviroItemWaterBottle = (EnviroItemWaterBottle)item;
                    d4 = enviroItemWaterBottle.getWaterType().hydration;
                } else {
                    d4 = 25.0;
                }
                Property property2 = config.get(category, string2, d4);
                if (item instanceof EnviroItemWaterBottle) {
                    enviroItemWaterBottle = (EnviroItemWaterBottle)item;
                    d3 = enviroItemWaterBottle.getWaterType().hydration;
                } else {
                    d3 = 25.0;
                }
                property2.getDouble(d3);
                String string3 = IPName[10];
                if (item instanceof EnviroItemWaterBottle) {
                    enviroItemWaterBottle = (EnviroItemWaterBottle)item;
                    d2 = enviroItemWaterBottle.getWaterType().temperatureInfluenceCap;
                } else {
                    d2 = 36.6f;
                }
                Property property3 = config.get(category, string3, d2);
                if (item instanceof EnviroItemWaterBottle) {
                    enviroItemWaterBottle = (EnviroItemWaterBottle)item;
                    d = enviroItemWaterBottle.getWaterType().temperatureInfluenceCap;
                } else {
                    d = 36.6f;
                }
                property3.getDouble(d);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], item instanceof EnviroItemWaterBottle ? "minecraft:glass_bottle" : "").getString();
                config.get(category, IPName[13], 0).getInt(0);
                if (item == Items.field_151068_bn) {
                    category = category + "_(water)";
                    config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                    config.get(category, IPName[1], 0).getInt(0);
                    config.get(category, IPName[2], false).getBoolean(false);
                    config.get(category, IPName[3], 0.0).getDouble(0.0);
                    config.get(category, IPName[4], 0.0).getDouble(0.0);
                    config.get(category, IPName[5], 0.0).getDouble(0.0);
                    config.get(category, IPName[6], (double)EM_Settings.CLEAN_TemperatureInfluence).getDouble((double)EM_Settings.CLEAN_TemperatureInfluence);
                    config.get(category, IPName[7], 0.0).getDouble(0.0);
                    config.get(category, IPName[8], 0.0).getDouble(0.0);
                    config.get(category, IPName[9], (double)EM_Settings.CLEAN_Hydration).getDouble((double)EM_Settings.CLEAN_Hydration);
                    config.get(category, IPName[10], (double)EM_Settings.CLEAN_TempInfluenceCap).getDouble((double)EM_Settings.CLEAN_TempInfluenceCap);
                    config.get(category, IPName[11], 25).getInt(25);
                    config.get(category, IPName[12], "minecraft:glass_bottle").getString();
                    config.get(category, IPName[13], 0).getInt(0);
                }
            } else if (item == Items.field_151127_ba || item == Items.field_151172_bF || item == Items.field_151034_e) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], false).getBoolean(false);
                config.get(category, IPName[3], 0.0).getDouble(0.0);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], -0.025).getDouble(-0.025);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], item == Items.field_151127_ba ? 15.0 : 5.0).getDouble(item == Items.field_151127_ba ? 15.0 : 5.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (item == Items.field_151009_A) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], false).getBoolean(false);
                config.get(category, IPName[3], 0.0).getDouble(0.0);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], -0.025).getDouble(-0.025);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 10.0).getDouble(10.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (block == Blocks.field_150433_aE || block == Blocks.field_150431_aC) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], true).getBoolean(true);
                config.get(category, IPName[3], -0.1).getDouble(-0.1);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], true).getBoolean(true);
                config.get(category, IPName[3], -0.5).getDouble(-0.5);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (block == Blocks.field_150424_aL || block == Blocks.field_150385_bj || block == Blocks.field_150386_bk || block == Blocks.field_150387_bl) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], true).getBoolean(true);
                config.get(category, IPName[3], 50.0).getDouble(50.0);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (block == Blocks.field_150425_aM || item == Items.field_151144_bL || block == Blocks.field_150465_bP) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], false).getBoolean(false);
                config.get(category, IPName[3], 0.0).getDouble(0.0);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], -1.0).getDouble(-1.0);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if ((block == Blocks.field_150457_bL || block == Blocks.field_150349_c || block instanceof BlockLeavesBase || block instanceof BlockFlower || block instanceof BlockBush || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151582_l) && (regName[0].equals("minecraft") || EM_Settings.genConfigs)) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], false).getBoolean(false);
                config.get(category, IPName[3], 0.0).getDouble(0.0);
                config.get(category, IPName[4], 0.025).getDouble(0.025);
                config.get(category, IPName[5], 0.1).getDouble(0.1);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (item == Items.field_151129_at) {
                config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
                config.get(category, IPName[1], -1).getInt(-1);
                config.get(category, IPName[2], true).getBoolean(true);
                config.get(category, IPName[3], 100.0).getDouble(100.0);
                config.get(category, IPName[4], 0.0).getDouble(0.0);
                config.get(category, IPName[5], 0.0).getDouble(0.0);
                config.get(category, IPName[6], 0.0).getDouble(0.0);
                config.get(category, IPName[7], 0.0).getDouble(0.0);
                config.get(category, IPName[8], 0.0).getDouble(0.0);
                config.get(category, IPName[9], 0.0).getDouble(0.0);
                config.get(category, IPName[10], 36.6).getDouble(36.6);
                config.get(category, IPName[11], 0).getInt(0);
                config.get(category, IPName[12], "").getString();
                config.get(category, IPName[13], 0).getInt(0);
            } else if (EM_Settings.genConfigs) {
                this.generateEmpty(config, item);
            }
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Items.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof Item)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non item object!", (Throwable)new Exception());
            }
            return;
        }
        Item item = (Item)obj;
        String[] regName = Item.field_150901_e.func_148750_c((Object)item).split(":");
        if (regName.length <= 0) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + item.func_77658_a() + "_" + regName[1]);
            }
            return;
        }
        String category = this.categoryName() + "." + EnviroUtils.replaceULN(item.func_77658_a() + "_" + regName[1]);
        config.get(category, IPName[0], Item.field_150901_e.func_148750_c((Object)item)).getString();
        config.get(category, IPName[1], -1).getInt(-1);
        config.get(category, IPName[2], false).getBoolean(false);
        config.get(category, IPName[3], 36.6).getDouble(36.6);
        config.get(category, IPName[4], 0.0).getDouble(0.0);
        config.get(category, IPName[5], 0.0).getDouble(0.0);
        config.get(category, IPName[6], 0.0).getDouble(0.0);
        config.get(category, IPName[7], 0.0).getDouble(0.0);
        config.get(category, IPName[8], 0.0).getDouble(0.0);
        config.get(category, IPName[9], 0.0).getDouble(0.0);
        config.get(category, IPName[10], 36.6).getDouble(36.6);
        config.get(category, IPName[11], 0).getInt(0);
        config.get(category, IPName[12], "").getString();
        config.get(category, IPName[13], 0).getInt(0);
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        ItemProperties.IPName[0] = "01.Name";
        ItemProperties.IPName[1] = "02.Damage";
        ItemProperties.IPName[2] = "03.Enable Ambient Temperature";
        ItemProperties.IPName[3] = "04.Ambient Temperature";
        ItemProperties.IPName[4] = "05.Ambient Air Quality";
        ItemProperties.IPName[5] = "06.Ambient Santity";
        ItemProperties.IPName[6] = "07.Effect Temperature";
        ItemProperties.IPName[7] = "08.Effect Air Quality";
        ItemProperties.IPName[8] = "09.Effect Sanity";
        ItemProperties.IPName[9] = "10.Effect Hydration";
        ItemProperties.IPName[10] = "11.Effect Temperature Cap";
        ItemProperties.IPName[11] = "12.CamelPack Fill Amount";
        ItemProperties.IPName[12] = "13.CamelPack Return Item";
        ItemProperties.IPName[13] = "14.CamelPack Return Meta";
    }
}

