/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import enviromine.utils.ModIdentification;
import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class DimensionProperties
implements SerialisableProperty,
PropertyBase {
    public static final DimensionProperties base = new DimensionProperties();
    static String[] DMName = new String[21];
    public int id;
    public boolean override;
    public boolean trackSanity;
    public boolean darkAffectSanity;
    public float sanityMulti;
    public boolean trackAirQuality;
    public float airMulti;
    public boolean trackHydration;
    public float hydrationMulti;
    public boolean trackTemp;
    public float tempMulti;
    public boolean dayNightTemp;
    public boolean weatherAffectsTemp;
    public boolean mineshaftGen;
    public int sealevel;
    public int mineDepth;
    public float tempRate;
    public float hydrationRate;
    public float sanityRate;
    public float airRate;
    public boolean physics;
    public String loadedFrom;

    public DimensionProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public DimensionProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public DimensionProperties(int id, boolean override, boolean trackSanity, boolean darkAffectSanity, float sanityMulti, boolean trackAirQuality, float airMulti, boolean trackHydration, float hydrationMulti, boolean trackTemp, float tempMulti, boolean dayNightTemp, boolean weatherAffectsTemp, boolean mineshaftGen, int sealevel, int mineDepth, float tempRate, float hydrationRate, float sanityRate, float airRate, boolean physics, String fileName) {
        this.id = id;
        this.override = override;
        this.trackSanity = trackSanity;
        this.darkAffectSanity = darkAffectSanity;
        this.sanityMulti = sanityMulti;
        this.trackAirQuality = trackAirQuality;
        this.airMulti = airMulti;
        this.trackHydration = trackHydration;
        this.hydrationMulti = hydrationMulti;
        this.trackTemp = trackTemp;
        this.tempMulti = tempMulti;
        this.dayNightTemp = dayNightTemp;
        this.weatherAffectsTemp = weatherAffectsTemp;
        this.mineshaftGen = mineshaftGen;
        this.sealevel = sealevel;
        this.mineDepth = mineDepth;
        this.tempRate = tempRate;
        this.hydrationRate = hydrationRate;
        this.sanityRate = sanityRate;
        this.airRate = airRate;
        this.physics = physics;
        this.loadedFrom = fileName;
    }

    public boolean hasProperty(int dimensionId) {
        return EM_Settings.dimensionProperties.containsKey(dimensionId);
    }

    public DimensionProperties getProperty(int dimensionId) {
        return EM_Settings.dimensionProperties.get(dimensionId);
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("id", this.id);
        tags.func_74757_a("override", this.override);
        tags.func_74757_a("trackSanity", this.trackSanity);
        tags.func_74757_a("darkAffectSanity", this.darkAffectSanity);
        tags.func_74776_a("sanityMulti", this.sanityMulti);
        tags.func_74757_a("trackAirQuality", this.trackAirQuality);
        tags.func_74776_a("airMulti", this.airMulti);
        tags.func_74757_a("trackHydration", this.trackHydration);
        tags.func_74776_a("hydrationMulti", this.hydrationMulti);
        tags.func_74757_a("trackTemp", this.trackTemp);
        tags.func_74776_a("tempMulti", this.tempMulti);
        tags.func_74757_a("weatherAffectsTemp", this.weatherAffectsTemp);
        tags.func_74757_a("mineshaftGen", this.mineshaftGen);
        tags.func_74768_a("sealevel", this.sealevel);
        tags.func_74768_a("mineDepth", this.mineDepth);
        tags.func_74776_a("tempRate", this.tempRate);
        tags.func_74776_a("hydrationRate", this.hydrationRate);
        tags.func_74776_a("sanityRate", this.sanityRate);
        tags.func_74776_a("airRate", this.airRate);
        tags.func_74757_a("physics", this.physics);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.id = tags.func_74762_e("id");
        this.override = tags.func_74767_n("override");
        this.trackSanity = tags.func_74767_n("trackSanity");
        this.darkAffectSanity = tags.func_74767_n("darkAffectSanity");
        this.sanityMulti = tags.func_74760_g("sanityMulti");
        this.trackAirQuality = tags.func_74767_n("trackAirQuality");
        this.airMulti = tags.func_74760_g("airMulti");
        this.trackHydration = tags.func_74767_n("trackHydration");
        this.hydrationMulti = tags.func_74760_g("hydrationMulti");
        this.trackTemp = tags.func_74767_n("trackTemp");
        this.tempMulti = tags.func_74760_g("tempMulti");
        this.weatherAffectsTemp = tags.func_74767_n("weatherAffectsTemp");
        this.mineshaftGen = tags.func_74767_n("mineshaftGen");
        this.sealevel = tags.func_74762_e("sealevel");
        this.mineDepth = tags.func_74762_e("mineDepth");
        this.tempRate = tags.func_74760_g("tempRate");
        this.hydrationRate = tags.func_74760_g("hydrationRate");
        this.sanityRate = tags.func_74760_g("sanityRate");
        this.airRate = tags.func_74760_g("airRate");
        this.physics = tags.func_74767_n("physics");
    }

    @Override
    public String categoryName() {
        return "dimension";
    }

    @Override
    public String categoryDescription() {
        return "Customise dimension environments";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        int id = config.get(category, DMName[0], 0).getInt(0);
        boolean override = config.get(category, DMName[1], false).getBoolean(false);
        boolean trackSanity = config.get(category, DMName[2], true).getBoolean(true);
        boolean darkAffectSanity = config.get(category, DMName[3], true).getBoolean(true);
        float sanityMulti = (float)config.get(category, DMName[4], 1.0).getDouble(1.0);
        boolean trackAirQuality = config.get(category, DMName[5], true).getBoolean(true);
        float airMulti = (float)config.get(category, DMName[6], 1.0).getDouble(1.0);
        boolean trackHydration = config.get(category, DMName[7], true).getBoolean(true);
        float hydrationMulti = (float)config.get(category, DMName[8], 1.0).getDouble(1.0);
        boolean trackTemp = config.get(category, DMName[9], true).getBoolean(true);
        float tempMulti = (float)config.get(category, DMName[10], 1.0).getDouble(1.0);
        boolean dayNightTemp = config.get(category, DMName[11], true).getBoolean(true);
        boolean weatherAffectsTemp = config.get(category, DMName[12], true).getBoolean(true);
        boolean mineshaftGen = config.get(category, DMName[13], true).getBoolean(true);
        int sealevel = config.get(category, DMName[14], 65).getInt(65);
        int mineDepth = config.getInt(DMName[15], category, 12, -255, 255, "Use a negitive value to skip shaft entrance checks");
        float tempRate = (float)config.get(category, DMName[16], 0.0).getDouble(0.0);
        float hydrationRate = (float)config.get(category, DMName[17], 0.0).getDouble(0.0);
        float sanityRate = (float)config.get(category, DMName[18], 0.0).getDouble(0.0);
        float airRate = (float)config.get(category, DMName[19], 0.0).getDouble(0.0);
        boolean physics = config.get(category, DMName[20], true).getBoolean(true);
        String filename = config.getConfigFile().getName();
        DimensionProperties entry = new DimensionProperties(id, override, trackSanity, darkAffectSanity, sanityMulti, trackAirQuality, airMulti, trackHydration, hydrationMulti, trackTemp, tempMulti, dayNightTemp, weatherAffectsTemp, mineshaftGen, sealevel, mineDepth, tempRate, hydrationRate, sanityRate, airRate, physics, filename);
        if (EM_Settings.dimensionProperties.containsKey(id) && !EM_ConfigHandler.loadedConfigs.contains(filename) && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Dimension ID " + id + " was already added from " + EM_Settings.dimensionProperties.get((Object)Integer.valueOf((int)id)).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
        }
        EM_Settings.dimensionProperties.put(id, entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, DMName[0], this.id).getInt(this.id);
        config.get(category, DMName[1], this.override).getBoolean(this.override);
        config.get(category, DMName[2], this.trackSanity).getBoolean(this.trackSanity);
        config.get(category, DMName[3], this.darkAffectSanity).getBoolean(this.darkAffectSanity);
        config.get(category, DMName[4], (double)this.sanityMulti).getDouble((double)this.sanityMulti);
        config.get(category, DMName[5], this.trackAirQuality).getBoolean(this.trackAirQuality);
        config.get(category, DMName[6], (double)this.airMulti).getDouble((double)this.airMulti);
        config.get(category, DMName[7], this.trackHydration).getBoolean(this.trackHydration);
        config.get(category, DMName[8], (double)this.hydrationMulti).getDouble((double)this.hydrationMulti);
        config.get(category, DMName[9], this.trackTemp).getBoolean(this.trackTemp);
        config.get(category, DMName[10], (double)this.tempMulti).getDouble((double)this.tempMulti);
        config.get(category, DMName[11], this.dayNightTemp).getBoolean(this.dayNightTemp);
        config.get(category, DMName[12], this.weatherAffectsTemp).getBoolean(this.weatherAffectsTemp);
        config.get(category, DMName[13], this.mineshaftGen).getBoolean(this.mineshaftGen);
        config.get(category, DMName[14], this.sealevel).getInt(this.sealevel);
        config.getInt(DMName[15], category, this.mineDepth, -255, 255, "Use a negitive value to skip shaft entrance checks");
        config.get(category, DMName[16], 0.0).getDouble(0.0);
        config.get(category, DMName[17], 0.0).getDouble(0.0);
        config.get(category, DMName[18], 0.0).getDouble(0.0);
        config.get(category, DMName[19], 0.0).getDouble(0.0);
        config.get(category, DMName[20], this.physics).getBoolean(this.physics);
    }

    @Override
    public void GenDefaults() {
        Integer[] dimIDs = DimensionManager.getStaticDimensionIDs();
        for (int i = 0; i < dimIDs.length; ++i) {
            WorldProvider dimension = WorldProvider.func_76570_a((int)dimIDs[i]);
            if (dimension == null) continue;
            String modID = ModIdentification.idFromObject(dimension);
            File file = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(modID) + ".cfg");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) continue;
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for dimension '" + dimension.func_80007_l() + "'", (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(file, true);
            config.load();
            String catName = this.categoryName() + "." + EnviroUtils.replaceULN(dimension.func_80007_l());
            if (dimension.field_76574_g == EM_Settings.caveDimID) {
                config.get(catName, DMName[0], dimension.field_76574_g).getInt(dimension.field_76574_g);
                config.get(catName, DMName[1], true).getBoolean(true);
                config.get(catName, DMName[2], true).getBoolean(true);
                config.get(catName, DMName[3], true).getBoolean(true);
                config.get(catName, DMName[4], 1.0).getDouble(1.0);
                config.get(catName, DMName[5], true).getBoolean(true);
                config.get(catName, DMName[6], 1.0).getDouble(1.0);
                config.get(catName, DMName[7], true).getBoolean(true);
                config.get(catName, DMName[8], 1.0).getDouble(1.0);
                config.get(catName, DMName[9], true).getBoolean(true);
                config.get(catName, DMName[10], 1.0).getDouble(1.0);
                config.get(catName, DMName[11], true).getBoolean(true);
                config.get(catName, DMName[12], true).getBoolean(true);
                config.get(catName, DMName[13], true).getBoolean(true);
                config.get(catName, DMName[14], 340).getInt(340);
                config.getInt(DMName[15], catName, -192, -255, 255, "Use a negitive value to skip shaft entrance checks");
                config.get(catName, DMName[16], 0.0).getDouble(0.0);
                config.get(catName, DMName[17], 0.0).getDouble(0.0);
                config.get(catName, DMName[18], 0.0).getDouble(0.0);
                config.get(catName, DMName[19], 0.0).getDouble(0.0);
                config.get(catName, DMName[20], true).getBoolean(true);
            } else if (dimension.field_76574_g == -1) {
                config.get(catName, DMName[0], dimension.field_76574_g).getInt(dimension.field_76574_g);
                config.get(catName, DMName[1], true).getBoolean(true);
                config.get(catName, DMName[2], true).getBoolean(true);
                config.get(catName, DMName[3], true).getBoolean(true);
                config.get(catName, DMName[4], 1.0).getDouble(1.0);
                config.get(catName, DMName[5], true).getBoolean(true);
                config.get(catName, DMName[6], 1.0).getDouble(1.0);
                config.get(catName, DMName[7], true).getBoolean(true);
                config.get(catName, DMName[8], 1.0).getDouble(1.0);
                config.get(catName, DMName[9], true).getBoolean(true);
                config.get(catName, DMName[10], 1.0).getDouble(1.0);
                config.get(catName, DMName[11], true).getBoolean(true);
                config.get(catName, DMName[12], true).getBoolean(true);
                config.get(catName, DMName[13], false).getBoolean(false);
                config.get(catName, DMName[14], 340).getInt(340);
                config.getInt(DMName[15], catName, -192, -255, 255, "Use a negitive value to skip shaft entrance checks");
                config.get(catName, DMName[16], 0.0).getDouble(0.0);
                config.get(catName, DMName[17], 0.0).getDouble(0.0);
                config.get(catName, DMName[18], 0.0).getDouble(0.0);
                config.get(catName, DMName[19], 0.0).getDouble(0.0);
                config.get(catName, DMName[20], true).getBoolean(true);
            } else if (EM_Settings.genConfigs || modID.equals("minecraft")) {
                this.generateEmpty(config, dimension);
            }
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Dimensions.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof WorldProvider)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non WorldProvider object!", (Throwable)new Exception());
            }
            return;
        }
        WorldProvider dimension = (WorldProvider)obj;
        String catName = this.categoryName() + "." + EnviroUtils.replaceULN(dimension.func_80007_l());
        config.get(catName, DMName[0], dimension.field_76574_g).getInt(dimension.field_76574_g);
        config.get(catName, DMName[1], true).getBoolean(true);
        config.get(catName, DMName[2], true).getBoolean(true);
        config.get(catName, DMName[3], true).getBoolean(true);
        config.get(catName, DMName[4], 1.0).getDouble(1.0);
        config.get(catName, DMName[5], true).getBoolean(true);
        config.get(catName, DMName[6], 1.0).getDouble(1.0);
        config.get(catName, DMName[7], true).getBoolean(true);
        config.get(catName, DMName[8], 1.0).getDouble(1.0);
        config.get(catName, DMName[9], true).getBoolean(true);
        config.get(catName, DMName[10], 1.0).getDouble(1.0);
        config.get(catName, DMName[11], !dimension.field_76576_e).getBoolean(!dimension.field_76576_e);
        config.get(catName, DMName[12], !dimension.field_76576_e).getBoolean(!dimension.field_76576_e);
        config.get(catName, DMName[13], !dimension.field_76576_e).getBoolean(!dimension.field_76576_e);
        config.get(catName, DMName[14], dimension.field_76576_e ? 340 : 64).getInt(dimension.field_76576_e ? 340 : 64);
        config.getInt(DMName[15], catName, 12, -255, 255, "Use a negitive value to skip shaft entrance checks");
        config.get(catName, DMName[16], 0.0).getDouble(0.0);
        config.get(catName, DMName[17], 0.0).getDouble(0.0);
        config.get(catName, DMName[18], 0.0).getDouble(0.0);
        config.get(catName, DMName[19], 0.0).getDouble(0.0);
        config.get(catName, DMName[20], true).getBoolean(true);
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        DimensionProperties.DMName[0] = "01.Dimension ID";
        DimensionProperties.DMName[1] = "02.Allow Config Override";
        DimensionProperties.DMName[2] = "03.Track Sanity";
        DimensionProperties.DMName[3] = "04.Dark Affects Sanity";
        DimensionProperties.DMName[4] = "05.Sanity Multiplier";
        DimensionProperties.DMName[5] = "06.Track Air Quility";
        DimensionProperties.DMName[6] = "07.Air Quility Multiplier";
        DimensionProperties.DMName[7] = "08.Track Hydration";
        DimensionProperties.DMName[8] = "09.Hydration Multiplier";
        DimensionProperties.DMName[9] = "10.Track Temperature";
        DimensionProperties.DMName[10] = "11.Temperature Multiplier";
        DimensionProperties.DMName[11] = "12.Day/Night Affects Temp";
        DimensionProperties.DMName[12] = "13.Weather Affects Temp";
        DimensionProperties.DMName[13] = "14.Generate Mineshafts";
        DimensionProperties.DMName[14] = "15.Where is Sea Level";
        DimensionProperties.DMName[15] = "16.Mine Y height";
        DimensionProperties.DMName[16] = "17.Base Temperature Rate";
        DimensionProperties.DMName[17] = "18.Base Hydration Rate";
        DimensionProperties.DMName[18] = "19.Base Sanity Rate";
        DimensionProperties.DMName[19] = "20.Base Air Quality Rate";
        DimensionProperties.DMName[20] = "20.Enable Physics";
    }
}

