/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.PropertyBase;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class CaveBaseProperties
implements PropertyBase {
    public static final CaveBaseProperties base = new CaveBaseProperties();
    static String[] CBName;
    public static Block caveStone_block;
    public static byte caveStone_meta;
    public static Block caveGravel_block;
    public static byte caveGravel_meta;
    public static Block caveDirt_block;
    public static byte caveDirt_meta;

    public CaveBaseProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String categoryName() {
        return "Main";
    }

    @Override
    public String categoryDescription() {
        return "The main options for the cave dimension";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
    }

    @Override
    public void GenDefaults() {
        File file = this.GetDefaultFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for StabilityTypes", (Throwable)e);
                }
                return;
            }
        }
        Configuration config = new Configuration(file, true);
        String catName = this.categoryName();
        config.load();
        config.get(catName, CBName[0], -2).getInt(-2);
        config.get(catName, CBName[1], true).getBoolean(true);
        config.get(catName, CBName[2], false, "Makes the dimension more volcanic").getBoolean(false);
        config.get(catName, CBName[3], 30).getInt(30);
        config.get(catName, CBName[4], 7).getInt(7);
        config.get(catName, CBName[5], 8).getInt(8);
        config.get(catName, CBName[6], 23).getInt(23);
        config.get(catName, CBName[7], false).getBoolean(false);
        config.get(catName, CBName[8], 10).getInt(10);
        config.getInt(CBName[9], catName, 32, 0, 255, "Height at which water/lava generates");
        config.get(catName, CBName[10], true).getBoolean(true);
        config.get(catName, CBName[11], false).getBoolean(false);
        config.get(catName, CBName[12], false).getBoolean(false);
        config.get(catName, CBName[13], "minecraft:stone", "The main block used to populate the Cave dimension. Use the form mod:blockname:meta or mod:blockname").getString().trim();
        config.get(catName, CBName[14], "minecraft:gravel", "A block used to populate the Cave dimension. Use the form mod:blockname:meta or mod:blockname").getString().trim();
        config.get(catName, CBName[15], "minecraft:dirt", "A block used to populate the Cave dimension. Use the form mod:blockname:meta or mod:blockname").getString().trim();
        config.save();
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.configPath + "CaveDimension.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
    }

    @Override
    public boolean useCustomConfigs() {
        return false;
    }

    @Override
    public void customLoad() {
        int i;
        File file = this.GetDefaultFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for StabilityTypes", (Throwable)e);
                }
                return;
            }
        }
        Configuration config = new Configuration(file, true);
        String catName = this.categoryName();
        config.load();
        EM_Settings.caveDimID = config.get(catName, CBName[0], -2).getInt(-2);
        EM_Settings.caveOreEvent = config.get(catName, CBName[1], true).getBoolean(true);
        EM_Settings.caveLava = config.get(catName, CBName[2], false, "Makes the dimension more volcanic").getBoolean(false);
        EM_Settings.caveRavineRarity = config.get(catName, CBName[3], 30).getInt(30);
        EM_Settings.caveTunnelRarity = config.get(catName, CBName[4], 7).getInt(7);
        EM_Settings.caveDungeons = config.get(catName, CBName[5], 8).getInt(8);
        EM_Settings.caveBiomeID = config.get(catName, CBName[6], 23).getInt(23);
        EM_Settings.disableCaves = config.get(catName, CBName[7], false).getBoolean(false);
        EM_Settings.limitElevatorY = config.get(catName, CBName[8], 10).getInt(10);
        EM_Settings.caveLiquidY = config.getInt(CBName[9], catName, 32, 0, 255, "Height at which water/lava generates");
        EM_Settings.caveFlood = config.get(catName, CBName[10], true).getBoolean(true);
        EM_Settings.caveRespawn = config.get(catName, CBName[11], false).getBoolean(false);
        EM_Settings.enforceWeights = config.get(catName, CBName[12], false, "If set to true EnviroMine will try to strictly enforce the configured spawn weights regardless of spawn method. Has some side effects!").getBoolean(false);
        String caveStoneRaw = config.get(catName, CBName[13], "minecraft:stone", "The main block used to populate the Cave dimension. Use the form mod:blockname:meta or mod:blockname").getString().trim();
        String caveGravelRaw = config.get(catName, CBName[14], "minecraft:gravel", "A block used to populate the Cave dimension. Use the form mod:blockname:meta or mod:blockname").getString().trim();
        String caveDirtRaw = config.get(catName, CBName[15], "minecraft:dirt", "A block used to populate the Cave dimension. Use the form mod:blockname:meta or mod:blockname").getString().trim();
        String[] caveBlockSplit = new String[]{"minecraft", "stone", "0"};
        String[] caveBlockSplitTemp = caveStoneRaw.split(":");
        for (i = 0; i < caveBlockSplitTemp.length; ++i) {
            caveBlockSplit[i] = caveBlockSplitTemp[i];
        }
        Block tempBlock = Block.func_149684_b((String)(caveBlockSplit[0] + ":" + caveBlockSplit[1]));
        if (tempBlock != null) {
            caveStone_block = tempBlock;
            if (caveBlockSplitTemp.length > 2) {
                try {
                    caveStone_meta = Byte.parseByte(caveBlockSplitTemp[2]);
                }
                catch (NumberFormatException e) {
                    caveStone_meta = 0;
                }
            }
        } else {
            caveStone_block = Blocks.field_150348_b;
            caveStone_meta = 0;
        }
        caveBlockSplit = new String[]{"minecraft", "gravel", "0"};
        caveBlockSplitTemp = caveGravelRaw.split(":");
        for (i = 0; i < caveBlockSplitTemp.length; ++i) {
            caveBlockSplit[i] = caveBlockSplitTemp[i];
        }
        tempBlock = Block.func_149684_b((String)(caveBlockSplit[0] + ":" + caveBlockSplit[1]));
        if (tempBlock != null) {
            caveGravel_block = tempBlock;
            if (caveBlockSplitTemp.length > 2) {
                try {
                    caveGravel_meta = Byte.parseByte(caveBlockSplitTemp[2]);
                }
                catch (NumberFormatException e) {
                    caveGravel_meta = 0;
                }
            }
        } else {
            caveGravel_block = Blocks.field_150351_n;
            caveGravel_meta = 0;
        }
        caveBlockSplit = new String[]{"minecraft", "dirt", "0"};
        caveBlockSplitTemp = caveDirtRaw.split(":");
        for (int i2 = 0; i2 < caveBlockSplitTemp.length; ++i2) {
            caveBlockSplit[i2] = caveBlockSplitTemp[i2];
        }
        tempBlock = Block.func_149684_b((String)(caveBlockSplit[0] + ":" + caveBlockSplit[1]));
        if (tempBlock != null) {
            caveDirt_block = tempBlock;
            if (caveBlockSplitTemp.length > 2) {
                try {
                    caveDirt_meta = Byte.parseByte(caveBlockSplitTemp[2]);
                }
                catch (NumberFormatException e) {
                    caveDirt_meta = 0;
                }
            }
        } else {
            caveDirt_block = Blocks.field_150346_d;
            caveDirt_meta = 0;
        }
        config.save();
    }

    static {
        caveStone_block = Blocks.field_150348_b;
        caveStone_meta = 0;
        caveGravel_block = Blocks.field_150351_n;
        caveGravel_meta = 0;
        caveDirt_block = Blocks.field_150346_d;
        caveDirt_meta = 0;
        CBName = new String[16];
        CaveBaseProperties.CBName[0] = "Dimension ID";
        CaveBaseProperties.CBName[1] = "Fire OreGen event";
        CaveBaseProperties.CBName[2] = "Lava instead of Water";
        CaveBaseProperties.CBName[3] = "Ravine Rarity";
        CaveBaseProperties.CBName[4] = "Small Cave Rarity";
        CaveBaseProperties.CBName[5] = "Dungeons";
        CaveBaseProperties.CBName[6] = "Cave Biome ID";
        CaveBaseProperties.CBName[7] = "Disable Elevator Access";
        CaveBaseProperties.CBName[8] = "Elevator Height Limit";
        CaveBaseProperties.CBName[9] = "Water/Lava Height";
        CaveBaseProperties.CBName[10] = "Flood Side Caves";
        CaveBaseProperties.CBName[11] = "Can Respawn in Caves";
        CaveBaseProperties.CBName[12] = "Enforce Spawn Weights";
        CaveBaseProperties.CBName[13] = "Cave Dimension Block: Main";
        CaveBaseProperties.CBName[14] = "Cave Dimension Block: Scattered 1";
        CaveBaseProperties.CBName[15] = "Cave Dimension Block: Scattered 2";
    }
}

