/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers.properties;

import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.compat.ArmorProperties_NTM;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import enviromine.utils.EnviroUtils;
import enviromine.utils.misc.CompatSafe;
import java.io.File;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

@CompatSafe
public class ArmorProperties
implements SerialisableProperty,
PropertyBase {
    public static final ArmorProperties base = new ArmorProperties();
    static String[] APName = new String[12];
    public Item item;
    public String name;
    public float nightTemp;
    public float shadeTemp;
    public float sunTemp;
    public float nightMult;
    public float shadeMult;
    public float sunMult;
    public float sanity;
    public float air;
    public boolean allowCamelPack;
    public String loadedFrom;
    public boolean isTemperatureResistance;
    public boolean isTemperatureSealed;

    public ArmorProperties(NBTTagCompound tags) {
        this.ReadFromNBT(tags);
    }

    public ArmorProperties() {
        if (base != null && base != this) {
            throw new IllegalStateException();
        }
    }

    public ArmorProperties(Item item, String name, float nightTemp, float shadeTemp, float sunTemp, float nightMult, float shadeMult, float sunMult, float sanity, float air, boolean allowCamelPack, String filename, boolean isTemperatureResistance, boolean isTemperatureSealed) {
        this.item = item;
        this.name = name;
        this.nightTemp = nightTemp;
        this.shadeTemp = shadeTemp;
        this.sunTemp = sunTemp;
        this.nightMult = nightMult;
        this.shadeMult = shadeMult;
        this.sunMult = sunMult;
        this.sanity = sanity;
        this.air = air;
        this.allowCamelPack = allowCamelPack;
        this.isTemperatureResistance = isTemperatureResistance;
        this.isTemperatureSealed = isTemperatureSealed;
        this.loadedFrom = filename;
    }

    public boolean hasProperty(ItemStack stack) {
        return EM_Settings.armorProperties.containsKey(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
    }

    public ArmorProperties getProperty(ItemStack stack) {
        return EM_Settings.armorProperties.get(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
    }

    @Override
    public NBTTagCompound WriteToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("name", Item.field_150901_e.func_148750_c((Object)this.item));
        tags.func_74776_a("nightTemp", this.nightTemp);
        tags.func_74776_a("shadeTemp", this.shadeTemp);
        tags.func_74776_a("sunTemp", this.sunTemp);
        tags.func_74776_a("nightMult", this.nightMult);
        tags.func_74776_a("shadeMult", this.shadeMult);
        tags.func_74776_a("sunMult", this.sunMult);
        tags.func_74776_a("sanity", this.sanity);
        tags.func_74776_a("air", this.air);
        tags.func_74757_a("allowCamelPack", this.allowCamelPack);
        tags.func_74757_a("isTemperatureResistance", this.isTemperatureResistance);
        tags.func_74757_a("isTemperatureSealed", this.isTemperatureSealed);
        return tags;
    }

    @Override
    public void ReadFromNBT(NBTTagCompound tags) {
        this.name = tags.func_74779_i("name");
        this.item = (Item)Item.field_150901_e.func_82594_a(this.name);
        this.nightTemp = tags.func_74760_g("nightTemp");
        this.shadeTemp = tags.func_74760_g("shadeTemp");
        this.sunTemp = tags.func_74760_g("sunTemp");
        this.nightMult = tags.func_74760_g("nightMult");
        this.shadeMult = tags.func_74760_g("shadeMult");
        this.sunMult = tags.func_74760_g("sunMult");
        this.sanity = tags.func_74760_g("sanity");
        this.air = tags.func_74760_g("air");
        this.allowCamelPack = tags.func_74767_n("allowCamelPack");
        this.isTemperatureResistance = tags.func_74767_n("isTemperatureResistance");
        this.isTemperatureSealed = tags.func_74767_n("isTemperatureSealed");
    }

    @Override
    public String categoryName() {
        return "armor";
    }

    @Override
    public String categoryDescription() {
        return "Modify the effects armor has on entities when worn";
    }

    @Override
    public void LoadProperty(Configuration config, String category) {
        config.setCategoryComment(this.categoryName(), this.categoryDescription());
        String name = config.get(category, APName[0], "").getString();
        float nightTemp = (float)config.get(category, APName[1], 0.0).getDouble(0.0);
        float shadeTemp = (float)config.get(category, APName[2], 0.0).getDouble(0.0);
        float sunTemp = (float)config.get(category, APName[3], 0.0).getDouble(0.0);
        float nightMult = (float)config.get(category, APName[4], 1.0).getDouble(1.0);
        float shadeMult = (float)config.get(category, APName[5], 1.0).getDouble(1.0);
        float sunMult = (float)config.get(category, APName[6], 1.0).getDouble(1.0);
        float sanity = (float)config.get(category, APName[7], 0.0).getDouble(0.0);
        float air = (float)config.get(category, APName[8], 0.0).getDouble(0.0);
        String filename = config.getConfigFile().getName();
        Object item = Item.field_150901_e.func_82594_a(name);
        boolean allowCamelPack = true;
        if (item instanceof ItemArmor && ((ItemArmor)item).field_77881_a == 1) {
            allowCamelPack = config.get(category, APName[9], true).getBoolean(true);
        }
        boolean isTemperatureResistance = config.get(category, APName[10], false).getBoolean(false);
        boolean isTemperatureSealed = config.get(category, APName[11], false).getBoolean(false);
        ArmorProperties entry = new ArmorProperties((Item)item, name, nightTemp, shadeTemp, sunTemp, nightMult, shadeMult, sunMult, sanity, air, allowCamelPack, filename, isTemperatureResistance, isTemperatureSealed);
        if (EM_Settings.armorProperties.containsKey(name) && !EM_ConfigHandler.loadedConfigs.contains(filename) && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "CONFIG DUPLICATE: Armor - " + name.toUpperCase() + " was already added from " + EM_Settings.armorProperties.get((Object)name).loadedFrom.toUpperCase() + " and will be overriden by " + filename.toUpperCase());
        }
        EM_Settings.armorProperties.put(name, entry);
    }

    @Override
    public void SaveProperty(Configuration config, String category) {
        config.get(category, APName[0], this.name).getString();
        config.get(category, APName[1], (double)this.nightTemp).getDouble((double)this.nightTemp);
        config.get(category, APName[2], (double)this.shadeTemp).getDouble((double)this.shadeTemp);
        config.get(category, APName[3], (double)this.sunTemp).getDouble((double)this.sunTemp);
        config.get(category, APName[4], (double)this.nightMult).getDouble((double)this.nightMult);
        config.get(category, APName[5], (double)this.shadeMult).getDouble((double)this.shadeMult);
        config.get(category, APName[6], (double)this.sunMult).getDouble((double)this.sunMult);
        config.get(category, APName[7], (double)this.sanity).getDouble((double)this.sanity);
        config.get(category, APName[8], (double)this.air).getDouble((double)this.air);
        config.get(category, APName[10], this.isTemperatureResistance).getBoolean(this.isTemperatureResistance);
        config.get(category, APName[11], this.isTemperatureSealed).getBoolean(this.isTemperatureSealed);
    }

    @Override
    public void GenDefaults() {
        for (Item regItem : Item.field_150901_e) {
            if (!(regItem instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)regItem;
            String[] regName = Item.field_150901_e.func_148750_c((Object)armor).split(":");
            if (regName.length <= 0) {
                if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) continue;
                EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + armor.func_77658_a());
                continue;
            }
            File armorFile = new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + EnviroUtils.SafeFilename(regName[0]) + ".cfg");
            if (!armorFile.exists()) {
                try {
                    armorFile.createNewFile();
                }
                catch (Exception e) {
                    if (EM_Settings.loggerVerbosity < EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) continue;
                    EnviroMine.logger.log(Level.ERROR, "Failed to create file for " + armor.func_77658_a(), (Throwable)e);
                    continue;
                }
            }
            Configuration config = new Configuration(armorFile, true);
            config.load();
            String catName = this.categoryName() + "." + EnviroUtils.replaceULN(armor.func_77658_a() + "_" + regName[1]);
            if (EnviroMine.isHbmLoaded) {
                try {
                    ArmorProperties_NTM.registerArmorNTM(config, catName, APName, armor);
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            if (armor == Items.field_151161_ac || armor == Items.field_151163_ad || armor == Items.field_151173_ae || armor == Items.field_151175_af || armor.func_82812_d() == ItemArmor.ArmorMaterial.DIAMOND && EM_Settings.genConfigs) {
                config.get(catName, APName[0], Item.field_150901_e.func_148750_c((Object)armor)).getString();
                config.get(catName, APName[1], 0.0).getDouble(0.0);
                config.get(catName, APName[2], 0.0).getDouble(0.0);
                config.get(catName, APName[3], 0.0).getDouble(0.0);
                config.get(catName, APName[4], 1.0).getDouble(1.0);
                config.get(catName, APName[5], 1.0).getDouble(1.0);
                config.get(catName, APName[6], 0.9).getDouble(0.9);
                config.get(catName, APName[7], 0.0).getDouble(0.0);
                config.get(catName, APName[8], 0.0).getDouble(0.0);
                config.get(catName, APName[10], false).getBoolean(false);
                config.get(catName, APName[11], false).getBoolean(false);
                if (armor.field_77881_a == 1) {
                    config.get(catName, APName[9], true).getBoolean(true);
                }
            } else if (armor == Items.field_151028_Y || armor == Items.field_151030_Z || armor == Items.field_151165_aa || armor == Items.field_151167_ab || armor.func_82812_d() == ItemArmor.ArmorMaterial.IRON && EM_Settings.genConfigs) {
                config.get(catName, APName[0], Item.field_150901_e.func_148750_c((Object)armor)).getString();
                config.get(catName, APName[1], -1.0).getDouble(-1.0);
                config.get(catName, APName[2], 0.0).getDouble(0.0);
                config.get(catName, APName[3], 2.0).getDouble(2.0);
                config.get(catName, APName[4], 1.0).getDouble(1.0);
                config.get(catName, APName[5], 1.0).getDouble(1.0);
                config.get(catName, APName[6], 1.1).getDouble(1.1);
                config.get(catName, APName[7], 0.0).getDouble(0.0);
                config.get(catName, APName[8], 0.0).getDouble(0.0);
                config.get(catName, APName[10], false).getBoolean(false);
                config.get(catName, APName[11], false).getBoolean(false);
                if (armor.field_77881_a == 1) {
                    config.get(catName, APName[9], true).getBoolean(true);
                }
            } else if (armor == Items.field_151169_ag || armor == Items.field_151171_ah || armor == Items.field_151149_ai || armor == Items.field_151151_aj || armor.func_82812_d() == ItemArmor.ArmorMaterial.GOLD && EM_Settings.genConfigs) {
                config.get(catName, APName[0], Item.field_150901_e.func_148750_c((Object)armor)).getString();
                config.get(catName, APName[1], 0.0).getDouble(0.0);
                config.get(catName, APName[2], 0.0).getDouble(0.0);
                config.get(catName, APName[3], 2.5).getDouble(2.5);
                config.get(catName, APName[4], 1.0).getDouble(1.0);
                config.get(catName, APName[5], 1.0).getDouble(1.0);
                config.get(catName, APName[6], 1.2).getDouble(1.2);
                config.get(catName, APName[7], 0.0).getDouble(0.0);
                config.get(catName, APName[8], 0.0).getDouble(0.0);
                config.get(catName, APName[10], false).getBoolean(false);
                config.get(catName, APName[11], false).getBoolean(false);
                if (armor.field_77881_a == 1) {
                    config.get(catName, APName[9], true).getBoolean(true);
                }
            } else if (armor == Items.field_151024_Q || armor == Items.field_151027_R || armor == Items.field_151026_S || armor == Items.field_151021_T || armor.func_82812_d() == ItemArmor.ArmorMaterial.CLOTH && EM_Settings.genConfigs) {
                config.get(catName, APName[0], Item.field_150901_e.func_148750_c((Object)armor)).getString();
                config.get(catName, APName[1], 1.0).getDouble(1.0);
                config.get(catName, APName[2], 1.0).getDouble(1.0);
                config.get(catName, APName[3], 1.0).getDouble(1.0);
                config.get(catName, APName[4], 1.0).getDouble(1.0);
                config.get(catName, APName[5], 1.0).getDouble(1.0);
                config.get(catName, APName[6], 1.0).getDouble(1.0);
                config.get(catName, APName[7], 0.0).getDouble(0.0);
                config.get(catName, APName[8], 0.0).getDouble(0.0);
                config.get(catName, APName[10], false).getBoolean(false);
                config.get(catName, APName[11], false).getBoolean(false);
                if (armor.field_77881_a == 1) {
                    config.get(catName, APName[9], true).getBoolean(true);
                }
            } else if (EM_Settings.genConfigs) {
                this.generateEmpty(config, armor);
            }
            config.save();
        }
    }

    @Override
    public File GetDefaultFile() {
        return new File(EM_ConfigHandler.loadedProfile + EM_ConfigHandler.customPath + "Armor.cfg");
    }

    @Override
    public void generateEmpty(Configuration config, Object obj) {
        if (obj == null || !(obj instanceof ItemArmor)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Tried to register config with non armor object!", (Throwable)new Exception());
            }
            return;
        }
        ItemArmor armor = (ItemArmor)obj;
        String[] regName = Item.field_150901_e.func_148750_c((Object)armor).split(":");
        if (regName.length <= 0) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Failed to get correctly formatted object name for " + armor.func_77658_a());
            }
            return;
        }
        String catName = this.categoryName() + "." + EnviroUtils.replaceULN(armor.func_77658_a() + "_" + regName);
        config.addCustomCategoryComment(catName, "");
        config.get(catName, APName[0], Item.field_150901_e.func_148750_c((Object)armor)).getString();
        config.get(catName, APName[1], 0.0).getDouble(0.0);
        config.get(catName, APName[2], 0.0).getDouble(0.0);
        config.get(catName, APName[3], 0.0).getDouble(0.0);
        config.get(catName, APName[4], 1.0).getDouble(1.0);
        config.get(catName, APName[5], 1.0).getDouble(1.0);
        config.get(catName, APName[6], 1.0).getDouble(1.0);
        config.get(catName, APName[7], 0.0).getDouble(0.0);
        config.get(catName, APName[8], 0.0).getDouble(0.0);
        config.get(catName, APName[10], false).getBoolean(false);
        config.get(catName, APName[11], false).getBoolean(false);
        if (armor.field_77881_a == 1) {
            config.get(catName, APName[9], true).getBoolean(true);
        }
    }

    @Override
    public boolean useCustomConfigs() {
        return true;
    }

    @Override
    public void customLoad() {
    }

    static {
        ArmorProperties.APName[0] = "01.ID";
        ArmorProperties.APName[1] = "02.Temp Add - Night";
        ArmorProperties.APName[2] = "03.Temp Add - Shade";
        ArmorProperties.APName[3] = "04.Temp Add - Sun";
        ArmorProperties.APName[4] = "05.Temp Multiplier - Night";
        ArmorProperties.APName[5] = "06.Temp Multiplier - Shade";
        ArmorProperties.APName[6] = "07.Temp Multiplier - Sun";
        ArmorProperties.APName[7] = "08.Sanity";
        ArmorProperties.APName[8] = "09.Air";
        ArmorProperties.APName[9] = "10.Allow Camel Pack";
        ArmorProperties.APName[10] = "11.Is Temperature Resistance";
        ArmorProperties.APName[11] = "12.Is Temperature Sealed";
    }
}

