/*
 * Decompiled with CFR 0.152.
 */
package enviromine.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import enviromine.client.gui.hud.HUDRegistry;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_EventManager;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EnviroDataTracker;
import enviromine.world.ClientQuake;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class PacketEnviroMine
implements IMessage {
    private NBTTagCompound tags;

    public PacketEnviroMine() {
    }

    public PacketEnviroMine(NBTTagCompound _tags) {
        this.tags = _tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class HandlerClient
    implements IMessageHandler<PacketEnviroMine, IMessage> {
        public IMessage onMessage(PacketEnviroMine packet, MessageContext ctx) {
            int id;
            int n = id = packet.tags.func_74764_b("id") ? packet.tags.func_74762_e("id") : -1;
            if (id == 0) {
                this.trackerSync(packet.tags);
            } else if (id == 3) {
                this.registerQuake(packet.tags);
            } else if (id == 4) {
                if (!packet.tags.func_74767_n("enableAirQ")) {
                    HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(3));
                } else {
                    HUDRegistry.enableHudItem(HUDRegistry.getHudItemByID(3));
                }
                if (!packet.tags.func_74767_n("enableBodyTemp")) {
                    HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(0));
                } else {
                    HUDRegistry.enableHudItem(HUDRegistry.getHudItemByID(0));
                }
                if (!packet.tags.func_74767_n("enableHydrate")) {
                    HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(1));
                } else {
                    HUDRegistry.enableHudItem(HUDRegistry.getHudItemByID(1));
                }
                if (!packet.tags.func_74767_n("enableSanity")) {
                    HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(2));
                } else {
                    HUDRegistry.enableHudItem(HUDRegistry.getHudItemByID(2));
                }
            } else if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Received invalid packet on clientside!");
            }
            return null;
        }

        private void trackerSync(NBTTagCompound tags) {
            EnviroDataTracker tracker = EM_StatusManager.lookupTrackerFromUsername(tags.func_74779_i("player"));
            if (tracker != null) {
                tracker.prevAirQuality = tracker.airQuality;
                tracker.prevBodyTemp = tracker.bodyTemp;
                tracker.prevHydration = tracker.hydration;
                tracker.prevSanity = tracker.sanity;
                tracker.airQuality = Float.valueOf(tags.func_74760_g("airQuality")).floatValue();
                tracker.bodyTemp = Float.valueOf(tags.func_74760_g("bodyTemp")).floatValue();
                tracker.hydration = Float.valueOf(tags.func_74760_g("hydration")).floatValue();
                tracker.sanity = Float.valueOf(tags.func_74760_g("sanity")).floatValue();
                tracker.airTemp = Float.valueOf(tags.func_74760_g("airTemp")).floatValue();
            }
        }

        private void registerQuake(NBTTagCompound tags) {
            int b = tags.func_74762_e("action");
            int d = tags.func_74762_e("dimension");
            int x = tags.func_74762_e("posX");
            int z = tags.func_74762_e("posZ");
            int l = tags.func_74762_e("length");
            int w = tags.func_74762_e("width");
            float a = tags.func_74760_g("angle");
            int h = tags.func_74762_e("height");
            if (b == 0) {
                new ClientQuake(d, x, z, l, w, a);
            } else if (b == 1) {
                ClientQuake.UpdateQuakeHeight(d, x, z, l, w, a, h);
            } else if (b == 2) {
                ClientQuake.RemoveQuake(x, z);
            }
        }
    }

    public static class HandlerServer
    implements IMessageHandler<PacketEnviroMine, IMessage> {
        public IMessage onMessage(PacketEnviroMine packet, MessageContext ctx) {
            int id;
            int n = id = packet.tags.func_74764_b("id") ? packet.tags.func_74762_e("id") : -1;
            if (id == 1) {
                this.emptyRightClick(packet.tags);
            } else if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Received invalid packet on serverside!");
            }
            return null;
        }

        private void emptyRightClick(NBTTagCompound tags) {
            EntityPlayer player = EM_StatusManager.findPlayer(tags.func_74779_i("player"));
            if (player != null) {
                EM_EventManager.drinkWater(player, null);
            }
        }
    }
}

