/*
 * Decompiled with CFR 0.152.
 */
package enviromine.mixins.early;

import enviromine.blocks.tiles.TileEntityCauldron;
import enviromine.blocks.water.BlockEnviroMineWater;
import enviromine.core.EnviroMine;
import enviromine.items.ItemModBucket;
import enviromine.utils.WaterUtils;
import enviromine.utils.misc.mixins.MixinBlockCauldron_NTM;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockCauldron.class}, priority=1003)
public class MixinBlockCauldron
implements ITileEntityProvider {
    @Shadow
    public void func_150024_a(World worldIn, int x, int y, int z, int level) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"onBlockActivated"}, at={@At(value="HEAD")}, cancellable=true)
    public void onBlockActivated(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ, CallbackInfoReturnable<Boolean> cir) {
        if (worldIn.field_72995_K) {
            cir.setReturnValue((Object)true);
            return;
        }
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack == null) {
            cir.setReturnValue((Object)true);
            return;
        }
        TileEntity te = worldIn.func_147438_o(x, y, z);
        int i1 = worldIn.func_72805_g(x, y, z);
        int j1 = BlockCauldron.func_150027_b((int)i1);
        if (!(te instanceof TileEntityCauldron)) return;
        TileEntityCauldron cauldron = (TileEntityCauldron)te;
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemModBucket) {
            ItemModBucket bucket = (ItemModBucket)item;
            Block block = bucket.containedFluid;
            if (block instanceof BlockEnviroMineWater) {
                BlockEnviroMineWater enviroMineWater = (BlockEnviroMineWater)block;
                if (j1 < 3) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
                    }
                    cauldron.setWaterType(WaterUtils.getTypeFromFluid(enviroMineWater.getFluid()));
                    this.func_150024_a(worldIn, x, y, z, 3);
                }
                cir.setReturnValue((Object)true);
                return;
            }
        }
        if (itemstack.func_77973_b() == Items.field_151126_ay) {
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            cauldron.setWaterType(WaterUtils.coolDown(cauldron.getWaterType()));
            cir.setReturnValue((Object)true);
            return;
        }
        int[] nArray = OreDictionary.getOreIDs((ItemStack)itemstack);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (OreDictionary.getOreID((String)"dustSalt") == id) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                cauldron.setWaterType(WaterUtils.saltDown(cauldron.getWaterType()));
                cir.setReturnValue((Object)true);
                return;
            }
            ++n2;
        }
    }

    @Inject(method={"onBlockActivated"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockCauldron;func_150024_a(Lnet/minecraft/world/World;IIII)V", ordinal=0, shift=At.Shift.BEFORE)})
    public void onBlockActivated2(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ, CallbackInfoReturnable<Boolean> cir) {
        TileEntity te = worldIn.func_147438_o(x, y, z);
        if (te instanceof TileEntityCauldron) {
            TileEntityCauldron cauldron = (TileEntityCauldron)te;
            cauldron.setWaterType(WaterUtils.WATER_TYPES.CLEAN);
        }
    }

    @Inject(method={"fillWithRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockMetadataWithNotify(IIIII)Z", shift=At.Shift.BEFORE)})
    public void fillWithRain(World worldIn, int x, int y, int z, CallbackInfo ci) {
        TileEntity te = worldIn.func_147438_o(x, y, z);
        if (te instanceof TileEntityCauldron) {
            TileEntityCauldron cauldron = (TileEntityCauldron)te;
            cauldron.setWaterType(WaterUtils.WATER_TYPES.DIRTY);
        }
    }

    @Inject(method={"onEntityCollidedWithBlock"}, at={@At(value="HEAD")})
    public void onEntityCollidedWithBlock(World worldIn, int x, int y, int z, Entity entityIn, CallbackInfo ci) {
        int l = BlockCauldron.func_150027_b((int)worldIn.func_72805_g(x, y, z));
        float f = (float)y + (6.0f + (float)(3 * l)) / 16.0f;
        TileEntity te = worldIn.func_147438_o(x, y, z);
        if (!worldIn.field_72995_K && te instanceof TileEntityCauldron) {
            TileEntityCauldron cauldron = (TileEntityCauldron)te;
            if (l > 0 && entityIn.field_70121_D.field_72338_b <= (double)f && cauldron.getWaterType().isRadioactive && entityIn instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entityIn;
                if (EnviroMine.isHbmLoaded) {
                    MixinBlockCauldron_NTM.applyRadiation(entityLivingBase, 0.125f);
                }
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCauldron();
    }
}

