/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers.compat;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.ThreeInts;
import com.hbm.handler.atmosphere.AtmosphereBlob;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.inventory.fluid.Fluids;
import enviromine.core.EM_Settings;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.properties.BiomeProperties;
import enviromine.utils.CompatUtils;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EM_StatusManager_NTM_SPACE {
    public static float getTempTerraformed(EntityLivingBase entityLiving, BiomeProperties biomeOverride) {
        CBT_Atmosphere atmosphere = CompatUtils.getAtmosphere(entityLiving.field_70170_p);
        if (CompatUtils.isTerraformed(atmosphere)) {
            return biomeOverride.ambientTemp_TERRAFORMED;
        }
        return biomeOverride.ambientTemp;
    }

    public static float TemperatureChangeSpace(EntityLivingBase entityLiving, float currentTime, float biome_DAWN_TEMPERATURE_TERRAFORMED, float biome_DAY_TEMPERATURE_TERRAFORMED, float biome_DUSK_TEMPERATURE_TERRAFORMED, float biome_NIGHT_TEMPERATURE_TERRAFORMED, float biome_DAWN_TEMPERATURE, float biome_DAY_TEMPERATURE, float biome_DUSK_TEMPERATURE, float biome_NIGHT_TEMPERATURE) {
        CelestialBody body = CelestialBody.getBody((World)entityLiving.field_70170_p);
        float fullCycle = Math.round((float)(body.getRotationalPeriod() / (1.0 - 1.0 / body.getPlanet().getOrbitalPeriod())));
        float phasePeriod = fullCycle / 4.0f;
        CBT_Atmosphere atmosphere = CompatUtils.getAtmosphere(entityLiving.field_70170_p);
        float temperatureChange = CompatUtils.isTerraformed(atmosphere) ? EM_StatusManager.calculateTemperatureChangeSpace(currentTime % fullCycle, phasePeriod, biome_DAWN_TEMPERATURE_TERRAFORMED, biome_DAY_TEMPERATURE_TERRAFORMED, biome_DUSK_TEMPERATURE_TERRAFORMED, biome_NIGHT_TEMPERATURE_TERRAFORMED) : EM_StatusManager.calculateTemperatureChangeSpace(currentTime % fullCycle, phasePeriod, biome_DAWN_TEMPERATURE, biome_DAY_TEMPERATURE, biome_DUSK_TEMPERATURE, biome_NIGHT_TEMPERATURE);
        return temperatureChange;
    }

    public static float TemperatureRateChangeSpace(EntityLivingBase entityLiving, float currentTime, float tempRate_DAWN, float tempRate_DAY, float tempRate_DUSK, float tempRate_NIGHT) {
        CelestialBody body = CelestialBody.getBody((World)entityLiving.field_70170_p);
        float phasePeriod = Math.round((float)(body.getRotationalPeriod() / (1.0 - 1.0 / body.getPlanet().getOrbitalPeriod())) / 4.0f);
        float temperatureRate = EM_StatusManager.calculateTemperatureChangeSpace(currentTime, phasePeriod, tempRate_DAWN, tempRate_DAY, tempRate_DUSK, tempRate_NIGHT);
        return temperatureRate;
    }

    public static float getBiomeTemperatureBlobs(EntityLivingBase entityLiving, float biomeTemperature) {
        return EM_StatusManager_NTM_SPACE.checkBlobs(entityLiving) ? EM_Settings.NTMSpaceAirVentTemperatureConstant : biomeTemperature;
    }

    public static boolean getAirVentConst(EntityLivingBase entityLiving) {
        return CompatUtils.isTerraformed(CompatUtils.getAtmosphere(entityLiving.field_70170_p));
    }

    public static boolean getAirVentConstBlobs(EntityLivingBase entityLiving) {
        return EM_StatusManager_NTM_SPACE.checkBlobs(entityLiving);
    }

    private static boolean checkBlobs(EntityLivingBase entityLiving) {
        ThreeInts pos = new ThreeInts(MathHelper.func_76128_c((double)entityLiving.field_70165_t), MathHelper.func_76128_c((double)(entityLiving.field_70163_u + (double)entityLiving.func_70047_e())), MathHelper.func_76128_c((double)entityLiving.field_70161_v));
        List currentBlobs = ChunkAtmosphereManager.proxy.getBlobs(entityLiving.field_70170_p, pos.x, pos.y, pos.z);
        for (AtmosphereBlob blob : currentBlobs) {
            if (!blob.hasFluid(Fluids.AIR, 0.21) && !blob.hasFluid(Fluids.OXYGEN, 0.09)) continue;
            return true;
        }
        return false;
    }
}

