/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers.compat;

import com.hbm.inventory.fluid.FluidType;
import com.hbm.tileentity.machine.TileEntityCrucible;
import com.hbm.tileentity.machine.TileEntityDiFurnace;
import com.hbm.tileentity.machine.TileEntityDiFurnaceRTG;
import com.hbm.tileentity.machine.TileEntityFurnaceBrick;
import com.hbm.tileentity.machine.TileEntityFurnaceCombination;
import com.hbm.tileentity.machine.TileEntityFurnaceIron;
import com.hbm.tileentity.machine.TileEntityFurnaceSteel;
import com.hbm.tileentity.machine.TileEntityHeatBoiler;
import com.hbm.tileentity.machine.TileEntityHeatBoilerIndustrial;
import com.hbm.tileentity.machine.TileEntityHeaterElectric;
import com.hbm.tileentity.machine.TileEntityHeaterFirebox;
import com.hbm.tileentity.machine.TileEntityHeaterOilburner;
import com.hbm.tileentity.machine.TileEntityHeaterOven;
import com.hbm.tileentity.machine.TileEntityMachineArcFurnaceLarge;
import com.hbm.tileentity.machine.TileEntityMachineCombustionEngine;
import com.hbm.tileentity.machine.TileEntityMachineCyclotron;
import com.hbm.tileentity.machine.TileEntityMachineDiesel;
import com.hbm.tileentity.machine.TileEntityMachineHephaestus;
import com.hbm.tileentity.machine.TileEntityMachinePress;
import com.hbm.tileentity.machine.TileEntityMachineTurbineGas;
import com.hbm.tileentity.machine.TileEntityMachineTurbofan;
import com.hbm.tileentity.machine.TileEntityMachineWoodBurner;
import com.hbm.tileentity.machine.oil.TileEntityMachineCoker;
import com.hbm.tileentity.machine.oil.TileEntityMachineGasFlare;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import enviromine.core.EM_Settings;
import enviromine.handlers.EM_StatusManager;
import java.lang.reflect.Field;
import net.minecraft.tileentity.TileEntity;

public class EM_StatusManager_NTM {
    public static float machinesTempInfluence(TileEntity tileentity, float dist, int cubeRadius) {
        float blockAndItemTempInfluence = 0.0f;
        float FireboxMax = TileEntityHeaterFirebox.maxHeatEnergy;
        float HeaterOvenMax = TileEntityHeaterOven.maxHeatEnergy;
        if (tileentity instanceof TileEntityMachinePress) {
            TileEntityMachinePress press = (TileEntityMachinePress)tileentity;
            if (press.burnTime > 0 && press.speed > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(Math.min((float)press.burnTime / EM_Settings.BurnerPressHeatDivisor, EM_Settings.BurnerPressHeatHardCap * EM_Settings.AmbTemp_Bl_It_TempInf_Div), dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityHeaterFirebox) {
            TileEntityHeaterFirebox firebox = (TileEntityHeaterFirebox)tileentity;
            if (firebox.burnTime > 0 && firebox.heatEnergy > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)firebox.burnHeat / EM_Settings.FireboxHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityHeaterOven) {
            TileEntityHeaterOven heaterOven = (TileEntityHeaterOven)tileentity;
            if (heaterOven.burnTime > 0 && heaterOven.heatEnergy > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)heaterOven.burnHeat / EM_Settings.HeaterOvenHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityHeaterOilburner) {
            TileEntityHeaterOilburner oilburner = (TileEntityHeaterOilburner)tileentity;
            if (oilburner.isOn && oilburner.heatEnergy > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)oilburner.heatEnergy / EM_Settings.FluidBurnerHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityHeaterElectric) {
            TileEntityHeaterElectric heaterElectric = (TileEntityHeaterElectric)tileentity;
            if (heaterElectric.isOn && heaterElectric.heatEnergy > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(Math.min((float)heaterElectric.heatEnergy / EM_Settings.HeaterElectricHeatDivisor, EM_Settings.HeaterElectricHeatHardCap * EM_Settings.AmbTemp_Bl_It_TempInf_Div), dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityFurnaceIron) {
            TileEntityFurnaceIron furnaceIron = (TileEntityFurnaceIron)tileentity;
            if (furnaceIron.wasOn) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(Math.min((float)furnaceIron.burnTime / EM_Settings.IronFurnaceHeatDivisor, EM_Settings.IronFurnaceHeatHardCap * EM_Settings.AmbTemp_Bl_It_TempInf_Div), dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityFurnaceSteel) {
            TileEntityFurnaceSteel furnaceSteel = (TileEntityFurnaceSteel)tileentity;
            if (furnaceSteel.wasOn) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)furnaceSteel.heat / EM_Settings.SteelFurnaceHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityFurnaceCombination) {
            TileEntityFurnaceCombination furnaceCombination = (TileEntityFurnaceCombination)tileentity;
            if (furnaceCombination.wasOn) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)furnaceCombination.heat / EM_Settings.CombinationOvenHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityCrucible) {
            TileEntityCrucible crucible = (TileEntityCrucible)tileentity;
            if (crucible.heat > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)crucible.heat / EM_Settings.CrucibleHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityHeatBoiler) {
            TileEntityHeatBoiler boiler = (TileEntityHeatBoiler)tileentity;
            float heat = boiler.heat;
            if (heat <= FireboxMax) {
                heat = (float)boiler.heat / EM_Settings.BoilerHeatDivisor;
            } else if (heat <= HeaterOvenMax) {
                heat = Math.max((float)boiler.heat / (EM_Settings.BoilerHeatDivisor * EM_Settings.BoilerHeaterOvenDivisorConstant), FireboxMax / EM_Settings.BoilerHeatDivisor);
            } else if (heat <= (float)TileEntityHeatBoiler.maxHeat) {
                heat = Math.max((float)boiler.heat / (EM_Settings.BoilerHeatDivisor * EM_Settings.BoilerMAXDivisorConstant), HeaterOvenMax / (EM_Settings.BoilerHeatDivisor * EM_Settings.BoilerHeaterOvenDivisorConstant));
            }
            blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(heat, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
        } else if (tileentity instanceof TileEntityHeatBoilerIndustrial) {
            TileEntityHeatBoilerIndustrial boilerIndustrial = (TileEntityHeatBoilerIndustrial)tileentity;
            float heat = boilerIndustrial.heat;
            if (heat <= FireboxMax) {
                heat = (float)boilerIndustrial.heat / EM_Settings.BoilerIndustrialHeatDivisor;
            } else if (heat <= HeaterOvenMax) {
                heat = Math.max((float)boilerIndustrial.heat / (EM_Settings.BoilerIndustrialHeatDivisor * EM_Settings.BoilerIndustrialHeaterOvenDivisorConstant), FireboxMax / EM_Settings.BoilerIndustrialHeatDivisor);
            } else if (heat <= (float)TileEntityHeatBoilerIndustrial.maxHeat) {
                heat = Math.max((float)boilerIndustrial.heat / (EM_Settings.BoilerIndustrialHeatDivisor * EM_Settings.BoilerIndustrialMAXDivisorConstant), HeaterOvenMax / (EM_Settings.BoilerIndustrialHeatDivisor * EM_Settings.BoilerIndustrialHeaterOvenDivisorConstant));
            }
            blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(heat, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
        } else if (tileentity instanceof TileEntityFurnaceBrick) {
            TileEntityFurnaceBrick furnaceBrick = (TileEntityFurnaceBrick)tileentity;
            if (furnaceBrick.burnTime > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(Math.min((float)furnaceBrick.burnTime / EM_Settings.FurnaceBrickHeatDivisor, EM_Settings.FurnaceBrickHeatHardCap * EM_Settings.AmbTemp_Bl_It_TempInf_Div), dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityDiFurnace) {
            TileEntityDiFurnace diFurnace = (TileEntityDiFurnace)tileentity;
            if (diFurnace.progress > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)diFurnace.fuel / EM_Settings.DiFurnaceHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityDiFurnaceRTG) {
            TileEntityDiFurnaceRTG diFurnaceRTG = (TileEntityDiFurnaceRTG)tileentity;
            if (diFurnaceRTG.progress > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)diFurnaceRTG.getPower() / EM_Settings.DiFurnaceRTGHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineWoodBurner) {
            TileEntityMachineWoodBurner woodBurner = (TileEntityMachineWoodBurner)tileentity;
            int powerGen = 0;
            try {
                Field powerGenz = TileEntityMachineWoodBurner.class.getDeclaredField("powerGen");
                powerGenz.setAccessible(true);
                powerGen = (Integer)powerGenz.get(woodBurner);
            }
            catch (IllegalAccessException | NoSuchFieldException powerGenz) {
                // empty catch block
            }
            if (woodBurner.isOn && powerGen > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)woodBurner.burnTime / EM_Settings.WoodBurningGenHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineDiesel) {
            TileEntityMachineDiesel diesel = (TileEntityMachineDiesel)tileentity;
            if (diesel.tank.getFill() > 0 && TileEntityMachineDiesel.getHEFromFuel((FluidType)diesel.tank.getTankType()) > 0L) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(EM_Settings.DieselGenHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineCombustionEngine) {
            TileEntityMachineCombustionEngine combustionEngine = (TileEntityMachineCombustionEngine)tileentity;
            if (combustionEngine.wasOn) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(EM_Settings.ICEHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineCyclotron) {
            TileEntityMachineCyclotron cyclotron = (TileEntityMachineCyclotron)tileentity;
            if (cyclotron.progress > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(EM_Settings.CyclotronHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineHephaestus) {
            TileEntityMachineHephaestus hephaestus = (TileEntityMachineHephaestus)tileentity;
            if (hephaestus.getTotalHeat() > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)hephaestus.getTotalHeat() / EM_Settings.GeothermalGenHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityRBMKBase) {
            TileEntityRBMKBase rbmkBase = (TileEntityRBMKBase)tileentity;
            if (rbmkBase.heat > 0.0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(Math.min((float)rbmkBase.heat / EM_Settings.RBMKRodHeatDivisor, EM_Settings.RBMKRodHeatHardCap * 2.0f), dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineArcFurnaceLarge) {
            TileEntityMachineArcFurnaceLarge arcFurnaceLarge = (TileEntityMachineArcFurnaceLarge)tileentity;
            if (arcFurnaceLarge.isProgressing) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(EM_Settings.ArcFurnaceHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineGasFlare) {
            TileEntityMachineGasFlare gasFlare = (TileEntityMachineGasFlare)tileentity;
            int powerGen = 0;
            try {
                Field output = TileEntityMachineGasFlare.class.getDeclaredField("output");
                output.setAccessible(true);
                powerGen = (Integer)output.get(gasFlare);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            if (gasFlare.doesBurn && powerGen > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(EM_Settings.FlareStackHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineCoker) {
            TileEntityMachineCoker coker = (TileEntityMachineCoker)tileentity;
            if (coker.wasOn && coker.heat > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)coker.heat / EM_Settings.CokerHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineTurbofan) {
            TileEntityMachineTurbofan turbofan = (TileEntityMachineTurbofan)tileentity;
            if (turbofan.wasOn) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(turbofan.afterburner > 0 ? EM_Settings.TurbofanAfterburnerHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div : EM_Settings.TurbofanHeatConstant * EM_Settings.AmbTemp_Bl_It_TempInf_Div, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        } else if (tileentity instanceof TileEntityMachineTurbineGas) {
            TileEntityMachineTurbineGas turbineGas = (TileEntityMachineTurbineGas)tileentity;
            if (turbineGas.temp > 0) {
                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff((float)turbineGas.temp / EM_Settings.CCGasTurbineHeatDivisor, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
            }
        }
        return blockAndItemTempInfluence;
    }
}

