/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import enviromine.EnviroPotion;
import enviromine.client.gui.UI_Settings;
import enviromine.client.gui.hud.items.Debug_Info;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import enviromine.handlers.EnviroAchievements;
import enviromine.handlers.compat.EM_StatusManager_LOTR;
import enviromine.handlers.compat.EM_StatusManager_NTM;
import enviromine.handlers.compat.EM_StatusManager_NTM_SPACE;
import enviromine.handlers.compat.EM_StatusManager_SS;
import enviromine.network.packet.PacketEnviroMine;
import enviromine.trackers.EnviroDataTracker;
import enviromine.trackers.properties.ArmorProperties;
import enviromine.trackers.properties.BiomeProperties;
import enviromine.trackers.properties.BlockProperties;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.trackers.properties.EntityProperties;
import enviromine.trackers.properties.ItemProperties;
import enviromine.utils.ArmorTempUtils;
import enviromine.utils.EnviroUtils;
import enviromine.utils.misc.CompatSafe;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.EnumPlantType;
import org.apache.logging.log4j.Level;

@CompatSafe
public class EM_StatusManager {
    public static final int AIR_QUALITY_DELTA_INDEX = 0;
    public static final int AMBIENT_TEMP_INDEX = 1;
    public static final int NEAR_LAVA_INDEX = 2;
    public static final int DEHYDRATION_DELTA_INDEX = 3;
    public static final int BODY_TEMP_DROP_SPEED_INDEX = 4;
    public static final int BODY_TEMP_RISE_SPEED_INDEX = 5;
    public static final int ANIMAL_HOSTILITY_INDEX = 6;
    public static final int SANITY_DELTA_INDEX = 7;
    public static HashMap<String, EnviroDataTracker> trackerList = new HashMap();
    private static Stopwatch timer = Stopwatch.createUnstarted();

    public static void addToManager(EnviroDataTracker tracker) {
        if (tracker.trackedEntity instanceof EntityPlayer) {
            trackerList.put("" + tracker.trackedEntity.func_70005_c_(), tracker);
        } else {
            trackerList.put("" + tracker.trackedEntity.func_145782_y(), tracker);
        }
    }

    public static void updateTracker(EnviroDataTracker tracker) {
        if (tracker == null) {
            return;
        }
        if (EnviroMine.proxy.isClient() && Minecraft.func_71410_x().func_71387_A() && Minecraft.func_71410_x().func_147113_T() && !EnviroMine.proxy.isOpenToLAN()) {
            return;
        }
        ++tracker.updateTimer;
        if ((float)tracker.updateTimer >= EM_Settings.TrackerUpdateTimer) {
            tracker.updateData();
            if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
                EM_StatusManager.syncMultiplayerTracker(tracker);
            }
        }
    }

    public static void syncMultiplayerTracker(EnviroDataTracker tracker) {
        if (!(tracker.trackedEntity instanceof EntityPlayer)) {
            return;
        }
        tracker.fixFloatingPointErrors();
        NBTTagCompound pData = new NBTTagCompound();
        pData.func_74768_a("id", 0);
        pData.func_74778_a("player", tracker.trackedEntity.func_70005_c_());
        pData.func_74776_a("airQuality", tracker.airQuality);
        pData.func_74776_a("bodyTemp", tracker.bodyTemp);
        pData.func_74776_a("hydration", tracker.hydration);
        pData.func_74776_a("sanity", tracker.sanity);
        pData.func_74776_a("airTemp", tracker.airTemp);
        EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(tracker.trackedEntity.field_70170_p.field_73011_w.field_76574_g, tracker.trackedEntity.field_70165_t, tracker.trackedEntity.field_70163_u, tracker.trackedEntity.field_70161_v, 128.0));
    }

    public static EnviroDataTracker lookupTracker(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return trackerList.getOrDefault("" + entity.func_70005_c_(), null);
        }
        return trackerList.getOrDefault("" + entity.func_145782_y(), null);
    }

    public static EnviroDataTracker lookupTrackerFromUsername(String username) {
        return trackerList.getOrDefault(username, null);
    }

    public static float[] getSurroundingData(EntityLivingBase entityLiving, int cubeRadius) {
        BiomeProperties biomeProp;
        BiomeProperties biomeProps;
        float sanityRate;
        if (EnviroMine.proxy.isClient() && entityLiving.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && !timer.isRunning()) {
            timer.start();
        }
        float[] data = new float[8];
        float sanityStartRate = sanityRate = 0.0f;
        float quality = 0.0f;
        double leaves = 0.0;
        float sanityBoost = 0.0f;
        float dropSpeed = 0.001f;
        float riseSpeed = 0.001f;
        float blockAndItemTempInfluence = 0.0f;
        float cooling = 0.0f;
        float dehydrateBonus = 0.0f;
        int animalHostility = 0;
        boolean nearLava = false;
        float dist = 0.0f;
        float solidBlocks = 0.0f;
        float totalBlocks = 0.0f;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        boolean airVentConst = false;
        if (entityLiving.field_70170_p == null) {
            return data;
        }
        Chunk chunk = entityLiving.field_70170_p.func_72938_d(i, k);
        if (chunk == null) {
            return data;
        }
        BiomeGenBase biome = EnviroMine.isLOTRLoaded ? EM_StatusManager_LOTR.findLOTRBiome(entityLiving, i, k) : chunk.func_76591_a(i & 0xF, k & 0xF, entityLiving.field_70170_p.func_72959_q());
        if (biome == null) {
            return data;
        }
        DimensionProperties dimensionProp = null;
        if (DimensionProperties.base.hasProperty(entityLiving.field_70170_p.field_73011_w.field_76574_g)) {
            dimensionProp = DimensionProperties.base.getProperty(entityLiving.field_70170_p.field_73011_w.field_76574_g);
        }
        float surroundingBiomeTempSamplesSum = 0.0f;
        int surroundingBiomeTempSamplesCount = 0;
        boolean isDay = entityLiving.field_70170_p.func_72935_r();
        if (entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            isDay = false;
        }
        int lightLev = 0;
        int blockLightLev = 0;
        if (j > 0) {
            if (j >= 256) {
                lightLev = 15;
                blockLightLev = 15;
            } else {
                lightLev = chunk.func_76614_a(EnumSkyBlock.Sky, i & 0xF, j, k & 0xF);
                blockLightLev = chunk.func_76614_a(EnumSkyBlock.Block, i & 0xF, j, k & 0xF);
            }
        }
        if (!(isDay || blockLightLev > 1 || entityLiving.func_70660_b(Potion.field_76439_r) != null || dimensionProp != null && dimensionProp.override && !dimensionProp.darkAffectSanity)) {
            sanityStartRate = EM_Settings.SanityRateDecreaseDark;
            sanityRate = EM_Settings.SanityRateDecreaseDark;
        }
        int cubeRadius_squared = cubeRadius * cubeRadius;
        for (int y = -cubeRadius; y <= cubeRadius; ++y) {
            float radiusAtVerticalSlice = MathHelper.func_76129_c((float)(cubeRadius_squared - y * y));
            int radiusAtVerticalSlice_floored = MathHelper.func_76141_d((float)radiusAtVerticalSlice);
            float radiusAtVerticalSlice_squared = radiusAtVerticalSlice * radiusAtVerticalSlice;
            for (int x = -radiusAtVerticalSlice_floored; x <= radiusAtVerticalSlice_floored; ++x) {
                float radiusAtXSlice = MathHelper.func_76129_c((float)(radiusAtVerticalSlice_squared - (float)(x * x)));
                int radiusAtXSlice_floored = MathHelper.func_76141_d((float)radiusAtXSlice);
                for (int z = -radiusAtXSlice_floored; z <= radiusAtXSlice_floored; ++z) {
                    TileEntity tileentity;
                    if (y == 0) {
                        Chunk testChunk = entityLiving.field_70170_p.func_72938_d(i + x, k + z);
                        BiomeGenBase checkBiome = EnviroMine.isLOTRLoaded ? EM_StatusManager_LOTR.findLOTRBiome(entityLiving, i + x, k + z) : testChunk.func_76591_a(i + x & 0xF, k + z & 0xF, entityLiving.field_70170_p.func_72959_q());
                        if (checkBiome != null) {
                            BiomeProperties biomeOverride = null;
                            if (BiomeProperties.base.hasProperty(checkBiome)) {
                                biomeOverride = BiomeProperties.base.getProperty(checkBiome);
                            }
                            surroundingBiomeTempSamplesSum = biomeOverride != null && biomeOverride.biomeOveride ? (EnviroMine.isHbmSpaceLoaded ? (surroundingBiomeTempSamplesSum += EM_StatusManager_NTM_SPACE.getTempTerraformed(entityLiving, biomeOverride)) : (surroundingBiomeTempSamplesSum += biomeOverride.ambientTemp)) : (surroundingBiomeTempSamplesSum += EnviroUtils.getBiomeTemp(i + x, j + y, k + z, checkBiome));
                            ++surroundingBiomeTempSamplesCount;
                        }
                    }
                    if (!EM_PhysManager.blockNotSolid(entityLiving.field_70170_p, x + i, y + j, z + k, false)) {
                        solidBlocks += 1.0f;
                    }
                    totalBlocks += 1.0f;
                    dist = (float)entityLiving.func_70011_f((double)(i + x), (double)(j + y), (double)(k + z));
                    Block block = Blocks.field_150350_a;
                    int meta = 0;
                    block = entityLiving.field_70170_p.func_147439_a(i + x, j + y, k + z);
                    if (EnviroMine.isHbmLoaded && EM_Settings.EnableHBMMachinesHeat && (tileentity = entityLiving.field_70170_p.func_147438_o(i + x, j + y, k + z)) != null) {
                        blockAndItemTempInfluence += EM_StatusManager_NTM.machinesTempInfluence(tileentity, dist, cubeRadius);
                    }
                    if (block != Blocks.field_150350_a) {
                        meta = entityLiving.field_70170_p.func_72805_g(i + x, j + y, k + z);
                    }
                    if (BlockProperties.base.hasProperty(block, meta)) {
                        BlockProperties blockProps = BlockProperties.base.getProperty(block, meta);
                        if (blockProps.air > 0.0f) {
                            leaves += (double)(blockProps.air / 0.1f);
                        } else if (quality >= blockProps.air && blockProps.air < 0.0f && quality <= 0.0f) {
                            quality += blockProps.air;
                        }
                        if (blockProps.enableTemp) {
                            if (blockAndItemTempInfluence <= EM_StatusManager.getTempFalloff(blockProps.temp, dist, cubeRadius, EM_Settings.blockTempDropoffPower) && blockProps.temp > 0.0f) {
                                blockAndItemTempInfluence += EM_StatusManager.getTempFalloff(blockProps.temp, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
                            } else if (blockProps.temp < 0.0f) {
                                cooling += EM_StatusManager.getTempFalloff(-blockProps.temp, dist, cubeRadius, EM_Settings.blockTempDropoffPower);
                            }
                        }
                        if (sanityRate >= blockProps.sanity && blockProps.sanity < 0.0f && sanityRate <= 0.0f) {
                            sanityRate += blockProps.sanity;
                        } else if (sanityRate <= blockProps.sanity && blockProps.sanity > 0.0f) {
                            if (block instanceof BlockFlower) {
                                if ((isDay || entityLiving.field_70170_p.field_73011_w.field_76576_e) && sanityBoost < blockProps.sanity) {
                                    sanityBoost += blockProps.sanity;
                                }
                            } else if (sanityBoost < blockProps.sanity) {
                                sanityBoost += blockProps.sanity;
                            }
                        }
                    }
                    if (block.func_149688_o() != Material.field_151587_i) continue;
                    nearLava = true;
                }
            }
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            for (int slot = 0; slot < 9; ++slot) {
                Object itemProps;
                ItemStack stack = player.field_71071_by.field_70462_a[slot];
                if (stack == null) continue;
                float stackMult = 1.0f;
                if (stack.field_77994_a > 1) {
                    stackMult = ((float)stack.field_77994_a - 1.0f) / 63.0f + 1.0f;
                }
                if (ItemProperties.base.hasProperty(stack)) {
                    itemProps = ItemProperties.base.getProperty(stack);
                    if (itemProps.ambAir > 0.0f) {
                        leaves += (double)(itemProps.ambAir / 0.1f * stackMult);
                    } else if (quality >= itemProps.ambAir * stackMult && itemProps.ambAir < 0.0f && quality <= 0.0f) {
                        quality += itemProps.ambAir * stackMult;
                    }
                    if (blockAndItemTempInfluence <= itemProps.ambTemp * stackMult && itemProps.enableTemp && itemProps.ambTemp > 0.0f) {
                        blockAndItemTempInfluence += itemProps.ambTemp * stackMult;
                    } else if (itemProps.enableTemp && itemProps.ambTemp < 0.0f) {
                        cooling += -itemProps.ambTemp * stackMult;
                    }
                    if (sanityRate >= itemProps.ambSanity * stackMult && itemProps.ambSanity < 0.0f && sanityRate <= 0.0f) {
                        sanityRate += itemProps.ambSanity * stackMult;
                        continue;
                    }
                    if (!(sanityBoost <= itemProps.ambSanity * stackMult) || !(itemProps.ambSanity > 0.0f)) continue;
                    if (stack.func_77973_b() instanceof ItemBlock) {
                        if (((ItemBlock)stack.func_77973_b()).field_150939_a instanceof BlockFlower) {
                            if (!isDay && !entityLiving.field_70170_p.field_73011_w.field_76576_e) continue;
                            sanityBoost += itemProps.ambSanity * stackMult;
                            continue;
                        }
                        sanityBoost += itemProps.ambSanity * stackMult;
                        continue;
                    }
                    sanityBoost += itemProps.ambSanity * stackMult;
                    continue;
                }
                itemProps = stack.func_77973_b();
                if (!(itemProps instanceof ItemBlock)) continue;
                ItemBlock itemBlock = (ItemBlock)itemProps;
                if (!(itemBlock.field_150939_a instanceof BlockFlower) || !isDay && !entityLiving.field_70170_p.field_73011_w.field_76576_e || !(sanityBoost <= 0.1f) || ((BlockFlower)itemBlock.field_150939_a).getPlantType((IBlockAccess)entityLiving.field_70170_p, i, j, k) != EnumPlantType.Plains) continue;
                sanityBoost += EM_Settings.SanityBoostFlowers;
            }
        }
        if (lightLev > 1 && !entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            quality += EM_Settings.AirQualityIncreaseLight;
            sanityRate += EM_Settings.SanityRateIncreaseLight;
        } else if (sanityRate <= sanityStartRate && sanityRate > -0.1f && blockLightLev <= 1 && entityLiving.func_70660_b(Potion.field_76439_r) == null) {
            sanityRate += EM_Settings.SanityRateDecreaseLight;
        }
        if (dimensionProp != null && entityLiving.field_70163_u > (double)((float)dimensionProp.sealevel * EM_Settings.SurfaceYPositionMultiplier) && !entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            quality += EM_Settings.AirQualityIncreaseSurface;
        }
        float biomeTemperature = surroundingBiomeTempSamplesSum / (float)surroundingBiomeTempSamplesCount;
        float maxHighAltitudeTemp = EM_Settings.MaxHighAltitudeTemp;
        float minLowAltitudeTemp = EM_Settings.MinLowAltitudeTemp;
        if (!entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            if (entityLiving.field_70163_u < (double)EM_Settings.SurfaceYPosition) {
                if (minLowAltitudeTemp - biomeTemperature > 0.0f) {
                    biomeTemperature = (float)((double)biomeTemperature + (double)(minLowAltitudeTemp - biomeTemperature) * (1.0 - entityLiving.field_70163_u / (double)EM_Settings.SurfaceYPosition));
                }
            } else if (entityLiving.field_70163_u > (double)EM_Settings.SkyYPositionLowerBound && entityLiving.field_70163_u < (double)EM_Settings.SkyYPositionUpperBound) {
                if (maxHighAltitudeTemp - biomeTemperature < 0.0f) {
                    biomeTemperature = (float)((double)biomeTemperature - (double)MathHelper.func_76135_e((float)(maxHighAltitudeTemp - biomeTemperature)) * ((entityLiving.field_70163_u - (double)EM_Settings.SkyYPositionLowerBound) / (double)EM_Settings.SkyYPositionLowerBoundDivider));
                }
            } else if (entityLiving.field_70163_u >= (double)EM_Settings.SkyYPositionUpperBound) {
                biomeTemperature = Math.min(biomeTemperature, maxHighAltitudeTemp);
            }
        }
        biomeTemperature -= cooling;
        if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_70608_bn()) {
            biomeTemperature += EM_Settings.BodyTempSleep;
        }
        if (dimensionProp == null || !dimensionProp.override || dimensionProp.weatherAffectsTemp) {
            float biomeTemperatureRain = 6.0f;
            float biomeTemperatureThunder = 8.0f;
            boolean biomeTemperatureRainBool = false;
            boolean biomeTemperatureThunderBool = false;
            float dropSpeedRain = 0.01f;
            float dropSpeedThunder = 0.01f;
            if (biome != null) {
                BiomeProperties biomeOverride = null;
                if (BiomeProperties.base.hasProperty(biome)) {
                    biomeOverride = BiomeProperties.base.getProperty(biome);
                }
                if (biomeOverride != null && biomeOverride.biomeOveride) {
                    biomeTemperatureRain = biomeOverride.TemperatureRainDecrease;
                    biomeTemperatureThunder = biomeOverride.TemperatureThunderDecrease;
                    biomeTemperatureRainBool = biomeOverride.TemperatureRainBool;
                    biomeTemperatureThunderBool = biomeOverride.TemperatureThunderBool;
                    dropSpeedRain = biomeOverride.dropSpeedRain;
                    dropSpeedThunder = biomeOverride.dropSpeedThunder;
                }
            }
            if (entityLiving.field_70170_p.func_72896_J() && biome.field_76751_G != 0.0f && biomeTemperatureRainBool) {
                biomeTemperature -= biomeTemperatureRain;
                animalHostility = -1;
                if (entityLiving.field_70170_p.func_72937_j(i, j, k)) {
                    dropSpeed = dropSpeedRain;
                }
            } else if (entityLiving.field_70170_p.func_72911_I() && biome.field_76751_G != 0.0f && biomeTemperatureThunderBool) {
                biomeTemperature -= biomeTemperatureThunder;
                animalHostility = -1;
                if (entityLiving.field_70170_p.func_72937_j(i, j, k)) {
                    dropSpeed = dropSpeedThunder;
                }
            }
        }
        float biomeTemperatureShade = 2.5f;
        if (biome != null) {
            BiomeProperties biomeOverride = null;
            if (BiomeProperties.base.hasProperty(biome)) {
                biomeOverride = BiomeProperties.base.getProperty(biome);
            }
            if (biomeOverride != null && biomeOverride.biomeOveride) {
                biomeTemperatureShade = biomeOverride.TemperatureShadeDecrease;
            }
        }
        if (!entityLiving.field_70170_p.func_72937_j(i, j, k) && isDay && !entityLiving.field_70170_p.func_72896_J()) {
            biomeTemperature -= biomeTemperatureShade;
        }
        if (!entityLiving.field_70170_p.field_73011_w.field_76576_e && dimensionProp == null || dimensionProp != null && dimensionProp.override && dimensionProp.dayNightTemp) {
            float temperatureChange;
            float TemperatureMultiplier = 1.0f;
            float biome_DAWN_TEMPERATURE_DECREASE = 4.0f;
            float biome_DAY_TEMPERATURE_DECREASE = 0.0f;
            float biome_DUSK_TEMPERATURE_DECREASE = 4.0f;
            float biome_NIGHT_TEMPERATURE_DECREASE = 8.0f;
            float biome_DAWN_TEMPERATURE_DECREASE_TERRAFORMED = 4.0f;
            float biome_DAY_TEMPERATURE_DECREASE_TERRAFORMED = 0.0f;
            float biome_DUSK_TEMPERATURE_DECREASE_TERRAFORMED = 4.0f;
            float biome_NIGHT_TEMPERATURE_DECREASE_TERRAFORMED = 8.0f;
            float biome_EARLY_SPRING_TEMPERATURE_DECREASE = 5.0f;
            float biome_MID_SPRING_TEMPERATURE_DECREASE = -2.0f;
            float biome_LATE_SPRING_TEMPERATURE_DECREASE = -1.0f;
            float biome_EARLY_SUMMER_TEMPERATURE_DECREASE = -1.0f;
            float biome_MID_SUMMER_TEMPERATURE_DECREASE = -3.0f;
            float biome_LATE_SUMMER_TEMPERATURE_DECREASE = -1.0f;
            float biome_EARLY_AUTUMN_TEMPERATURE_DECREASE = 6.0f;
            float biome_MID_AUTUMN_TEMPERATURE_DECREASE = 8.0f;
            float biome_LATE_AUTUMN_TEMPERATURE_DECREASE = 10.0f;
            float biome_EARLY_WINTER_TEMPERATURE_DECREASE = 12.0f;
            float biome_MID_WINTER_TEMPERATURE_DECREASE = 16.0f;
            float biome_LATE_WINTER_TEMPERATURE_DECREASE = 10.0f;
            if (biome != null) {
                BiomeProperties biomeOverride = null;
                if (BiomeProperties.base.hasProperty(biome)) {
                    biomeOverride = BiomeProperties.base.getProperty(biome);
                }
                if (biomeOverride != null && biomeOverride.biomeOveride) {
                    TemperatureMultiplier = biomeOverride.TemperatureMultiplier;
                    biome_DAWN_TEMPERATURE_DECREASE = biomeOverride.DAWN_TEMPERATURE_DECREASE;
                    biome_DAY_TEMPERATURE_DECREASE = biomeOverride.DAY_TEMPERATURE_DECREASE;
                    biome_DUSK_TEMPERATURE_DECREASE = biomeOverride.DUSK_TEMPERATURE_DECREASE;
                    biome_NIGHT_TEMPERATURE_DECREASE = biomeOverride.NIGHT_TEMPERATURE_DECREASE;
                    biome_DAWN_TEMPERATURE_DECREASE_TERRAFORMED = biomeOverride.DAWN_TEMPERATURE_DECREASE_TERRAFORMED;
                    biome_DAY_TEMPERATURE_DECREASE_TERRAFORMED = biomeOverride.DAY_TEMPERATURE_DECREASE_TERRAFORMED;
                    biome_DUSK_TEMPERATURE_DECREASE_TERRAFORMED = biomeOverride.DUSK_TEMPERATURE_DECREASE_TERRAFORMED;
                    biome_NIGHT_TEMPERATURE_DECREASE_TERRAFORMED = biomeOverride.NIGHT_TEMPERATURE_DECREASE_TERRAFORMED;
                    biome_EARLY_SPRING_TEMPERATURE_DECREASE = biomeOverride.EARLY_SPRING_TEMPERATURE_DECREASE;
                    biome_MID_SPRING_TEMPERATURE_DECREASE = biomeOverride.MID_SPRING_TEMPERATURE_DECREASE;
                    biome_LATE_SPRING_TEMPERATURE_DECREASE = biomeOverride.LATE_SPRING_TEMPERATURE_DECREASE;
                    biome_EARLY_SUMMER_TEMPERATURE_DECREASE = biomeOverride.EARLY_SUMMER_TEMPERATURE_DECREASE;
                    biome_MID_SUMMER_TEMPERATURE_DECREASE = biomeOverride.MID_SUMMER_TEMPERATURE_DECREASE;
                    biome_LATE_SUMMER_TEMPERATURE_DECREASE = biomeOverride.LATE_SUMMER_TEMPERATURE_DECREASE;
                    biome_EARLY_AUTUMN_TEMPERATURE_DECREASE = biomeOverride.EARLY_AUTUMN_TEMPERATURE_DECREASE;
                    biome_MID_AUTUMN_TEMPERATURE_DECREASE = biomeOverride.MID_AUTUMN_TEMPERATURE_DECREASE;
                    biome_LATE_AUTUMN_TEMPERATURE_DECREASE = biomeOverride.LATE_AUTUMN_TEMPERATURE_DECREASE;
                    biome_EARLY_WINTER_TEMPERATURE_DECREASE = biomeOverride.EARLY_WINTER_TEMPERATURE_DECREASE;
                    biome_MID_WINTER_TEMPERATURE_DECREASE = biomeOverride.MID_WINTER_TEMPERATURE_DECREASE;
                    biome_LATE_WINTER_TEMPERATURE_DECREASE = biomeOverride.LATE_WINTER_TEMPERATURE_DECREASE;
                }
            }
            float currentTime = entityLiving.field_70170_p.func_72820_D();
            if (EnviroMine.isHbmSpaceLoaded) {
                temperatureChange = EM_StatusManager_NTM_SPACE.TemperatureChangeSpace(entityLiving, currentTime, biome_DAWN_TEMPERATURE_DECREASE_TERRAFORMED, biome_DAY_TEMPERATURE_DECREASE_TERRAFORMED, biome_DUSK_TEMPERATURE_DECREASE_TERRAFORMED, biome_NIGHT_TEMPERATURE_DECREASE_TERRAFORMED, biome_DAWN_TEMPERATURE_DECREASE, biome_DAY_TEMPERATURE_DECREASE, biome_DUSK_TEMPERATURE_DECREASE, biome_NIGHT_TEMPERATURE_DECREASE);
                airVentConst = EM_StatusManager_NTM_SPACE.getAirVentConst(entityLiving);
            } else {
                temperatureChange = EM_StatusManager.calculateTemperatureChange(currentTime % 24000.0f, biome_DAWN_TEMPERATURE_DECREASE, biome_DAY_TEMPERATURE_DECREASE, biome_DUSK_TEMPERATURE_DECREASE, biome_NIGHT_TEMPERATURE_DECREASE);
            }
            biomeTemperature -= temperatureChange * TemperatureMultiplier;
            if (EnviroMine.isSereneSeasonsLoaded) {
                biomeTemperature = EM_StatusManager_SS.getTempDecreaseSeason(entityLiving, biomeTemperature, biome_EARLY_SPRING_TEMPERATURE_DECREASE, biome_MID_SPRING_TEMPERATURE_DECREASE, biome_LATE_SPRING_TEMPERATURE_DECREASE, biome_EARLY_SUMMER_TEMPERATURE_DECREASE, biome_MID_SUMMER_TEMPERATURE_DECREASE, biome_LATE_SUMMER_TEMPERATURE_DECREASE, biome_EARLY_AUTUMN_TEMPERATURE_DECREASE, biome_MID_AUTUMN_TEMPERATURE_DECREASE, biome_LATE_AUTUMN_TEMPERATURE_DECREASE, biome_EARLY_WINTER_TEMPERATURE_DECREASE, biome_MID_WINTER_TEMPERATURE_DECREASE, biome_LATE_WINTER_TEMPERATURE_DECREASE);
            }
            if (EnviroMine.isHbmSpaceLoaded) {
                biomeTemperature = EM_StatusManager_NTM_SPACE.getBiomeTemperatureBlobs(entityLiving, biomeTemperature);
                airVentConst = EM_StatusManager_NTM_SPACE.getAirVentConstBlobs(entityLiving);
            }
        }
        List mobList = entityLiving.field_70170_p.func_72839_b((Entity)entityLiving, AxisAlignedBB.func_72330_a((double)(entityLiving.field_70165_t - 2.0), (double)(entityLiving.field_70163_u - 2.0), (double)(entityLiving.field_70161_v - 2.0), (double)(entityLiving.field_70165_t + 3.0), (double)(entityLiving.field_70163_u + 3.0), (double)(entityLiving.field_70161_v + 3.0)));
        Iterator iterator = mobList.iterator();
        float avgEntityTemp = 0.0f;
        int validEntities = 0;
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entityLiving);
        if (tracker == null && EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
            EnviroMine.logger.log(Level.ERROR, "Tracker updating as null! Crash imminent!");
        }
        while (iterator.hasNext()) {
            Entity mob = (Entity)iterator.next();
            if (!(mob instanceof EntityLivingBase)) continue;
            EnviroDataTracker mobTrack = EM_StatusManager.lookupTracker((EntityLivingBase)mob);
            EntityProperties livingProps = null;
            if (EntityProperties.base.hasProperty(mob)) {
                livingProps = EntityProperties.base.getProperty(mob);
            }
            if (mob instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)mob;
                if (entityLiving instanceof EntityPlayer && entityLiving.func_70685_l(mob) && EM_Settings.villageAssist) {
                    Village village = entityLiving.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)villager.field_70165_t), MathHelper.func_76128_c((double)villager.field_70163_u), MathHelper.func_76128_c((double)villager.field_70161_v), 32);
                    long assistTime = villager.getEntityData().func_74763_f("Enviro_Assist_Time");
                    long worldTime = entityLiving.field_70170_p.field_73011_w.getWorldTime();
                    if (village != null && village.func_82684_a(entityLiving.func_70005_c_()) >= 5 && !villager.func_70631_g_() && Math.abs(worldTime - assistTime) > 24000L) {
                        FoodStats food;
                        if (villager.func_70946_n() == 2) {
                            if (sanityBoost < 5.0f) {
                                sanityBoost = 5.0f;
                            }
                            ((EntityPlayer)entityLiving).func_71064_a((StatBase)EnviroAchievements.tradingFavours, 1);
                        } else if (villager.func_70946_n() == 0 && isDay) {
                            if (tracker.hydration < 50.0f) {
                                tracker.hydration = 100.0f;
                                if (tracker.bodyTemp >= 38.0f) {
                                    tracker.bodyTemp -= 1.0f;
                                }
                                entityLiving.field_70170_p.func_72956_a((Entity)entityLiving, "random.drink", 1.0f, 1.0f);
                                villager.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                                villager.getEntityData().func_74772_a("Enviro_Assist_Time", worldTime);
                                ((EntityPlayer)entityLiving).func_71064_a((StatBase)EnviroAchievements.tradingFavours, 1);
                            }
                        } else if (villager.func_70946_n() == 4 && isDay && (food = ((EntityPlayer)entityLiving).func_71024_bL()).func_75116_a() <= 10) {
                            food.func_75114_a(20);
                            entityLiving.field_70170_p.func_72956_a((Entity)entityLiving, "random.burp", 0.5f, entityLiving.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                            villager.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                            villager.getEntityData().func_74772_a("Enviro_Assist_Time", worldTime);
                            ((EntityPlayer)entityLiving).func_71064_a((StatBase)EnviroAchievements.tradingFavours, 1);
                        }
                    }
                }
            }
            if (livingProps != null && entityLiving.func_70685_l(mob)) {
                if (sanityRate >= livingProps.ambSanity && livingProps.ambSanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate += livingProps.ambSanity;
                } else if (sanityRate <= livingProps.ambSanity && livingProps.ambSanity > 0.0f && sanityBoost < livingProps.ambSanity) {
                    sanityBoost += livingProps.ambSanity;
                }
                if (livingProps.ambAir > 0.0f) {
                    leaves += (double)(livingProps.ambAir / 0.1f);
                } else if (quality >= livingProps.ambAir && livingProps.ambAir < 0.0f && quality <= 0.0f) {
                    quality += livingProps.ambAir;
                }
                dehydrateBonus -= livingProps.ambHydration;
            }
            if (mobTrack != null) {
                avgEntityTemp = livingProps != null ? (!livingProps.bodyTemp || !livingProps.shouldTrack ? (avgEntityTemp += livingProps.ambTemp) : (avgEntityTemp += mobTrack.bodyTemp)) : (avgEntityTemp += mobTrack.bodyTemp);
                ++validEntities;
                continue;
            }
            if (livingProps != null) {
                avgEntityTemp = !livingProps.bodyTemp || !livingProps.shouldTrack ? (avgEntityTemp += livingProps.ambTemp) : (avgEntityTemp += 36.6f);
                ++validEntities;
                continue;
            }
            if (mob instanceof EntityMob) continue;
            avgEntityTemp += 36.6f;
            ++validEntities;
        }
        if (validEntities > 0 && biomeTemperature < (avgEntityTemp /= (float)validEntities) - EM_Settings.RealTemperatureConstant) {
            biomeTemperature = (biomeTemperature + (avgEntityTemp - EM_Settings.RealTemperatureConstant)) / EM_Settings.AvgEntityTempDivider;
        }
        float fireProt = 0.0f;
        ItemStack helmet = entityLiving.func_71124_b(4);
        ItemStack plate = entityLiving.func_71124_b(3);
        ItemStack legs = entityLiving.func_71124_b(2);
        ItemStack boots = entityLiving.func_71124_b(1);
        float tempMultTotal = 0.0f;
        float addTemp = 0.0f;
        if (helmet != null) {
            NBTTagList enchTags = helmet.func_77986_q();
            if (enchTags != null) {
                for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = enchTags.func_150305_b(index).func_74765_d("id");
                    short enLV = enchTags.func_150305_b(index).func_74765_d("lvl");
                    if (enID == Enchantment.field_77340_h.field_77352_x) {
                        leaves += (double)(3.0f * (float)enLV);
                        continue;
                    }
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(helmet)) {
                ArmorProperties props = ArmorProperties.base.getProperty(helmet);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && biomeTemperature > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (props.air > 0.0f) {
                    leaves += (double)(props.air / 0.1f);
                } else if (quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality += props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate += props.sanity;
                } else if (sanityBoost <= props.sanity && props.sanity > 0.0f) {
                    sanityBoost += props.sanity;
                }
            }
        }
        if (plate != null) {
            NBTTagList enchTags = plate.func_77986_q();
            if (enchTags != null) {
                for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = enchTags.func_150305_b(index).func_74765_d("id");
                    short enLV = enchTags.func_150305_b(index).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(plate)) {
                ArmorProperties props = ArmorProperties.base.getProperty(plate);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && biomeTemperature > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality += props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate += props.sanity;
                } else if (sanityBoost <= props.sanity && props.sanity > 0.0f) {
                    sanityBoost += props.sanity;
                }
            }
        }
        if (legs != null) {
            NBTTagList enchTags = legs.func_77986_q();
            if (enchTags != null) {
                for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = enchTags.func_150305_b(index).func_74765_d("id");
                    short enLV = enchTags.func_150305_b(index).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(legs)) {
                ArmorProperties props = ArmorProperties.base.getProperty(legs);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && biomeTemperature > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality += props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate += props.sanity;
                } else if (sanityBoost <= props.sanity && props.sanity > 0.0f) {
                    sanityBoost += props.sanity;
                }
            }
        }
        if (boots != null) {
            NBTTagList enchTags = boots.func_77986_q();
            if (enchTags != null) {
                for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = enchTags.func_150305_b(index).func_74765_d("id");
                    short enLV = enchTags.func_150305_b(index).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(boots)) {
                ArmorProperties props = ArmorProperties.base.getProperty(boots);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && biomeTemperature > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality += props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate += props.sanity;
                } else if (sanityBoost <= props.sanity && props.sanity > 0.0f) {
                    sanityBoost += props.sanity;
                }
            }
        }
        biomeTemperature *= 1.0f + tempMultTotal;
        biomeTemperature += addTemp;
        fireProt = 1.0f - fireProt / 18.0f;
        float TemperatureWaterDecrease = 10.0f;
        float dropSpeedWater = 0.01f;
        if (BiomeProperties.base.hasProperty(biome) && (biomeProps = BiomeProperties.base.getProperty(biome)) != null && biomeProps.biomeOveride) {
            TemperatureWaterDecrease = biomeProps.TemperatureWaterDecrease;
            dropSpeedWater = biomeProps.dropSpeedWater;
        }
        if (entityLiving.func_70090_H()) {
            biomeTemperature -= TemperatureWaterDecrease;
            dropSpeed = dropSpeedWater;
        }
        float ambientTemperature = 0.0f;
        if (blockAndItemTempInfluence > biomeTemperature) {
            ambientTemperature = (biomeTemperature + blockAndItemTempInfluence) / EM_Settings.AmbTemp_Bl_It_TempInf_Div;
            if (blockAndItemTempInfluence > biomeTemperature + EM_Settings.AmbTemp_Bl_It_TempInf_For_RiseSpeedConst) {
                riseSpeed = EM_Settings.AmbTemp_Bl_It_TempInf_RiseSpeedConst;
            }
        } else {
            ambientTemperature = biomeTemperature;
        }
        if (entityLiving.func_70660_b(Potion.field_76438_s) != null) {
            dehydrateBonus += EM_Settings.HungerEffectDehydrateBonus;
        }
        if (nearLava) {
            if (riseSpeed <= EM_Settings.NearLavaMinRiseSpeed) {
                riseSpeed = EM_Settings.NearLavaMinRiseSpeed;
            }
            dehydrateBonus += EM_Settings.NearLavaDehydrateBonus;
            if (animalHostility == 0) {
                animalHostility = 1;
            }
        }
        if (BiomeProperties.base.hasProperty(biome) && (biomeProp = BiomeProperties.base.getProperty(biome)) != null && biomeProp.biomeOveride) {
            dehydrateBonus += biomeProp.dehydrateRate;
            if (biomeProp.tempRate > 0.0f) {
                riseSpeed += biomeProp.tempRate;
            } else {
                dropSpeed += biomeProp.tempRate;
            }
            float temperatureRate = 0.0f;
            if (biomeProp.tempRate_DAWN != 0.0f || biomeProp.tempRate_DAY != 0.0f || biomeProp.tempRate_DUSK != 0.0f || biomeProp.tempRate_NIGHT != 0.0f) {
                float currentTime = entityLiving.field_70170_p.func_72820_D();
                temperatureRate = EnviroMine.isHbmSpaceLoaded ? EM_StatusManager_NTM_SPACE.TemperatureRateChangeSpace(entityLiving, currentTime, biomeProp.tempRate_DAWN, biomeProp.tempRate_DAY, biomeProp.tempRate_DUSK, biomeProp.tempRate_NIGHT) : EM_StatusManager.calculateTemperatureChange(currentTime % 24000.0f, biomeProp.tempRate_DAWN, biomeProp.tempRate_DAY, biomeProp.tempRate_DUSK, biomeProp.tempRate_NIGHT);
            }
            if (!airVentConst) {
                if (temperatureRate > 0.0f) {
                    riseSpeed += temperatureRate;
                } else {
                    dropSpeed -= temperatureRate;
                }
            }
            sanityRate += biomeProp.sanityRate;
        }
        if (biome.func_76744_g() == 0 && isDay) {
            dehydrateBonus += EM_Settings.NoBiomeRainfallDayDehydrateBonus;
            if (animalHostility == 0) {
                animalHostility = 1;
            }
        }
        boolean ImmunityBurning = ArmorTempUtils.getTempResistance(entityLiving);
        boolean ImmunityFull = ArmorTempUtils.getTempSealing(entityLiving);
        if (!ImmunityFull && !entityLiving.func_70644_a(Potion.field_76426_n)) {
            if (entityLiving.field_70170_p.func_147439_a(i, j, k).func_149688_o() == Material.field_151587_i) {
                if (ImmunityBurning) {
                    ambientTemperature += EM_Settings.BurningambientTemperature;
                    riseSpeed = EM_Settings.RiseSpeedLavaDecr;
                } else {
                    ambientTemperature += EM_Settings.LavaBlockAmbientTemperature;
                    riseSpeed = EM_Settings.RiseSpeedLava;
                }
            } else if (entityLiving.func_70027_ad() && !ImmunityBurning) {
                if (ambientTemperature <= EM_Settings.BurningambientTemperature) {
                    ambientTemperature += EM_Settings.BurningambientTemperature;
                }
                if (riseSpeed < EM_Settings.RiseSpeedMin) {
                    riseSpeed = EM_Settings.RiseSpeedMin;
                }
            }
        }
        quality = (float)((double)quality + leaves * (double)0.1f);
        sanityRate += sanityBoost;
        if (quality < 0.0f) {
            quality *= solidBlocks / totalBlocks;
        }
        if (entityLiving.func_70051_ag()) {
            dehydrateBonus += EM_Settings.SprintDehydrateBonus;
            if (riseSpeed < EM_Settings.SprintMinRiseSpeed) {
                riseSpeed = EM_Settings.SprintMinRiseSpeed;
            }
            ambientTemperature += EM_Settings.SprintambientTemperature;
        }
        if (dimensionProp != null && dimensionProp.override) {
            quality = quality * dimensionProp.airMulti + dimensionProp.airRate;
            riseSpeed = riseSpeed * dimensionProp.tempMulti + dimensionProp.tempRate;
            dropSpeed = dropSpeed * dimensionProp.tempMulti + dimensionProp.tempRate;
            sanityRate = sanityRate * dimensionProp.sanityMulti + dimensionProp.sanityRate;
            dehydrateBonus = dehydrateBonus * dimensionProp.hydrationMulti + dimensionProp.hydrationRate;
        }
        data[0] = quality * (float)EM_Settings.airMult;
        data[1] = entityLiving.func_70644_a(Potion.field_76426_n) && ambientTemperature > 36.6f ? 36.6f : (ambientTemperature > 36.6f ? 36.6f + (ambientTemperature - 36.6f) * fireProt : ambientTemperature);
        data[2] = nearLava ? 1.0f : 0.0f;
        data[3] = dehydrateBonus * (float)EM_Settings.hydrationMult;
        data[4] = dropSpeed * (float)EM_Settings.tempMult;
        data[5] = riseSpeed * (float)EM_Settings.tempMult * (tracker.bodyTemp < 36.6f ? 1.0f : fireProt);
        data[6] = animalHostility;
        data[7] = sanityRate * (float)EM_Settings.sanityMult;
        if (EnviroMine.proxy.isClient() && entityLiving.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && timer.isRunning()) {
            timer.stop();
            Debug_Info.DB_timer = timer.toString();
            timer.reset();
        }
        return data;
    }

    public static float calculateTemperatureChange(float currentTime, float DAWN_TEMPERATURE, float DAY_TEMPERATURE, float DUSK_TEMPERATURE, float NIGHT_TEMPERATURE) {
        float temperatureChange = currentTime >= 0.0f && currentTime < 6000.0f ? DAWN_TEMPERATURE - (DAWN_TEMPERATURE - DAY_TEMPERATURE) / 6000.0f * currentTime : (currentTime >= 6000.0f && currentTime < 12000.0f ? DAY_TEMPERATURE + (DUSK_TEMPERATURE - DAY_TEMPERATURE) / 6000.0f * (currentTime - 6000.0f) : (currentTime >= 12000.0f && currentTime < 18000.0f ? DUSK_TEMPERATURE + (NIGHT_TEMPERATURE - DUSK_TEMPERATURE) / 6000.0f * (currentTime - 12000.0f) : (currentTime >= 18000.0f && currentTime < 24000.0f ? NIGHT_TEMPERATURE - (NIGHT_TEMPERATURE - DAWN_TEMPERATURE) / 6000.0f * (currentTime - 18000.0f) : 0.0f)));
        return temperatureChange;
    }

    public static float calculateTemperatureChangeSpace(float currentTime, float phasePeriod, float DAWN_TEMPERATURE, float DAY_TEMPERATURE, float DUSK_TEMPERATURE, float NIGHT_TEMPERATURE) {
        float temperatureChange = currentTime >= 0.0f && currentTime < phasePeriod ? DAWN_TEMPERATURE - (DAWN_TEMPERATURE - DAY_TEMPERATURE) / phasePeriod * currentTime : (currentTime >= phasePeriod && currentTime < phasePeriod * 2.0f ? DAY_TEMPERATURE + (DUSK_TEMPERATURE - DAY_TEMPERATURE) / phasePeriod * (currentTime - phasePeriod) : (currentTime >= phasePeriod * 2.0f && currentTime < phasePeriod * 3.0f ? DUSK_TEMPERATURE + (NIGHT_TEMPERATURE - DUSK_TEMPERATURE) / phasePeriod * (currentTime - phasePeriod * 2.0f) : (currentTime >= phasePeriod * 3.0f && currentTime < phasePeriod * 4.0f ? NIGHT_TEMPERATURE - (NIGHT_TEMPERATURE - DAWN_TEMPERATURE) / phasePeriod * (currentTime - phasePeriod * 3.0f) : 0.0f)));
        return temperatureChange;
    }

    public static void removeTracker(EnviroDataTracker tracker) {
        if (trackerList.containsValue(tracker)) {
            tracker.isDisabled = true;
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(tracker.trackedEntity.func_70005_c_());
            } else {
                trackerList.remove("" + tracker.trackedEntity.func_145782_y());
            }
        }
    }

    public static void saveAndRemoveTracker(EnviroDataTracker tracker) {
        if (trackerList.containsValue(tracker)) {
            tracker.isDisabled = true;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(tracker.trackedEntity.func_70005_c_());
            } else {
                trackerList.remove("" + tracker.trackedEntity.func_145782_y());
            }
        }
    }

    public static void saveTracker(EnviroDataTracker tracker) {
        NBTTagCompound tags = tracker.trackedEntity.getEntityData();
        tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
        tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
        tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
        tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
    }

    public static void removeAllTrackers() {
        for (EnviroDataTracker tracker : trackerList.values()) {
            tracker.isDisabled = true;
        }
        trackerList.clear();
    }

    public static void saveAndDeleteAllTrackers() {
        for (EnviroDataTracker tracker : trackerList.values()) {
            tracker.isDisabled = true;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
        }
        trackerList.clear();
    }

    public static void saveAndDeleteWorldTrackers(World world) {
        HashMap<String, EnviroDataTracker> tempList = new HashMap<String, EnviroDataTracker>(trackerList);
        for (EnviroDataTracker tracker : tempList.values()) {
            if (tracker.trackedEntity.field_70170_p != world) continue;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
            tracker.isDisabled = true;
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(tracker.trackedEntity.func_70005_c_());
                continue;
            }
            trackerList.remove("" + tracker.trackedEntity.func_145782_y());
        }
    }

    public static void saveAllWorldTrackers(World world) {
        HashMap<String, EnviroDataTracker> tempList = new HashMap<String, EnviroDataTracker>(trackerList);
        for (EnviroDataTracker tracker : tempList.values()) {
            if (tracker.trackedEntity.field_70170_p != world) continue;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
        }
    }

    public static EntityPlayer findPlayer(String username) {
        World[] worlds = new World[1];
        if (EnviroMine.proxy.isClient()) {
            if (Minecraft.func_71410_x().func_71387_A()) {
                worlds = MinecraftServer.func_71276_C().field_71305_c;
            } else {
                worlds[0] = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            }
        } else {
            worlds = MinecraftServer.func_71276_C().field_71305_c;
        }
        for (int i = worlds.length - 1; i >= 0; --i) {
            EntityPlayer player;
            if (worlds[i] == null || (player = worlds[i].func_72924_a(username)) == null || !player.func_70089_S()) continue;
            return player;
        }
        return null;
    }

    public static void createFX(EntityLivingBase entityLiving) {
        float rndX = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70130_N * 2.0f - entityLiving.field_70130_N;
        float rndY = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70131_O;
        float rndZ = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70130_N * 2.0f - entityLiving.field_70130_N;
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entityLiving);
        if (entityLiving instanceof EntityPlayer && !(entityLiving instanceof EntityPlayerMP)) {
            rndY = -rndY;
        }
        if (tracker != null) {
            if (tracker.bodyTemp >= EM_Settings.SweatTemperature && UI_Settings.sweatParticals) {
                entityLiving.field_70170_p.func_72869_a("dripWater", entityLiving.field_70165_t + (double)rndX, entityLiving.field_70163_u + (double)rndY, entityLiving.field_70161_v + (double)rndZ, 0.0, 0.0, 0.0);
            }
            if (tracker.trackedEntity.func_70644_a((Potion)EnviroPotion.insanity) && UI_Settings.insaneParticals) {
                entityLiving.field_70170_p.func_72869_a("portal", entityLiving.field_70165_t + (double)rndX, entityLiving.field_70163_u + (double)rndY, entityLiving.field_70161_v + (double)rndZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public static float getTempFalloff(float blockTemperature, float cartesianDistance, int scanRadius, float dropoffPower) {
        return cartesianDistance <= (float)scanRadius ? (float)((double)blockTemperature * (1.0 - Math.pow(MathHelper.func_76131_a((float)(cartesianDistance - EM_Settings.auraRadius), (float)0.0f, (float)scanRadius) / (float)scanRadius, 1.0f / dropoffPower))) : 0.0f;
    }
}

