/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers;

import com.google.common.base.Stopwatch;
import enviromine.EntityPhysicsBlock;
import enviromine.client.gui.hud.items.Debug_Info;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.compat.EM_PhysManager_TC;
import enviromine.trackers.properties.BlockProperties;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.trackers.properties.StabilityType;
import enviromine.utils.EnviroUtils;
import enviromine.utils.misc.CompatSafe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;

@CompatSafe
public class EM_PhysManager {
    public static ArrayList<String> usedSlidePositions = new ArrayList();
    public static HashMap<String, String> excluded = new HashMap();
    public static ArrayList<Object[]> physSchedule = new ArrayList();
    public static HashMap<String, Long> chunkDelay = new HashMap();
    public static int currentTime = 0;
    public static int debugInterval = 30;
    public static int debugTime = 0;
    public static int debugUpdatesCaptured = 0;
    private static Stopwatch timer = Stopwatch.createUnstarted();
    public static long worldStartTime = -1L;

    public static void schedulePhysUpdate(World world, int x, int y, int z, boolean updateSelf, String type) {
        if (world.field_72995_K || world.func_82737_E() < worldStartTime + (long)EM_Settings.worldDelay) {
            return;
        }
        if (chunkDelay.containsKey(world.field_73011_w.field_76574_g + "" + (x >> 4) + "," + (z >> 4)) && chunkDelay.get(world.field_73011_w.field_76574_g + "" + (x >> 4) + "," + (z >> 4)) > world.func_82737_E()) {
            return;
        }
        DimensionProperties dProps = EM_Settings.dimensionProperties.get(world.field_73011_w.field_76574_g);
        if (dProps != null && !dProps.physics) {
            return;
        }
        Object[] entry = new Object[]{world, x, y, z, updateSelf, type};
        physSchedule.add(entry);
    }

    public static void scheduleSlideUpdate(World world, int x, int y, int z) {
        if (world.field_72995_K || world.func_82737_E() < worldStartTime + (long)EM_Settings.worldDelay) {
            return;
        }
        if (chunkDelay.containsKey(world.field_73011_w.field_76574_g + "" + (x >> 4) + "," + (z >> 4)) && chunkDelay.get(world.field_73011_w.field_76574_g + "" + (x >> 4) + "," + (z >> 4)) > world.func_82737_E()) {
            return;
        }
        DimensionProperties dProps = EM_Settings.dimensionProperties.get(world.field_73011_w.field_76574_g);
        if (dProps != null && !dProps.physics) {
            return;
        }
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        Object[] entry = new Object[]{world, x, y, z, true, "Slide"};
        physSchedule.add(entry);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateSurroundingWithExclusions(World world, int x, int y, int z, boolean updateSelf, String type) {
        if (world.field_72995_K) {
            return;
        }
        int i = -1;
        block0: while (i <= 1) {
            int j = -1;
            while (true) {
                if (j <= 1) {
                } else {
                    ++i;
                    continue block0;
                }
                for (int k = -1; k <= 1; ++k) {
                    block11: {
                        if (timer.elapsed(TimeUnit.SECONDS) > 2L) {
                            return;
                        }
                        String position = x + i + "," + (y + j) + "," + (z + k);
                        if (i == 0 && j == 0 && k == 0) {
                            if (updateSelf) {
                                EM_PhysManager.callPhysUpdate(world, x, y, z, type);
                                break block11;
                            } else {
                                excluded.put(position, type);
                                continue;
                            }
                        }
                        EM_PhysManager.callPhysUpdate(world, x + i, y + j, k + z, type);
                    }
                    if (physSchedule.size() > 0) continue;
                    return;
                }
                ++j;
            }
            break;
        }
        return;
    }

    public static void callPhysUpdate(World world, int x, int y, int z, String type) {
        if (world.field_72995_K) {
            return;
        }
        EM_PhysManager.callPhysUpdate(world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void callPhysUpdate(World world, int x, int y, int z, Block block, int meta, String type) {
        String position = x + "," + y + "," + z;
        if (excluded.containsKey(position)) {
            if (excluded.get(position).equals("Collapse") || !type.equals("Collapse")) return;
            excluded.put(position, type);
        } else {
            excluded.put(position, type);
        }
        if (world.field_72995_K || world.func_82737_E() < worldStartTime + (long)EM_Settings.worldDelay) {
            return;
        }
        if (chunkDelay.containsKey(world.field_73011_w.field_76574_g + "" + (x >> 4) + "," + (z >> 4)) && chunkDelay.get(world.field_73011_w.field_76574_g + "" + (x >> 4) + "," + (z >> 4)) > world.func_82737_E()) {
            return;
        }
        DimensionProperties dProps = EM_Settings.dimensionProperties.get(world.field_73011_w.field_76574_g);
        if (dProps != null && !dProps.physics) {
            return;
        }
        boolean locLoaded = false;
        locLoaded = world.func_72863_F().func_73149_a(x >> 4, z >> 4) ? world.func_72964_e((int)(x >> 4), (int)(z >> 4)).field_76636_d : false;
        if (world.field_72995_K || block == null || !locLoaded) {
            return;
        }
        if (EnviroMine.proxy.isClient()) {
            ++debugUpdatesCaptured;
        }
        int[] blockData = EM_PhysManager.getSurroundingBlockData(world, x, y, z);
        boolean waterLogged = false;
        boolean touchingWaterDirect = blockData[2] > 0;
        boolean touchingWater = blockData[3] > 0;
        BlockProperties blockProps = null;
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk != null) {
            waterLogged = chunk.func_76591_a((int)(x & 0xF), (int)(z & 0xF), (WorldChunkManager)world.func_72959_q()).field_76751_G > 0.0f && world.func_72896_J() && world.func_72937_j(x, y + 1, z) || touchingWater;
        }
        boolean validSlideType = false;
        boolean emptyBelow = BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z);
        if (EM_Settings.blockProperties.containsKey("" + Block.field_149771_c.func_148750_c((Object)block) + "," + meta) || EM_Settings.blockProperties.containsKey("" + Block.field_149771_c.func_148750_c((Object)block))) {
            blockProps = EM_Settings.blockProperties.containsKey("" + Block.field_149771_c.func_148750_c((Object)block) + "," + meta) ? EM_Settings.blockProperties.get("" + Block.field_149771_c.func_148750_c((Object)block) + "," + meta) : EM_Settings.blockProperties.get("" + Block.field_149771_c.func_148750_c((Object)block));
            boolean bl = validSlideType = blockProps.slides || (waterLogged || touchingWater) && blockProps.wetSlide;
        }
        if (validSlideType && EM_Settings.enableLandslide) {
            if (!(block instanceof BlockFalling) && blockData[4] >= 1) {
                return;
            }
            Block slideBlock = block;
            int slideMeta = meta;
            int[] pos = new int[]{x, y, z};
            int[] npos = EM_PhysManager.slideDirection(world, pos, true);
            int[] ppos = EM_PhysManager.slideDirection(world, pos, false);
            TileEntity tile = world.func_147438_o(x, y, z);
            NBTTagCompound nbtTC = new NBTTagCompound();
            if (tile != null) {
                tile.func_145841_b(nbtTC);
            }
            if (emptyBelow) {
                if (!(block instanceof BlockFalling) && !usedSlidePositions.contains("" + pos[0] + "," + pos[2])) {
                    EntityPhysicsBlock physBlock = new EntityPhysicsBlock(world, (double)pos[0] + 0.5, (double)pos[1] + 0.5, (double)pos[2] + 0.5, slideBlock, slideMeta, false);
                    if (tile != null) {
                        physBlock.field_145810_d = nbtTC;
                    }
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                    physBlock.isLandSlide = true;
                    world.func_72838_d((Entity)physBlock);
                    EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Collapse");
                    return;
                }
            } else {
                if (!(pos[0] == npos[0] && pos[1] == npos[1] && pos[2] == npos[2] || usedSlidePositions.contains("" + npos[0] + "," + npos[2]))) {
                    EntityPhysicsBlock physBlock = new EntityPhysicsBlock(world, (double)npos[0] + 0.5, (double)npos[1] + 0.5, (double)npos[2] + 0.5, slideBlock, slideMeta, false);
                    if (tile != null) {
                        physBlock.field_145810_d = nbtTC;
                    }
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                    physBlock.isLandSlide = true;
                    world.func_72838_d((Entity)physBlock);
                    EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Collapse");
                    return;
                }
                if (pos[0] != ppos[0] || pos[1] != ppos[1] || pos[2] != ppos[2]) {
                    EM_PhysManager.scheduleSlideUpdate(world, x, y, z);
                }
            }
        }
        if (!EM_PhysManager.isLegalType(world, x, y, z) || !EM_PhysManager.blockNotSolid(world, x, y - 1, z, false) || blockData[4] > 0) return;
        Block dropBlock = block;
        int dropMeta = -1;
        int dropNum = -1;
        int dropType = 0;
        boolean isCustom = false;
        boolean defaultDrop = true;
        if (blockProps != null) {
            isCustom = true;
            defaultDrop = false;
            if (blockProps.dropName.equals("")) {
                dropType = -1;
                defaultDrop = true;
                dropNum = blockProps.dropNum;
            } else if (Block.func_149684_b((String)blockProps.dropName) != null && blockProps.dropNum <= 0) {
                dropType = 1;
                dropBlock = Block.func_149684_b((String)blockProps.dropName);
                dropMeta = blockProps.dropMeta <= -1 ? -1 : blockProps.dropMeta;
                dropNum = 0;
            } else if (Item.func_150898_a((Block)Block.func_149684_b((String)blockProps.dropName)) != null && blockProps.dropNum > 0) {
                dropType = 2;
                dropBlock = Item.func_150898_a((Block)Block.func_149684_b((String)blockProps.dropName));
                dropMeta = blockProps.dropMeta <= -1 ? -1 : blockProps.dropMeta;
                dropNum = blockProps.dropNum;
            } else {
                dropType = 0;
                dropBlock = null;
                dropMeta = -1;
                dropNum = -1;
            }
        }
        if (defaultDrop) {
            if (dropBlock == null || dropBlock == Blocks.field_150350_a || block.func_149688_o() == Material.field_151592_s || block.func_149688_o() == Material.field_151588_w) {
                dropType = 0;
            } else if (block instanceof BlockLeavesBase) {
                dropType = -1;
            } else if (EnviroMine.isTCLoaded) {
                if (EM_PhysManager_TC.checkLeaves(block)) {
                    dropType = -1;
                }
            } else {
                dropType = dropBlock instanceof Block ? 1 : (dropBlock instanceof Item ? 2 : -1);
            }
        }
        int minThreshold = 10;
        int maxThreshold = 15;
        int supportDist = 1;
        int yMax = 1;
        StabilityType stabType = EnviroUtils.getDefaultStabilityType(block);
        if (isCustom) {
            minThreshold = blockProps.minFall;
            maxThreshold = blockProps.maxFall;
            supportDist = blockProps.supportDist;
            yMax = blockProps.canHang ? 2 : 1;
        } else if (stabType != null) {
            minThreshold = stabType.minFall;
            maxThreshold = stabType.maxFall;
            supportDist = stabType.supportDist;
            yMax = stabType.canHang ? 2 : 1;
        }
        int missingBlocks = 0;
        missingBlocks = yMax >= 2 ? blockData[0] : blockData[1];
        int dropChance = maxThreshold - missingBlocks;
        if (dropChance <= 0) {
            dropChance = 1;
        }
        boolean supported = EM_PhysManager.hasSupports(world, x, y, z, touchingWaterDirect && EM_Settings.waterCollapse ? MathHelper.func_76128_c((double)((double)supportDist / 2.0)) : supportDist);
        if (missingBlocks <= 0 || !EM_PhysManager.blockNotSolid(world, x, y - 1, z, false) || supported) return;
        if (!world.field_72995_K && (missingBlocks > minThreshold && (world.field_73012_v.nextInt(dropChance) == 0 || type.equals("Collapse")) || missingBlocks >= maxThreshold || touchingWaterDirect && EM_Settings.waterCollapse && world.field_73012_v.nextBoolean())) {
            if (dropType == -1) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (world.func_72805_g(x, y, z) << 12));
                block.func_149697_b(world, x, y, z, meta, 0);
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                return;
            }
            if (dropType == 2) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (world.func_72805_g(x, y, z) << 12));
                if (isCustom && dropMeta > -1) {
                    if (dropNum >= 1) {
                        if (dropBlock instanceof Item) {
                            EM_PhysManager.dropItemstack(world, x, y, z, new ItemStack((Item)dropBlock, dropNum, dropMeta));
                        } else if (dropBlock instanceof Block) {
                            EM_PhysManager.dropItemstack(world, x, y, z, new ItemStack(dropBlock, dropNum, dropMeta));
                        }
                    }
                } else if (isCustom && dropNum >= 1) {
                    if (dropBlock instanceof Item) {
                        EM_PhysManager.dropItemstack(world, x, y, z, new ItemStack((Item)dropBlock, dropNum, meta));
                    } else if (dropBlock instanceof Block) {
                        EM_PhysManager.dropItemstack(world, x, y, z, new ItemStack(dropBlock, dropNum, meta));
                    }
                } else if (!isCustom) {
                    block.func_149697_b(world, x, y, z, meta, 0);
                }
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Normal");
                return;
            }
            if (dropType == 0) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (world.func_72805_g(x, y, z) << 12));
                if (block == Blocks.field_150432_aD) {
                    Material mat = world.func_147439_a(x, y - 1, z).func_149688_o();
                    if ((mat.func_76230_c() || mat.func_76224_d()) && !world.field_73011_w.field_76575_d) {
                        world.func_147449_b(x, y, z, (Block)Blocks.field_150358_i);
                    } else {
                        world.func_147449_b(x, y, z, Blocks.field_150350_a);
                    }
                } else {
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                }
                if (block.func_149688_o() == Material.field_151588_w && !EM_Settings.spreadIce) return;
                EM_PhysManager.schedulePhysUpdate(world, x, y, z, true, "Break");
                return;
            }
            if (dropType != 1) {
                return;
            }
            if (block == Blocks.field_150348_b && EM_Settings.stoneCracks && !isCustom) {
                world.func_147449_b(x, y, z, Blocks.field_150347_e);
                dropBlock = Blocks.field_150347_e;
            } else if (block == Blocks.field_150349_c && !isCustom) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
                dropBlock = Blocks.field_150346_d;
            } else if (world.func_147439_a(x, y, z) != dropBlock) {
                world.func_147465_d(x, y, z, dropBlock, world.func_72805_g(x, y, z), 2);
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            NBTTagCompound nbtTC = new NBTTagCompound();
            if (tile != null) {
                tile.func_145841_b(nbtTC);
            }
            EntityPhysicsBlock entityphysblock = isCustom && dropMeta > -1 ? new EntityPhysicsBlock(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, dropBlock, dropMeta, true) : new EntityPhysicsBlock(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, dropBlock, world.func_72805_g(x, y, z), true);
            if (tile != null) {
                entityphysblock.field_145810_d = nbtTC;
            }
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), entityphysblock.block.field_149762_H.func_150496_b(), (entityphysblock.block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, entityphysblock.block.field_149762_H.func_150494_d() * 1.2f);
            world.func_72838_d((Entity)entityphysblock);
            return;
        } else {
            if (missingBlocks <= minThreshold || world.field_72995_K || !EM_Settings.stoneCracks) return;
            if (block == Blocks.field_150348_b && !isCustom) {
                world.func_147449_b(x, y, z, Blocks.field_150347_e);
                return;
            } else {
                if (block != Blocks.field_150349_c || isCustom) return;
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
            }
        }
    }

    public static int[] getSurroundingBlockData(World world, int x, int y, int z) {
        int[] data = new int[]{0, 0, 0, 0, 0};
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                for (int k = z - 1; k <= z + 1; ++k) {
                    Block block = world.func_147439_a(i, j, k);
                    Material material = block.func_149688_o();
                    int metaID = world.func_72805_g(i, j, k);
                    String name = Block.field_149771_c.func_148750_c((Object)block);
                    if (block == Blocks.field_150350_a) {
                        if (j < y + 1) {
                            data[1] = data[1] + 1;
                        }
                        data[0] = data[0] + 1;
                        continue;
                    }
                    StabilityType stabType = EnviroUtils.getDefaultStabilityType(block);
                    if (material != null && material.func_76224_d()) {
                        if (j >= y && (i == x || k == z)) {
                            data[2] = data[2] + 1;
                            data[3] = data[3] + 1;
                        } else {
                            data[3] = data[3] + 1;
                        }
                    }
                    BlockProperties blockProps = null;
                    if (EM_Settings.blockProperties.containsKey("" + name) || EM_Settings.blockProperties.containsKey("" + name + "," + metaID)) {
                        if (EM_Settings.blockProperties.containsKey("" + name + "," + metaID)) {
                            blockProps = EM_Settings.blockProperties.get("" + name + "," + metaID);
                        } else if (EM_Settings.blockProperties.containsKey("" + name)) {
                            blockProps = EM_Settings.blockProperties.get("" + name);
                        }
                    }
                    if (blockProps != null) {
                        if (blockProps.holdsOthers) {
                            data[4] = 1;
                        }
                    } else if (stabType != null && stabType != null && stabType.holdOther) {
                        data[4] = 1;
                    }
                    if (world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1))).size() > 0) {
                        if (j < y + 1) {
                            data[1] = data[1] + 1;
                        }
                        data[0] = data[0] + 1;
                        continue;
                    }
                    if (!EM_PhysManager.blockNotSolid(world, i, j, k, false) && (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151584_j || material != Material.field_151584_j) || i == x && j < y + 1 && k == z) continue;
                    if (j < y + 1) {
                        data[1] = data[1] + 1;
                    }
                    data[0] = data[0] + 1;
                }
            }
        }
        data[1] = data[1] + 9;
        return data;
    }

    public static boolean hasSupports(World world, int x, int y, int z, int dist) {
        int i;
        int k;
        Material material;
        Block block;
        boolean cancel;
        int k2;
        int i2;
        if (dist <= 0) {
            return false;
        }
        Block baseBlock = world.func_147439_a(x, y, z);
        Material baseMat = baseBlock == null ? Material.field_151579_a : baseBlock.func_149688_o();
        boolean isLeaves = baseMat == Material.field_151584_j;
        for (i2 = x - 1; i2 <= x + 1; ++i2) {
            for (k2 = z - 1; k2 <= z + 1; ++k2) {
                Material material2;
                int j = y - 1;
                Block block2 = world.func_147439_a(i2, j, k2);
                Material material3 = material2 = block2 == null ? Material.field_151579_a : block2.func_149688_o();
                if (EM_PhysManager.blockNotSolid(world, i2, j, k2, false) || material2 == Material.field_151584_j && !isLeaves) continue;
                return true;
            }
        }
        for (i2 = x + 1; i2 <= x + dist; ++i2) {
            k2 = z;
            cancel = false;
            for (int j = y - 1; j <= y; ++j) {
                block = world.func_147439_a(i2, j, k2);
                Material material4 = material = block == null ? Material.field_151579_a : block.func_149688_o();
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i2, j, k2, false) && (material != Material.field_151584_j || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i2, j, k2, false) || material == Material.field_151584_j && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        for (i2 = x - 1; i2 >= x - dist; --i2) {
            k2 = z;
            cancel = false;
            for (int j = y - 1; j <= y; ++j) {
                block = world.func_147439_a(i2, j, k2);
                Material material5 = material = block == null ? Material.field_151579_a : block.func_149688_o();
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i2, j, k2, false) && (material != Material.field_151584_j || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i2, j, k2, false) || material == Material.field_151584_j && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        for (k = z + 1; k <= z + dist; ++k) {
            i = x;
            cancel = false;
            for (int j = y - 1; j <= y; ++j) {
                block = world.func_147439_a(i, j, k);
                Material material6 = material = block == null ? Material.field_151579_a : block.func_149688_o();
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i, j, k, false) && (material != Material.field_151584_j || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i, j, k, false) || material == Material.field_151584_j && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        for (k = z - 1; k >= z - dist; --k) {
            i = x;
            cancel = false;
            for (int j = y - 1; j <= y; ++j) {
                block = world.func_147439_a(i, j, k);
                Material material7 = material = block == null ? Material.field_151579_a : block.func_149688_o();
                if (j == y) {
                    if (!EM_PhysManager.blockNotSolid(world, i, j, k, false) && (material != Material.field_151584_j || isLeaves)) continue;
                    cancel = true;
                    break;
                }
                if (EM_PhysManager.blockNotSolid(world, i, j, k, false) || material == Material.field_151584_j && !isLeaves) continue;
                return true;
            }
            if (cancel) break;
        }
        return false;
    }

    protected static void dropItemstack(World par1World, int par2, int par3, int par4, ItemStack par5ItemStack) {
        if (!par1World.field_72995_K && par1World.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(par1World.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(par1World.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(par1World.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(par1World, (double)par2 + d0, (double)par3 + d1, (double)par4 + d2, par5ItemStack);
            entityitem.field_145804_b = 10;
            par1World.func_72838_d((Entity)entityitem);
        }
    }

    public static boolean isLegalType(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        String name = Block.field_149771_c.func_148750_c((Object)block);
        int meta = world.func_72805_g(x, y, z);
        if (EM_Settings.blockProperties.containsKey("" + name + "," + meta) || EM_Settings.blockProperties.containsKey("" + name)) {
            if (EM_Settings.blockProperties.containsKey("" + name + "," + meta)) {
                BlockProperties blockProps = EM_Settings.blockProperties.get("" + name + "," + meta);
                return blockProps.hasPhys && !blockProps.holdsOthers;
            }
            BlockProperties blockProps = EM_Settings.blockProperties.get("" + name);
            return blockProps.hasPhys && !blockProps.holdsOthers;
        }
        if (block.func_149712_f(world, x, y, z) >= 0.0f) {
            StabilityType stabType = EnviroUtils.getDefaultStabilityType(block);
            if (stabType != null) {
                return stabType.enablePhysics && !stabType.holdOther;
            }
            return false;
        }
        return false;
    }

    public static boolean blockNotSolid(World world, int x, int y, int z, boolean isSliding) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        Material material = block.func_149688_o();
        if (block == Blocks.field_150480_ab) {
            return true;
        }
        if (material.func_76224_d()) {
            return !isSliding;
        }
        return block.func_149668_a(world, x, y, z) == null || !material.func_76230_c();
    }

    public static void updateSchedule() {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        if (physSchedule.size() >= 4096 && EM_Settings.updateCap <= -1) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "Physics updates exeeded 4096! Dumping update schedule");
            }
            physSchedule.clear();
            return;
        }
        if (EnviroMine.proxy.isClient() && debugTime == 0) {
            if (!timer.isRunning()) {
                timer.reset();
                timer.start();
            }
            debugUpdatesCaptured = 0;
        }
        boolean canClear = true;
        if (currentTime >= EM_Settings.physInterval) {
            int updateNum = 0;
            updateNum = physSchedule.size() <= EM_Settings.updateCap || EM_Settings.updateCap < 0 ? physSchedule.size() : EM_Settings.updateCap;
            int updateRem = physSchedule.size();
            for (int i = updateNum - 1; i >= 0; --i) {
                if (!MinecraftServer.func_71276_C().func_71278_l()) {
                    physSchedule.clear();
                    physSchedule = new ArrayList();
                    canClear = true;
                    break;
                }
                if (EnviroMine.proxy.isClient() && Minecraft.func_71410_x().func_71387_A()) {
                    if (Minecraft.func_71410_x().func_147113_T() && !EnviroMine.proxy.isOpenToLAN()) {
                        if (!timer.isRunning()) break;
                        timer.stop();
                        debugTime = 0;
                        break;
                    }
                    if (!timer.isRunning()) {
                        timer.start();
                    }
                }
                if (timer.elapsed(TimeUnit.SECONDS) > 2L) {
                    if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                        EnviroMine.logger.log(Level.ERROR, "Physics updates are taking too long! Dumping schedule!");
                    }
                    physSchedule.clear();
                    canClear = false;
                    break;
                }
                if (physSchedule.size() - 1 < i) {
                    if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                        EnviroMine.logger.log(Level.ERROR, "Unable to get physcis schedule entry, index out of bounds! (Size: " + physSchedule.size() + ", Index: " + i + ")");
                    }
                    canClear = false;
                    break;
                }
                Object[] entry = physSchedule.get(i);
                boolean locLoaded = false;
                locLoaded = ((World)entry[0]).func_72863_F().func_73149_a((Integer)entry[1] >> 4, (Integer)entry[3] >> 4) ? ((World)entry[0]).func_72964_e((int)(((Integer)entry[1]).intValue() >> 4), (int)(((Integer)entry[3]).intValue() >> 4)).field_76636_d : false;
                if (locLoaded) {
                    canClear = false;
                    if (((String)entry[5]).equalsIgnoreCase("Slide")) {
                        String position = (Integer)entry[1] + "," + (Integer)entry[2] + "," + (Integer)entry[3];
                        if (!excluded.containsKey(position)) {
                            excluded.put(position, (String)entry[5]);
                            EM_PhysManager.callPhysUpdate((World)entry[0], (Integer)entry[1], (Integer)entry[2], (Integer)entry[3], (String)entry[5]);
                        }
                    } else {
                        EM_PhysManager.updateSurroundingWithExclusions((World)entry[0], (Integer)entry[1], (Integer)entry[2], (Integer)entry[3], (Boolean)entry[4], (String)entry[5]);
                    }
                }
                if (physSchedule.size() < updateRem) {
                    if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                        EnviroMine.logger.log(Level.ERROR, "Physics schedule dumped early! Resetting scheduler...");
                    }
                    physSchedule.clear();
                    canClear = false;
                    break;
                }
                if (physSchedule.size() - 1 >= i) {
                    physSchedule.remove(i);
                } else if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Failed to remove entry from physics schedule. Things may break badly!");
                }
                updateRem = physSchedule.size();
            }
            currentTime = 0;
        } else {
            ++currentTime;
        }
        if (canClear) {
            excluded.clear();
            usedSlidePositions.clear();
        }
        if (EnviroMine.proxy.isClient() && debugTime >= debugInterval && timer.isRunning()) {
            timer.stop();
            Debug_Info.DB_physTimer = timer.toString();
            Debug_Info.DB_physUpdates = debugUpdatesCaptured;
            Debug_Info.DB_physBuffer = physSchedule.size();
            timer.reset();
            debugTime = 0;
        } else if (EnviroMine.proxy.isClient()) {
            ++debugTime;
        }
    }

    public static int[] slideDirection(World world, int[] pos, boolean checkEntities) {
        if (pos.length != 3) {
            return pos;
        }
        int[] npos = new int[3];
        int x = pos[0];
        int y = pos[1];
        int z = pos[2];
        npos[0] = x;
        npos[1] = y;
        npos[2] = z;
        ArrayList<String> canSlideDir = new ArrayList<String>();
        if (EM_PhysManager.blockNotSolid(world, x + 1, y, z, true) && EM_PhysManager.blockNotSolid(world, x + 1, y - 1, z, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)(x + 1), (double)(y - 2), (double)z, (double)(x + 2), (double)y, (double)(z + 1))).size() <= 0)) {
            canSlideDir.add("X+");
        }
        if (EM_PhysManager.blockNotSolid(world, x - 1, y, z, true) && EM_PhysManager.blockNotSolid(world, x - 1, y - 1, z, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 2), (double)z, (double)x, (double)y, (double)(z + 1))).size() <= 0)) {
            canSlideDir.add("X-");
        }
        if (EM_PhysManager.blockNotSolid(world, x, y, z + 1, true) && EM_PhysManager.blockNotSolid(world, x, y - 1, z + 1, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)x, (double)(y - 2), (double)(z + 1), (double)(x + 1), (double)y, (double)(z + 2))).size() <= 0)) {
            canSlideDir.add("Z+");
        }
        if (EM_PhysManager.blockNotSolid(world, x, y, z - 1, true) && EM_PhysManager.blockNotSolid(world, x, y - 1, z - 1, false) && (!checkEntities || world.func_72872_a(EntityPhysicsBlock.class, AxisAlignedBB.func_72330_a((double)x, (double)(y - 2), (double)(z - 1), (double)(x + 1), (double)y, (double)z)).size() <= 0)) {
            canSlideDir.add("Z-");
        }
        if (canSlideDir.size() >= 1) {
            String slideDir = "";
            slideDir = (String)canSlideDir.get(world.field_73012_v.nextInt(canSlideDir.size()));
            if (slideDir == "X+") {
                npos[0] = x + 1;
            } else if (slideDir == "X-") {
                npos[0] = x - 1;
            } else if (slideDir == "Z+") {
                npos[2] = z + 1;
            } else if (slideDir == "Z-") {
                npos[2] = z - 1;
            }
        }
        return npos;
    }
}

