/*
 * Decompiled with CFR 0.152.
 */
package enviromine.gases.types;

import api.hbm.item.IGasMask;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.gases.EnviroGas;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.EnviroDataTracker;
import enviromine.utils.EnviroUtils;
import enviromine.utils.misc.CompatDanger;
import java.awt.Color;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;

@CompatDanger
public class GasHydrogenSulfide
extends EnviroGas {
    boolean isCreative = false;
    boolean hasGasMask = false;
    boolean isHbmMask = false;

    public GasHydrogenSulfide(String name, int ID) {
        super(name, ID);
        this.setColor(new Color(255, 255, 0, 64));
        this.setDensity(1.0f);
        this.setVolitility(100.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyEffects(EntityLivingBase entityLiving, int amplifier) {
        super.applyEffects(entityLiving, amplifier);
        if (entityLiving instanceof EntityPlayer) {
            this.isCreative = ((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d;
        }
        if (entityLiving.field_70170_p.field_72995_K || entityLiving.func_70662_br()) {
            return;
        }
        ItemStack helmet = entityLiving.func_71124_b(4);
        if (helmet != null && !this.isCreative && EnviroMine.isHbmLoaded) {
            Item item = helmet.func_77973_b();
            if (item instanceof IGasMask) {
                IGasMask mask = (IGasMask)item;
                ItemStack filter = mask.getFilter(helmet, entityLiving);
                if (filter != null) {
                    if (ArmorRegistry.hasProtection((EntityLivingBase)entityLiving, (int)3, (ArmorRegistry.HazardClass)ArmorRegistry.HazardClass.GAS_LUNG)) {
                        this.hasGasMask = true;
                        this.isHbmMask = true;
                        if (entityLiving.func_70681_au().nextInt(Math.max(EM_Settings.HbmGasMaskBreakChanceNumber - 10, 1)) == 0) {
                            ArmorUtil.damageGasMaskFilter((EntityLivingBase)entityLiving, (int)MathHelper.func_76141_d((float)(1.5f * (float)EM_Settings.HbmGasMaskBreakMultiplier)));
                        }
                    } else {
                        this.hasGasMask = false;
                        this.isHbmMask = false;
                    }
                } else {
                    this.hasGasMask = false;
                    this.isHbmMask = false;
                }
            } else if (ArmorRegistry.hasProtection((EntityLivingBase)entityLiving, (int)3, (ArmorRegistry.HazardClass)ArmorRegistry.HazardClass.GAS_LUNG)) {
                this.hasGasMask = true;
                this.isHbmMask = true;
                if (entityLiving.func_70681_au().nextInt(Math.max(EM_Settings.HbmGasMaskBreakChanceNumber - 10, 1)) == 0) {
                    ArmorUtil.damageGasMaskFilter((EntityLivingBase)entityLiving, (int)MathHelper.func_76141_d((float)(1.5f * (float)EM_Settings.HbmGasMaskBreakMultiplier)));
                }
            } else {
                this.hasGasMask = false;
                this.isHbmMask = false;
            }
        } else {
            this.hasGasMask = false;
            this.isHbmMask = false;
        }
        if (helmet != null && !this.isCreative && !this.isHbmMask) {
            if (entityLiving.func_71124_b(4).func_77973_b() == ObjectHandler.gasMask) {
                if (helmet.func_77942_o() && helmet.func_77978_p().func_74764_b("gasMaskFill")) {
                    NBTTagCompound tag = helmet.func_77978_p();
                    int maskFill = tag.func_74762_e("gasMaskFill");
                    if (maskFill > 0) {
                        this.hasGasMask = true;
                        if (entityLiving.field_70173_aa % 20 == 0) {
                            int newMaskQuality = maskFill - MathHelper.func_76141_d((float)(1.0f * (float)EM_Settings.EnviromineGasMaskBreakMultiplier));
                            if (newMaskQuality < 0) {
                                newMaskQuality = 0;
                            }
                            tag.func_74768_a("gasMaskFill", newMaskQuality);
                        }
                    } else {
                        this.hasGasMask = false;
                    }
                } else {
                    this.hasGasMask = false;
                }
            } else {
                this.hasGasMask = false;
            }
        } else if (!this.isHbmMask) {
            this.hasGasMask = false;
        }
        if (!this.hasGasMask && helmet != null && !this.isCreative && EnviroMine.isMCELoaded) {
            ItemScubaTank tank;
            Item item;
            this.hasGasMask = helmet.func_77973_b() instanceof ItemGasMask ? (entityLiving.func_71124_b(3) != null && (item = entityLiving.func_71124_b(3).func_77973_b()) instanceof ItemScubaTank ? (tank = (ItemScubaTank)item).getFlowing(entityLiving.func_71124_b(3)) && tank.getGas(entityLiving.func_71124_b(3)) != null : false) : false;
        }
        if (EM_Settings.HydrogenSulfideGasDebugLogger) {
            EnviroDataTracker.logger.warn("HydrogenSulfide: amplifier:  " + amplifier);
            EnviroDataTracker.logger.warn("HydrogenSulfide: hasGasMask:  " + this.hasGasMask);
            EnviroDataTracker.logger.warn("HydrogenSulfide: isCreative:  " + this.isCreative);
            EnviroDataTracker.logger.warn("HydrogenSulfide: entityLiving.getRNG().nextInt(HydrogenSulfidePoisoningChance) == 0?:  " + (entityLiving.func_70681_au().nextInt(EM_Settings.HydrogenSulfidePoisoningChance) == 0));
        }
        if (!this.hasGasMask && !this.isCreative && amplifier >= EM_Settings.HydrogenSulfidePoisoningAmplifier + (EM_Settings.witcheryVampireImmunities && entityLiving instanceof EntityPlayer ? EnviroUtils.getWitcheryVampireLevel((Entity)entityLiving) : 0) && entityLiving.func_70681_au().nextInt(EM_Settings.HydrogenSulfidePoisoningChance) == 0) {
            if (amplifier >= EM_Settings.HydrogenSulfideSeverePoisoningAmplifier + (EM_Settings.witcheryVampireImmunities && entityLiving instanceof EntityPlayer ? EnviroUtils.getWitcheryVampireLevel((Entity)entityLiving) * 2 : 0)) {
                entityLiving.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, EM_Settings.HydrogenSulfideSeverePoisoningTime, EM_Settings.HydrogenSulfideSeverePoisoningLevel));
            } else {
                entityLiving.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, EM_Settings.HydrogenSulfidePoisoningTime, EM_Settings.HydrogenSulfidePoisoningLevel));
            }
        }
    }
}

