/*
 * Decompiled with CFR 0.152.
 */
package enviromine.core;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import enviromine.EnviroPotion;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroTab;
import enviromine.core.commands.CommandPhysics;
import enviromine.core.commands.EnviroCommand;
import enviromine.core.commands.QuakeCommand;
import enviromine.core.config.mixins.ConfigMixinsLate;
import enviromine.core.proxies.EM_CommonProxy;
import enviromine.handlers.EnviroAchievements;
import enviromine.handlers.EnviroShaftCreationHandler;
import enviromine.handlers.Legacy.LegacyHandler;
import enviromine.handlers.ObjectHandler;
import enviromine.handlers.ObjectHandlerCompat;
import enviromine.handlers.compat.EM_Water_Compat_NTM;
import enviromine.handlers.compat.EM_Water_Compat_NTM_SPACE;
import enviromine.handlers.compat.ObjectHandler_MCF;
import enviromine.handlers.compat.ObjectHandler_MCF_NTM;
import enviromine.handlers.compat.ObjectHandler_Netherlicious;
import enviromine.network.packet.PacketAutoOverride;
import enviromine.network.packet.PacketEnviroMine;
import enviromine.network.packet.PacketServerOverride;
import enviromine.utils.EnviroUtils;
import enviromine.world.WorldProviderCaves;
import enviromine.world.biomes.BiomeGenCaves;
import enviromine.world.features.WorldFeatureGenerator;
import enviromine.world.features.mineshaft.EM_VillageMineshaft;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enviromine", name="EnviroMine", version="1.3.148-FINAL kotmatross edition", guiFactory="enviromine.client.gui.menu.config.EnviroMineGuiFactory")
public class EnviroMine {
    public static Logger logger;
    public static BiomeGenCaves caves;
    public static EnviroTab enviroTab;
    @Mod.Instance(value="enviromine")
    public static EnviroMine instance;
    @SidedProxy(clientSide="enviromine.core.proxies.EM_ClientProxy", serverSide="enviromine.core.proxies.EM_CommonProxy")
    public static EM_CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static boolean isHbmLoaded;
    public static boolean isHbmSpaceLoaded;
    public static boolean isTCLoaded;
    public static boolean isSereneSeasonsLoaded;
    public static boolean isEtFuturumLoaded;
    public static boolean isMCELoaded;
    public static boolean isLOTRLoaded;
    public static boolean isCFBHLoaded;
    public static boolean isCFMLoaded;
    public static boolean isNetherliciousLoaded;
    public static boolean isHarvestCraftLoaded;
    public static boolean isJAFFALoaded;
    public static boolean isEndlessIDsLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = EnumChatFormatting.AQUA + "EnviroMine";
        event.getModMetadata().version = EnumChatFormatting.DARK_AQUA + "1.3.148-FINAL kotmatross edition";
        event.getModMetadata().credits = EnumChatFormatting.AQUA + "See Acknowledgments.txt";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(EnumChatFormatting.BLUE + "Funwayguy, TimbuckTato, GenDeathrow, thislooksfun, AstroTibs, " + EnumChatFormatting.AQUA + "Kot" + EnumChatFormatting.GOLD + "matross");
        event.getModMetadata().url = EnumChatFormatting.GRAY + "https://modrinth.com/mod/enviromine-continuation";
        event.getModMetadata().description = EnumChatFormatting.GREEN + "Adds more realism to Minecraft with environmental effects, physics, gases and a cave dimension.";
        event.getModMetadata().logoFile = "title_new.png";
        logger = event.getModLog();
        if (Loader.isModLoaded((String)"hbm")) {
            isHbmLoaded = true;
            try {
                if (Launch.classLoader.getClassBytes("com.hbm.dim.SolarSystem") != null) {
                    isHbmSpaceLoaded = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            isTCLoaded = true;
        }
        if (Loader.isModLoaded((String)"sereneseasons")) {
            isSereneSeasonsLoaded = true;
        }
        if (Loader.isModLoaded((String)"etfuturum")) {
            isEtFuturumLoaded = true;
        }
        if (Loader.isModLoaded((String)"Mekanism")) {
            isMCELoaded = true;
        }
        if (Loader.isModLoaded((String)"lotr")) {
            isLOTRLoaded = true;
        }
        if (Loader.isModLoaded((String)"cookingforblockheads")) {
            isCFBHLoaded = true;
        }
        if (Loader.isModLoaded((String)"cfm")) {
            isCFMLoaded = true;
        }
        if (Loader.isModLoaded((String)"netherlicious")) {
            isNetherliciousLoaded = true;
        }
        if (Loader.isModLoaded((String)"harvestcraft")) {
            isHarvestCraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"jaffa")) {
            isJAFFALoaded = true;
        }
        if (Loader.isModLoaded((String)"endlessids")) {
            isEndlessIDsLoaded = true;
        }
        enviroTab = new EnviroTab("enviromine.enviroTab");
        LegacyHandler.preInit();
        LegacyHandler.init();
        proxy.preInit(event);
        ObjectHandler.initBlocks();
        ObjectHandler.registerBlocks();
        ObjectHandler.initItems();
        ObjectHandler.registerItems();
        if (isHbmLoaded) {
            ObjectHandlerCompat.initItems();
            ObjectHandlerCompat.registerItems();
            if (ConfigMixinsLate.MixinNTMWaterTypes) {
                if (isHbmSpaceLoaded) {
                    new EM_Water_Compat_NTM_SPACE().register();
                } else {
                    new EM_Water_Compat_NTM().register();
                }
            }
        }
        if (isNetherliciousLoaded) {
            ObjectHandler_Netherlicious.initBlocks();
            ObjectHandler_Netherlicious.registerBlocks();
        }
        if (isCFMLoaded) {
            ObjectHandler_MCF.register();
            if (isHbmLoaded) {
                ObjectHandler_MCF_NTM.register();
            }
        }
        EM_ConfigHandler.initConfig();
        ObjectHandler.registerGases();
        ObjectHandler.registerEntities();
        if (EM_Settings.shaftGen) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new EnviroShaftCreationHandler());
            MapGenStructureIO.func_143031_a(EM_VillageMineshaft.class, (String)"ViMS");
        }
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("EM_CH");
        this.network.registerMessage(PacketEnviroMine.HandlerServer.class, PacketEnviroMine.class, 0, Side.SERVER);
        this.network.registerMessage(PacketEnviroMine.HandlerClient.class, PacketEnviroMine.class, 1, Side.CLIENT);
        this.network.registerMessage(PacketAutoOverride.Handler.class, PacketAutoOverride.class, 2, Side.CLIENT);
        this.network.registerMessage(PacketServerOverride.Handler.class, PacketServerOverride.class, 3, Side.CLIENT);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldFeatureGenerator(), (int)20);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        ObjectHandler.registerRecipes();
        if (!isEndlessIDsLoaded) {
            EnviroUtils.extendPotionList();
        }
        EnviroPotion.RegisterPotions();
        EnviroAchievements.InitAchievements();
        if (!EM_Settings.disableCaves) {
            caves = (BiomeGenCaves)new BiomeGenCaves(EM_Settings.caveBiomeID).func_76739_b(0).func_76735_a("Caves").func_76745_m().func_76732_a(1.0f, 0.0f);
            BiomeDictionary.registerBiomeType((BiomeGenBase)caves, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND});
            DimensionManager.registerProviderType((int)EM_Settings.caveDimID, WorldProviderCaves.class, (boolean)false);
            DimensionManager.registerDimension((int)EM_Settings.caveDimID, (int)EM_Settings.caveDimID);
        }
        proxy.registerTickHandlers();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        if (isHbmLoaded) {
            ObjectHandlerCompat.registerRecipes();
            ObjectHandlerCompat.registerNTMFluidContainers();
        }
        EM_ConfigHandler.initConfig();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new CommandPhysics());
        manager.func_71560_a((ICommand)new EnviroCommand());
        manager.func_71560_a((ICommand)new QuakeCommand());
    }
}

