/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.renderer.tileentity;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.blocks.BlockGas;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.ObjectHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGasHandler
implements ISimpleBlockRenderingHandler {
    private IIcon icon;
    private Tessellator tessellator;
    private int verts;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (renderer.field_147844_c) {
            int var6 = block.func_149741_i(metadata);
            red = (float)(var6 >> 16 & 0xFF) / 255.0f;
            green = (float)(var6 >> 8 & 0xFF) / 255.0f;
            blue = (float)(var6 & 0xFF) / 255.0f;
        }
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int i, int j, int k, Block oBlock, int modelId, RenderBlocks renderer) {
        if (!EM_Settings.hardcoregases) {
            double sideMaxY;
            double sideMinY;
            float sideAlpha;
            Block sideBlock;
            BlockGas block = (BlockGas)oBlock;
            if (!(blockAccess.func_147439_a(i, j, k) instanceof BlockGas)) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Trying to render gas without block at position!");
                }
                return false;
            }
            if (blockAccess.func_147438_o(i, j, k) == null) {
                if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.ALL.getLevel()) {
                    EnviroMine.logger.log(Level.ERROR, "Trying to render gas without tile at position!");
                }
                return false;
            }
            this.icon = renderer.func_147744_b() ? renderer.field_147840_d : renderer.func_147745_b((Block)block);
            int brightness = block.func_149677_c(blockAccess, i, j, k);
            int color = block.func_149720_d(blockAccess, i, j, k);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float alpha = block.getOpacity(blockAccess, i, j, k);
            if (alpha <= 0.1f) {
                return false;
            }
            double minX = 0.0;
            double maxX = 1.0;
            double minY = block.getMinY(blockAccess, i, j, k);
            double maxY = block.getMaxY(blockAccess, i, j, k);
            double minZ = 0.0;
            double maxZ = 1.0;
            this.verts = 0;
            this.tessellator = Tessellator.field_78398_a;
            this.tessellator.func_78380_c(brightness);
            this.tessellator.func_78372_c((float)i, (float)j, (float)k);
            this.tessellator.func_78369_a(red * 0.9f, green * 0.9f, blue * 0.9f, alpha * 0.9f);
            if (block.func_149646_a(blockAccess, i, j, k, 2)) {
                sideBlock = blockAccess.func_147439_a(i, j, k - 1);
                float f = sideAlpha = sideBlock instanceof BlockGas ? ((BlockGas)sideBlock).getOpacity(blockAccess, i, j, k - 1) : 0.0f;
                if (sideAlpha > 0.1f) {
                    sideMinY = ((BlockGas)sideBlock).getMinY(blockAccess, i, j, k - 1);
                    if (minY <= sideMinY & minY <= (sideMaxY = ((BlockGas)sideBlock).getMaxY(blockAccess, i, j, k - 1)) & maxY <= sideMinY & maxY <= sideMinY | minY >= sideMinY & minY >= sideMaxY & maxY >= sideMinY & maxY >= sideMinY) {
                        this.vertexAutoMap(minX, minY, minZ, maxX, minY);
                        this.vertexAutoMap(minX, maxY, minZ, maxX, maxY);
                        this.vertexAutoMap(maxX, maxY, minZ, minX, maxY);
                        this.vertexAutoMap(maxX, minY, minZ, minX, minY);
                    } else {
                        if (minY < sideMinY) {
                            this.vertexAutoMap(minX, minY, minZ, maxX, minY);
                            this.vertexAutoMap(minX, sideMinY, minZ, maxX, sideMinY);
                            this.vertexAutoMap(maxX, sideMinY, minZ, minX, sideMinY);
                            this.vertexAutoMap(maxX, minY, minZ, minX, minY);
                        }
                        if (maxY > sideMaxY) {
                            this.vertexAutoMap(minX, sideMaxY, minZ, maxX, sideMaxY);
                            this.vertexAutoMap(minX, maxY, minZ, maxX, maxY);
                            this.vertexAutoMap(maxX, maxY, minZ, minX, maxY);
                            this.vertexAutoMap(maxX, sideMaxY, minZ, minX, sideMaxY);
                        }
                    }
                } else {
                    this.vertexAutoMap(minX, minY, minZ, maxX, minY);
                    this.vertexAutoMap(minX, maxY, minZ, maxX, maxY);
                    this.vertexAutoMap(maxX, maxY, minZ, minX, maxY);
                    this.vertexAutoMap(maxX, minY, minZ, minX, minY);
                }
            }
            if (block.func_149646_a(blockAccess, i, j, k, 3)) {
                sideBlock = blockAccess.func_147439_a(i, j, k + 1);
                float f = sideAlpha = sideBlock instanceof BlockGas ? ((BlockGas)sideBlock).getOpacity(blockAccess, i, j, k + 1) : 0.0f;
                if (sideAlpha > 0.1f) {
                    sideMinY = ((BlockGas)sideBlock).getMinY(blockAccess, i, j, k + 1);
                    if (minY <= sideMinY & minY <= (sideMaxY = ((BlockGas)sideBlock).getMaxY(blockAccess, i, j, k + 1)) & maxY <= sideMinY & maxY <= sideMinY | minY >= sideMinY & minY >= sideMaxY & maxY >= sideMinY & maxY >= sideMinY) {
                        this.vertexAutoMap(maxX, minY, maxZ, maxX, minY);
                        this.vertexAutoMap(maxX, maxY, maxZ, maxX, maxY);
                        this.vertexAutoMap(minX, maxY, maxZ, minX, maxY);
                        this.vertexAutoMap(minX, minY, maxZ, minX, minY);
                    } else {
                        if (minY < sideMinY) {
                            this.vertexAutoMap(maxX, minY, maxZ, maxX, minY);
                            this.vertexAutoMap(maxX, sideMinY, maxZ, maxX, sideMinY);
                            this.vertexAutoMap(minX, sideMinY, maxZ, minX, sideMinY);
                            this.vertexAutoMap(minX, minY, maxZ, minX, minY);
                        }
                        if (maxY > sideMaxY) {
                            this.vertexAutoMap(maxX, sideMaxY, maxZ, maxX, sideMaxY);
                            this.vertexAutoMap(maxX, maxY, maxZ, maxX, maxY);
                            this.vertexAutoMap(minX, maxY, maxZ, minX, maxY);
                            this.vertexAutoMap(minX, sideMaxY, maxZ, minX, sideMaxY);
                        }
                    }
                } else {
                    this.vertexAutoMap(maxX, minY, maxZ, maxX, minY);
                    this.vertexAutoMap(maxX, maxY, maxZ, maxX, maxY);
                    this.vertexAutoMap(minX, maxY, maxZ, minX, maxY);
                    this.vertexAutoMap(minX, minY, maxZ, minX, minY);
                }
            }
            if (block.func_149646_a(blockAccess, i, j, k, 4)) {
                sideBlock = blockAccess.func_147439_a(i - 1, j, k);
                float f = sideAlpha = sideBlock instanceof BlockGas ? ((BlockGas)sideBlock).getOpacity(blockAccess, i - 1, j, k) : 0.0f;
                if (sideAlpha > 0.1f) {
                    sideMinY = ((BlockGas)sideBlock).getMinY(blockAccess, i - 1, j, k);
                    if (minY <= sideMinY & minY <= (sideMaxY = ((BlockGas)sideBlock).getMaxY(blockAccess, i - 1, j, k)) & maxY <= sideMinY & maxY <= sideMinY | minY >= sideMinY & minY >= sideMaxY & maxY >= sideMinY & maxY >= sideMinY) {
                        this.vertexAutoMap(minX, minY, maxZ, minZ, maxY);
                        this.vertexAutoMap(minX, maxY, maxZ, minZ, minY);
                        this.vertexAutoMap(minX, maxY, minZ, maxZ, minY);
                        this.vertexAutoMap(minX, minY, minZ, maxZ, maxY);
                    } else {
                        if (minY < sideMinY) {
                            this.vertexAutoMap(minX, minY, maxZ, minZ, sideMinY);
                            this.vertexAutoMap(minX, sideMinY, maxZ, minZ, minY);
                            this.vertexAutoMap(minX, sideMinY, minZ, maxZ, minY);
                            this.vertexAutoMap(minX, minY, minZ, maxZ, sideMinY);
                        }
                        if (maxY > sideMaxY) {
                            this.vertexAutoMap(minX, sideMaxY, maxZ, minZ, maxY);
                            this.vertexAutoMap(minX, maxY, maxZ, minZ, sideMaxY);
                            this.vertexAutoMap(minX, maxY, minZ, maxZ, sideMaxY);
                            this.vertexAutoMap(minX, sideMaxY, minZ, maxZ, maxY);
                        }
                    }
                } else {
                    this.vertexAutoMap(minX, minY, maxZ, minZ, maxY);
                    this.vertexAutoMap(minX, maxY, maxZ, minZ, minY);
                    this.vertexAutoMap(minX, maxY, minZ, maxZ, minY);
                    this.vertexAutoMap(minX, minY, minZ, maxZ, maxY);
                }
            }
            if (block.func_149646_a(blockAccess, i, j, k, 5)) {
                sideBlock = blockAccess.func_147439_a(i + 1, j, k);
                float f = sideAlpha = sideBlock instanceof BlockGas ? ((BlockGas)sideBlock).getOpacity(blockAccess, i + 1, j, k) : 0.0f;
                if (sideAlpha > 0.1f) {
                    sideMinY = ((BlockGas)sideBlock).getMinY(blockAccess, i + 1, j, k);
                    if (minY <= sideMinY & minY <= (sideMaxY = ((BlockGas)sideBlock).getMaxY(blockAccess, i + 1, j, k)) & maxY <= sideMinY & maxY <= sideMinY | minY >= sideMinY & minY >= sideMaxY & maxY >= sideMinY & maxY >= sideMinY) {
                        this.vertexAutoMap(maxX, minY, minZ, minZ, maxY);
                        this.vertexAutoMap(maxX, maxY, minZ, minZ, minY);
                        this.vertexAutoMap(maxX, maxY, maxZ, maxZ, minY);
                        this.vertexAutoMap(maxX, minY, maxZ, maxZ, maxY);
                    } else {
                        if (minY < sideMinY) {
                            this.vertexAutoMap(maxX, minY, minZ, minZ, sideMinY);
                            this.vertexAutoMap(maxX, sideMinY, minZ, minZ, minY);
                            this.vertexAutoMap(maxX, sideMinY, maxZ, maxZ, minY);
                            this.vertexAutoMap(maxX, minY, maxZ, maxZ, sideMinY);
                        }
                        if (maxY > sideMaxY) {
                            this.vertexAutoMap(maxX, sideMaxY, minZ, minZ, maxY);
                            this.vertexAutoMap(maxX, maxY, minZ, minZ, sideMaxY);
                            this.vertexAutoMap(maxX, maxY, maxZ, maxZ, sideMaxY);
                            this.vertexAutoMap(maxX, sideMaxY, maxZ, maxZ, maxY);
                        }
                    }
                } else {
                    this.vertexAutoMap(maxX, minY, minZ, minZ, maxY);
                    this.vertexAutoMap(maxX, maxY, minZ, minZ, minY);
                    this.vertexAutoMap(maxX, maxY, maxZ, maxZ, minY);
                    this.vertexAutoMap(maxX, minY, maxZ, maxZ, maxY);
                }
            }
            this.tessellator.func_78369_a(red * 0.8f, green * 0.8f, blue * 0.8f, alpha * 0.9f);
            if (block.func_149646_a(blockAccess, i, j, k, 0)) {
                this.vertexAutoMap(maxX, minY, minZ, maxX, maxZ);
                this.vertexAutoMap(maxX, minY, maxZ, maxX, minZ);
                this.vertexAutoMap(minX, minY, maxZ, minX, minZ);
                this.vertexAutoMap(minX, minY, minZ, minX, maxZ);
            }
            this.tessellator.func_78369_a(red, green, blue, alpha * 0.9f);
            if (block.func_149646_a(blockAccess, i, j, k, 1)) {
                this.vertexAutoMap(maxX, maxY, maxZ, maxX, maxZ);
                this.vertexAutoMap(maxX, maxY, minZ, maxX, minZ);
                this.vertexAutoMap(minX, maxY, minZ, minX, minZ);
                this.vertexAutoMap(minX, maxY, maxZ, minX, maxZ);
            }
            this.tessellator.func_78372_c((float)(-i), (float)(-j), (float)(-k));
        }
        return this.verts > 0;
    }

    private void vertexAutoMap(double x, double y, double z, double u, double v) {
        this.tessellator.func_78374_a(x, y, z, (double)this.icon.func_94214_a(u * 16.0), (double)this.icon.func_94207_b(v * 16.0));
        ++this.verts;
    }

    public boolean shouldRender3DInInventory(int i) {
        return true;
    }

    public int getRenderId() {
        return ObjectHandler.renderGasID;
    }
}

