/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui.hud.items;

import enviromine.client.gui.Gui_EventManager;
import enviromine.client.gui.UI_Settings;
import enviromine.client.gui.hud.HUDRegistry;
import enviromine.client.gui.hud.HudItem;
import enviromine.core.EM_Settings;
import enviromine.utils.Alignment;
import enviromine.utils.EnviroUtils;
import enviromine.utils.RenderAssist;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class HudItemTemperature
extends HudItem {
    @Override
    public String getName() {
        return "Temperature";
    }

    @Override
    public String getNameLoc() {
        return StatCollector.func_74838_a((String)"options.enviromine.hud.temperature");
    }

    @Override
    public String getButtonLabel() {
        return this.getNameLoc() + " Bar";
    }

    @Override
    public Alignment getDefaultAlignment() {
        return Alignment.BOTTOMLEFT;
    }

    @Override
    public int getDefaultPosX() {
        return 8;
    }

    @Override
    public int getDefaultPosY() {
        return HUDRegistry.screenHeight - 30;
    }

    @Override
    public int getWidth() {
        return UI_Settings.minimalHud && !this.rotated ? 0 : 64;
    }

    @Override
    public int getHeight() {
        return 8;
    }

    @Override
    public boolean isEnabledByDefault() {
        return EM_Settings.enableBodyTemp;
    }

    @Override
    public int getDefaultID() {
        return 0;
    }

    @Override
    public boolean isBlinking() {
        return this.blink() && Gui_EventManager.tracker.bodyTemp < 35.0f || this.blink() && Gui_EventManager.tracker.bodyTemp > 39.0f;
    }

    @Override
    public void render() {
        EntityClientPlayerMP ecplayermp = Minecraft.func_71410_x().field_71439_g;
        if (EM_Settings.dimensionProperties.containsKey(ecplayermp.field_71093_bK) && !EM_Settings.dimensionProperties.get((Object)Integer.valueOf((int)ecplayermp.field_71093_bK)).trackTemp || !EM_Settings.enableBodyTemp || EM_Settings.matterOverdriveAndroidImmunities && EnviroUtils.isPlayerCurrentlyMOAndroid((EntityPlayer)ecplayermp)) {
            return;
        }
        GL11.glPushMatrix();
        float transx = (float)this.posX - (float)this.posX * UI_Settings.guiScale;
        float transy = (float)this.posY - (float)this.posY * UI_Settings.guiScale;
        GL11.glTranslated((double)transx, (double)transy, (double)0.0);
        GL11.glScalef((float)UI_Settings.guiScale, (float)UI_Settings.guiScale, (float)UI_Settings.guiScale);
        int heatBar = MathHelper.func_76123_f((float)((Gui_EventManager.tracker.bodyTemp + 50.0f) / 150.0f * (float)this.getWidth()));
        int preheatBar = MathHelper.func_76123_f((float)((Gui_EventManager.tracker.airTemp + 50.0f) / 150.0f * (float)this.getWidth()));
        int preheatIco = 16 - MathHelper.func_76123_f((float)((Gui_EventManager.tracker.airTemp + 50.0f) / 150.0f * 16.0f));
        int frameBorder = 4;
        if (this.isBlinking()) {
            frameBorder = 5;
        }
        if (heatBar > this.getWidth()) {
            heatBar = this.getWidth();
        } else if (heatBar < 0) {
            heatBar = 0;
        }
        if (preheatBar > this.getWidth()) {
            preheatBar = this.getWidth();
        } else if (preheatBar < 0) {
            preheatBar = 0;
        }
        if (preheatIco > 24) {
            preheatIco = 24;
        } else if (preheatIco < 0) {
            preheatIco = 0;
        }
        if (!UI_Settings.minimalHud || this.rotated) {
            GL11.glPushMatrix();
            if (this.rotated) {
                int angle = -90;
                GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-this.posX + 6), (float)(-this.posY - 8 + this.getWidth() / 2), (float)0.0f);
            }
            RenderAssist.drawTexturedModalRect(this.posX, this.posY, 0.0f, 24.0f, this.getWidth(), this.getHeight());
            RenderAssist.drawTexturedModalRect(this.posX + preheatBar - 4, this.posY, 32.0f, 64.0f, 8.0f, 8.0f);
            RenderAssist.drawTexturedModalRect(this.posX + heatBar - 2, this.posY + 2, 20.0f, 64.0f, 4.0f, 4.0f);
            RenderAssist.drawTexturedModalRect(this.posX, this.posY, 0.0f, this.getHeight() * frameBorder, this.getWidth(), this.getHeight());
            GL11.glPopMatrix();
        }
        if (UI_Settings.ShowGuiIcons) {
            int iconPosX = this.getIconPosX();
            if (this.rotated) {
                iconPosX = this.posX + 20;
            }
            RenderAssist.drawTexturedModalRect(iconPosX, this.posY - 4, 0.0f, 80.0f, 16.0f, 16.0f);
            if (preheatIco >= 8) {
                RenderAssist.drawTexturedModalRect(iconPosX, this.posY - 4 + preheatIco, 16.0f, 96 + preheatIco, 16.0f, 16 - preheatIco);
            } else {
                RenderAssist.drawTexturedModalRect(iconPosX, this.posY - 4 + preheatIco, 0.0f, 96 + preheatIco, 16.0f, 16 - preheatIco);
            }
        }
        if (UI_Settings.ShowText && !this.rotated) {
            RenderAssist.drawTexturedModalRect(this.getTextPosX(), this.posY, 64.0f, this.getHeight() * 4, 32.0f, this.getHeight());
            if (UI_Settings.useFarenheit) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(String.format("%.1f", (double)Gui_EventManager.tracker.bodyTemp * 1.8 + 32.0) + "F", this.getTextPosX(), this.posY, 0xFFFFFF);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(String.format("%.1f", Float.valueOf(Gui_EventManager.tracker.bodyTemp)) + "C", this.getTextPosX(), this.posY, 0xFFFFFF);
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public ResourceLocation getResource(String type) {
        if (type == "TintOverlay") {
            return Gui_EventManager.blurOverlayResource;
        }
        return Gui_EventManager.guiResource;
    }

    @Override
    public void renderScreenOverlay(int scaledwidth, int scaledheight) {
        if (Gui_EventManager.tracker.bodyTemp >= 39.0f) {
            int grad = 0;
            grad = Gui_EventManager.tracker.bodyTemp >= 43.0f ? 255 : MathHelper.func_76141_d((float)((Gui_EventManager.tracker.bodyTemp - 39.0f) / 6.0f * 255.0f));
            RenderAssist.drawScreenOverlay(scaledwidth, scaledheight, RenderAssist.getColorFromRGBA(255, 255, 255, grad));
        } else if (Gui_EventManager.tracker.bodyTemp <= 35.0f) {
            int grad = 0;
            grad = Gui_EventManager.tracker.bodyTemp <= 30.0f ? 255 : MathHelper.func_76141_d((float)(Math.abs(5.0f - (Gui_EventManager.tracker.bodyTemp - 30.0f)) / 5.0f * 255.0f));
            RenderAssist.drawScreenOverlay(scaledwidth, scaledheight, RenderAssist.getColorFromRGBA(125, 255, 255, grad));
        }
    }
}

