/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui.hud.items;

import enviromine.client.gui.Gui_EventManager;
import enviromine.client.gui.UI_Settings;
import enviromine.client.gui.hud.HUDRegistry;
import enviromine.client.gui.hud.HudItem;
import enviromine.core.EM_Settings;
import enviromine.utils.Alignment;
import enviromine.utils.EnviroUtils;
import enviromine.utils.RenderAssist;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class HudItemAirQuality
extends HudItem {
    @Override
    public String getName() {
        return "Air Quality";
    }

    @Override
    public String getNameLoc() {
        return StatCollector.func_74838_a((String)"options.enviromine.hud.air");
    }

    @Override
    public String getButtonLabel() {
        return this.getNameLoc() + " Bar";
    }

    @Override
    public Alignment getDefaultAlignment() {
        return Alignment.BOTTOMRIGHT;
    }

    @Override
    public int getDefaultPosX() {
        return HUDRegistry.screenWidth - 4 - this.getWidth();
    }

    @Override
    public int getDefaultPosY() {
        return HUDRegistry.screenHeight - 15;
    }

    @Override
    public int getWidth() {
        return UI_Settings.minimalHud && !this.rotated ? 0 : 64;
    }

    @Override
    public int getHeight() {
        return 8;
    }

    @Override
    public boolean isEnabledByDefault() {
        return EM_Settings.enableAirQ;
    }

    @Override
    public boolean isBlinking() {
        return this.blink() && Gui_EventManager.tracker.airQuality < 25.0f;
    }

    @Override
    public int getDefaultID() {
        return 3;
    }

    @Override
    public void render() {
        EntityClientPlayerMP ecplayermp = Minecraft.func_71410_x().field_71439_g;
        if (EM_Settings.dimensionProperties.containsKey(ecplayermp.field_71093_bK) && !EM_Settings.dimensionProperties.get((Object)Integer.valueOf((int)ecplayermp.field_71093_bK)).trackAirQuality || !EM_Settings.enableAirQ || EM_Settings.matterOverdriveAndroidImmunities && EnviroUtils.isPlayerCurrentlyMOAndroid((EntityPlayer)ecplayermp)) {
            return;
        }
        GL11.glPushMatrix();
        float transx = (float)this.posX - (float)this.posX * UI_Settings.guiScale;
        float transy = (float)this.posY - (float)this.posY * UI_Settings.guiScale;
        GL11.glTranslated((double)transx, (double)transy, (double)0.0);
        GL11.glScalef((float)UI_Settings.guiScale, (float)UI_Settings.guiScale, (float)UI_Settings.guiScale);
        int airBar = MathHelper.func_76123_f((float)(Gui_EventManager.tracker.airQuality / 100.0f * (float)this.getWidth()));
        int frameBorder = 4;
        if (this.isBlinking()) {
            frameBorder = 5;
        }
        if (airBar > this.getWidth()) {
            airBar = this.getWidth();
        } else if (airBar < 0) {
            airBar = 0;
        }
        if (!UI_Settings.minimalHud || this.rotated) {
            GL11.glPushMatrix();
            if (this.rotated) {
                int angle = -90;
                GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-this.posX + 6), (float)(-this.posY - 8 + this.getWidth() / 2), (float)0.0f);
            }
            RenderAssist.drawTexturedModalRect(this.posX, this.posY, 0.0f, 8.0f, this.getWidth(), this.getHeight());
            RenderAssist.drawTexturedModalRect(this.posX, this.posY, 64.0f, 8.0f, airBar, this.getHeight());
            RenderAssist.drawTexturedModalRect(this.posX + airBar - 2, this.posY + 2, 8.0f, 64.0f, 4.0f, 4.0f);
            RenderAssist.drawTexturedModalRect(this.posX, this.posY, 0.0f, this.getHeight() * frameBorder, this.getWidth(), this.getHeight());
            GL11.glPopMatrix();
        }
        if (UI_Settings.ShowGuiIcons) {
            int iconPosX = this.getIconPosX();
            if (this.rotated) {
                iconPosX = this.posX + 20;
            }
            RenderAssist.drawTexturedModalRect(iconPosX, this.posY - 4, 48.0f, 80.0f, 16.0f, 16.0f);
        }
        if (UI_Settings.ShowText && !this.rotated) {
            RenderAssist.drawTexturedModalRect(this.getTextPosX(), this.posY, 64.0f, this.getHeight() * 4, 32.0f, this.getHeight());
            Minecraft.func_71410_x().field_71466_p.func_78276_b(String.format("%.1f", Float.valueOf(Gui_EventManager.tracker.airQuality)) + "%", this.getTextPosX(), this.posY, 0xFFFFFF);
        }
        GL11.glPopMatrix();
    }

    @Override
    public ResourceLocation getResource(String type) {
        if (type == "TintOverlay") {
            return Gui_EventManager.blurOverlayResource;
        }
        return Gui_EventManager.guiResource;
    }

    @Override
    public void renderScreenOverlay(int scaledwidth, int scaledheight) {
        if (Gui_EventManager.tracker.airQuality < 50.0f) {
            int grad = (int)((50.0f - Gui_EventManager.tracker.airQuality) / 50.0f * 255.0f);
            RenderAssist.drawScreenOverlay(scaledwidth, scaledheight, RenderAssist.getColorFromRGBA(32, 96, 0, grad));
        }
    }
}

