/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui.hud;

import enviromine.client.gui.hud.HudItem;
import enviromine.utils.Alignment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HUDRegistry {
    protected static List<HudItem> hudItemList = new ArrayList<HudItem>();
    protected static boolean initialLoadComplete = false;
    protected static List<HudItem> hudItemListActive = new ArrayList<HudItem>();
    private static Logger log = LogManager.getLogger((String)"AdvancedHUD-API");
    public static int screenWidth;
    public static int screenHeight;
    public static int updateCounter;

    public static void registerHudItem(HudItem hudItem) {
        if (hudItem.getDefaultID() <= 25 && initialLoadComplete) {
            log.info("Rejecting " + hudItem.getName() + " due to invalid ID.");
        }
        if (!hudItemList.contains(hudItem)) {
            hudItemList.add(hudItem);
            if (hudItem.isEnabledByDefault()) {
                HUDRegistry.enableHudItem(hudItem);
            }
        }
    }

    public static List<HudItem> getHudItemList() {
        return hudItemList;
    }

    public static void enableHudItem(HudItem hudItem) {
        if (hudItemList.contains(hudItem) && !hudItemListActive.contains(hudItem)) {
            hudItemListActive.add(hudItem);
        }
    }

    public static void disableHudItem(HudItem hudItem) {
        hudItemListActive.remove(hudItem);
    }

    public static List<HudItem> getActiveHudItemList() {
        return hudItemListActive;
    }

    public static boolean isActiveHudItem(HudItem hudItem) {
        return HUDRegistry.getActiveHudItemList().contains(hudItem);
    }

    public static Minecraft getMinecraftInstance() {
        return Minecraft.func_71410_x();
    }

    public static String getMinecraftVersion() {
        return "@MCVERSION@";
    }

    public static HudItem getHudItemByID(int id) {
        for (HudItem huditem : HUDRegistry.getHudItemList()) {
            if (id != huditem.getDefaultID()) continue;
            return huditem;
        }
        return null;
    }

    public static void resetAllDefaults() {
        for (HudItem huditem : HUDRegistry.getHudItemList()) {
            huditem.rotated = false;
            huditem.alignment = huditem.getDefaultAlignment();
            huditem.posX = huditem.getDefaultPosX();
            huditem.posY = huditem.getDefaultPosY();
        }
    }

    public static boolean checkForResize() {
        Minecraft mc = HUDRegistry.getMinecraftInstance();
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        if (scaledresolution.func_78326_a() != screenWidth || scaledresolution.func_78328_b() != screenHeight) {
            if (screenWidth != 0) {
                HUDRegistry.fixHudItemOffsets(scaledresolution.func_78326_a(), scaledresolution.func_78328_b(), screenWidth, screenHeight);
            }
            screenWidth = scaledresolution.func_78326_a();
            screenHeight = scaledresolution.func_78328_b();
            return true;
        }
        return false;
    }

    private static void fixHudItemOffsets(int newScreenWidth, int newScreenHeight, int oldScreenWidth, int oldScreenHeight) {
        for (HudItem hudItem : hudItemList) {
            int offsetY;
            int offsetX;
            if (Alignment.isHorizontalCenter(hudItem.alignment)) {
                offsetX = hudItem.posX - oldScreenWidth / 2;
                hudItem.posX = newScreenWidth / 2 + offsetX;
            } else if (Alignment.isRight(hudItem.alignment)) {
                offsetX = hudItem.posX - oldScreenWidth;
                hudItem.posX = newScreenWidth + offsetX;
            }
            if (Alignment.isVerticalCenter(hudItem.alignment)) {
                offsetY = hudItem.posY - oldScreenHeight / 2;
                hudItem.posY = newScreenHeight / 2 + offsetY;
                continue;
            }
            if (!Alignment.isBottom(hudItem.alignment)) continue;
            offsetY = hudItem.posY - oldScreenHeight;
            hudItem.posY = newScreenHeight + offsetY;
        }
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        screenWidth = nbt.func_74762_e("screenWidth");
        screenHeight = nbt.func_74762_e("screenHeight");
        hudItemListActive = new ArrayList<HudItem>(hudItemList);
        for (int i = 0; i < hudItemList.size(); ++i) {
            HudItem hudItem = hudItemList.get(i);
            if (hudItem.isEnabledByDefault()) continue;
            HUDRegistry.disableHudItem(hudItem);
        }
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("screenWidth", screenWidth);
        nbt.func_74768_a("screenHeight", screenHeight);
        Iterator<HudItem> iterator = hudItemListActive.iterator();
        while (iterator.hasNext()) {
            HudItem hudItem_;
            HudItem hudItem = hudItem_ = iterator.next();
            nbt.func_74757_a(hudItem.getName(), true);
        }
    }

    public static void setInitialLoadComplete(boolean b) {
        initialLoadComplete = b;
    }
}

