/*
 * Decompiled with CFR 0.152.
 */
package enviromine.blocks.tiles;

import enviromine.blocks.BlockGas;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.gases.EnviroGas;
import enviromine.gases.EnviroGasDictionary;
import enviromine.handlers.ObjectHandler;
import enviromine.utils.RenderAssist;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;

public class TileEntityGas
extends TileEntity {
    public ArrayList<int[]> gases = new ArrayList();
    public Color color = Color.WHITE;
    public float opacity = 0.0f;
    public float yMax = 1.0f;
    public float yMin = 0.0f;
    public int amount = 0;
    public int firePressure = 0;
    public boolean preReqRender = true;
    public boolean curReqRender = true;
    public int ticks = 0;

    public TileEntityGas() {
    }

    public TileEntityGas(World world) {
        this.field_145850_b = world;
    }

    public void doAllEffects(EntityLivingBase entityLiving) {
        if (this.gases.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            EnviroGasDictionary.gasList[gasArray[0]].applyEffects(entityLiving, gasArray[1]);
        }
    }

    public void updateColor() {
        if (this.gases.size() <= 0) {
            this.color = Color.WHITE;
            return;
        }
        Color fCol = null;
        for (int i = 0; i < this.gases.size(); ++i) {
            if (fCol == null) {
                fCol = EnviroGasDictionary.gasList[this.gases.get((int)i)[0]].color;
                continue;
            }
            int[] gasArray = this.gases.get(i);
            EnviroGas gas = EnviroGasDictionary.gasList[gasArray[0]];
            float opacity = gas.getOpacity() * (float)gasArray[1];
            opacity = opacity >= 1.0f ? 1.0f : opacity;
            fCol = RenderAssist.blendColors(fCol.getRGB(), gas.color.getRGB(), opacity / 0.5f);
        }
        this.color = fCol;
    }

    public void updateOpacity() {
        if (this.gases.size() <= 0 || this.amount == 0) {
            this.opacity = 1.0f;
            return;
        }
        float alpha = 0.0f;
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            alpha += EnviroGasDictionary.gasList[gasArray[0]].getOpacity() * (float)gasArray[1];
        }
        this.opacity = alpha >= 1.0f ? 1.0f : alpha;
        if (this.field_145850_b != null) {
            TileEntity tile1 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            TileEntity tile2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            TileEntity tile3 = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            TileEntity tile4 = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            TileEntity tile5 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            TileEntity tile6 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            if (tile1 != null && tile1 instanceof TileEntityGas) {
                TileEntityGas gasTile1 = (TileEntityGas)tile1;
                if (gasTile1.opacity > 0.1f && this.opacity > 0.1f && gasTile1.opacity > this.opacity) {
                    this.opacity = gasTile1.opacity;
                }
            }
            if (tile2 != null && tile2 instanceof TileEntityGas) {
                TileEntityGas gasTile2 = (TileEntityGas)tile2;
                if (gasTile2.opacity > 0.1f && this.opacity > 0.1f && gasTile2.opacity > this.opacity) {
                    this.opacity = gasTile2.opacity;
                }
            }
            if (tile3 != null && tile3 instanceof TileEntityGas) {
                TileEntityGas gasTile3 = (TileEntityGas)tile3;
                if (gasTile3.opacity > 0.1f && this.opacity > 0.1f && gasTile3.opacity > this.opacity) {
                    this.opacity = gasTile3.opacity;
                }
            }
            if (tile4 != null && tile4 instanceof TileEntityGas) {
                TileEntityGas gasTile4 = (TileEntityGas)tile4;
                if (gasTile4.opacity > 0.1f && this.opacity > 0.1f && gasTile4.opacity > this.opacity) {
                    this.opacity = gasTile4.opacity;
                }
            }
            if (tile5 != null && tile5 instanceof TileEntityGas) {
                TileEntityGas gasTile5 = (TileEntityGas)tile5;
                if (gasTile5.opacity > 0.1f && this.opacity > 0.1f && gasTile5.opacity > this.opacity) {
                    this.opacity = gasTile5.opacity;
                }
            }
            if (tile6 != null && tile6 instanceof TileEntityGas) {
                TileEntityGas gasTile6 = (TileEntityGas)tile6;
                if (gasTile6.opacity > 0.1f && this.opacity > 0.1f && gasTile6.opacity > this.opacity) {
                    this.opacity = gasTile6.opacity;
                }
            }
        }
    }

    public void updateSize() {
        if (this.amount >= 10) {
            this.yMax = 1.0f;
            this.yMin = 0.0f;
            return;
        }
        if (this.amount <= 0) {
            this.yMax = 0.0f;
            this.yMin = 0.0f;
            return;
        }
        boolean lightGas = false;
        boolean heavyGas = false;
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            float density = EnviroGasDictionary.gasList[gasArray[0]].density;
            if (density >= 1.0f) {
                heavyGas = true;
            } else if (density <= -1.0f) {
                lightGas = true;
            }
            if (!lightGas || !heavyGas) continue;
            this.yMax = 1.0f;
            this.yMin = 0.0f;
            return;
        }
        if (this.amount >= 10) {
            this.yMax = 1.0f;
            this.yMin = 0.0f;
            return;
        }
        if (lightGas) {
            this.yMax = 1.0f;
            this.yMin = 1.0f - (float)this.amount / 10.0f;
        } else if (heavyGas) {
            this.yMax = (float)this.amount / 10.0f;
            this.yMin = 0.0f;
        } else {
            this.yMax = 0.5f + (float)this.amount / 20.0f;
            this.yMin = 0.5f - (float)this.amount / 20.0f;
        }
        if (this.field_145850_b != null) {
            TileEntity tile1 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            TileEntity tile2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (tile1 != null && tile1 instanceof TileEntityGas) {
                TileEntityGas gasTile1 = (TileEntityGas)tile1;
                if (gasTile1.opacity > 0.1f) {
                    this.yMax = 1.0f;
                }
            }
            if (tile2 != null && tile2 instanceof TileEntityGas) {
                TileEntityGas gasTile2 = (TileEntityGas)tile2;
                if (gasTile2.opacity > 0.1f) {
                    this.yMin = 0.0f;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (!par1NBTTagCompound.func_74764_b("GasArray")) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.LOW.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "GasTile missing NBT 'GasArray', this should not happen!", (Throwable)new Exception());
            }
            return;
        }
        int[] savedGases = par1NBTTagCompound.func_74759_k("GasArray");
        if (savedGases.length <= 0) {
            return;
        }
        this.gases = new ArrayList();
        for (int i = 0; i < savedGases.length; ++i) {
            this.addGas(savedGases[i], 1);
        }
        if (this.gases.size() <= 0) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "GasTile loaded " + savedGases.length + " gas units but no gases were actually added!", (Throwable)new Exception());
            }
            return;
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        ArrayList<Integer> savedGases = new ArrayList<Integer>();
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            for (int j = 0; j < gasArray[1]; ++j) {
                savedGases.add(gasArray[0]);
            }
        }
        int[] savedArray = new int[savedGases.size()];
        for (int i = 0; i < savedGases.size(); ++i) {
            savedArray[i] = (Integer)savedGases.get(i);
        }
        par1NBTTagCompound.func_74783_a("GasArray", savedArray);
    }

    public void updateAmount() {
        ++this.ticks;
        int before = this.amount;
        this.amount = this.getGasQuantity(-1);
        if (this.amount != before) {
            this.func_70296_d();
        }
    }

    public int getGasQuantity(int id) {
        int total = 0;
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            if (gasArray[0] != id && id > -1) continue;
            total += gasArray[1];
        }
        return total;
    }

    public void updateRender() {
        if (this.field_145850_b == null || this.gases.size() <= 0 || !(this.func_145838_q() instanceof BlockGas)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.checkNeedsReRender();
            if (!this.preReqRender && !this.curReqRender) {
                return;
            }
            Packet packet = this.func_145844_m();
            MinecraftServer.func_71276_C().func_71203_ab().func_148541_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0, this.field_145850_b.field_73011_w.field_76574_g, packet);
        } else {
            Minecraft.func_71410_x().field_71438_f.func_147588_b(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void checkNeedsReRender() {
        boolean shouldRender = false;
        for (int i = 0; i < 6; ++i) {
            if (!((BlockGas)this.func_145838_q()).func_149646_a((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, i)) continue;
            shouldRender = true;
        }
        this.preReqRender = this.curReqRender;
        this.curReqRender = shouldRender;
    }

    public Packet func_145844_m() {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_145841_b(tags);
        if (this.amount <= 0) {
            // empty if block
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tags);
    }

    public void addGas(int id, int addNum) {
        if (addNum <= 0) {
            return;
        }
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            if (gasArray[0] != id) continue;
            this.gases.set(i, new int[]{id, gasArray[1] + addNum});
            this.updateAmount();
            this.updateColor();
            this.updateOpacity();
            this.updateSize();
            this.sortGasesByDensity();
            return;
        }
        this.gases.add(new int[]{id, addNum});
        if (id == 0 && this.func_145830_o() && this.func_145838_q() == ObjectHandler.gasBlock) {
            this.burnGases();
            ((BlockGas)this.func_145838_q()).swtichIgnitionState(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.updateAmount();
        this.updateColor();
        this.updateOpacity();
        this.updateSize();
        this.sortGasesByDensity();
    }

    public void subtractGas(int id, int takeNum) {
        if (takeNum <= 0) {
            return;
        }
        for (int i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            if (gasArray[0] != id) continue;
            if (gasArray[1] <= takeNum) {
                this.gases.remove(i);
                break;
            }
            this.gases.set(i, new int[]{id, gasArray[1] - takeNum});
            break;
        }
        this.updateAmount();
        this.updateColor();
        this.updateOpacity();
        this.updateSize();
    }

    public boolean burnGases() {
        int i;
        boolean didBurn = false;
        int fireSize = 0;
        ArrayList<int[]> burntGases = new ArrayList<int[]>();
        for (i = 0; i < this.gases.size(); ++i) {
            int[] gasArray = this.gases.get(i);
            int fire = EnviroGasDictionary.gasList[gasArray[0]].getFire(gasArray[1], this.amount >= 10 ? 0 : 10 - this.amount);
            float vol = EnviroGasDictionary.gasList[gasArray[0]].volitility;
            if (!(vol > 0.0f)) continue;
            burntGases.add(gasArray);
            fireSize += fire;
            didBurn = true;
        }
        if (burntGases.size() >= 1) {
            for (i = 0; i < burntGases.size(); ++i) {
                int[] burntArray = (int[])burntGases.get(i);
                this.subtractGas(burntArray[0], burntArray[1]);
            }
        }
        if (fireSize >= 1) {
            this.addGas(EnviroGasDictionary.gasFire.gasID, fireSize);
        }
        return didBurn;
    }

    public void sortGasesByDensity() {
        if (this.gases.size() <= 1) {
            return;
        }
        block0: for (int i = 1; i < this.gases.size(); ++i) {
            EnviroGas gasA = EnviroGasDictionary.gasList[this.gases.get(i)[0]];
            EnviroGas gasB = EnviroGasDictionary.gasList[this.gases.get(i - 1)[0]];
            if (!(gasA.density < gasB.density)) continue;
            for (int j = i - 1; j >= 0; --j) {
                EnviroGas gasD;
                EnviroGas gasC = EnviroGasDictionary.gasList[this.gases.get(j)[0]];
                EnviroGas enviroGas = gasD = j == 0 ? gasA : EnviroGasDictionary.gasList[this.gases.get(j - 1)[0]];
                if (j != 0 && (!(gasA.density < gasC.density) || !(gasA.density >= gasD.density))) continue;
                int[] tmpGas = this.gases.get(i);
                this.gases.remove(i);
                this.gases.add(j, tmpGas);
                continue block0;
            }
        }
    }

    public boolean spreadGas() {
        if (this.gases.size() <= 0 || this.amount == 0) {
            return false;
        }
        if (this.func_145838_q() == Blocks.field_150350_a) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "TileEntityGas has null block type!");
            }
            return false;
        }
        if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockGas)) {
            if (EM_Settings.loggerVerbosity >= EM_ConfigHandler.EnumLogVerbosity.NORMAL.getLevel()) {
                EnviroMine.logger.log(Level.ERROR, "TileEntityGas has no block at position!");
            }
            return false;
        }
        boolean changed = false;
        ArrayList<int[]> gDir = new ArrayList<int[]>();
        int[] dArray = this.getGasDistribution();
        gDir.add(new int[]{-1, 0, 0, dArray[0]});
        gDir.add(new int[]{1, 0, 0, dArray[1]});
        gDir.add(new int[]{0, -1, 0, dArray[2]});
        gDir.add(new int[]{0, 1, 0, dArray[3]});
        gDir.add(new int[]{0, 0, -1, dArray[4]});
        gDir.add(new int[]{0, 0, 1, dArray[5]});
        if (this.doDecay()) {
            changed = true;
        }
        for (int i = gDir.size(); i > 0; --i) {
            int index = this.field_145850_b.field_73012_v.nextInt(gDir.size());
            int[] rDir = (int[])gDir.get(index);
            if (rDir[1] == 0 && this.amount <= 1 || !this.field_145850_b.func_72863_F().func_73149_a((this.field_145851_c + rDir[0]) / 16, (this.field_145849_e + rDir[2]) / 16)) {
                gDir.remove(index);
                continue;
            }
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + rDir[0], this.field_145848_d + rDir[1], this.field_145849_e + rDir[2]);
            if ((tile != null && tile instanceof TileEntityGas || this.field_145850_b.func_147439_a(this.field_145851_c + rDir[0], this.field_145848_d + rDir[1], this.field_145849_e + rDir[2]) == Blocks.field_150350_a) && this.offLoadGas(this.field_145851_c + rDir[0], this.field_145848_d + rDir[1], this.field_145849_e + rDir[2], rDir[3])) {
                changed = true;
            }
            if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c + rDir[0], this.field_145848_d + rDir[1], this.field_145849_e + rDir[2])) != null && tile instanceof TileEntityGas) {
                TileEntityGas gasTile = (TileEntityGas)tile;
                if (gasTile.gases.size() <= 0 || gasTile.amount <= 0) {
                    this.field_145850_b.func_147468_f(this.field_145851_c + rDir[0], this.field_145848_d + rDir[1], this.field_145849_e + rDir[2]);
                }
            }
            gDir.remove(index);
        }
        if (changed) {
            // empty if block
        }
        return changed;
    }

    public boolean offLoadGas(int i, int j, int k, int offLoadNum) {
        if (this.gases.size() <= 0 || this.amount <= 0 || j < 0 || j > 255 || offLoadNum <= 0) {
            return false;
        }
        int gasMode = EM_Settings.gasWaterLike ? 1 : 0;
        int vDir = j - this.field_145848_d;
        TileEntity tile = this.field_145850_b.func_147438_o(i, j, k);
        if (tile == null) {
            if (this.field_145850_b.func_147439_a(i, j, k) == Blocks.field_150350_a && this.func_145838_q() != Blocks.field_150350_a) {
                this.field_145850_b.func_147449_b(i, j, k, this.func_145838_q());
                if (this.field_145850_b.func_147438_o(i, j, k) == null) {
                    return false;
                }
                return this.offLoadGas(i, j, k, offLoadNum);
            }
            return false;
        }
        if (!(tile instanceof TileEntityGas)) {
            return false;
        }
        TileEntityGas gasTile = (TileEntityGas)tile;
        if (gasTile.amount + gasMode >= this.amount && this.amount <= 10 && vDir == 0 && this.func_145838_q() != ObjectHandler.fireGasBlock) {
            return false;
        }
        if (vDir != 0 && this.amount <= 10 && gasTile.amount >= 10 && this.func_145838_q() != ObjectHandler.fireGasBlock) {
            return false;
        }
        int[] selGas = null;
        if (EnviroGasDictionary.gasList[this.gases.get((int)0)[0]].density < 0.0f && vDir == 1 && (gasTile.amount < 10 || this.amount > 10)) {
            selGas = this.gases.get(0);
        } else if (EnviroGasDictionary.gasList[this.gases.get((int)(this.gases.size() - 1))[0]].density > 0.0f && vDir == -1 && (gasTile.amount < 10 || this.amount > 10)) {
            selGas = this.gases.get(this.gases.size() - 1);
        } else if (this.func_145838_q() == ObjectHandler.fireGasBlock && this.getGasQuantity(0) > 0) {
            selGas = new int[]{0, this.getGasQuantity(0)};
        } else {
            for (int index = 0; index < this.gases.size(); ++index) {
                EnviroGas gasType = EnviroGasDictionary.gasList[this.gases.get(index)[0]];
                if (gasType.density < 0.0f && vDir == -1 && this.amount <= 10 || gasType.density > 0.0f && vDir == 1 && this.amount <= 10) continue;
                selGas = this.gases.get(index);
                break;
            }
        }
        if (selGas == null) {
            return false;
        }
        int gasDiff = selGas[1] < offLoadNum ? selGas[1] : offLoadNum;
        gasTile.addGas(selGas[0], gasDiff);
        this.subtractGas(selGas[0], gasDiff);
        gasTile.updateRender();
        return true;
    }

    public boolean doDecay() {
        boolean decayed = false;
        int skyLight = 0;
        Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
        if (this.field_145848_d > 0 && chunk != null) {
            skyLight = this.field_145848_d >= 256 ? 15 : chunk.func_76614_a(EnumSkyBlock.Sky, this.field_145851_c & 0xF, this.field_145848_d, this.field_145849_e & 0xF);
        }
        for (int i = this.gases.size() - 1; i >= 0; --i) {
            int[] gasArray = this.gases.get(i);
            EnviroGas gasType = EnviroGasDictionary.gasList[gasArray[0]];
            int decayGasID = gasType.getGasOnDeath(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (gasType.normDecay > 0 && gasType.normDecayThresh >= gasArray[1]) {
                decayed = true;
                this.subtractGas(gasArray[0], gasType.normDecay);
                if (decayGasID >= 0) {
                    int decayNum = gasArray[1] < gasType.normDecay ? gasArray[1] : gasType.normDecay;
                    this.addGas(decayGasID, decayNum);
                }
                return decayed;
            }
            if (skyLight >= 5 && gasType.airDecay > 0 && gasType.airDecayThresh >= gasArray[1]) {
                decayed = true;
                this.subtractGas(gasArray[0], gasType.airDecay);
                if (decayGasID >= 0) {
                    int decayNum = gasArray[1] < gasType.airDecay ? gasArray[1] : gasType.airDecay;
                    this.addGas(decayGasID, decayNum);
                }
                return decayed;
            }
            if (this.field_145850_b.field_73012_v.nextInt(100) != 0 || gasType.randDecay <= 0 || gasType.randDecayThresh < gasArray[1]) continue;
            decayed = true;
            this.subtractGas(gasArray[0], gasType.randDecay);
            if (decayGasID >= 0) {
                int decayNum = gasArray[1] < gasType.randDecay ? gasArray[1] : gasType.randDecay;
                this.addGas(decayGasID, decayNum);
            }
            return decayed;
        }
        return decayed;
    }

    public int[] getGasDistribution() {
        int[] dArray = new int[]{0, 0, 0, 0, 0, 0};
        ArrayList<int[]> gDir = new ArrayList<int[]>();
        gDir.add(new int[]{-1, 0, 0});
        gDir.add(new int[]{1, 0, 0});
        gDir.add(new int[]{0, -1, 0});
        gDir.add(new int[]{0, 1, 0});
        gDir.add(new int[]{0, 0, -1});
        gDir.add(new int[]{0, 0, 1});
        for (int i = 0; i < gDir.size(); ++i) {
            int[] rDir = (int[])gDir.get(i);
            dArray[i] = this.getGasCapactiy(this.field_145851_c + rDir[0], this.field_145848_d + rDir[1], this.field_145849_e + rDir[2]);
        }
        int totalSpace = 0;
        int largestSpace = 0;
        for (int i = 0; i < 6; ++i) {
            if (dArray[i] <= 0) continue;
            totalSpace += dArray[i];
            if (dArray[i] <= largestSpace) continue;
            largestSpace = dArray[i];
        }
        float gasFactor = this.func_145838_q() == ObjectHandler.fireGasBlock ? (float)this.amount / ((float)totalSpace + 1.0f) : (float)this.amount / ((float)totalSpace + 10.0f);
        for (int i = 0; i < 6; ++i) {
            if (dArray[i] <= 0) continue;
            dArray[i] = MathHelper.func_76123_f((float)((float)dArray[i] * gasFactor));
        }
        return dArray;
    }

    public int getGasCapactiy(int i, int j, int k) {
        if (!this.field_145850_b.func_72863_F().func_73149_a(i / 16, k / 16)) {
            return 0;
        }
        int fireAmount = this.getGasQuantity(0);
        TileEntity tile = this.field_145850_b.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityGas) {
            TileEntityGas gasTile = (TileEntityGas)tile;
            int gasSpace = 10 - gasTile.amount;
            int n = gasSpace < 0 ? (this.amount > 10 ? 10 : 0) : (gasSpace = gasSpace);
            if (this.func_145838_q() == ObjectHandler.fireGasBlock) {
                if (j < this.field_145848_d) {
                    return 1;
                }
                if (gasTile.getGasQuantity(0) > fireAmount) {
                    return 5;
                }
                if (gasTile.getGasQuantity(0) > 0) {
                    return 10;
                }
                return 20;
            }
            return gasSpace;
        }
        if (this.field_145850_b.func_147439_a(i, j, k) == Blocks.field_150350_a) {
            return 10;
        }
        return 0;
    }

    public void onDataPacket(NetworkManager netManager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

