/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.uv.MultiIconTransformation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.logic.TransceiverPart;
import codechicken.wirelessredstone.logic.WirelessPart;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderWireless {
    private static MultiIconTransformation model_icont;
    private static MultiIconTransformation[] base_icont;
    private static CCModel[][] models;
    private static LightModel lm;
    private static PlanarLightModel rlm;

    private static CCModel setTex(CCModel model, int index) {
        for (Vertex5 v : model.verts) {
            v.uv.tex = index;
        }
        return model;
    }

    public static void loadIcons(IIconRegister r) {
        IIcon base = r.func_94245_a("wrcbe_logic:base");
        IIcon on = r.func_94245_a("wrcbe_logic:on");
        IIcon off = r.func_94245_a("wrcbe_logic:off");
        IIcon blaze = r.func_94245_a("wrcbe_logic:blaze");
        IIcon obsidian = r.func_94245_a("obsidian");
        model_icont = new MultiIconTransformation(new IIcon[]{base, blaze, obsidian});
        RenderWireless.base_icont[0] = new MultiIconTransformation(new IIcon[]{base, off, base, base, base, base});
        RenderWireless.base_icont[1] = new MultiIconTransformation(new IIcon[]{base, on, base, base, base, base});
    }

    public static void renderInv(WirelessPart p) {
        CCRenderState state = CCRenderState.instance();
        state.resetInstance();
        state.useNormals = true;
        state.pushLightmapInstance();
        state.startDrawingInstance(7);
        state.setPipelineInstance(new CCRenderState.IVertexOperation[]{base_icont[0]});
        BlockRenderer.renderCuboid((Cuboid6)WirelessPart.baseBounds(0), (int)0);
        models[p.modelId()][0].render(new CCRenderState.IVertexOperation[]{model_icont});
        state.drawInstance();
        RenderWireless.renderPearl(Vector3.zero, p);
    }

    public static void renderWorld(WirelessPart p) {
        CCRenderState state = CCRenderState.instance();
        state.setBrightnessInstance((IBlockAccess)p.world(), p.x(), p.y(), p.z());
        Translation t = new Translation((double)p.x(), (double)p.y(), (double)p.z());
        state.setPipelineInstance(new CCRenderState.IVertexOperation[]{p.rotationT().at(Vector3.center).with((Transformation)t), base_icont[p.textureSet()], rlm});
        BlockRenderer.renderCuboid((Cuboid6)p.baseRenderBounds, (int)p.baseRenderMask);
        models[p.modelId()][p.side() << 2 | p.rotation()].render(new CCRenderState.IVertexOperation[]{t, model_icont});
    }

    public static void renderFreq(Vector3 pos, TransceiverPart p) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(pos.x + Vector3.center.x), (double)(pos.y + Vector3.center.y), (double)(pos.z + Vector3.center.z));
        p.rotationT().glApply();
        RenderWireless.renderFreq(p.getFreq());
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderWireless.renderFreq(p.getFreq());
        GL11.glPopMatrix();
    }

    private static void renderFreq(int freq) {
        float scale = 0.015625f;
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)-0.3125, (double)0.374);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String s = Integer.toString(freq);
        GL11.glDepthMask((boolean)false);
        font.func_78276_b(s, -font.func_78256_a(s) / 2, 0, 0);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public static void renderPearl(Vector3 pos, WirelessPart p) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        p.rotationT().at(Vector3.center).glApply();
        Vector3 pearlPos = p.getPearlPos();
        GL11.glTranslated((double)pearlPos.x, (double)pearlPos.y, (double)pearlPos.z);
        p.getPearlRotation().glApply();
        double pearlScale = p.getPearlScale();
        GL11.glScaled((double)pearlScale, (double)pearlScale, (double)pearlScale);
        float light = 1.0f;
        if (p.tile() != null) {
            GL11.glRotatef((float)((float)(p.getPearlSpin() * 57.29577951308232)), (float)0.0f, (float)1.0f, (float)0.0f);
            light = p.getPearlLight();
        }
        GL11.glDisable((int)2896);
        CCRenderState state = CCRenderState.instance();
        state.resetInstance();
        CCRenderState.changeTexture((String)"wrcbe_core:textures/hedronmap.png");
        state.pushLightmapInstance();
        byte lightByte = (byte)(255.0f * light);
        int alpha = -1;
        int colorI = (lightByte & 0xFF) << 24 | (lightByte & 0xFF) << 16 | (lightByte & 0xFF) << 8 | 0xFF;
        state.setColourInstance(colorI);
        state.startDrawingInstance(4);
        CCModelLibrary.icosahedron4.render(new CCRenderState.IVertexOperation[0]);
        state.drawInstance();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public static IIcon getBreakingIcon(int tex) {
        return RenderWireless.base_icont[tex].icons[1];
    }

    static {
        int j;
        base_icont = new MultiIconTransformation[2];
        models = new CCModel[3][24];
        lm = new LightModel().setAmbient(new Vector3(0.7, 0.7, 0.7)).addLight(new LightModel.Light(new Vector3(0.2, 1.0, -0.7)).setDiffuse(new Vector3(0.3, 0.3, 0.3))).addLight(new LightModel.Light(new Vector3(-0.2, 1.0, 0.7)).setDiffuse(new Vector3(0.3, 0.3, 0.3))).addLight(new LightModel.Light(new Vector3(0.7, -1.0, -0.2)).setDiffuse(new Vector3(0.2, 0.2, 0.2))).addLight(new LightModel.Light(new Vector3(-0.7, -1.0, 0.2)).setDiffuse(new Vector3(0.2, 0.2, 0.2)));
        rlm = lm.reducePlanar();
        Map modelMap = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("wrcbe_logic", "models/models.obj"), (int)7, null);
        CCModel tstand = RenderWireless.setTex((CCModel)modelMap.get("TStand"), 2);
        CCModel jstand = RenderWireless.setTex(tstand.copy(), 1);
        CCModel rstand = RenderWireless.setTex((CCModel)modelMap.get("RStand"), 2);
        CCModel rdish = (CCModel)modelMap.get("RDish");
        RenderWireless.models[0][0] = tstand;
        RenderWireless.models[1][0] = CCModel.combine(Arrays.asList(rstand, rdish));
        RenderWireless.models[2][0] = jstand;
        for (int i = 0; i < 3; ++i) {
            models[i][0].computeNormals();
        }
        for (j = 1; j < 24; ++j) {
            Transformation t = Rotation.sideOrientation((int)(j >> 2), (int)(j & 3)).at(Vector3.center);
            for (int i = 0; i < models.length; ++i) {
                RenderWireless.models[i][j] = models[i][0].copy().apply(t);
            }
        }
        for (j = 0; j < 24; ++j) {
            for (int i = 0; i < 3; ++i) {
                models[i][j].computeLighting(lm);
            }
        }
    }
}

