/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.Acceptor;
import climateControl.utils.Accessor;
import climateControl.utils.Maker;
import climateControl.utils.SelfTrackable;
import climateControl.utils.Streamer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;

public abstract class Savee<Type extends SelfTrackable<Type>>
extends WorldSavedData {
    public final String DATA_NAME = "data";
    private final String saveName;
    private Type data;
    private Acceptor<Type> toSelf = new Acceptor<Type>(){

        @Override
        public void accept(Type accepted) {
            Savee.this.set(accepted);
        }
    };
    private static Accessor<MapStorage, ISaveHandler> saveHandlerAccess = new Accessor("field_75751_a", "saveHandler");
    private static Accessor<MapStorage, Map> loadedMapAccess = new Accessor("field_75749_b", "loadedDataMap");
    private static Accessor<MapStorage, List> loadedListAccess = new Accessor("field_75750_c", "loadedDataList");

    public void loadData(String saveName, Savee<Type> worldsaveddata, World world, Maker<Type> maker) {
        ISaveHandler saveHandler = saveHandlerAccess.get(world.field_72988_C);
        MapStorage mapStorage = world.field_72988_C;
        if (saveHandler != null) {
            try {
                File file1 = saveHandler.func_75758_b(saveName);
                if (file1 != null && file1.exists()) {
                    FileInputStream fileinputstream = new FileInputStream(file1);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    worldsaveddata.func_76184_a(nbttagcompound.func_74775_l("data"));
                }
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        if (worldsaveddata.data() == null) {
            worldsaveddata.data = (SelfTrackable)maker.item();
            worldsaveddata.data.informOnChange(this.toSelf);
        }
        if (worldsaveddata != null) {
            mapStorage.func_75745_a(this.field_76190_i, worldsaveddata);
            worldsaveddata.func_76186_a(true);
            mapStorage.func_75744_a();
        }
    }

    public Savee(String saveName) {
        super(saveName);
        this.saveName = saveName;
    }

    public Savee(String saveName, Type data) {
        super(saveName);
        this.saveName = saveName;
        this.set(data);
        data.informOnChange(this.toSelf);
    }

    public Savee(String saveName, Type data, boolean startDirty) {
        super(saveName);
        this.saveName = saveName;
        if (startDirty) {
            this.set(data);
        } else {
            this.data = data;
        }
        data.informOnChange(this.toSelf);
    }

    abstract Streamer<Type> streamer();

    public Type data() {
        return this.data;
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(nbttagcompound.func_74770_j("data")));
        try {
            this.data = (SelfTrackable)this.streamer().readFrom(inputStream);
            this.data.informOnChange(this.toSelf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(72);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            this.streamer().writeTo(this.data, outputStream);
            nbttagcompound.func_74773_a("data", bos.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void set(Type newData) {
        if (this.data != newData) {
            if (this.data != null) {
                this.data.stopInforming(this.toSelf);
            }
            newData.informOnChange(this.toSelf);
        }
        this.data = newData;
        this.func_76186_a(true);
    }
}

