/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.Maker;
import climateControl.utils.Saver;
import climateControl.utils.SelfTrackable;
import climateControl.utils.Streamer;
import net.minecraft.world.World;

public abstract class SavedNumberedItems<Type extends SelfTrackable<Type>> {
    private final Saver<Type> saver;
    private final String saveTitle;
    private final Streamer<Type> streamer;

    public SavedNumberedItems(String saveTitle, Streamer<Type> streamer) {
        this.saveTitle = saveTitle;
        this.streamer = streamer;
        this.saver = new Saver<Type>(this.streamer());
    }

    public final Streamer<Type> streamer() {
        return this.streamer;
    }

    public abstract Maker<Type> maker(int var1);

    public abstract boolean saveOnNew(int var1);

    public int nextInt(World world) {
        return world.field_72988_C.func_75743_a(this.saveTitle);
    }

    public String saveName(int index) {
        return this.saveTitle + "_" + index;
    }

    public Type saved(int index, World world) {
        try {
            return this.saver.savee(this.saveName(index), world, this.maker(index), this.saveOnNew(index)).data();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public Type saved(int index, World world, Maker<Type> maker) {
        return this.saver.savee(this.saveName(index), world, maker, this.saveOnNew(index)).data();
    }
}

