/*
 * Decompiled with CFR 0.152.
 */
package climateControl.generator;

import climateControl.ClimateControl;
import climateControl.api.BiomeSettings;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.utils.IntRandomizer;
import climateControl.utils.Zeno410Logger;
import java.util.ArrayList;
import java.util.logging.Logger;

public class SubBiomeChooser {
    public static Logger logger = new Zeno410Logger("subBiomeChooser").logger();
    private BiomeReplacer[] replacers = new BiomeReplacer[256];

    public void clear() {
        for (int i = 0; i < this.replacers.length; ++i) {
            this.replacers[i] = BiomeReplacer.noChange;
        }
    }

    public void set(int biomeIndex, BiomeReplacer replacer) {
        this.replacers[biomeIndex] = new BiomeReplacer.Multiple(replacer, this.replacers[biomeIndex]);
    }

    public void set(ArrayList<BiomeSettings> settings) {
        for (BiomeSettings setting : settings) {
            if (!setting.biomesAreActive()) continue;
            setting.update(this);
        }
    }

    public int subBiome(int biome, IntRandomizer randomizer, int x, int z) {
        try {
            return this.replacers[biome].replacement(biome, randomizer, x, z);
        }
        catch (NullPointerException e) {
            if (ClimateControl.testing) {
                // empty if block
            }
            return biome;
        }
    }
}

